import { isRecord } from "../../utils/index.js";
const _transformKeys = (data, transform) => {
    if (Array.isArray(data)) {
        return data.map((value) => _transformKeys(value, transform));
    }
    if (isRecord(data)) {
        return Object.fromEntries(Object.entries(data).map(([key, value]) => [
            transform(key),
            _transformKeys(value, transform),
        ]));
    }
    return data;
};
export const transformKeys = (data, transform) => {
    const f = (key) => {
        // `PATCH /v1/preferences` uses `:` as a delimiter
        if (key.includes(":"))
            return key;
        // `PATCH /v2/filters` uses _destroy as a special key
        if (key.startsWith("_"))
            return key;
        return transform(key);
    };
    return _transformKeys(data, f);
};
