"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseLinkHeader = void 0;
const parseLinkHeader = (linkHeader) => {
    const links = new Map();
    for (const link of linkHeader.split(",")) {
        const match = link.match(/<([^>]+)>;\s*rel="([^"]+)"/);
        if (match) {
            links.set(match[2], match[1]);
        }
    }
    return links;
};
exports.parseLinkHeader = parseLinkHeader;
