"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.flattenForRailsQueryString = exports.flattenForFormData = void 0;
const index_js_1 = require("../../utils/index.js");
const ObjectFlattener = (keyMapper) => {
    const flatten = (object, parent = "") => {
        if (Array.isArray(object)) {
            return object.flatMap((value, i) => flatten(value, parent == "" ? i.toString() : keyMapper.onArray(parent, i)));
        }
        if ((0, index_js_1.isRecord)(object)) {
            return Object.entries(object).flatMap(([key, value]) => flatten(value, parent === "" ? key : keyMapper.onObject(parent, key)));
        }
        return [[parent, object]];
    };
    return flatten;
};
const flattenForFormData = (object) => {
    const flatten = ObjectFlattener({
        onArray: (parent, index) => `${parent}[${index}]`,
        onObject: (parent, key) => `${parent}[${key}]`,
    });
    return Object.fromEntries(flatten(object));
};
exports.flattenForFormData = flattenForFormData;
const flattenForRailsQueryString = (object) => {
    const flatten = ObjectFlattener({
        onArray: (parent) => `${parent}[]`,
        onObject: (parent, key) => `${parent}[${key}]`,
    });
    return flatten(object)
        .filter(([, v]) => v != undefined)
        .map(([k, v]) => `${k}=${encodeURIComponent(v)}`)
        .join("&");
};
exports.flattenForRailsQueryString = flattenForRailsQueryString;
