"use strict";
/* eslint-disable import/no-deprecated */
Object.defineProperty(exports, "__esModule", { value: true });
exports.jsonStringToLex = exports.jsonToLex = exports.stringifyLex = exports.lexToJson = exports.ipldToLex = exports.lexToIpld = void 0;
const cid_1 = require("multiformats/cid");
const common_web_1 = require("@atproto/common-web");
const blob_refs_1 = require("./blob-refs");
// @NOTE avoiding use of check.is() here only because it makes
// these implementations slow, and they often live in hot paths.
/**
 * @deprecated Use `LexValue` from `@atproto/lex-data` instead (which doesn't need conversion to IPLD).
 */
const lexToIpld = (val) => {
    // walk arrays
    if (Array.isArray(val)) {
        return val.map((item) => (0, exports.lexToIpld)(item));
    }
    // objects
    if (val && typeof val === 'object') {
        // convert blobs, leaving the original encoding so that we don't change CIDs on re-encode
        if (val instanceof blob_refs_1.BlobRef) {
            return val.original;
        }
        // retain cids & bytes
        if (cid_1.CID.asCID(val) || val instanceof Uint8Array) {
            return val;
        }
        // walk plain objects
        const toReturn = {};
        for (const key of Object.keys(val)) {
            toReturn[key] = (0, exports.lexToIpld)(val[key]);
        }
        return toReturn;
    }
    // pass through
    return val;
};
exports.lexToIpld = lexToIpld;
/**
 * @deprecated Use `LexValue` from `@atproto/lex-data` instead instead (which doesn't need conversion to IPLD).
 */
const ipldToLex = (val) => {
    // map arrays
    if (Array.isArray(val)) {
        return val.map((item) => (0, exports.ipldToLex)(item));
    }
    // objects
    if (val && typeof val === 'object') {
        // convert blobs, using hints to avoid expensive is() check
        if ((val['$type'] === 'blob' ||
            (typeof val['cid'] === 'string' &&
                typeof val['mimeType'] === 'string')) &&
            common_web_1.check.is(val, blob_refs_1.jsonBlobRef)) {
            return blob_refs_1.BlobRef.fromJsonRef(val);
        }
        // retain cids, bytes
        if (cid_1.CID.asCID(val) || val instanceof Uint8Array) {
            return val;
        }
        // map plain objects
        const toReturn = {};
        for (const key of Object.keys(val)) {
            toReturn[key] = (0, exports.ipldToLex)(val[key]);
        }
        return toReturn;
    }
    // pass through
    return val;
};
exports.ipldToLex = ipldToLex;
const lexToJson = (val) => {
    return (0, common_web_1.ipldToJson)((0, exports.lexToIpld)(val));
};
exports.lexToJson = lexToJson;
const stringifyLex = (val) => {
    return JSON.stringify((0, exports.lexToJson)(val));
};
exports.stringifyLex = stringifyLex;
const jsonToLex = (val) => {
    return (0, exports.ipldToLex)((0, common_web_1.jsonToIpld)(val));
};
exports.jsonToLex = jsonToLex;
const jsonStringToLex = (val) => {
    return (0, exports.jsonToLex)(JSON.parse(val));
};
exports.jsonStringToLex = jsonStringToLex;
//# sourceMappingURL=serialize.js.map