"use strict";
/* eslint-disable import/no-deprecated */
Object.defineProperty(exports, "__esModule", { value: true });
exports.BlobRef = exports.jsonBlobRef = exports.untypedJsonBlobRef = exports.typedJsonBlobRef = void 0;
const cid_1 = require("multiformats/cid");
const zod_1 = require("zod");
const common_web_1 = require("@atproto/common-web");
exports.typedJsonBlobRef = zod_1.z
    .object({
    $type: zod_1.z.literal('blob'),
    ref: common_web_1.schema.cid,
    mimeType: zod_1.z.string(),
    size: zod_1.z.number(),
})
    .strict();
exports.untypedJsonBlobRef = zod_1.z
    .object({
    cid: zod_1.z.string(),
    mimeType: zod_1.z.string(),
})
    .strict();
exports.jsonBlobRef = zod_1.z.union([exports.typedJsonBlobRef, exports.untypedJsonBlobRef]);
class BlobRef {
    constructor(ref, mimeType, size, original) {
        Object.defineProperty(this, "ref", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: ref
        });
        Object.defineProperty(this, "mimeType", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: mimeType
        });
        Object.defineProperty(this, "size", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: size
        });
        Object.defineProperty(this, "original", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.original = original ?? {
            $type: 'blob',
            ref,
            mimeType,
            size,
        };
    }
    static asBlobRef(obj) {
        if (common_web_1.check.is(obj, exports.jsonBlobRef)) {
            return BlobRef.fromJsonRef(obj);
        }
        return null;
    }
    static fromJsonRef(json) {
        if (common_web_1.check.is(json, exports.typedJsonBlobRef)) {
            return new BlobRef(json.ref, json.mimeType, json.size);
        }
        else {
            return new BlobRef(cid_1.CID.parse(json.cid), json.mimeType, -1, json);
        }
    }
    ipld() {
        return this.original;
    }
    toJSON() {
        return (0, common_web_1.ipldToJson)(this.ipld());
    }
}
exports.BlobRef = BlobRef;
//# sourceMappingURL=blob-refs.js.map