import { Base64Alphabet } from './uint8array-base64.js';
export type { Base64Alphabet };
/**
 * Encodes a Uint8Array into a base64 string.
 *
 * @returns The base64 encoded string
 */
export declare const toBase64: (bytes: Uint8Array, alphabet?: Base64Alphabet) => string;
/**
 * Decodes a base64 string into a Uint8Array. This function supports both padded
 * and unpadded base64 strings.
 *
 * @returns The decoded {@link Uint8Array}
 * @throws If the input is not a valid base64 string
 */
export declare const fromBase64: (b64: string, alphabet?: Base64Alphabet) => Uint8Array;
/**
 * Coerces various binary data representations into a Uint8Array.
 *
 * @return `undefined` if the input could not be coerced into a {@link Uint8Array}.
 */
export declare function asUint8Array(input: unknown): Uint8Array | undefined;
export declare function ui8Equals(a: Uint8Array, b: Uint8Array): boolean;
//# sourceMappingURL=uint8array.d.ts.map