import { CID } from 'multiformats/cid';
export declare const DAG_CBOR_MULTICODEC = 113;
export declare const RAW_BIN_MULTICODEC = 85;
export declare const SHA2_256_MULTIHASH_CODE = 18;
export type MultihashDigest<Code extends number = number> = {
    code: Code;
    digest: Uint8Array;
    size: number;
    bytes: Uint8Array;
};
declare module 'multiformats/cid' {
    /**
     * @deprecated use the {@link Cid} interface from `@atproto/lex-data`, and
     * related helpers ({@link asCid}, {@link parseCid}, {@link decodeCid},
     * {@link createCid}, {@link isCid}), instead.
     *
     * This is marked as deprecated because we want to discourage direct usage of
     * `multiformats/cid` in dependent packages, and instead have them rely on the
     * {@link Cid} interface from `@atproto/lex-data`. The {@link CID} class from
     * `multiformats` version <10 has compatibility issues with certain TypeScript
     * module resolution strategies, which can lead to type errors in dependent
     * packages.
     *
     * We are stuck with version 9 because `@atproto` packages did not drop
     * CommonJS support yet, and multiformats version 10 only supports ES modules.
     *
     * In order to avoid compatibility issues, while preparing for future breaking
     * changes (CID in multiformats v10+ has a slightly different interface), as
     * we update or swap out `multiformats`, we provide our own stable `Cid`
     * interface.
     */
    interface CID {
    }
}
export { CID };
/**
 * Interface for working with decoded CID string, compatible with
 * {@link CID} implementation.
 */
export interface Cid {
    version: 0 | 1;
    code: number;
    multihash: MultihashDigest;
    bytes: Uint8Array;
    equals(other: unknown): boolean;
    toString(): string;
}
export declare function asCid(value: unknown): Cid | null;
export declare function parseCid(input: string): Cid;
export declare function decodeCid(bytes: Uint8Array): Cid;
export declare function createCid(code: number, digest: MultihashDigest): Cid;
export declare function isCid(value: unknown, options?: {
    strict?: boolean;
}): value is Cid;
export declare function validateCidString(input: string): boolean;
export declare function parseCidString(input: string): Cid | undefined;
export declare function ensureValidCidString(input: string): void;
//# sourceMappingURL=cid.d.ts.map