"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepoNotFoundError = void 0;
exports.toKnownErr = toKnownErr;
exports.isTimelineItem = isTimelineItem;
exports.validateTimelineItem = validateTimelineItem;
exports.isTimelineItemSummary = isTimelineItemSummary;
exports.validateTimelineItemSummary = validateTimelineItemSummary;
/**
 * GENERATED CODE - DO NOT MODIFY
 */
const xrpc_1 = require("@atproto/xrpc");
const lexicons_1 = require("../../../../lexicons");
const util_1 = require("../../../../util");
const is$typed = util_1.is$typed, validate = lexicons_1.validate;
const id = 'tools.ozone.moderation.getAccountTimeline';
class RepoNotFoundError extends xrpc_1.XRPCError {
    constructor(src) {
        super(src.status, src.error, src.message, src.headers, { cause: src });
    }
}
exports.RepoNotFoundError = RepoNotFoundError;
function toKnownErr(e) {
    if (e instanceof xrpc_1.XRPCError) {
        if (e.error === 'RepoNotFound')
            return new RepoNotFoundError(e);
    }
    return e;
}
const hashTimelineItem = 'timelineItem';
function isTimelineItem(v) {
    return is$typed(v, id, hashTimelineItem);
}
function validateTimelineItem(v) {
    return validate(v, id, hashTimelineItem);
}
const hashTimelineItemSummary = 'timelineItemSummary';
function isTimelineItemSummary(v) {
    return is$typed(v, id, hashTimelineItemSummary);
}
function validateTimelineItemSummary(v) {
    return validate(v, id, hashTimelineItemSummary);
}
//# sourceMappingURL=getAccountTimeline.js.map