"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalError = exports.InvalidCodeError = exports.InvalidPhoneError = exports.InvalidDidError = exports.RateLimitExceededError = void 0;
exports.toKnownErr = toKnownErr;
/**
 * GENERATED CODE - DO NOT MODIFY
 */
const xrpc_1 = require("@atproto/xrpc");
const lexicons_1 = require("../../../../lexicons");
const util_1 = require("../../../../util");
const is$typed = util_1.is$typed, validate = lexicons_1.validate;
const id = 'app.bsky.contact.verifyPhone';
class RateLimitExceededError extends xrpc_1.XRPCError {
    constructor(src) {
        super(src.status, src.error, src.message, src.headers, { cause: src });
    }
}
exports.RateLimitExceededError = RateLimitExceededError;
class InvalidDidError extends xrpc_1.XRPCError {
    constructor(src) {
        super(src.status, src.error, src.message, src.headers, { cause: src });
    }
}
exports.InvalidDidError = InvalidDidError;
class InvalidPhoneError extends xrpc_1.XRPCError {
    constructor(src) {
        super(src.status, src.error, src.message, src.headers, { cause: src });
    }
}
exports.InvalidPhoneError = InvalidPhoneError;
class InvalidCodeError extends xrpc_1.XRPCError {
    constructor(src) {
        super(src.status, src.error, src.message, src.headers, { cause: src });
    }
}
exports.InvalidCodeError = InvalidCodeError;
class InternalError extends xrpc_1.XRPCError {
    constructor(src) {
        super(src.status, src.error, src.message, src.headers, { cause: src });
    }
}
exports.InternalError = InternalError;
function toKnownErr(e) {
    if (e instanceof xrpc_1.XRPCError) {
        if (e.error === 'RateLimitExceeded')
            return new RateLimitExceededError(e);
        if (e.error === 'InvalidDid')
            return new InvalidDidError(e);
        if (e.error === 'InvalidPhone')
            return new InvalidPhoneError(e);
        if (e.error === 'InvalidCode')
            return new InvalidCodeError(e);
        if (e.error === 'InternalError')
            return new InternalError(e);
    }
    return e;
}
//# sourceMappingURL=verifyPhone.js.map