import * as React from 'react';
import Svg, { Path, G } from 'react-native-svg';
function SvgComponent(props: any) {
	const size = props.size ?? 512;
	const scale = size / 512;

	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			{...props}
			width={512 * scale}
			height={512 * scale}
		>
			<G scale={scale}>
				<Path
					fill="#eec06b"
					d="M332.946 287.024c-94.742.151-172.515-76.968-173.128-171.707-.158-24.42 4.749-47.677 13.731-68.781 4.7-11.042-7.305-21.805-17.626-15.681-59.401 35.244-99.42 99.716-100.225 173.606-1.231 113.025 91.335 206.649 204.366 206.649 92.319 0 170.338-61.212 195.692-145.262 3.441-11.407-9.803-20.582-19.327-13.422-28.827 21.671-64.654 34.537-103.483 34.598z"
				/>
				<Path
					fill="#e9a52d"
					d="M448.053 250.672c-31.199 72.961-103.617 124.091-187.988 124.092-106.141.001-194.229-82.558-203.556-186.212a206.948 206.948 0 0 0-.81 15.909C54.468 317.486 147.034 411.11 260.065 411.11c92.319 0 170.337-61.212 195.692-145.262 2.099-6.96-2.016-13.081-7.704-15.176z"
				/>
				<Path
					fill="#e9a52d"
					d="M270.357 281.167v129.677c66.699-3.31 124.979-38.588 159.835-90.836-.487-19.691-8.512-37.501-21.314-50.659-22.912 11.275-48.681 17.632-75.932 17.676-22.188.035-43.445-4.168-62.998-11.842.261 1.971.409 3.967.409 5.984z"
				/>
				<Path
					fill="#ddebfd"
					d="M208.627 234.258a174.563 174.563 0 0 0 17.244 15.59c11.104 8.767 17.677 22.059 17.677 36.207v211.44c0 8.011 6.494 14.505 14.505 14.505h36.263c28.952 0 52.423-23.471 52.423-52.423v-13.835H364.1c21.722 0 39.331-17.609 39.331-39.331V326.79c0-41.636-33.753-75.389-75.389-75.389h-31.558V248.7c0-22.962-22.945-38.848-44.438-30.767z"
				/>
				<G fill="#bed9fd">
					<Path d="M328.041 251.401h-25.944c41.636 0 75.389 33.753 75.389 75.389v79.621c0 21.722-17.609 39.331-39.331 39.331h-3.525c-7.641 0-13.835 6.194-13.835 13.835 0 28.952-23.471 52.423-52.423 52.423h25.944c28.952 0 52.423-23.47 52.423-52.423v-13.835H364.1c21.722 0 39.331-17.609 39.331-39.331V326.79c0-41.636-33.753-75.389-75.39-75.389z" />
					<Path d="M303.588 325.051a7.103 7.103 0 0 0 7.104-7.104v-66.546h-14.208v66.546a7.103 7.103 0 0 0 7.104 7.104zM353.844 367.201a7.103 7.103 0 0 0-7.104 7.104v71.437h14.208v-71.437a7.104 7.104 0 0 0-7.104-7.104z" />
				</G>
				<Path
					fill="#8c818f"
					d="M340.139 184.891h-28.883a10.273 10.273 0 0 1-8.701-15.729l23.819-37.94h-19.928a7.61 7.61 0 1 1 0-15.222h28.884a10.273 10.273 0 0 1 8.698 15.732l-23.817 37.937h19.928a7.61 7.61 0 1 1 0 15.222zm-4.809-53.669h.01zM296.932 68.892h-28.883a10.273 10.273 0 0 1-8.701-15.729l23.819-37.94h-19.928a7.612 7.612 0 0 1 0-15.223h28.884a10.273 10.273 0 0 1 8.698 15.732l-23.817 37.937h19.928a7.612 7.612 0 1 1 0 15.223zm-4.809-53.669h.01zM430.24 120.148h-28.883a10.273 10.273 0 0 1-8.699-15.732l23.817-37.937h-19.928a7.612 7.612 0 1 1 0-15.222h28.884a10.273 10.273 0 0 1 8.698 15.732l-23.817 37.937h19.928a7.612 7.612 0 1 1 0 15.222zm-4.809-53.669h.01z"
				/>
			</G>
		</Svg>
	);
}

export default SvgComponent;
