import * as React from 'react';
import Svg, { Path, G } from 'react-native-svg';
function SvgComponent(props) {
	const size = props.size ?? 512;
	const scale = size / 512;

	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			width={512 * scale}
			height={512 * scale}
			viewBox="0 0 200 200"
			{...props}
		>
			<Path
				fill="#6ac4e9"
				d="M164.36 82.343a4.178 4.178 0 0 0-.277-.23 10.957 10.957 0 0 0-2.941-1.643h-.005c-2.846-1.068-6.06-.977-9.006-.071-.699.215-1.38.488-2.06.77l-.593.25c-.297.124-.752.402-1.073.24-.34-.178-.422-.757-.508-1.093-.23-.867-.421-1.739-.685-2.6a16.928 16.928 0 0 0-.445-1.284c-.872-2.261-2.204-4.321-3.957-5.955a13.646 13.646 0 0 0-3.358-2.29c-1.935-.928-4.062-1.383-6.198-1.398a15.235 15.235 0 0 0-2.098.134c-1.27.158-2.515.455-3.76.79.56 1.04 1.03 2.127 1.398 3.253v.005c.46 1.418.747 2.888.824 4.378.062 1.202 0 2.448-.206 3.67-.249 1.518-.718 2.998-1.432 4.33-1.27 2.342-3.415 4.052-5.959 4.828-2.15.656-4.55.627-6.716-.058-2.71-.848-5.048-2.72-6.045-5.532a8.904 8.904 0 0 1-.503-3.248c.048-1.528.489-3.037 1.365-4.292 1.514-2.175 4.35-3.338 6.917-2.424 2.434.872 3.583 3.722 2.333 6.022-.038.076-.086.153-.134.23-.22.364-.517.742-.886.929-.321.167-.307-.01-.197-.278.158-.388.307-.776.412-1.169.211-.771.269-1.552-.067-2.366-1.02-2.52-4.493-2.117-6.006-.33a5.008 5.008 0 0 0-.968 1.815c-.536 1.791-.182 3.885.92 5.374 1.94 2.62 5.623 3.315 8.622 2.276 1.571-.542 2.95-1.557 3.798-3.018 1.37-2.371 1.595-5.456 1.136-8.105a14.24 14.24 0 0 0-.843-2.898c-.642-1.58-1.543-3.06-2.573-4.397-2.855-3.708-6.816-6.625-11.194-8.325a24.819 24.819 0 0 0-2.51-.83 28.329 28.329 0 0 0-3.013-.636h-.005c-4.584-.719-9.336-.355-13.824.737-.656.159-1.303.34-1.94.542a31.297 31.297 0 0 0-5.537 2.37c-2.376 1.304-4.594 2.904-6.64 4.738a55.754 55.754 0 0 0-2.648 2.563c-.211.22-.422.436-.633.651-.024.024-.138.12-.196.187-.02.024-.034.043-.034.053 0 .033.206.21.25.259.45.469.867.967 1.24 1.499a14.279 14.279 0 0 1 1.974 3.976c.258.847.426 1.72.488 2.605.182 2.63-.852 5.126-2.816 6.879-1.94 1.724-4.651 2.644-7.238 2.266a7.04 7.04 0 0 1-1.15-.269c-2.045-.656-3.688-2.208-4.498-4.248-.699-1.749-.56-3.794.427-5.322a4.723 4.723 0 0 1 1.834-1.681c1.107-.57 2.434-.705 3.564-.13 1.04.522 1.739 1.59 1.85 2.745.047.488.018 1.135-.274 1.552-.191.268-.278.177-.33-.11-.211-1.188-.542-2.477-1.859-2.874-1.154-.345-2.405.416-2.984 1.398a2.654 2.654 0 0 0-.22.475c-.312.843-.254 1.815.052 2.648.537 1.457 1.667 2.415 2.999 2.817 1.015.311 2.146.302 3.228-.043 2.458-.79 4.354-3.032 4.163-5.686a8.788 8.788 0 0 0-.69-2.788 10.965 10.965 0 0 0-2.342-3.453c-1.466-1.466-3.325-2.486-5.27-3.186-.344-.124-.689-.235-1.034-.34-2.385-.714-4.92-1.097-7.415-1.068-.297.005-.59.014-.881.029-5.418.287-10.615 2.586-14.715 6.102-.168.144-.336.292-.499.44-1.95 1.759-3.616 3.862-4.617 6.305-.987 2.4-1.231 5.024-.82 7.573.02.139.044.282.072.421.446 2.323 1.505 4.33 2.434 6.472.043.1.235.44.148.546-.167.206-.694-.36-.8-.46-.824-.78-1.504-1.739-2.074-2.72-.575.363-1.236.593-1.853.87a20.82 20.82 0 0 0-1.936.969c-1.293.737-2.486 1.652-3.434 2.807a9.966 9.966 0 0 0-.891 1.288c-1.495 2.577-1.744 5.686-1.05 8.598.533 2.232 1.62 4.345 3.12 6.012 1.182 1.312 2.643 2.232 4.248 2.864.867.34 1.782.594 2.706.781.59.115 1.184.201 1.773.302.254.043 1.087.086 1.212.388.277.67-2.218 1.034-2.563 1.078.623 1.662 1.082 3.372 1.73 5.024a34.698 34.698 0 0 0 2.907 5.777l.11.173c1.954 3.08 4.632 5.585 7.721 7.496 2.218 1.375 4.7 2.285 7.248 2.836.584.13 1.169.24 1.758.33 3.664.56 7.42.297 11.012-.57.13-.029.259-.057.388-.09 3.061-.772 5.916-2.041 8.766-3.378a15.634 15.634 0 0 1-1.734-5.748c-.192-1.983 0-4.038.632-5.925.604-1.81 1.615-3.468 3.076-4.771a10.168 10.168 0 0 1 3.468-2.021h.004a11.344 11.344 0 0 1 7.612.062c1.743.646 3.2 1.729 4.239 3.109 1.24 1.628 1.897 3.664 1.767 5.877-.23 3.928-3.784 7.583-7.903 6.409-1.92-.55-3.262-2.29-3.152-4.311.048-.886.374-1.772.948-2.448.182-.21 1.016-.943.729-.196-.321.833-.618 1.619-.532 2.529.086.905.517 1.753 1.284 2.266 1.6 1.063 3.89.335 5.01-1.083 1.231-1.557 1.37-3.731.733-5.556a5.486 5.486 0 0 0-.695-1.341c-.742-1.069-1.844-1.869-3.07-2.333-2.261-.858-4.852-.656-6.903.507a7.031 7.031 0 0 0-2.605 2.51 9.167 9.167 0 0 0-.661 1.342c-1.294 3.334-.537 7.31 1.283 10.298.039.063.072.12.115.178 1.222 1.954 2.826 3.654 4.637 5.101a27.012 27.012 0 0 0 4.369 2.83 27.884 27.884 0 0 0 7.29 2.597c4.805 1.006 9.91.79 14.452-.915a20.918 20.918 0 0 0 2.486-1.111c3.535-1.868 6.486-4.68 8.57-8.086a29.942 29.942 0 0 0 2.562-5.345c.038-.101.072-.202.11-.307.13-.36.254-.718.378-1.083.03-.076.072-.181.12-.296.1-.245.201-.527.134-.68-.086-.197-.407-.427-.56-.6a23.294 23.294 0 0 1-.527-.632 19.257 19.257 0 0 1-.877-1.173c-.914-1.332-1.671-2.793-2.174-4.33-.22-.666-.503-1.476-.436-2.194.038-.436.263-.33.503-.058.512.599.905 1.322 1.341 1.978.445.666.905 1.318 1.399 1.95 1.164 1.485 2.505 2.845 4.028 3.966.053.038.106.077.163.115 5.279 3.799 12.34 4.66 18.365 2.414a18.451 18.451 0 0 0 3.79-1.93c3.156-2.103 5.661-5.154 7.136-8.646a21.397 21.397 0 0 0 1.547-6.16c.168-1.73.092-3.435.005-5.164-.69.268-1.389.498-2.112.661-2.453.556-4.967.297-7.118-.924a8.58 8.58 0 0 1-1.078-.714c-2.189-1.686-3.482-4.316-2.936-7.094.488-2.5 2.361-4.867 4.9-5.5 2.155-.54 4.608.293 5.667 2.17v.01c.254.46.426.982.488 1.562.134 1.265-.436 2.529-1.576 3.142a2.976 2.976 0 0 1-1.825.326c-.234-.034-1.226-.244-1.188-.613.024-.25.94-.187 1.15-.23.546-.11 1.078-.369 1.418-.824.354-.47.402-1.025.254-1.547a2.532 2.532 0 0 0-1.207-1.5c-2.491-1.317-4.996 1.294-5.222 3.646-.124 1.279.398 2.4 1.25 3.252 1.002 1.02 2.472 1.662 3.857 1.758 2.811.197 5.786-1.303 7.827-3.137a11.343 11.343 0 0 0 2.385-3.004c.738-1.346 1.207-2.83 1.413-4.411.532-4.153-.757-8.728-4.023-11.473zm-84.405-12.32c.311-.709.867-1.331 1.38-1.901a21.151 21.151 0 0 1 2.667-2.486 24.373 24.373 0 0 1 2.539-1.754 25.94 25.94 0 0 1 11.817-3.66 24.933 24.933 0 0 1 2.932-.004c1.49.081 2.97.297 4.42.661 1.03.259 2.065.58 3.019 1.05.153.076 1.063.468.962.746-.11.33-1.465.048-1.686.024-1.236-.139-2.476-.287-3.717-.369a34.509 34.509 0 0 0-4.282-.014c-1.303.077-2.601.23-3.885.47a29.707 29.707 0 0 0-6.605 2.045c-1.011.436-1.998.93-2.965 1.466a42.632 42.632 0 0 0-4.34 2.75c-.628.45-1.274 1.048-1.988 1.355-.388.167-.412-.048-.268-.379zm-5.844 63.383c-.834.69-1.763 1.269-2.73 1.748a17.65 17.65 0 0 1-4.604 1.538 18.67 18.67 0 0 1-7.726-.144c-.048-.01-.1-.024-.149-.034a17.767 17.767 0 0 1-5.436-2.309c-.805-.517-1.586-1.106-2.252-1.796-.177-.182-.824-.766-.737-1.082.134-.484 2.878 1.01 3.156 1.135 1.51.675 3.07 1.24 4.675 1.629a21.781 21.781 0 0 0 7.348.484 24.49 24.49 0 0 0 5.897-1.38c.967-.355 1.911-.786 2.883-1.13.192-.072.839-.365.839.023-.005.46-.867 1.073-1.164 1.318zm78.998-13a24.794 24.794 0 0 0 3.32-4.843c.794-1.505 1.379-3.08 2.02-4.647.092-.22.331-1.073.647-1.102.302-.028.336.642.35.824.139 1.514-.21 3.119-.67 4.556-1.117 3.487-3.33 6.62-6.223 8.861-.57.44-1.169.853-1.791 1.227-.685.412-1.404.776-2.142 1.077-.77.316-1.576.594-2.4.714-.177.024-.938.173-1.03-.105-.114-.345.91-.886 1.102-1.016.786-.522 1.586-1.03 2.357-1.58a29.36 29.36 0 0 0 2.022-1.581 23.878 23.878 0 0 0 2.438-2.386z"
			/>
			<Path
				fill="#fff"
				d="M50.469 74.6c1.622 0 1.625-2.522 0-2.522-1.623 0-1.625 2.521 0 2.521zM44.937 96.528c1.622 0 1.625-2.521 0-2.521-1.622 0-1.625 2.521 0 2.521zM55.282 105.654c1.622 0 1.625-2.521 0-2.521-1.623 0-1.625 2.521 0 2.521zM90.849 125.458c1.622 0 1.625-2.521 0-2.521-1.622 0-1.625 2.521 0 2.521zM83.027 132.491c1.622 0 1.625-2.521 0-2.521-1.622 0-1.625 2.521 0 2.521zM65.959 79.893c1.622 0 1.625-2.521 0-2.521-1.623 0-1.625 2.52 0 2.52zM48.033 123.143c1.622 0 1.625-2.521 0-2.521-1.622 0-1.625 2.521 0 2.521zM77.938 118.672c1.623 0 1.625-2.521 0-2.521-1.622 0-1.625 2.52 0 2.52zM94.002 107.658c1.622 0 1.625-2.522 0-2.522-1.622 0-1.625 2.522 0 2.522zM105.282 120.675c1.623 0 1.625-2.52 0-2.52-1.622 0-1.625 2.52 0 2.52zM107.718 141.936c1.622 0 1.625-2.521 0-2.521-1.623 0-1.625 2.521 0 2.521zM139.682 104.393c1.622 0 1.625-2.52 0-2.52-1.622 0-1.625 2.52 0 2.52zM155.982 86.735c1.623 0 1.625-2.52 0-2.52-1.622 0-1.625 2.52 0 2.52zM130.62 89.257c1.621 0 1.624-2.522 0-2.522-1.623 0-1.626 2.522 0 2.522zM133.055 71.22c1.622 0 1.625-2.522 0-2.522-1.623 0-1.625 2.522 0 2.522zM115.024 97.271c1.622 0 1.625-2.521 0-2.521-1.622 0-1.625 2.521 0 2.521zM99.005 68.583c1.623 0 1.625-2.521 0-2.521-1.622 0-1.625 2.52 0 2.52zM83.027 88.739c1.622 0 1.625-2.521 0-2.521-1.622 0-1.625 2.521 0 2.521zM73.34 80.285c1.622 0 1.624-2.521 0-2.521-1.623 0-1.626 2.521 0 2.521zM62.872 71.22c1.622 0 1.625-2.522 0-2.522-1.623 0-1.625 2.522 0 2.522zM42.502 84.292c1.622 0 1.625-2.52 0-2.52-1.623 0-1.625 2.52 0 2.52zM66.741 99.241c1.622 0 1.625-2.52 0-2.52-1.622 0-1.625 2.52 0 2.52zM46.816 109.661c1.622 0 1.624-2.521 0-2.521-1.623 0-1.626 2.521 0 2.521zM66.741 122.679c1.622 0 1.625-2.521 0-2.521-1.622 0-1.625 2.521 0 2.521zM84.245 99.241c1.622 0 1.625-2.52 0-2.52-1.623 0-1.625 2.52 0 2.52zM90.131 74.878c1.623 0 1.625-2.522 0-2.522-1.622 0-1.625 2.522 0 2.522zM143.553 92.954c1.622 0 1.625-2.521 0-2.521-1.622 0-1.625 2.521 0 2.521zM135.49 119.415c1.622 0 1.625-2.522 0-2.522-1.622 0-1.625 2.522 0 2.522zM107.718 132.908c1.622 0 1.625-2.52 0-2.52-1.623 0-1.625 2.52 0 2.52zM108.936 109.661c1.622 0 1.624-2.521 0-2.521-1.623 0-1.626 2.521 0 2.521zM118.895 84.292c1.622 0 1.625-2.52 0-2.52-1.622 0-1.625 2.52 0 2.52z"
				opacity={0.2}
			/>
			<Path
				fill="#fff"
				d="M72.261 82.289c1.622 0 1.625-2.521 0-2.521-1.622 0-1.625 2.52 0 2.52zM49.251 74.878c1.622 0 1.625-2.522 0-2.522-1.622 0-1.625 2.522 0 2.522zM42.502 94.007c1.622 0 1.625-2.521 0-2.521-1.623 0-1.625 2.52 0 2.52zM56.5 102.512c1.622 0 1.624-2.521 0-2.521-1.623 0-1.626 2.521 0 2.521zM48.033 119.734c1.622 0 1.625-2.52 0-2.52-1.622 0-1.625 2.52 0 2.52zM65.957 79.112c1.622 0 1.625-2.521 0-2.521-1.623 0-1.625 2.52 0 2.52zM83.814 129.843c1.622 0 1.625-2.521 0-2.521-1.622 0-1.625 2.52 0 2.52zM153.547 99.918c1.622 0 1.625-2.521 0-2.521-1.622 0-1.625 2.521 0 2.521zM75.275 120.995c1.622 0 1.625-2.521 0-2.521-1.623 0-1.625 2.521 0 2.521zM92.067 105.654c1.622 0 1.625-2.521 0-2.521-1.623 0-1.625 2.521 0 2.521zM81.81 90c1.622 0 1.624-2.522 0-2.522-1.623 0-1.626 2.522 0 2.522zM97.787 69.959c1.623 0 1.625-2.521 0-2.521-1.622 0-1.625 2.52 0 2.52zM139.682 102.498c1.622 0 1.625-2.522 0-2.522-1.622 0-1.625 2.522 0 2.522zM131.837 71.22c1.622 0 1.625-2.522 0-2.522-1.622 0-1.625 2.522 0 2.522zM115.024 99.241c1.622 0 1.625-2.52 0-2.52-1.622 0-1.625 2.52 0 2.52zM107.718 118.672c1.622 0 1.625-2.521 0-2.521-1.623 0-1.625 2.52 0 2.52zM105.282 142.84c1.623 0 1.625-2.521 0-2.521-1.622 0-1.625 2.52 0 2.52zM153.547 84.759c1.622 0 1.625-2.522 0-2.522-1.622 0-1.625 2.522 0 2.522zM129.077 87.996c1.622 0 1.625-2.521 0-2.521-1.623 0-1.625 2.521 0 2.521z"
				opacity={0.6}
			/>
			<Path
				fill="#fff"
				d="M116.96 69.326c2.578 0 2.582-4.007 0-4.007-2.579 0-2.583 4.007 0 4.007zM79.874 69.326c2.578 0 2.583-4.007 0-4.007-2.579 0-2.583 4.007 0 4.007zM96.722 90.743c2.578 0 2.583-4.008 0-4.008-2.578 0-2.583 4.008 0 4.008zM73.34 106.397c2.578 0 2.582-4.007 0-4.007-2.58 0-2.583 4.007 0 4.007zM55.728 85.035c2.579 0 2.583-4.007 0-4.007-2.578 0-2.583 4.007 0 4.007zM32.736 111.817c2.578 0 2.583-4.007 0-4.007-2.579 0-2.583 4.007 0 4.007zM59.153 131.4c2.578 0 2.582-4.007 0-4.007-2.579 0-2.583 4.008 0 4.008zM119.81 131.4c2.578 0 2.582-4.007 0-4.007-2.58 0-2.584 4.008 0 4.008zM90.131 137.04c2.579 0 2.583-4.007 0-4.007-2.578 0-2.582 4.007 0 4.007zM148.02 118.474c2.578 0 2.582-4.007 0-4.007-2.579 0-2.583 4.007 0 4.007zM123.68 109.814c2.579 0 2.583-4.008 0-4.008-2.578 0-2.583 4.008 0 4.008zM141.618 85.035c2.578 0 2.582-4.007 0-4.007-2.579 0-2.583 4.007 0 4.007zM163.185 90.743c2.578 0 2.583-4.008 0-4.008-2.579 0-2.583 4.008 0 4.008z"
				opacity={0.8}
			/>
			<Path
				fill="#fff"
				d="M34.671 108.4c2.579 0 2.583-4.007 0-4.007-2.578 0-2.582 4.008 0 4.008zM57.217 81.028c2.579 0 2.583-4.007 0-4.007-2.578 0-2.583 4.007 0 4.007zM80.168 72.356c2.578 0 2.582-4.007 0-4.007-2.579 0-2.583 4.007 0 4.007zM115.938 65.692c2.579 0 2.583-4.007 0-4.007-2.578 0-2.582 4.007 0 4.007zM98.657 94.75c2.579 0 2.583-4.007 0-4.007-2.578 0-2.582 4.007 0 4.007zM69.501 106.397c2.579 0 2.583-4.007 0-4.007-2.578 0-2.583 4.007 0 4.007zM62.872 130.387c2.578 0 2.582-4.007 0-4.007-2.579 0-2.583 4.007 0 4.007zM92.067 139.043c2.578 0 2.582-4.007 0-4.007-2.579 0-2.583 4.007 0 4.007zM119.81 135.408c2.578 0 2.582-4.007 0-4.007-2.58 0-2.584 4.007 0 4.007zM126.317 111.817c2.578 0 2.583-4.007 0-4.007-2.579 0-2.583 4.007 0 4.007zM149.137 121.418c2.578 0 2.582-4.007 0-4.007-2.579 0-2.583 4.007 0 4.007zM165.12 93.697c2.579 0 2.583-4.007 0-4.007-2.578 0-2.582 4.007 0 4.007zM141.618 81.746c2.578 0 2.582-4.007 0-4.007-2.579 0-2.583 4.007 0 4.007z"
				opacity={0.3}
			/>
			<Path
				fill="#fff"
				d="M53.793 95.44c1.048 0 1.05-1.63 0-1.63-1.049 0-1.05 1.63 0 1.63zM34.671 98.864c1.049 0 1.05-1.63 0-1.63-1.048 0-1.05 1.63 0 1.63zM48.033 78.554c1.049 0 1.05-1.63 0-1.63-1.048 0-1.05 1.63 0 1.63zM83.027 76.8c1.049 0 1.05-1.63 0-1.63-1.049 0-1.05 1.63 0 1.63zM102.091 58.423c1.049 0 1.05-1.63 0-1.63-1.048 0-1.05 1.63 0 1.63zM107.718 73.171c1.048 0 1.05-1.63 0-1.63-1.049 0-1.05 1.63 0 1.63zM114.313 79.447c1.048 0 1.05-1.63 0-1.63-1.049 0-1.05 1.63 0 1.63zM108.284 90.505c1.048 0 1.05-1.63 0-1.63-1.049 0-1.05 1.63 0 1.63zM124.381 98.796c1.049 0 1.05-1.63 0-1.63-1.048 0-1.05 1.63 0 1.63zM138.137 90.072c1.048 0 1.05-1.63 0-1.63-1.049 0-1.05 1.63 0 1.63zM148.02 107.212c1.048 0 1.05-1.63 0-1.63-1.049 0-1.05 1.63 0 1.63zM112.022 127.195c1.049 0 1.05-1.63 0-1.63-1.048 0-1.05 1.63 0 1.63zM100.223 109.215c1.048 0 1.05-1.63 0-1.63-1.049 0-1.05 1.63 0 1.63zM48.033 130.212c1.049 0 1.05-1.63 0-1.63-1.048 0-1.05 1.63 0 1.63zM55.728 115.096c1.049 0 1.05-1.63 0-1.63-1.048 0-1.05 1.63 0 1.63zM73.34 91.558c1.048 0 1.05-1.63 0-1.63s-1.051 1.63 0 1.63zM92.784 125.827c1.049 0 1.05-1.63 0-1.63-1.048 0-1.05 1.63 0 1.63zM143.553 125.012c1.048 0 1.05-1.63 0-1.63-1.049 0-1.05 1.63 0 1.63z"
				opacity={0.8}
			/>
			<G fill="#fff">
				<Path d="m59.135 74.186-1.918-.271 1.632-1.04a.41.41 0 0 0 .175-.265l.264-1.918 1.04 1.632c.059.09.16.155.273.168l1.91.27-1.625 1.041a.372.372 0 0 0-.175.272l-.27 1.91-1.04-1.632a.373.373 0 0 0-.266-.167zM62.142 94.545l-1.917-.272 1.632-1.04a.41.41 0 0 0 .174-.264l.264-1.919 1.04 1.632c.06.091.16.156.273.168l1.91.27-1.624 1.042a.372.372 0 0 0-.175.272l-.27 1.91-1.041-1.632a.374.374 0 0 0-.266-.167zM42.99 106.502l-1.917-.272 1.632-1.04a.41.41 0 0 0 .174-.264l.264-1.919 1.04 1.632c.06.091.16.156.273.168l1.91.27-1.624 1.042a.372.372 0 0 0-.176.272l-.27 1.91-1.04-1.632a.373.373 0 0 0-.266-.167zM62.142 122.73l-1.917-.271 1.632-1.04a.409.409 0 0 0 .174-.265l.264-1.918 1.04 1.632c.06.09.16.155.273.168l1.91.27-1.624 1.041a.372.372 0 0 0-.175.272l-.27 1.91-1.041-1.632a.373.373 0 0 0-.266-.167zM82.298 107.245l-1.918-.272 1.632-1.04a.41.41 0 0 0 .175-.264l.264-1.919 1.04 1.632c.059.091.16.156.273.168l1.91.27-1.625 1.042a.372.372 0 0 0-.175.272l-.27 1.91-1.04-1.632a.373.373 0 0 0-.266-.167zM100.575 78.612l-1.918-.272 1.632-1.04a.41.41 0 0 0 .175-.265l.264-1.918 1.04 1.632c.06.09.16.156.273.168l1.91.27-1.624 1.042a.372.372 0 0 0-.176.272l-.27 1.91-1.04-1.632a.374.374 0 0 0-.266-.167zM116.23 114.352l-1.917-.272 1.632-1.04a.41.41 0 0 0 .174-.265l.264-1.918 1.04 1.632c.06.09.16.155.273.168l1.91.27-1.624 1.041a.372.372 0 0 0-.176.272l-.27 1.91-1.04-1.631a.373.373 0 0 0-.266-.168zM131.108 98.119l-1.918-.272 1.632-1.04a.41.41 0 0 0 .175-.264l.263-1.919 1.04 1.632c.06.091.16.156.274.168l1.91.27-1.625 1.042a.372.372 0 0 0-.175.272l-.27 1.91-1.041-1.632a.373.373 0 0 0-.265-.167zM140.888 113.308l-1.917-.271 1.632-1.04a.41.41 0 0 0 .174-.265l.264-1.919 1.04 1.633c.06.09.16.155.273.167l1.91.271-1.624 1.041a.372.372 0 0 0-.176.272l-.27 1.91-1.04-1.632a.374.374 0 0 0-.266-.167zM160.52 99.505l-1.917-.271 1.632-1.04a.41.41 0 0 0 .174-.265l.264-1.919 1.04 1.633c.06.09.16.155.273.167l1.91.271-1.624 1.041a.372.372 0 0 0-.176.272l-.27 1.91-1.04-1.632a.373.373 0 0 0-.266-.167zM134.76 76.833l-1.917-.271 1.632-1.04a.409.409 0 0 0 .175-.265l.264-1.919 1.04 1.632c.059.091.16.156.273.168l1.91.271-1.625 1.041a.372.372 0 0 0-.175.272l-.27 1.91-1.04-1.632a.373.373 0 0 0-.266-.167zM100.575 135.884l-1.918-.272 1.632-1.04a.409.409 0 0 0 .175-.264l.264-1.919 1.04 1.632c.06.091.16.156.273.168l1.91.27-1.624 1.042a.372.372 0 0 0-.176.272l-.27 1.91-1.04-1.632a.373.373 0 0 0-.266-.167zM47.33 85.357l1.355-.191-1.153-.735a.289.289 0 0 1-.123-.187l-.186-1.355-.735 1.153a.266.266 0 0 1-.193.118l-1.349.192 1.147.735c.07.046.116.112.124.192l.192 1.349.734-1.153a.264.264 0 0 1 .188-.118zM64.605 109.643l1.354-.192-1.153-.735a.289.289 0 0 1-.123-.187l-.187-1.354-.734 1.152a.266.266 0 0 1-.193.119l-1.349.19 1.147.736c.07.047.115.112.124.192l.191 1.35.735-1.153a.263.263 0 0 1 .187-.118zM89.428 80.884l1.355-.192-1.153-.734a.289.289 0 0 1-.123-.187l-.187-1.355-.734 1.152a.266.266 0 0 1-.193.119l-1.349.191 1.147.735c.07.047.116.112.124.193l.191 1.348.735-1.152a.264.264 0 0 1 .187-.118zM110.668 65.917l1.354-.191-1.152-.735a.289.289 0 0 1-.123-.187l-.187-1.355-.734 1.153a.266.266 0 0 1-.193.118l-1.35.192 1.148.735c.07.046.115.112.124.192l.191 1.349.735-1.153a.263.263 0 0 1 .187-.118zM124.195 79.015l1.354-.192-1.152-.735a.29.29 0 0 1-.124-.187l-.186-1.354-.734 1.152a.266.266 0 0 1-.193.119l-1.35.19 1.148.736c.07.047.115.112.124.192l.191 1.35.735-1.153a.263.263 0 0 1 .187-.118zM107.015 100.517l1.354-.192-1.152-.735a.289.289 0 0 1-.124-.186l-.186-1.355-.735 1.152a.266.266 0 0 1-.192.119l-1.35.191 1.148.735c.07.047.115.112.124.192l.191 1.35.735-1.153a.264.264 0 0 1 .187-.118zM99.52 116.75l1.355-.192-1.153-.735a.289.289 0 0 1-.123-.187l-.187-1.355-.734 1.153a.266.266 0 0 1-.193.118l-1.35.192 1.148.735c.07.046.115.112.124.192l.191 1.349.735-1.153a.263.263 0 0 1 .187-.118zM134.787 123.742l1.355-.192-1.153-.734a.289.289 0 0 1-.123-.187l-.187-1.355-.734 1.152a.266.266 0 0 1-.193.119l-1.349.191 1.147.735c.07.047.115.112.124.193l.191 1.348.735-1.152a.264.264 0 0 1 .187-.118zM151.587 88.595l1.354-.192-1.152-.734a.29.29 0 0 1-.124-.187l-.186-1.355-.735 1.152a.266.266 0 0 1-.192.119l-1.35.191 1.148.735c.07.047.115.112.124.192l.191 1.35.735-1.153a.263.263 0 0 1 .187-.118zM155.28 110.869l1.354-.192-1.153-.735a.29.29 0 0 1-.123-.186l-.186-1.355-.735 1.152a.266.266 0 0 1-.193.119l-1.349.19 1.148.736c.07.047.115.112.123.192l.192 1.35.734-1.153a.264.264 0 0 1 .188-.118z" />
				<Path
					d="M37.625 99.281c-2.683.426-5.394.254-7.851-.833a4.314 4.314 0 0 1-1.279-.877c.259-.446.556-.877.89-1.288.95-1.155 2.142-2.07 3.435-2.808a20.82 20.82 0 0 1 1.936-.967c.618-.278 1.279-.508 1.853-.872.57.982 1.25 1.94 2.074 2.72.106.101.633.667.8.46.087-.105-.105-.445-.148-.545-.93-2.142-1.988-4.149-2.433-6.472a6.455 6.455 0 0 1-.072-.421c.464-.848.814-1.763 1.46-2.5.91-1.045 2.338-1.155 3.603-.82 2.016.541 4.186 2.137 4.531 4.297.853 5.365-3.746 9.786-8.8 10.926zM72.08 71.523c.977.977 1.796 2.16 2.342 3.453-1.561-.072-3.09-.393-4.531-1.03-2.027-.895-3.18-3.396-3.08-5.609 1.944.7 3.803 1.72 5.269 3.186zM86.55 66.297c-.608 4.181-4.469 7.448-8.674 8.445a14.279 14.279 0 0 0-1.974-3.976c-.373-.532-.79-1.03-1.24-1.5-.044-.047-.25-.225-.25-.258 0-.01.015-.029.034-.053.058-.067.173-.163.197-.187.21-.215.421-.43.632-.651a55.754 55.754 0 0 1 2.649-2.563c2.045-1.834 4.263-3.434 6.639-4.737 1 .771 1.777 1.81 1.973 3.032 0 .01.005.024.005.033a24.373 24.373 0 0 0-2.539 1.754 21.151 21.151 0 0 0-2.668 2.486c-.512.57-1.068 1.192-1.38 1.901-.143.33-.12.546.269.379.714-.307 1.36-.906 1.988-1.356a42.632 42.632 0 0 1 4.34-2.75zM79.581 135.192c-2.85 1.337-5.705 2.606-8.766 3.377-.13.034-.258.062-.388.091a11.81 11.81 0 0 1-1.983-.675 4.528 4.528 0 0 1-1.667-1.293 17.65 17.65 0 0 0 4.603-1.538 14.068 14.068 0 0 0 2.73-1.748c.298-.245 1.16-.858 1.165-1.318 0-.388-.647-.095-.838-.024-.973.345-1.916.776-2.884 1.13a24.49 24.49 0 0 1-5.897 1.38c-.33-1.058-.397-2.194-.158-3.195.038-.158.086-.316.149-.47.718-1.743 2.558-1.498 4.105-1.407 1.667.095 3.372.019 4.68-1.164 1.207-1.088 1.49-2.735 2.529-3.923a2.832 2.832 0 0 1 1.518-.896c-.632 1.887-.824 3.942-.632 5.925a15.634 15.634 0 0 0 1.734 5.748zM83.226 134.546c-.043-.058-.076-.115-.115-.178-1.82-2.989-2.577-6.964-1.283-10.298 1.576.757 2.993 2.112 3.262 3.822.397 2.505-.393 4.8-1.864 6.654zM58.361 66.929c-1.293 3.362-4.704 5.896-8.35 6.72-2.466.393-4.957.278-7.246-.589 4.1-3.516 9.297-5.815 14.715-6.102.292-.015.584-.024.881-.03zM150.762 125.282c-.144 1.221-.57 2.366-1.203 3.405-6.026 2.247-13.086 1.385-18.365-2.414.024-.072.048-.144.077-.216.718-1.743 2.562-1.499 4.105-1.408 1.671.1 3.377.02 4.684-1.159 1.208-1.092 1.485-2.735 2.525-3.928.91-1.04 2.337-1.154 3.602-.814 1.94.517 4.019 2.007 4.484 4.043a29.36 29.36 0 0 1-2.022 1.58c-.771.551-1.571 1.059-2.357 1.581-.191.13-1.216.67-1.101 1.016.09.278.852.129 1.03.105.823-.12 1.628-.398 2.4-.714a15.718 15.718 0 0 0 2.14-1.077zM161.137 80.47c-1.562 2.77-4.584 4.81-7.789 5.533-2.682.426-5.394.254-7.85-.829-2.334-1.034-3.512-4.205-2.947-6.61.039-.158.087-.316.149-.47.714-1.729 2.534-1.503 4.067-1.412.167.421.31.847.445 1.283.264.863.455 1.734.685 2.601.086.336.168.915.508 1.092.32.163.776-.115 1.073-.24.196-.08.397-.167.594-.248.68-.283 1.36-.556 2.06-.771 2.945-.906 6.16-.997 9.005.071zM77.097 88.594c-1.307 1.182-3.013 1.26-4.682 1.162-1.545-.09-3.385-.335-4.104 1.409-.063.152-.113.31-.15.47-.568 2.402.61 5.573 2.947 6.607 2.454 1.086 5.166 1.259 7.849.832 5.053-1.139 9.65-5.56 8.798-10.927-.344-2.16-2.513-3.757-4.528-4.295-1.268-.338-2.693-.225-3.604.817-1.04 1.19-1.32 2.835-2.526 3.925zM99.522 145.074a27.884 27.884 0 0 1-7.29-2.596 27.012 27.012 0 0 1-4.369-2.831 5.711 5.711 0 0 1 .115-1.816c.038-.158.086-.316.149-.469.718-1.744 2.562-1.5 4.105-1.408 1.671.096 3.377.019 4.684-1.164 1.207-1.088 1.485-2.73 2.525-3.923.91-1.044 2.337-1.155 3.602-.82 2.016.542 4.186 2.137 4.526 4.297.815 5.102-3.3 9.346-8.047 10.73zM128.56 89.855c-1.307 1.181-3.013 1.259-4.682 1.162-1.545-.09-3.385-.335-4.104 1.408-.063.153-.113.31-.15.47-.568 2.402.61 5.574 2.947 6.607 2.454 1.086 5.166 1.26 7.849.833 5.053-1.14 9.65-5.56 8.798-10.927-.344-2.161-2.513-3.757-4.528-4.295-1.268-.338-2.693-.225-3.604.817-1.04 1.19-1.32 2.835-2.526 3.925zM142.81 70.727c-.134.067-.264.134-.393.202-1.485.766-2.912 1.7-3.44 3.381-.478 1.557.116 3.114-.171 4.666-.254 1.36-1.423 2.184-2.688 2.539-2.007.565-4.69.292-6.083-1.39a8.115 8.115 0 0 1-.623-.857c.206-1.221.268-2.467.206-3.669a17.037 17.037 0 0 0-.824-4.378v-.005a12.652 12.652 0 0 1 2.362-4.043c.69-.09 1.389-.139 2.098-.134 2.136.014 4.263.47 6.198 1.399 1.25.598 2.371 1.38 3.358 2.29zM168.384 93.816c-.206 1.58-.675 3.065-1.413 4.411-1.84.259-3.957-.153-5.145-1.585-3.468-4.187-1.757-10.332 2.012-13.882.173-.144.345-.283.522-.417 3.267 2.745 4.556 7.32 4.024 11.473zM158.08 97.212c-.483.325-1.039.594-1.551.857-1.485.767-2.913 1.7-3.44 3.382-.12.383-.172.771-.186 1.16-.853-.854-1.375-1.974-1.25-3.253.225-2.352 2.73-4.963 5.22-3.646.566.302 1.03.872 1.208 1.5z"
					opacity={0.3}
				/>
				<Path
					d="M159.36 95.387c-1.059-1.878-3.512-2.711-5.667-2.17-2.539.632-4.412 2.998-4.9 5.499-.546 2.778.747 5.408 2.936 7.094a8.58 8.58 0 0 0 1.078.714c-.388 1.12-1.447 1.815-2.577 2.131-2.007.565-4.69.292-6.084-1.389-3.468-4.186-1.762-10.332 2.007-13.886 2.094-1.734 4.517-2.965 7.18-3.281 2.54-.298 5.17 1.83 5.902 4.186.048.158.086.32.11.484.034.22.034.426.015.618zM100.006 62.316c-.388 1.49.158 2.99-.12 4.484-.254 1.36-1.422 2.18-2.687 2.534-2.007.565-4.69.296-6.083-1.39a7.988 7.988 0 0 1-1.6-3.113 29.707 29.707 0 0 1 6.605-2.046 31.146 31.146 0 0 1 3.885-.469zM105.864 57.167c-.556.709-1.523 1.15-2.366 1.585-.795.407-1.576.867-2.208 1.466a24.933 24.933 0 0 0-2.932.005 25.94 25.94 0 0 0-9.12 2.246c.014-1.355.326-2.73.862-4.023a28.996 28.996 0 0 1 1.94-.542c4.488-1.092 9.24-1.456 13.824-.737zM67.16 86.223c-.479 1.054-1.23 1.988-2.126 2.587a2.753 2.753 0 0 1-.432.244c-1.714.786-2.898-.646-3.966-1.767-1.154-1.207-2.457-2.314-4.215-2.338-1.629-.024-2.95.987-4.527 1.15-1.374.143-2.495-.748-3.195-1.859-1.106-1.767-1.604-4.411-.383-6.227 3.032-4.507 9.408-4.613 13.882-2.002.306.206.603.417.89.642-.986 1.528-1.125 3.573-.426 5.322.81 2.04 2.453 3.592 4.498 4.248z"
					opacity={0.3}
				/>
				<Path
					d="M64.722 80.676c-.306-.833-.364-1.806-.052-2.649 1.135 1.14 2.069 2.453 2.706 3.943.206.484.316 1 .345 1.523-1.332-.402-2.462-1.36-2.999-2.817zM38.449 110.217c-1.49.766-2.917 1.7-3.44 3.386a4.827 4.827 0 0 0-.196 1.442c-1.605-.632-3.066-1.552-4.249-2.864-1.499-1.667-2.586-3.78-3.118-6.012.196-.22.407-.436.627-.642 2.094-1.734 4.513-2.965 7.18-3.276 2.535-.302 5.164 1.83 5.897 4.182.053.158.087.32.11.483.269 1.869-1.436 2.592-2.811 3.3zM75.751 117.063c.524-1.682 1.952-2.617 3.439-3.383 1.375-.71 3.084-1.436 2.815-3.302a3.113 3.113 0 0 0-.11-.481c-.734-2.357-3.363-4.486-5.9-4.186-2.665.314-5.087 1.546-7.18 3.28-3.769 3.552-5.475 9.699-2.009 13.883 1.396 1.685 4.075 1.955 6.084 1.391 1.263-.354 2.433-1.176 2.685-2.537.29-1.554-.307-3.112.176-4.665zM113.276 116.427c-1.659-.595-2.532-2.062-3.234-3.58-.65-1.404-1.303-3.142-3.18-2.953a3.113 3.113 0 0 0-.485.09c-2.385.633-4.624 3.169-4.433 5.716.2 2.676 1.328 5.149 2.97 7.313 3.39 3.917 9.458 5.884 13.787 2.598 1.742-1.322 2.126-3.988 1.648-6.019-.3-1.277-1.072-2.48-2.42-2.79-1.54-.356-3.122.174-4.653-.375z"
					opacity={0.3}
				/>
				<Path
					d="M122.46 102.59c-2.957-3.123-7.525-3.043-10.325-.81-1.745 1.518-3.078 4.097-2.044 6.077 2.268 5.164 9.47 3.97 12.903 1.307 1.534-1.375 1.444-3.325.565-5.118a7.678 7.678 0 0 0-1.098-1.456zM115.305 88.37c-3.132.536-6.452-.221-7.86-3.43-.881-1.691-.043-3.818 1.312-5.351a8.904 8.904 0 0 0 .503 3.248c.997 2.811 3.334 4.684 6.045 5.532zM121.068 85.376c-2.999 1.039-6.682.344-8.622-2.276-1.102-1.49-1.456-3.583-.92-5.374 2.218-.814 4.876-.618 7.041.881a7.588 7.588 0 0 1 1.246 1.068c.44.455.81.949 1.102 1.452.704 1.442.9 2.989.153 4.249zM50.062 100.75c2.403 6.668 7.129 9.752 10.478 8.43 2.113-1.01 4.02-3.87 3.364-7.506-1.27-9.186-8.942-12.476-13.033-10.966-1.865.947-2.177 3.878-1.641 7.132.197.948.474 1.928.832 2.91zM100.73 101.277c7.087.06 11.619-3.303 11.541-6.903-.214-2.331-2.233-5.113-5.872-5.76-9.056-1.996-14.803 4.058-14.807 8.419.241 2.078 2.882 3.387 6.12 4.014.957.144 1.972.224 3.018.23zM127.819 112.65c2.403 6.667 7.129 9.75 10.478 8.428 2.113-1.009 4.02-3.868 3.364-7.505-1.27-9.186-8.942-12.475-13.033-10.966-1.865.947-2.176 3.878-1.641 7.132.197.948.474 1.928.832 2.911zM125.159 71.355c-.618.896-1.413 1.571-2.237 1.964-3.353 1.322-8.076-1.763-10.481-8.43a21.461 21.461 0 0 1-.834-2.913c-.191-1.183-.273-2.323-.215-3.344 4.378 1.701 8.34 4.618 11.194 8.326 1.03 1.336 1.93 2.816 2.573 4.397zM98.461 73.187c-6.56-2.68-12.015-1.236-13.277 2.136-.665 2.245.18 5.577 3.32 7.525 7.672 5.21 15.253 1.716 16.872-2.333.546-2.02-1.421-4.214-4.196-5.995-.836-.49-1.75-.94-2.719-1.333zM59.05 136.548a2.502 2.502 0 0 1-.071.369c-.278.69-.723 1.365-1.322 1.983-2.548-.551-5.03-1.461-7.247-2.836-3.09-1.911-5.768-4.416-7.722-7.497 2.428-.68 5.729-.464 9.374 1.026.968.392 1.883.843 2.716 1.331 1.509.968 2.774 2.05 3.53 3.167-1.604-.388-3.166-.954-4.675-1.63-.278-.124-3.022-1.618-3.156-1.134-.087.316.56.9.737 1.082.666.69 1.447 1.28 2.252 1.796a17.767 17.767 0 0 0 5.436 2.31c.048.009.1.023.149.033zM57.784 115.876c-5.39-4.601-11.023-4.939-13.278-2.132-1.335 1.924-1.576 5.353.795 8.187 5.654 7.35 13.948 6.408 16.754 3.07 1.151-1.747-.03-4.447-2.107-7.008a21.109 21.109 0 0 0-2.164-2.117zM127.702 129.31c-.038.105-.072.206-.11.307a29.942 29.942 0 0 1-2.563 5.345c-2.083 3.406-5.034 6.218-8.57 8.086-.804.426-1.637.795-2.485 1.111-.714-.335-1.322-.776-1.782-1.283-2.228-2.832-.637-8.244 5.058-12.464a21.098 21.098 0 0 1 2.548-1.634c2.96-1.451 5.859-1.997 7.3-.483.23.301.432.641.604 1.015zM95.067 122.043c-2.4 2.439-5.609 2.664-7.62 1.691-1.189-.68-2.003-1.916-2.353-3.516 2.05-1.164 4.642-1.365 6.903-.507 1.226.464 2.328 1.264 3.07 2.332zM96.878 119.897c-1.04-1.38-2.496-2.462-4.24-3.108a11.344 11.344 0 0 0-7.61-.063c.272-1.963 1.063-4.172 2.457-6.437a20.76 20.76 0 0 1 1.758-2.467c2.208-2.453 4.69-4.038 6.596-3.171 3.405 2.055 5.556 8.943 1.039 15.247z"
					opacity={0.2}
				/>
			</G>
			<G fill="#6ac4e9">
				<Path d="M193.535 66.961c-.543-.754-1.657-.78-2.314-.17-.282-.848-1.267-1.359-2.107-.962-.442.214-.76.66-.816 1.15-.058.503.15 1.004.434 1.42.5.732 1.296 1.326 1.508 2.229l.002.01.001.009.008-.016c.62-.692 1.597-.83 2.387-1.233.454-.23.876-.572 1.065-1.042.187-.451.122-.999-.168-1.395zM186.732 77.764c-1.67-.23-3.105 1.199-3.124 2.83-1.475-.697-3.394-.036-3.916 1.563a2.702 2.702 0 0 0 .473 2.52c.59.708 1.512 1.064 2.418 1.214 1.596.262 3.373-.033 4.83.822l.012.022c0-.004.004-.01.003-.015.005.005.01.004.015.008l-.018-.026c-.125-1.678.923-3.144 1.385-4.694.27-.885.356-1.868-.026-2.706a2.7 2.7 0 0 0-2.052-1.538zM174.435 66.82c-.384-1.157-1.738-1.858-2.875-1.313a2.028 2.028 0 0 0-1.12 1.564c-.082.687.204 1.374.597 1.944.684.999 1.764 1.81 2.057 3.04l-.007.02c.005 0 .004-.005.01-.006 0 0 0 .005.005.009l.002-.02c.848-.94 2.185-1.134 3.263-1.684.62-.314 1.193-.776 1.453-1.417a2.025 2.025 0 0 0-.229-1.909c-.74-1.024-2.258-1.06-3.156-.228zM11.706 66.978a1.484 1.484 0 0 0-.816-1.149c-.84-.397-1.825.114-2.107.963-.657-.611-1.77-.585-2.314.17-.29.395-.355.943-.168 1.394.189.47.61.812 1.065 1.042.79.404 1.768.54 2.387 1.233l.008.016.001-.01.002-.01c.212-.902 1.007-1.496 1.509-2.228.282-.416.49-.917.433-1.42zM127.487 54.887c.79.404 1.768.54 2.388 1.233l.007.016.001-.01.002-.01c.212-.902 1.007-1.496 1.509-2.228.282-.417.49-.917.433-1.42a1.484 1.484 0 0 0-.815-1.15c-.84-.397-1.826.114-2.108.963-.656-.611-1.77-.585-2.314.17-.29.395-.355.943-.168 1.393.19.47.611.813 1.065 1.043zM68.693 56.117l.002.01.001.009.007-.016c.62-.692 1.597-.83 2.388-1.233.454-.23.876-.572 1.065-1.043.187-.45.121-.998-.168-1.394-.543-.754-1.657-.78-2.314-.17-.282-.848-1.268-1.359-2.108-.962-.442.214-.76.66-.815 1.15-.058.503.15 1.003.433 1.42.502.732 1.297 1.326 1.51 2.229zM16.396 80.594c-.019-1.631-1.455-3.06-3.124-2.83a2.7 2.7 0 0 0-2.052 1.538c-.382.838-.296 1.82-.026 2.706.462 1.55 1.51 3.016 1.385 4.694l-.018.026c.005-.004.01-.003.015-.007 0 .004.004.01.003.014l.013-.022c1.456-.855 3.233-.56 4.83-.822.905-.15 1.828-.506 2.417-1.215a2.702 2.702 0 0 0 .474-2.52c-.523-1.598-2.442-2.259-3.917-1.562zM26.9 72.058l.002.02a.015.015 0 0 0 .006-.009c.005 0 .004.005.009.006l-.007-.02c.293-1.23 1.373-2.041 2.057-3.04.393-.57.68-1.257.597-1.944a2.028 2.028 0 0 0-1.12-1.564c-1.137-.545-2.491.156-2.874 1.313-.899-.832-2.417-.796-3.157.228-.39.541-.481 1.288-.228 1.909.259.64.832 1.103 1.452 1.417 1.078.55 2.415.743 3.263 1.684z" />
			</G>
		</Svg>
	);
}
export default SvgComponent;
