import * as React from 'react';
import Svg, { Circle, Path } from 'react-native-svg';
function SvgComponent(props) {
	const size = props.size ?? 512;
	const scale = size / 512;
	const color = props.color ?? 'white';

	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			width={512 * scale}
			height={512 * scale}
			viewBox="0 0 64 64"
			{...props}
		>
			<Circle cx={48} cy={20} r={1} />
			<Path
				fill={color}
				d="M60 18h-.973a6.263 6.263 0 0 1-4.46-1.848c-.298-.298-.614-.57-.939-.828A4.446 4.446 0 0 0 54 13.586c0-1.246.664-2.418 1.732-3.059l2.037-1.223A2.544 2.544 0 0 0 59 7.131v-.596A2.538 2.538 0 0 0 56.465 4c-.502 0-.988.147-1.406.426l-1.374.916a2.045 2.045 0 0 1-3.121-1.206l-.215-.864C50.014 1.935 48.817 1 47.399 1a3.246 3.246 0 0 0-2.919 1.804 3.265 3.265 0 0 0-.247 2.251l.077.308a11.72 11.72 0 0 0 3.083 5.444c.391.391.607.913.607 1.467 0 .264-.063.523-.162.769a10.738 10.738 0 0 0-.882-.043c-.541 0-1.077.044-1.605.124a7.644 7.644 0 0 0-5.159-3.995l-2.651-.589a2.993 2.993 0 0 1-2.233-2.102l-.905-3.172C34.022 1.933 32.784 1 31.354 1c-1.219 0-2.313.678-2.874 1.804a3.265 3.265 0 0 0-.247 2.251l.124.496c.088.352.01.716-.212 1.001a1.16 1.16 0 0 1-.919.448c-.407 0-.79-.217-.955-.483l-1.848-3.86A2.93 2.93 0 0 0 21.793 1c-.778 0-1.509.303-2.062.854l-.821.822A3.09 3.09 0 0 0 18 4.873c0 1.041.517 2.007 1.383 2.584a8.353 8.353 0 0 1 2.831 3.207A4.205 4.205 0 0 0 25.994 13h4.79c.985 0 1.955.214 2.85.613a7.023 7.023 0 0 0-2.109 1.447l-.846.846L32.7 18.6a6.03 6.03 0 0 0 4.8 2.4h.244A34.505 34.505 0 0 0 37 28.123v.891a2.915 2.915 0 0 0-2.43 1.61l-.178.355A3.747 3.747 0 0 0 34 32.642c0 .188.037.37.065.553-1.743.44-3.568.54-5.341.245l-3.628-.604a61.684 61.684 0 0 0-9.818-.835l-1.228-.737a8.899 8.899 0 0 1-4.08-5.506l-.344-1.377-2.809 1.873c-1.066.709-1.722 1.87-1.801 3.168A4.591 4.591 0 0 0 3 33.236c0 2.64 1.971 4.912 4.587 5.286l1.753.245A10.137 10.137 0 0 0 8 43.811c0 2.323.901 4.504 2.538 6.143l.188.187a.94.94 0 0 1 .274.662.932.932 0 0 1-.518.838l-7.858 3.93A2.919 2.919 0 0 0 1 58.197c0 .773.313 1.53.86 2.077l1.792 1.792A3.164 3.164 0 0 0 5.906 63c.998 0 1.951-.477 2.55-1.275a12.921 12.921 0 0 1 5.542-4.247l7.917-3.166a6.48 6.48 0 0 0 2.707-2.052c1.435.482 2.923.74 4.444.74 2.771 0 5.455-.812 7.76-2.35a14.21 14.21 0 0 1 4.282-1.912c.787.56 1.676.989 2.648 1.232l6.485 1.621a1 1 0 0 1 .759.971v.833a3.862 3.862 0 0 1-1.723 3.219C48.478 57.146 48 58.039 48 59s.478 1.854 1.277 2.387l1.602 1.068A3.232 3.232 0 0 0 52.68 63a3.034 3.034 0 0 0 2.77-1.801l3.141-7.064a4.73 4.73 0 0 0 .41-1.932c0-.997-.306-1.952-.886-2.764l-3.138-4.393a5.213 5.213 0 0 1-.872-2.057A1.996 1.996 0 0 0 56 41v-2.586A2.01 2.01 0 0 0 55.414 37a2.285 2.285 0 0 1-.63-1.177l-.215-1.078c-.367-1.833-1.8-3.23-3.569-3.623v-2.13a7.942 7.942 0 0 0 4.312-1.331 10.19 10.19 0 0 1 2.421-1.186l3.215-1.071A2.994 2.994 0 0 0 63 22.559V21c0-1.654-1.346-3-3-3zm1 3v.699A2.92 2.92 0 0 1 59.209 20H60c.551 0 1 .448 1 1zM48.806 9.393a9.732 9.732 0 0 1-2.556-4.515l-.077-.308a1.264 1.264 0 0 1 .096-.872c.215-.43.648-.698 1.169-.698a1 1 0 0 1 .97.757l.215.864a4.032 4.032 0 0 0 2.646 2.857 4.032 4.032 0 0 0 3.524-.473l1.374-.916c.334-.222.833.046.833.446v.596c0 .188-.1.363-.26.459l-2.038 1.223a5.594 5.594 0 0 0-2.703 4.773c0 .211-.035.419-.089.622a10.653 10.653 0 0 0-2.087-.814c.105-.366.176-.74.176-1.12a4.04 4.04 0 0 0-1.193-2.881zM25.994 11a2.214 2.214 0 0 1-1.991-1.23 10.377 10.377 0 0 0-3.51-3.977 1.104 1.104 0 0 1-.168-1.703l.82-.821c.423-.421 1.217-.284 1.474.251l1.893 3.943A3.182 3.182 0 0 0 27.226 9c.981 0 1.891-.443 2.495-1.218a3.146 3.146 0 0 0 .576-2.716l-.124-.496a1.296 1.296 0 0 1 .115-.91c.203-.407.611-.66 1.103-.66.512 0 .95.327 1.089.815l.905 3.172a4.994 4.994 0 0 0 3.722 3.506l2.65.589a5.644 5.644 0 0 1 3.591 2.567c-.777.277-1.532.621-2.235 1.075a6.973 6.973 0 0 0-4.494-1.718l-1.205-.723a9.004 9.004 0 0 0-4.63-1.282h-4.79zm10.187 20.874.178-.355c.271-.546 1.071-.674 1.501-.244a11.672 11.672 0 0 0 6.368 3.277l1.201.2-.214 1.071a2.277 2.277 0 0 1-.568 1.093l-1.892-.304a13.996 13.996 0 0 1-6.069-2.597 1.717 1.717 0 0 1-.505-2.141zM46 39h8v2h-8zM5.066 60.652 3.274 58.86A.945.945 0 0 1 3 58.197c0-.357.199-.679.518-.838l1.618-.809 2.753 2.754c-.363.389-.712.793-1.033 1.221-.411.546-1.305.61-1.79.127zm46.923.139-1.603-1.068a.869.869 0 0 1 .001-1.446 5.866 5.866 0 0 0 1.018-.868l2.795 1.677-.578 1.3c-.265.6-1.09.767-1.633.405zm4.498-10.189c.336.469.513 1.024.513 1.601 0 .388-.08.765-.237 1.119l-1.744 3.923-2.515-1.509A5.863 5.863 0 0 0 53 53.395v-.833a2.996 2.996 0 0 0-2.272-2.91l-6.485-1.621a5.86 5.86 0 0 1-4.272-4.272l-1.94.484a7.866 7.866 0 0 0 1.413 2.908 16.274 16.274 0 0 0-3.725 1.836c-2.958 1.972-6.718 2.497-10.109 1.483a6.46 6.46 0 0 0-1.513-6.788l-1.39-1.39-1.414 1.414 1.39 1.39A4.467 4.467 0 0 1 24 48.277c0 1.851-1.11 3.49-2.827 4.177l-7.917 3.166a14.939 14.939 0 0 0-3.906 2.316l-2.328-2.328 4.355-2.178A2.922 2.922 0 0 0 13 50.803c0-.773-.313-1.53-.86-2.077l-.189-.188A6.643 6.643 0 0 1 10 43.811c0-2.19.854-4.251 2.403-5.8l1.304-1.304-1.414-1.414-1.304 1.304c-.109.109-.205.227-.308.34l-2.813-.394A3.357 3.357 0 0 1 5 33.236c0-.577.202-1.107.531-1.549.187.34.406.664.688.946l1.074 1.074 1.414-1.414-1.075-1.074A2.182 2.182 0 0 1 7 29.646c0-.696.346-1.343.926-1.729l.524-.35a10.87 10.87 0 0 0 4.571 5.41L14.723 34H15c3.26 0 6.547.272 9.768.809l3.628.604c.814.136 1.639.203 2.463.203 1.364 0 2.725-.196 4.04-.561.175.205.368.396.587.56a16.017 16.017 0 0 0 6.946 2.971l1.568.252V41c0 1.103.897 2 2 2h6.077a7.173 7.173 0 0 0 1.272 3.209zm-3.879-15.464.215 1.078c.054.272.143.531.246.784H46.93c.104-.253.192-.513.246-.784l.215-1.078C47.64 33.899 48.737 33 50 33s2.36.899 2.608 2.138zm4.494-10.56a12.111 12.111 0 0 0-2.899 1.419A5.96 5.96 0 0 1 50.889 27a5.93 5.93 0 0 1-4.224-1.75l-.958-.957-1.414 1.414.957.957A7.914 7.914 0 0 0 49 28.767v2.355a4.668 4.668 0 0 0-2.708 1.746l-1.735-.289a9.681 9.681 0 0 1-5.283-2.719c-.085-.085-.181-.153-.274-.226v-1.512c0-2.654.326-5.306.97-7.881L40.281 19H37.5a4.023 4.023 0 0 1-3.2-1.6l-.962-1.284A4.996 4.996 0 0 1 36.5 15c1.345 0 2.609.523 3.561 1.475l.812.812 1.223-.815A8.728 8.728 0 0 1 46.956 15c2.341 0 4.542.911 6.196 2.566a8.237 8.237 0 0 0 3.918 2.193 4.912 4.912 0 0 0 3.153 3.779z"
			/>
			<Path
				fill={color}
				d="M20 35c-2.243 0-4 1.317-4 3s1.757 3 4 3 4-1.317 4-3-1.757-3-4-3zm0 4c-1.221 0-2-.592-2-1s.779-1 2-1 2 .592 2 1-.779 1-2 1zM26 37v2c1.221 0 2 .592 2 1s-.779 1-2 1v2c2.243 0 4-1.317 4-3s-1.757-3-4-3zM14 46c0 1.683 1.757 3 4 3v-2c-1.221 0-2-.592-2-1s.779-1 2-1v-2c-2.243 0-4 1.317-4 3z"
			/>
		</Svg>
	);
}
export default SvgComponent;
