import * as React from 'react';
import Svg, { Path, G, Circle } from 'react-native-svg';
function SvgComponent(props) {
	const size = props.size ?? 512;
	const scale = size / 512;
	const color = props.color ?? 'white';

	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			width={512 * scale}
			height={512 * scale}
			viewBox="0 0 64 64"
			{...props}
		>
			<Path
				fill="#cf9e76"
				d="M15 33c3.33 0 6.65.27 9.93.82l3.63.61c2.26.37 4.58.19 6.75-.53.18.35.45.67.78.92 1.91 1.43 4.14 2.39 6.5 2.78l2.5.4c-.06.13-.09.27-.09.41V41c0 .55.45 1 1 1h7c0 1.3.41 2.57 1.16 3.63l3.14 4.39c.46.64.7 1.4.7 2.18 0 .53-.11 1.05-.32 1.53l-2.2 4.95h-.01l-4.29-2.57-.01-.01c.54-.79.83-1.73.83-2.71v-.83c0-.92-.62-1.72-1.51-1.94L44 49c-1-.25-1.91-.72-2.68-1.36l-.01.01c-1.8.41-3.5 1.14-5.04 2.17a12.993 12.993 0 0 1-12.03 1.25 5.47 5.47 0 0 1-2.7 2.31l-7.91 3.17c-1.61.64-3.08 1.58-4.33 2.75l-3.97-3.97 5.6-2.79c.66-.33 1.07-1 1.07-1.74 0-.51-.2-1-.57-1.37l-.19-.19A7.672 7.672 0 0 1 9 43.81c0-2.12.73-4.17 2.07-5.81l-3.34-.47A4.33 4.33 0 0 1 4 33.24c0-1.37.77-2.63 2-3.24h.02c-.01-.11-.02-.21-.02-.32v-.03c0-1.03.51-1.99 1.37-2.56L9 26a9.942 9.942 0 0 0 4.54 6.12zM50 27.94V32c-1.39 0-2.63.78-3.24 1.96l-2.37-.39c-2.2-.37-4.24-1.42-5.82-3-.17-.17-.36-.3-.57-.39V28.12c0-2.74.34-5.46 1-8.12h-1.5c-1.57 0-3.06-.74-4-2L32 16l.23-.23c1.05-1.05 2.47-1.68 4.11-1.76.05-.01.11-.01.16-.01 1.6 0 3.14.64 4.27 1.77L41 16l.54-.36c.37-.24.75-.46 3.22-1.39a9.58 9.58 0 0 1 3.68-.13c.78.11 1.53.32 2.26.62a9.792 9.792 0 0 1 3.16 2.12A7.211 7.211 0 0 0 58 18.92v.01c0 1.8 1.23 3.38 2.98 3.82l.96.24c-.14.68-.63 1.24-1.31 1.47l-3.21 1.07c-.94.31-1.84.75-2.66 1.3A7.01 7.01 0 0 1 50.89 28c-.3 0-.6-.02-.89-.06z"
			/>
			<Path
				fill="#b27946"
				d="M48.68 13.65c.21-.43.32-.9.32-1.38 0-.81-.32-1.59-.9-2.17-1.37-1.37-2.35-3.1-2.82-4.98l-.08-.31a2.21 2.21 0 0 1 .17-1.56A2.27 2.27 0 0 1 47.4 2h.04c.92 0 1.72.62 1.94 1.51l.21.87a3.068 3.068 0 0 0 2 2.15c.89.3 1.87.16 2.65-.36l1.37-.91c.26-.17.55-.26.85-.26.85 0 1.54.69 1.54 1.54v.59c0 .54-.28 1.04-.75 1.32l-2.03 1.22A4.553 4.553 0 0 0 53 13.59a3.4 3.4 0 0 1-.67 2.02c-.51-.34-1.06-.63-1.63-.87-.73-.3-1.48-.51-2.26-.62v-.01zM44.76 14.25c-2.47.93-2.85 1.15-3.22 1.39L41 16l-.23-.23A6.049 6.049 0 0 0 36.5 14c-.05 0-.11 0-.16.01V14l-1.44-.86A7.967 7.967 0 0 0 30.78 12h-4.79c-1.22 0-2.34-.69-2.88-1.78a9.309 9.309 0 0 0-3.17-3.59c-.59-.4-.94-1.05-.94-1.76 0-.56.22-1.09.62-1.49l.82-.82a1.916 1.916 0 0 1 3.08.53l1.85 3.86c.39.65 1.1 1.05 1.86 1.05 1.23 0 2.17-1 2.17-2.16 0-.17-.03-.35-.07-.53l-.13-.5c-.13-.52-.07-1.08.17-1.56l.02-.03C29.76 2.47 30.52 2 31.35 2h.04c.96 0 1.79.63 2.05 1.54.27.93.61 2.13.91 3.17.4 1.41 1.54 2.49 2.97 2.81l2.66.59c2.2.49 3.99 2.06 4.78 4.14z"
			/>
			<Path
				fill="#838f9b"
				d="m55.48 58.68-.94 2.11c-.33.74-1.06 1.21-1.86 1.21-.44 0-.88-.13-1.25-.38l-1.6-1.07c-.52-.34-.83-.93-.83-1.55s.31-1.21.83-1.55c.54-.36 1-.82 1.34-1.35l.01.01 4.29 2.57zM5.33 55.33 9.3 59.3c-.6.55-1.15 1.16-1.64 1.82a2.188 2.188 0 0 1-3.3.24l-1.79-1.79A1.93 1.93 0 0 1 2 58.2c0-.74.41-1.41 1.07-1.74z"
			/>
			<Path
				fill="#ef7385"
				d="M46.2 36.02c-.13.64-.45 1.23-.91 1.69-.08.08-.15.18-.19.29h-.01l-2.5-.4c-2.36-.39-4.59-1.35-6.5-2.78A2.741 2.741 0 0 1 35 32.64c0-.42.1-.84.29-1.21l.17-.36c.33-.66 1-1.07 1.74-1.07.05 0 .09 0 .8.18.21.09.4.22.57.39 1.58 1.58 3.62 2.63 5.82 3l2.37.39c-.16.3-.28.63-.35.98zM61.94 22.99l-.96-.24A3.946 3.946 0 0 1 58 18.93v-.01c.34.06.68.08 1.03.08H60c1.1 0 2 .9 2 2v1.56c0 .15-.02.29-.05.43z"
			/>
			<G fill="#fcd770">
				<Path d="M54.9 38h-9.8c.04-.11.11-.21.19-.29.46-.46.78-1.05.91-1.69l.21-1.08c.07-.35.19-.68.35-.98A3.646 3.646 0 0 1 50 32c.87 0 1.68.31 2.32.83s1.1 1.25 1.27 2.11l.21 1.08c.13.64.45 1.23.91 1.69.08.08.15.18.19.29zM55 38.41V41c0 .55-.45 1-1 1h-8c-.55 0-1-.45-1-1v-2.59c0-.14.03-.28.09-.41h9.81c.07.13.1.27.1.41z" />
			</G>
			<Circle cx={48} cy={20} r={1} />
			<Path d="M60 18h-.973a6.263 6.263 0 0 1-4.46-1.848c-.298-.298-.614-.57-.939-.828A4.446 4.446 0 0 0 54 13.586c0-1.246.664-2.418 1.732-3.059l2.037-1.223A2.544 2.544 0 0 0 59 7.131v-.596A2.538 2.538 0 0 0 56.465 4c-.502 0-.988.147-1.406.426l-1.374.916a2.045 2.045 0 0 1-3.121-1.206l-.215-.864C50.014 1.935 48.817 1 47.399 1a3.246 3.246 0 0 0-2.919 1.804 3.265 3.265 0 0 0-.247 2.251l.077.308a11.72 11.72 0 0 0 3.083 5.444c.391.391.607.913.607 1.467 0 .264-.063.523-.162.769a10.738 10.738 0 0 0-.882-.043c-.541 0-1.077.044-1.605.124a7.644 7.644 0 0 0-5.159-3.995l-2.651-.589a2.993 2.993 0 0 1-2.233-2.102l-.905-3.172C34.022 1.933 32.784 1 31.354 1c-1.219 0-2.313.678-2.874 1.804a3.265 3.265 0 0 0-.247 2.251l.124.496c.088.352.01.716-.212 1.001a1.16 1.16 0 0 1-.919.448c-.407 0-.79-.217-.955-.483l-1.848-3.86A2.93 2.93 0 0 0 21.793 1c-.778 0-1.509.303-2.062.854l-.821.822A3.09 3.09 0 0 0 18 4.873c0 1.041.517 2.007 1.383 2.584a8.353 8.353 0 0 1 2.831 3.207A4.205 4.205 0 0 0 25.994 13h4.79c.985 0 1.955.214 2.85.613a7.023 7.023 0 0 0-2.109 1.447l-.846.846L32.7 18.6a6.03 6.03 0 0 0 4.8 2.4h.244A34.505 34.505 0 0 0 37 28.123v.891a2.915 2.915 0 0 0-2.43 1.61l-.178.355A3.747 3.747 0 0 0 34 32.642c0 .188.037.37.065.553-1.743.44-3.568.54-5.341.245l-3.628-.604a61.684 61.684 0 0 0-9.818-.835l-1.228-.737a8.899 8.899 0 0 1-4.08-5.506l-.344-1.377-2.809 1.873c-1.066.709-1.722 1.87-1.801 3.168A4.591 4.591 0 0 0 3 33.236c0 2.64 1.971 4.912 4.587 5.286l1.753.245A10.137 10.137 0 0 0 8 43.811c0 2.323.901 4.504 2.538 6.143l.188.187a.94.94 0 0 1 .274.662.932.932 0 0 1-.518.838l-7.858 3.93A2.919 2.919 0 0 0 1 58.197c0 .773.313 1.53.86 2.077l1.792 1.792A3.164 3.164 0 0 0 5.906 63c.998 0 1.951-.477 2.55-1.275a12.921 12.921 0 0 1 5.542-4.247l7.917-3.166a6.48 6.48 0 0 0 2.707-2.052c1.435.482 2.923.74 4.444.74 2.771 0 5.455-.812 7.76-2.35a14.21 14.21 0 0 1 4.282-1.912c.787.56 1.676.989 2.648 1.232l6.485 1.621a1 1 0 0 1 .759.971v.833a3.862 3.862 0 0 1-1.723 3.219C48.478 57.146 48 58.039 48 59s.478 1.854 1.277 2.387l1.602 1.068A3.232 3.232 0 0 0 52.68 63a3.034 3.034 0 0 0 2.77-1.801l3.141-7.064a4.73 4.73 0 0 0 .41-1.932c0-.997-.306-1.952-.886-2.764l-3.138-4.393a5.213 5.213 0 0 1-.872-2.057A1.996 1.996 0 0 0 56 41v-2.586A2.01 2.01 0 0 0 55.414 37a2.285 2.285 0 0 1-.63-1.177l-.215-1.078c-.367-1.833-1.8-3.23-3.569-3.623v-2.13a7.942 7.942 0 0 0 4.312-1.331 10.19 10.19 0 0 1 2.421-1.186l3.215-1.071A2.994 2.994 0 0 0 63 22.559V21c0-1.654-1.346-3-3-3zm1 3v.699A2.92 2.92 0 0 1 59.209 20H60c.551 0 1 .448 1 1zM48.806 9.393a9.732 9.732 0 0 1-2.556-4.515l-.077-.308a1.264 1.264 0 0 1 .096-.872c.215-.43.648-.698 1.169-.698a1 1 0 0 1 .97.757l.215.864a4.032 4.032 0 0 0 2.646 2.857 4.032 4.032 0 0 0 3.524-.473l1.374-.916c.334-.222.833.046.833.446v.596c0 .188-.1.363-.26.459l-2.038 1.223a5.594 5.594 0 0 0-2.703 4.773c0 .211-.035.419-.089.622a10.653 10.653 0 0 0-2.087-.814c.105-.366.176-.74.176-1.12a4.04 4.04 0 0 0-1.193-2.881zM25.994 11a2.214 2.214 0 0 1-1.991-1.23 10.377 10.377 0 0 0-3.51-3.977 1.104 1.104 0 0 1-.168-1.703l.82-.821c.423-.421 1.217-.284 1.474.251l1.893 3.943A3.182 3.182 0 0 0 27.226 9c.981 0 1.891-.443 2.495-1.218a3.146 3.146 0 0 0 .576-2.716l-.124-.496a1.296 1.296 0 0 1 .115-.91c.203-.407.611-.66 1.103-.66.512 0 .95.327 1.089.815l.905 3.172a4.994 4.994 0 0 0 3.722 3.506l2.65.589a5.644 5.644 0 0 1 3.591 2.567c-.777.277-1.532.621-2.235 1.075a6.973 6.973 0 0 0-4.494-1.718l-1.205-.723a9.004 9.004 0 0 0-4.63-1.282h-4.79zm10.187 20.874.178-.355c.271-.546 1.071-.674 1.501-.244a11.672 11.672 0 0 0 6.368 3.277l1.201.2-.214 1.071a2.277 2.277 0 0 1-.568 1.093l-1.892-.304a13.996 13.996 0 0 1-6.069-2.597 1.717 1.717 0 0 1-.505-2.141zM46 39h8v2h-8zM5.066 60.652 3.274 58.86A.945.945 0 0 1 3 58.197c0-.357.199-.679.518-.838l1.618-.809 2.753 2.754c-.363.389-.712.793-1.033 1.221-.411.546-1.305.61-1.79.127zm46.923.139-1.603-1.068a.869.869 0 0 1 .001-1.446 5.866 5.866 0 0 0 1.018-.868l2.795 1.677-.578 1.3c-.265.6-1.09.767-1.633.405zm4.498-10.189c.336.469.513 1.024.513 1.601 0 .388-.08.765-.237 1.119l-1.744 3.923-2.515-1.509A5.863 5.863 0 0 0 53 53.395v-.833a2.996 2.996 0 0 0-2.272-2.91l-6.485-1.621a5.86 5.86 0 0 1-4.272-4.272l-1.94.484a7.866 7.866 0 0 0 1.413 2.908 16.274 16.274 0 0 0-3.725 1.836c-2.958 1.972-6.718 2.497-10.109 1.483a6.46 6.46 0 0 0-1.513-6.788l-1.39-1.39-1.414 1.414 1.39 1.39A4.467 4.467 0 0 1 24 48.277c0 1.851-1.11 3.49-2.827 4.177l-7.917 3.166a14.939 14.939 0 0 0-3.906 2.316l-2.328-2.328 4.355-2.178A2.922 2.922 0 0 0 13 50.803c0-.773-.313-1.53-.86-2.077l-.189-.188A6.643 6.643 0 0 1 10 43.811c0-2.19.854-4.251 2.403-5.8l1.304-1.304-1.414-1.414-1.304 1.304c-.109.109-.205.227-.308.34l-2.813-.394A3.357 3.357 0 0 1 5 33.236c0-.577.202-1.107.531-1.549.187.34.406.664.688.946l1.074 1.074 1.414-1.414-1.075-1.074A2.182 2.182 0 0 1 7 29.646c0-.696.346-1.343.926-1.729l.524-.35a10.87 10.87 0 0 0 4.571 5.41L14.723 34H15c3.26 0 6.547.272 9.768.809l3.628.604c.814.136 1.639.203 2.463.203 1.364 0 2.725-.196 4.04-.561.175.205.368.396.587.56a16.017 16.017 0 0 0 6.946 2.971l1.568.252V41c0 1.103.897 2 2 2h6.077a7.173 7.173 0 0 0 1.272 3.209zm-3.879-15.464.215 1.078c.054.272.143.531.246.784H46.93c.104-.253.192-.513.246-.784l.215-1.078C47.64 33.899 48.737 33 50 33s2.36.899 2.608 2.138zm4.494-10.56a12.111 12.111 0 0 0-2.899 1.419A5.96 5.96 0 0 1 50.889 27a5.93 5.93 0 0 1-4.224-1.75l-.958-.957-1.414 1.414.957.957A7.914 7.914 0 0 0 49 28.767v2.355a4.668 4.668 0 0 0-2.708 1.746l-1.735-.289a9.681 9.681 0 0 1-5.283-2.719c-.085-.085-.181-.153-.274-.226v-1.512c0-2.654.326-5.306.97-7.881L40.281 19H37.5a4.023 4.023 0 0 1-3.2-1.6l-.962-1.284A4.996 4.996 0 0 1 36.5 15c1.345 0 2.609.523 3.561 1.475l.812.812 1.223-.815A8.728 8.728 0 0 1 46.956 15c2.341 0 4.542.911 6.196 2.566a8.237 8.237 0 0 0 3.918 2.193 4.912 4.912 0 0 0 3.153 3.779z" />
			<Path d="M20 35c-2.243 0-4 1.317-4 3s1.757 3 4 3 4-1.317 4-3-1.757-3-4-3zm0 4c-1.221 0-2-.592-2-1s.779-1 2-1 2 .592 2 1-.779 1-2 1zM26 37v2c1.221 0 2 .592 2 1s-.779 1-2 1v2c2.243 0 4-1.317 4-3s-1.757-3-4-3zM14 46c0 1.683 1.757 3 4 3v-2c-1.221 0-2-.592-2-1s.779-1 2-1v-2c-2.243 0-4 1.317-4 3z" />
		</Svg>
	);
}
export default SvgComponent;
