// @ts-nocheck
import * as React from 'react';
import Svg, { Path, G } from 'react-native-svg';
function SvgComponent(props) {
	const size = props.size ?? 512;
	const scale = size / 512;
	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			xmlSpace="preserve"
			style={{
				enableBackground: 'new 0 0 512 512',
			}}
			viewBox="0 0 512 512"
			{...props}
		>
			<G scale={scale}>
				<Path
					d="M269.549 114.328 214.822 36.39c-15.532-22.12-49.186-19.131-60.577 5.381l-40.133 86.364 155.437-13.807z"
					style={{
						fill: '#f9475e',
					}}
				/>
				<Path
					d="m206.203 146.595 42.403-24.481-111.183-64.192c-31.556-18.219-71 4.555-71 40.992v47.681h139.78zM242.451 114.328l54.727-77.938c15.533-22.12 49.186-19.131 60.577 5.381l40.133 86.364-155.437-13.807z"
					style={{
						fill: '#fd5c6f',
					}}
				/>
				<Path
					d="M445.577 146.595V98.914c0-36.437-39.445-59.211-71-40.992l-111.183 64.192 42.403 24.481h139.78z"
					style={{
						fill: '#ff6e80',
					}}
				/>
				<Path
					d="M307.95 126.748c0 7.03-1.4 13.73-3.93 19.85H244.5c-10.174-4.491-10.174-12.82-10.174-19.85 0-22.26 10.656-47.865 39.934-48.65 19.68 7.39 33.69 26.39 33.69 48.65z"
					style={{
						fill: '#ff8a98',
					}}
				/>
				<Path
					d="M240.57 126.748c0 7.03 1.4 13.73 3.93 19.85h-36.52a51.827 51.827 0 0 1-3.93-19.85c0-28.69 23.26-51.95 51.95-51.95 6.42 0 12.58 1.17 18.26 3.3-19.68 7.39-33.69 26.39-33.69 48.65z"
					style={{
						fill: '#ff6e80',
					}}
				/>
				<Path
					d="M461.13 249.518v171.15c0 38.59-31.29 69.88-69.88 69.88h-67.91l-58.17-41.56c-32.74-60.36-32.84-148.38-7.21-199.47h203.17z"
					style={{
						fill: '#fce3a0',
					}}
				/>
				<Path
					d="m265.17 448.988-4.88-3.49-71.63 45.05h-67.91c-38.59 0-69.88-31.29-69.88-69.88v-171.15h207.09c-25.63 51.09-25.53 139.11 7.21 199.47z"
					style={{
						fill: '#ffce71',
					}}
				/>
				<Path
					d="M323.34 249.518v241.03h-24.38c-89.591-16.757-105.783-204.203-41-241.03h65.38z"
					style={{
						fill: '#ff8a98',
					}}
				/>
				<Path
					d="M298.96 490.548h-110.3v-241.03h69.3c-32.55 64.88-23.61 189.31 41 241.03z"
					style={{
						fill: '#ff6e80',
					}}
				/>
				<Path
					d="M504.5 176.678v50.18c0 22.07-17.88 39.95-39.95 39.95H323.34l-61.31-23.11c-11.69-24.68-14.4-56.07-5.49-83.49l66.8-23.48h141.21c22.07 0 39.95 17.88 39.95 39.95z"
					style={{
						fill: '#ffce71',
					}}
				/>
				<Path
					d="m262.03 243.698-6.03-2.27-67.34 25.38H47.45c-22.07 0-39.95-17.88-39.95-39.95v-50.18c0-22.07 17.88-39.95 39.95-39.95h141.21l67.34 23.67.54-.19c-8.91 27.42-6.2 58.81 5.49 83.49z"
					style={{
						fill: '#ffb357',
					}}
				/>
				<Path
					d="M323.34 136.728v130.08H277.6c-49.667-25.957-49.43-107.415-9.71-130.08h55.45z"
					style={{
						fill: '#ff6e80',
					}}
				/>
				<Path
					d="M277.6 266.808h-88.94v-130.08h79.23c-26.78 39.78-19.55 99.27 9.71 130.08z"
					style={{
						fill: '#fd5c6f',
					}}
				/>
				<Path
					d="m242.95 76.45-28.128-40.058c-15.533-22.12-49.186-19.131-60.577 5.381l-9.476 20.393"
					style={{
						fill: 'none',
						stroke: '#000',
						strokeWidth: 15,
						strokeLinecap: 'round',
						strokeLinejoin: 'round',
						strokeMiterlimit: 10,
					}}
				/>
				<Path
					d="m211.171 100.502-73.747-42.578c-31.556-18.219-71 4.555-71 40.992v37.814M367.231 62.165l-9.476-20.393c-11.39-24.512-45.044-27.501-60.577-5.381L269.05 76.45"
					style={{
						fill: 'none',
						stroke: '#000',
						strokeWidth: 15,
						strokeLinecap: 'round',
						strokeLinejoin: 'round',
						strokeMiterlimit: 10,
					}}
				/>
				<Path
					d="M445.577 136.73V98.916c0-36.437-39.445-59.211-71-40.992l-73.747 42.578M188.661 490.546V136.73M323.339 136.73v353.816"
					style={{
						fill: 'none',
						stroke: '#000',
						strokeWidth: 15,
						strokeLinecap: 'round',
						strokeLinejoin: 'round',
						strokeMiterlimit: 10,
					}}
				/>
				<Path
					d="M107.576 136.73H47.447c-22.062 0-39.947 17.885-39.947 39.947v50.187c0 22.062 17.885 39.947 39.947 39.947h417.106c22.062 0 39.947-17.885 39.947-39.947v-50.187c0-22.062-17.885-39.947-39.947-39.947H142.576M461.129 366.025v-99.214M50.871 266.811v153.855c0 38.594 31.286 69.88 69.88 69.88h270.498c38.594 0 69.88-31.286 69.88-69.88v-19.641"
					style={{
						fill: 'none',
						stroke: '#000',
						strokeWidth: 15,
						strokeLinecap: 'round',
						strokeLinejoin: 'round',
						strokeMiterlimit: 10,
					}}
				/>
				<Path
					d="M306.984 136.73c.629-3.232.968-6.567.968-9.982 0-28.692-23.26-51.952-51.952-51.952-28.692 0-51.952 23.26-51.952 51.952 0 3.416.339 6.751.968 9.982"
					style={{
						fill: 'none',
						stroke: '#000',
						strokeWidth: 15,
						strokeLinecap: 'round',
						strokeLinejoin: 'round',
						strokeMiterlimit: 10,
					}}
				/>
			</G>
		</Svg>
	);
}
export default SvgComponent;
