import * as React from 'react';
import Svg, { G, Path } from 'react-native-svg';
function SvgComponent(props) {
	const size = props.size ?? 512;
	const scale = size / 512;

	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			width={512 * scale}
			height={512 * scale}
			{...props}
		>
			<G scale={scale}>
				<Path fill="#a77d73" d="M222.081 7.5h67.838v97.018h-67.838z" />
				<Path fill="#98695e" d="M222.081 58.614h67.838v76h-67.838z" />
				<Path fill="#a77d73" d="M222.081 129.838h67.838v252.323h-67.838z" />
				<Path fill="#98695e" d="M222.081 103.617h67.838v76h-67.838z" />
				<Path fill="#a77d73" d="M222.081 400.865h67.838v103.636h-67.838z" />
				<Path fill="#98695e" d="M222.081 377.1h67.838v76h-67.838z" />
				<Path fill="#98695e" d="M222.081 328.714h67.838v76h-67.838z" />
				<Path fill="#ffd064" d="M504.5 86.404v67.838H7.5V86.404z" />
				<Path
					fill="#ffc250"
					d="M178.473 86.404v67.838H60.551V86.404zM449.827 86.404v67.838H331.905V86.404z"
				/>
				<Path fill="#ffd064" d="M504.5 357.758v67.838H7.5v-67.838z" />
				<Path
					fill="#ffc250"
					d="M449.826 357.762V425.6H331.904v-67.838zM179.284 357.762V425.6H61.362v-67.838z"
				/>
				<Path
					fill="#a77d73"
					d="M357.758 268.092h67.838V504.5h-67.838zM357.758 7.5h67.838v234.062h-67.838z"
				/>
				<Path fill="#98695e" d="M357.758 195.478h67.838v121.045h-67.838z" />
				<Path
					fill="#a77d73"
					d="M86.404 271.257h67.838V504.5H86.404zM86.404 7.5h67.838v234.914H86.404z"
				/>
				<Path fill="#98695e" d="M86.404 195.478h67.838v121.045H86.404z" />
				<Path
					fill="#ffd064"
					d="M100.145 222.08H7.5v67.84H222.081v-67.84h-92.646"
				/>
				<Path fill="#ffc250" d="M222.081 222.082v67.838h-25.042v-67.838z" />
				<Path fill="#ffd064" d="M289.92 222.08H504.5v67.84H289.92" />
				<Path fill="#ffc250" d="M314.962 222.082v67.838H289.92v-67.838z" />
				<Path d="M504.5 161.74a7.5 7.5 0 0 0 7.5-7.5V86.4a7.5 7.5 0 0 0-7.5-7.5h-71.404V7.5a7.5 7.5 0 0 0-7.5-7.5h-67.838a7.5 7.5 0 0 0-7.5 7.5v71.4H297.42V7.5a7.5 7.5 0 0 0-7.5-7.5h-67.838a7.5 7.5 0 0 0-7.5 7.5v71.4H161.74V7.5a7.5 7.5 0 0 0-7.5-7.5H86.4a7.5 7.5 0 0 0-7.5 7.5v21.02a7.5 7.5 0 0 0 15 0V15h52.84v199.58H93.9V58.48a7.5 7.5 0 0 0-15 0V78.9H7.5A7.5 7.5 0 0 0 0 86.4v67.84a7.5 7.5 0 0 0 7.5 7.5h71.4v52.84H7.5a7.5 7.5 0 0 0-7.5 7.5v67.84a7.5 7.5 0 0 0 7.5 7.5h71.404v52.84H7.5a7.5 7.5 0 0 0-7.5 7.5v67.84a7.5 7.5 0 0 0 7.5 7.5h71.404v71.4a7.5 7.5 0 0 0 7.5 7.5h67.838a7.5 7.5 0 0 0 7.5-7.5v-71.4h52.838v71.4a7.5 7.5 0 0 0 7.5 7.5h67.838a7.5 7.5 0 0 0 7.5-7.5v-71.4h52.838v71.4a7.5 7.5 0 0 0 7.5 7.5h67.838a7.5 7.5 0 0 0 7.5-7.5v-71.4H504.5a7.5 7.5 0 0 0 7.5-7.5v-67.84a7.5 7.5 0 0 0-7.5-7.5h-71.404v-52.84H504.5a7.5 7.5 0 0 0 7.5-7.5v-67.84a7.5 7.5 0 0 0-7.5-7.5h-71.404v-52.84zm-489.5-15V93.9h63.9v52.84zM497 93.9v52.84h-63.904V93.9zM297.419 214.58v-52.84h52.838v52.84zm-135.676 82.84h52.838v52.84h-52.838zm67.838 52.837V161.743h52.838v188.515h-52.838zm67.838-52.837h52.838v52.84h-52.838zM229.581 15h52.838v63.9h-52.838zm120.676 78.9v52.84H161.74V93.9zM161.74 161.74h52.841v52.84H161.74zM15 229.58h199.581v52.84H15zm0 188.52v-52.84h63.904v52.84zM93.904 497V297.42h52.838V497zm188.515 0h-52.838v-63.9h52.838zm-120.676-78.9v-52.84h188.515v52.84zM497 365.26v52.84h-63.904v-52.84zm0-82.84h-89.61a7.5 7.5 0 0 0 0 15h10.706V497h-52.838V297.42h12.213a7.5 7.5 0 0 0 0-15H297.42v-52.84H497zm-131.743-67.84V15h52.838v199.58z" />
			</G>
		</Svg>
	);
}
export default SvgComponent;
