import * as React from 'react';
import Svg, { Path, G, Circle } from 'react-native-svg';
function SvgComponent(props) {
	const size = props.size ?? 512;
	const scale = size / 512;

	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			width={512 * scale}
			height={512 * scale}
			viewBox="0 0 512.002 512.002"
			{...props}
		>
			<Path
				fill="#ffd15b"
				d="m463.132 372.978-373.114 71.18c-12.431 2.326-24.394-5.867-26.72-18.298L7.896 129.724c-2.326-12.431 5.867-24.394 18.298-26.72l127.353-23.825a24.58 24.58 0 0 1 20.252 5.275l23.692 19.735a24.58 24.58 0 0 0 20.252 5.275L406.952 72.69c12.431-2.326 24.394 5.867 26.72 18.298l47.756 255.271c2.327 12.43-5.865 24.393-18.296 26.719z"
			/>
			<G fill="#ffc344">
				<Path d="M481.43 346.257 433.673 90.986c-2.326-12.432-14.289-20.624-26.72-18.298l-60.329 11.726c11.163-.433 21.252 7.365 23.368 18.673l44.164 243.171c2.326 12.431-5.867 24.394-18.298 26.72L67.643 435.591c5.086 6.614 13.611 10.205 22.374 8.566l373.114-71.18c12.432-2.325 20.624-14.288 18.299-26.72zM115.573 94.646l18.238 21.642a24.58 24.58 0 0 0 20.252 5.275l60.277-11.716a24.571 24.571 0 0 1-16.848-5.659L173.8 84.453a24.58 24.58 0 0 0-20.252-5.275l-52.453 9.813a24.58 24.58 0 0 1 14.478 5.655z" />
			</G>
			<Path
				fill="#eaf9fa"
				d="M72.714 486.95c-19.757 0-35.773-16.016-35.773-35.773V217.223c0-19.757 16.016-35.772 35.772-35.772h345.762c19.757 0 35.773 16.016 35.773 35.773v233.954c0 19.757-16.016 35.772-35.772 35.772z"
			/>
			<Path
				fill="#d4f2f6"
				d="M418.475 181.451h-84.056c19.757 0 35.773 16.016 35.773 35.773v233.954c0 19.756-16.016 35.772-35.772 35.772h84.056c19.756 0 35.772-16.016 35.772-35.772V217.224c0-19.757-16.016-35.773-35.773-35.773z"
			/>
			<Path
				fill="#a6e7f0"
				d="M423.021 222.598v223.205a9.154 9.154 0 0 1-9.154 9.154H77.323a9.154 9.154 0 0 1-9.154-9.154V222.598a9.154 9.154 0 0 1 9.154-9.154h336.544a9.154 9.154 0 0 1 9.154 9.154z"
			/>
			<Path
				fill="#81dbea"
				d="M413.867 213.444h-56.501c7.084 0 12.827 5.743 12.827 12.827V442.13c0 7.084-5.743 12.827-12.827 12.827h56.501a9.154 9.154 0 0 0 9.154-9.154V222.599a9.155 9.155 0 0 0-9.154-9.155z"
			/>
			<Path
				fill="#2ed1e2"
				d="M423.021 343.662v102.14c0 5.06-4.1 9.16-9.15 9.16H77.321c-5.06 0-9.15-4.1-9.15-9.16v-22.18l166.7-89.6c6.38-3.44 14.26-2.34 19.47 2.72l39.63 38.47 75.57-58.26c.21-.16.43-.32.65-.47 6.03-4.22 14.17-3.97 19.96.69z"
			/>
			<Path
				fill="#05bddb"
				d="M423.021 343.662v102.14c0 5.06-4.1 9.16-9.15 9.16h-56.51c7.09 0 12.83-5.75 12.83-12.83v-125.65c6.03-4.22 14.17-3.97 19.96.69z"
			/>
			<Path
				fill="#bbec6c"
				d="m190.283 358.351-17.734-26.647h4.92c4.582 0 7.317-5.105 4.778-8.92l-25.204-37.871c-2.401-3.608-7.703-3.608-10.104 0l-25.204 37.871c-2.539 3.815.196 8.92 4.778 8.92h4.92l-17.734 26.647c-2.539 3.815.196 8.92 4.778 8.92h11.399l-16.177 24.308c-2.539 3.815.196 8.92 4.778 8.92h67.025c4.582 0 7.317-5.105 4.778-8.92l-16.177-24.308h11.399c4.585 0 7.319-5.105 4.781-8.92z"
			/>
			<Path
				fill="#a2e62e"
				d="M174.105 367.271h11.399c4.582 0 7.317-5.105 4.778-8.92l-17.733-26.646h4.92c4.582 0 7.317-5.105 4.778-8.92l-25.204-37.871c-2.401-3.608-7.702-3.608-10.104 0l-9.24 13.884c2.472-.831 5.39-.043 7.002 2.38l14.262 21.608c2.539 3.815-.196 8.92-4.778 8.92h-4.92l17.734 26.646c2.539 3.815-.196 8.92-4.778 8.92h-11.399l16.177 24.308c2.539 3.815-.196 8.92-4.778 8.92h23.283c4.582 0 7.317-5.105 4.778-8.92z"
			/>
			<Circle cx={297.699} cy={278.026} r={20.445} fill="#ffd15b" />
			<Path
				fill="#ffc344"
				d="M297.699 257.58c-3.537 0-6.864.899-9.766 2.48 6.362 3.466 10.679 10.211 10.679 17.965s-4.318 14.5-10.679 17.965a20.352 20.352 0 0 0 9.766 2.48c11.292 0 20.445-9.154 20.445-20.445s-9.153-20.445-20.445-20.445z"
			/>
			<Path d="M430.52 222.599c0-9.184-7.471-16.654-16.653-16.654H77.322c-9.183 0-16.653 7.471-16.653 16.654v223.204c0 4.018 1.43 7.708 3.808 10.588 3.056 3.706 7.679 6.071 12.844 6.071h74.671c4.143 0 7.5-3.357 7.5-7.5V408h26.013c4.889 0 9.36-2.677 11.67-6.986s2.062-9.517-.648-13.589l-8.571-12.88a13.215 13.215 0 0 0 9.22-6.76 13.236 13.236 0 0 0 1.562-5.828l39.693-21.333a9.092 9.092 0 0 1 10.688 1.501l68.069 67.017a7.474 7.474 0 0 0 5.313 2.207 7.5 7.5 0 0 0 5.314-12.793l-22.518-22.604 68.826-53.061a9.118 9.118 0 0 1 11.322.122l30.075 24.238v98.553c0 .912-.741 1.654-1.653 1.654-.033 0-.064.004-.097.005H187.115c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h226.756c9.181 0 16.65-7.474 16.65-16.66zM144.492 447.462H77.419c-.032 0-.064-.005-.097-.005-.502 0-.946-.229-1.25-.583a1.653 1.653 0 0 1-.401-1.072v-17.696L113.076 408h31.416zm23.37-76.035 14.356 21.572h-60.453l14.356-21.572a7.501 7.501 0 0 0-6.244-11.655h-8.113l15.913-23.911a7.497 7.497 0 0 0-6.243-11.655H129.8l22.191-33.346 22.19 33.346h-1.634a7.498 7.498 0 0 0-6.243 11.655l15.913 23.911h-8.113a7.499 7.499 0 0 0-6.242 11.655zm247.658-43.443-20.666-16.655c-8.731-7.03-21.026-7.161-29.893-.317l-70.426 54.294-34.969-33.944c-7.593-7.375-18.948-8.96-28.247-3.947l-38.755 20.828-7.573-11.379a13.228 13.228 0 0 0 4.147-4.647 13.216 13.216 0 0 0-.648-13.587l-25.203-37.871a13.54 13.54 0 0 0-11.297-6.051 13.541 13.541 0 0 0-11.296 6.051l-25.202 37.87a13.216 13.216 0 0 0-.649 13.588 13.22 13.22 0 0 0 4.147 4.647l-11.535 17.333a13.216 13.216 0 0 0-.647 13.587 13.216 13.216 0 0 0 9.221 6.76l-8.571 12.879a13.217 13.217 0 0 0-2.211 7.754l-29.578 15.9V222.599c0-.912.741-1.654 1.653-1.654h336.545c.912 0 1.653.742 1.653 1.654z" />
			<Path d="M297.699 250.081c-15.409 0-27.945 12.536-27.945 27.945 0 15.408 12.536 27.944 27.945 27.944s27.945-12.536 27.945-27.944c0-15.409-12.536-27.945-27.945-27.945zm0 40.89c-7.138 0-12.945-5.807-12.945-12.944s5.808-12.945 12.945-12.945 12.945 5.808 12.945 12.945-5.807 12.944-12.945 12.944z" />
			<Path d="M441.045 89.606c-1.49-7.983-6.003-14.906-12.706-19.493-6.703-4.588-14.788-6.288-22.818-4.783L216.36 102.09a17.037 17.037 0 0 1-14.067-3.659L178.604 78.69a31.967 31.967 0 0 0-26.43-6.88L24.809 95.63C8.341 98.718-2.556 114.628.519 131.1l28.922 154.577v165.5c0 23.86 19.412 43.272 43.272 43.272h345.762c23.86 0 43.272-19.412 43.272-43.272V380.88c17.125-1.764 30.408-18.479 27.056-35.998zm5.703 361.572c0 15.59-12.683 28.272-28.272 28.272H72.714c-15.59 0-28.272-12.683-28.272-28.272V217.223c0-15.59 12.683-28.272 28.272-28.272h257.237c4.143 0 7.5-3.357 7.5-7.5s-3.357-7.5-7.5-7.5H72.714c-20.933 0-38.439 14.943-42.42 34.721l-15.029-80.326c-1.559-8.346 3.964-16.408 12.306-17.972l127.363-23.82a17.012 17.012 0 0 1 14.067 3.66l23.696 19.746c7.379 6.135 17.016 8.641 26.475 6.864l189.161-36.761c4.047-.755 8.141.104 11.534 2.428s5.678 5.827 6.433 9.87l16.694 89.233a43.019 43.019 0 0 0-24.519-7.643h-53.333c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h53.333c15.59 0 28.272 12.684 28.272 28.273v233.954zm15-85.568v-83.774l12.311 65.801c1.557 8.34-3.957 16.397-12.311 17.973z" />
			<Path d="m154.457 109.651-69.009 12.91a7.5 7.5 0 0 0 2.758 14.744l69.009-12.91a7.5 7.5 0 0 0 5.993-8.751c-.762-4.072-4.686-6.752-8.751-5.993zM504.502 109.523h-6.336v-6.336c0-4.143-3.357-7.5-7.5-7.5s-7.5 3.357-7.5 7.5v6.336h-6.336c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h6.336v6.336c0 4.143 3.357 7.5 7.5 7.5s7.5-3.357 7.5-7.5v-6.336h6.336c4.143 0 7.5-3.357 7.5-7.5s-3.358-7.5-7.5-7.5z" />
			<Circle cx={448.019} cy={25.052} r={7.5} />
			<Circle cx={50.925} cy={138.45} r={7.5} />
		</Svg>
	);
}
export default SvgComponent;
