import * as React from 'react';
import Svg, { Path, Ellipse } from 'react-native-svg';
function SvgComponent(props) {
	const size = props.size ?? 512;
	const scale = size / 512;
	const color = props.color ?? 'white';

	return (
		<Svg
			xmlns="http://www.w3.org/2000/svg"
			width={512 * scale}
			height={512 * scale}
			viewBox="0 0 511.982 511.982"
			{...props}
		>
			<Path
				fill="#f7ef87"
				d="M398.212 474.061H146.937C69.928 474.061 7.5 411.633 7.5 334.624V83.349c0-25.09 20.339-45.428 45.428-45.428h345.284c25.09 0 45.428 20.339 45.428 45.428v345.284c.001 25.089-20.338 45.428-45.428 45.428z"
			/>
			<Path
				fill="#eed076"
				d="M443.641 83.349c0-2.865-.277-5.664-.785-8.381-.743-.026-1.485-.054-2.231-.054-16.583 0-32.173 6.457-43.898 18.183L208.444 281.379c-14.598 14.598-24.297 33.044-28.05 53.345l-7.776 42.075c-2.789 15.087 1.232 30.496 11.033 42.275 9.83 11.814 24.236 18.589 39.526 18.59h.002c3.145 0 6.319-.292 9.435-.868l42.075-7.777c20.3-3.752 38.747-13.452 53.345-28.049l115.607-115.607z"
			/>
			<Ellipse
				cx={142.005}
				cy={147.775}
				fill="#e8899e"
				rx={30.834}
				ry={24.555}
			/>
			<Ellipse
				cx={309.135}
				cy={147.775}
				fill="#e8899e"
				rx={30.834}
				ry={24.555}
			/>
			<Path
				fill="#8ea3e2"
				d="m387.382 144.792 77.153 77.152-33.66 33.66-77.152-77.154z"
			/>
			<Path
				fill="#e8899e"
				d="m495.103 146.104-31.794-31.794c-12.529-12.529-32.841-12.529-45.37 0l-30.538 30.538 77.164 77.164 30.538-30.538c12.529-12.529 12.529-32.842 0-45.37z"
			/>
			<Path
				fill="#fff"
				d="m269.237 399.519-42.075 7.777c-14.819 2.739-27.783-10.225-25.044-25.044l7.777-42.075a71.543 71.543 0 0 1 19.762-37.584l124.08-124.08 77.164 77.164-124.08 124.08a71.543 71.543 0 0 1-37.584 19.762z"
			/>
			<Path
				fill="#a3defe"
				d="m247.606 333.726 12.917 4.663a17.468 17.468 0 0 1 10.501 10.501l4.663 12.917a17.468 17.468 0 0 0 10.501 10.501l20.633 7.448 124.08-124.08-77.164-77.164-124.08 124.08 7.448 20.633a17.468 17.468 0 0 0 10.501 10.501z"
			/>
			<Path
				fill="#7acefa"
				d="m292.443 239.806-62.786 62.786 7.448 20.633a17.47 17.47 0 0 0 10.501 10.501l12.917 4.663a17.468 17.468 0 0 1 10.501 10.501l4.663 12.917a17.468 17.468 0 0 0 10.501 10.501l20.633 7.448 14.899-14.899c-29.243-30.324-33.786-85.266-29.277-125.051z"
			/>
			<Path
				fill="#4e5660"
				d="m208.274 348.944-6.156 33.307c-2.739 14.819 10.225 27.783 25.044 25.044l33.307-6.156z"
			/>
			<Path
				fill="#eed076"
				d="M7.5 334.624c0 77.009 62.428 139.437 139.437 139.437h41.537c-28.183 0-51.03-22.847-51.03-51.03v-43.672c0-19.463-15.778-35.241-35.241-35.241H58.53c-28.183 0-51.03-22.847-51.03-51.03z"
			/>
			<Path d="M372.379 466.561H188.473c-24.002 0-43.53-19.528-43.53-43.53v-43.672c0-23.567-19.173-42.741-42.741-42.741H58.53c-24.002 0-43.53-19.527-43.53-43.53V83.349c0-15.538 9.305-29.344 23.706-35.173a7.5 7.5 0 1 0-5.629-13.905C12.984 42.405 0 61.669 0 83.349v251.276c0 81.021 65.915 146.936 146.936 146.936h225.443a7.5 7.5 0 0 0 0-15zm-225.443 0C74.186 466.561 15 407.375 15 334.625v-2.46c10.723 11.933 26.262 19.454 43.53 19.454h43.672c15.296 0 27.741 12.444 27.741 27.741v43.672c0 17.268 7.521 32.808 19.454 43.53h-2.461zm140.14-343.06c0-3.532 2.874-6.406 6.406-6.406s6.406 2.874 6.406 6.406a7.5 7.5 0 0 0 15 0c0-11.803-9.603-21.406-21.406-21.406s-21.406 9.603-21.406 21.406a7.5 7.5 0 0 0 15 0zm-61.506 15.64a30.44 30.44 0 0 0 22.948-10.451 7.5 7.5 0 0 0-11.309-9.855c-2.939 3.373-7.181 5.307-11.64 5.307s-8.701-1.934-11.64-5.307a7.501 7.501 0 0 0-11.309 9.855 30.446 30.446 0 0 0 22.95 10.451zm-58.095-15.306v-12a7.5 7.5 0 0 0-15 0v12a7.5 7.5 0 0 0 15 0zM500.407 140.8l-31.794-31.794c-4.927-4.927-10.928-8.384-17.472-10.176V83.349c0-29.185-23.744-52.928-52.928-52.928h-326a7.5 7.5 0 0 0 0 15h326c20.914 0 37.928 17.015 37.928 37.928v14.324c-8.876.995-17.096 4.926-23.504 11.334L307.084 214.56H97.75a7.5 7.5 0 0 0 0 15h194.333l-45.075 45.075H133.165a7.5 7.5 0 0 0 0 15h98.843c-3.677 4.62-23.838 18.605-29.488 49.179l-7.777 42.075c-3.682 19.919 13.76 37.485 33.782 33.782l42.075-7.777c16.167-2.988 30.441-10.751 41.524-21.834l124.017-124.017v167.59c0 17.736-12.043 32.927-29.288 36.941a7.5 7.5 0 0 0 3.401 14.609c24.073-5.604 40.886-26.803 40.886-51.551v-182.59l49.266-49.266c15.434-15.432 15.434-40.543.001-55.976zM225.798 399.92c-9.666 1.784-18.092-6.643-16.306-16.306l3.564-19.282 32.023 32.024zm37.186-6.873-46.618-46.618c.735-2.733 1.456-15.189 10.696-28.936l2.988 8.278a24.902 24.902 0 0 0 15.009 15.009l12.918 4.663a9.943 9.943 0 0 1 5.993 5.993l4.663 12.917a24.9 24.9 0 0 0 15.009 15.009l8.278 2.988c-13.702 9.211-26.107 9.936-28.936 10.697zm41.902-21.963-16.152-5.831a9.943 9.943 0 0 1-5.993-5.993l-4.663-12.916c-2.53-7.009-8-12.48-15.009-15.009l-12.917-4.663a9.947 9.947 0 0 1-5.994-5.993l-5.831-16.152 115.408-115.408 66.557 66.558zM430.901 245.07l-66.557-66.558 23.058-23.058 66.557 66.558-23.058 23.058zm58.899-58.9-25.235 25.235-66.557-66.558 25.235-25.235c9.606-9.606 25.155-9.608 34.763 0l31.794 31.794c9.585 9.585 9.585 25.18 0 34.764zm-153.776 76.612-29.878 29.877a7.5 7.5 0 0 0 0 10.606 7.5 7.5 0 0 0 10.606 0l29.878-29.878a7.5 7.5 0 1 0-10.606-10.605z" />
		</Svg>
	);
}
export default SvgComponent;
