// @ts-nocheck
import * as React from 'react';
import Svg, { Defs, Path } from 'react-native-svg';
/* SVGR has dropped some elements not supported by react-native-svg: style */
const SvgComponent = (props) => (
	<Svg
		xmlns="http://www.w3.org/2000/svg"
		id="\u5716\u5C64_3"
		width={512}
		height={512}
		data-name="\u5716\u5C64 3"
		viewBox="0 0 500 500"
		{...props}
	>
		<Defs></Defs>
		<Path
			d="M232.58 181.15c46.65-26.76 55.84-98 21.3-138-17.67-20.5-46.64-31-73.32-26.12-26.17 4.81-48.93 23.76-59.62 48-13.53 30.61-7 66.37 12.4 92.84l8.15-12.44c-17-12.35-19-39.29-16-58.32 3.24-21.09 16.93-38.73 36.11-47.93a60.86 60.86 0 0 1 57.37 3c20.22 12.17 28.44 33.03 30.59 55.82 1.31 13.77 1.29 27.95-5.46 40.42-5.78 10.67-15.55 18.42-26.79 22.67l8.69 15.76c18.57-12.17 29.24-32.9 32-54.6 3.48-26.8-4.44-53.36-14-78.09l-14.39 2.54a127.25 127.25 0 0 1 2 92.4l14.58 6c.66-33.52 1.22-67.14-2.91-100.48-.54-4.32-3.54-9-8.23-9.52-4.5-.49-7.31 3.43-7.05 7.6a594.54 594.54 0 0 1-3.08 106.38l15.18 4-1.56-58.4c-.54-19.06-1.39-38.13-4.67-56.95-.76-4.31-3.39-9-8.23-9.52-4.37-.48-7.47 3.41-7.05 7.6a520.17 520.17 0 0 1-2.41 123.81l15.18 4.06L228.72 43c-.21-9.89-14.95-13.6-15.28-1.91L210 164.9l15.28 1.92a832 832 0 0 1-4.49-131c.37-8.33-12.93-14-15.18-4.05-9.8 43.57 1.48 87.65-.93 131.58l14.77 1.83c-9-43.39-8.3-88.07-7.74-132.15.1-8.08-13.6-14.37-15.18-4.06-6.75 44.09-5.11 88.79-3.3 133.19l14.87-.31a406.89 406.89 0 0 1-6.93-65.31q-.42-15.87.39-31.74c.56-11.17.93-22.14-2.24-33-1-3.4-4.1-6.9-7.82-7.29-3.26-.33-6.68 2-6.95 5.47q-4.84 61.59-3.67 123.46l15.28 1.92a924.19 924.19 0 0 1-6.55-116.76c.06-8.07-13.52-14.37-15.18-4.05-6.16 38.34-2.56 77.13 1.3 115.5l14.88-.31c-5.69-16.11-8.52-32.85-10.53-49.76-2.14-18-3.91-36-5.84-54-.46-4.32-3.58-9-8.23-9.52-4.45-.49-7.36 3.42-7 7.6l7.87 104.87 14.87-.31a289.35 289.35 0 0 1-3.22-106.32l-3.17 4.77c1.83-.78 4.51-.83 6 .71l2.38-14q0 8.15 3 5.77c-.72 0-.45.11.82.31l-5-16.43C159.42 36.29 136 52.26 134.73 81.21c-.32 7 10.69 13.87 14.58 6a163.66 163.66 0 0 0 12.31-34.35c1.83-7.63-9.88-17-14.48-8.13L127.25 83l13.89 10 13.36-36.39a10.27 10.27 0 0 0-2.87-11.26c-2.55-2.23-7.44-3.83-10-.44L129.74 61l12.83 11.69a94.66 94.66 0 0 1 14.19-20L143.93 41a592.11 592.11 0 0 0-25.13 55.83 10.22 10.22 0 0 0 2.87 11.25c2.43 2.14 7.61 4 10 .44a208.74 208.74 0 0 0 22-42.21 10.47 10.47 0 0 0-3.71-12c-3.35-2.41-8.29-2.15-10.18 2L122.41 94l14.48 8.13L140 84.28l-15.18-4q2 23.91 5.92 47.6l14.87-.32-3.7-14.69-14.47 2.55 6.85 21.19c1.22 3.77 4.57 7.41 8.8 7.26 3.91-.13 6.48-3.73 6.08-7.58a46.9 46.9 0 0 0-9.64-23.89c-5.27-7-14.64-1.14-12.15 6.73l6.25 19.73 12.15-6.73A84.21 84.21 0 0 1 136 116c-4-8.48-17.08-4.87-13.53 4.77L129 138.5c1.46 3.95 5.08 8.08 9.77 7.24s5.78-5.93 4.7-9.79a116.35 116.35 0 0 0-6.64-17.57l-12.59 7L138 154l7.66-11.53-5.65-2.7 1.17 16.55.68.32-3.55-2.57.61.73-2.32-4.19-.13-.38.69-4.08-.36.79 2.58-2.83-.72.48c-7.68 5.13-1 16.71 6.9 16.39 18-.73 31.67 15.41 41.79 28.2 11.27 14.26 22.55 28.72 39.49 36.48a6.25 6.25 0 0 0 7.78-2.18c2-2.93 1.19-6.33-.11-9.34a109.08 109.08 0 0 1-8.48-45.61c.16-8.13-14.47-14.32-15.18-4a100.12 100.12 0 0 0 2 28.16c1.21 5.79 11.17 11.06 14.17 3.76l8.34-20.24-13.89-10.07-11.37 28.41 14.18 3.76-5.71-31.14c-1.58-8.65-15.82-10.12-14.87.31a243.89 243.89 0 0 0 4.82 30.52l13.53-4.76A140.56 140.56 0 0 1 207.81 163c-1.31-4-5.18-8.06-9.76-7.24s-5.89 5.95-4.7 9.79l7.88 25.45 13.53-4.76a111.8 111.8 0 0 1-13.82-30.2l-13.53 4.76a115.71 115.71 0 0 1 9.31 25l12.15-6.73a199.63 199.63 0 0 1-21-26c-2.28-3.41-6.41-6.65-10.66-4.38-4 2.13-4 7.93-1.93 11.36l9.32 15.74 11.21-8.94-22.59-20.76-8.15 12.45 10.23 8 4.6-15a38.9 38.9 0 0 1-20.05-16l-7.66 11.53c3.38 1 6.69 2.5 8.69 5.54l9.53-10.47-20.06-16.46c-7.27-6-13.19 4-9.53 10.47L149 150.6l12.59-7-12.52-18.7 1.35 4.45a157.31 157.31 0 0 0-6-39.45c-2.32-8.21-15.59-10.42-14.87.32a90.37 90.37 0 0 0 4.74 23.57c1.3 3.76 4.5 7.41 8.79 7.26a6.55 6.55 0 0 0 6.08-7.58l-4.89-27.32-13.93 2.53a189.09 189.09 0 0 1 15.73 34.77c1.34 4 5.17 8.07 9.77 7.25 4.45-.79 5.91-6 4.7-9.79a215.35 215.35 0 0 1-9.35-46.73l-14.87.31a330.18 330.18 0 0 1 14.72 49.65l14.46-2.55a193.72 193.72 0 0 1-7.41-55l-14.87.31a268 268 0 0 1 10.9 47.1l14.87-.31a244.36 244.36 0 0 1-5.46-54.8l-14.87.31a159.07 159.07 0 0 1 7.85 51.64l15.28 1.91-5.92-53.09c-.49-4.32-3.58-9-8.23-9.52-4.43-.48-7.4 3.42-7 7.6q2.9 34.76 2.76 69.63l10.87-6-13.56-11c-8-6.55-14.61 6.37-8.15 12.45l17.66 16.59 4.32-14c-6.84-1.67-12.27-5.84-16.43-11.39l-6.28 13.5a26.39 26.39 0 0 1 13.95 13.68l9.53-10.48-22.53-20.05c-6.12-5.45-13.45-13.33-21.55-6.62-4.43 3.67-.49 11 2.65 13.65q32 27.5 64.84 54.05c5.69 4.59 13.14-1.72 10.47-8.26a19.36 19.36 0 0 1-1.59-8.49l-10.87 6a20.06 20.06 0 0 1 9.78 13.3c2.45 10.32 17.17 8.84 14.47-2.54A40.06 40.06 0 0 0 193.2 147c-5.61-3.43-10.72-.43-10.88 6a31.69 31.69 0 0 0 2.36 12.87l10.47-8.26q-32.82-26.55-64.85-54l2.64 13.65.79-.66-3.35 1.86q-2.53-1.1-1.13-.12a21.43 21.43 0 0 1 1.92 1.65c1.22 1.07 2.42 2.16 3.63 3.24l8 7.11 16 14.23a6.8 6.8 0 0 0 9.12-.32c2.6-2.81 1.89-7 .42-10.15a46.33 46.33 0 0 0-23.82-22.77 6.33 6.33 0 0 0-8.31 3c-1.74 3.54-.15 7.59 2 10.49 6.83 9.11 16.47 14.91 27.44 17.59 7.77 1.9 8.42-10.17 4.32-14l-17.66-16.59-8.14 12.44 13.56 11.06c5.26 4.28 10.85-.21 10.88-6q.13-34.86-2.76-69.63l-15.28-1.92 5.92 53.1c1.07 9.57 15.14 13.85 15.28 1.91a174.29 174.29 0 0 0-8.66-56.09c-2.71-8.29-14.77-10.4-14.88.31a264.21 264.21 0 0 0 6.28 59.26c1.85 8.46 16.29 10.16 14.87-.31a292.9 292.9 0 0 0-11.7-51.58c-2.7-8.27-14.79-10.4-14.87.32a210.34 210.34 0 0 0 8.23 59.48c1.15 4 5.29 8 9.76 7.25 4.76-.85 5.53-5.9 4.7-9.8A328.89 328.89 0 0 0 150.8 72c-1.43-3.74-4.4-7.42-8.79-7.27-4 .14-6.41 3.73-6.08 7.58a236.91 236.91 0 0 0 10.16 51.19l14.47-2.54A213.88 213.88 0 0 0 143 81.7c-1.71-3-5.18-5.72-8.83-5a6.81 6.81 0 0 0-5.17 7.53l4.89 27.33 14.87-.32a72.12 72.12 0 0 1-3.92-19.11l-14.84.32a135 135 0 0 1 5 30.27c.13 2.74-.05 5.47 1 8.05 1 2.35 2.7 4.45 4.11 6.57L149 150.6c2.27 3.41 6.42 6.65 10.66 4.38 4-2.15 3.89-7.89 1.93-11.36l-8.11-14.36-9.53 10.48L164 156.2c7 5.75 13.78-4 9.53-10.48C169 138.85 163 133.45 155 131.09c-7.17-2.11-11.38 5.48-7.66 11.52a59.39 59.39 0 0 0 29.91 25.08c3.65 1.35 7.45-.12 8.61-4 1.24-4.13-.72-8.46-4-11.05l-10.23-8c-8.12-6.4-14.7 6.42-8.14 12.44L186 177.81c2.79 2.56 6.6 4.52 10 1.81 3.17-2.5 3.11-7.48 1.17-10.76l-9.32-15.74-12.59 7A227.36 227.36 0 0 0 199 190c6 6.29 14.23 1.6 12.15-6.73A138 138 0 0 0 200 153.84c-4.34-8.46-16.34-5-13.53 4.77a129.64 129.64 0 0 0 15.69 34.63c2.1 3.23 5.69 6.16 9.75 4.71 3.8-1.37 4.9-5.86 3.78-9.47L207.81 163l-14.46 2.55a160.63 160.63 0 0 0 16.11 34.69c5 8.08 15.77 5.33 13.53-4.76a204.93 204.93 0 0 1-4-26.07l-14.87.31 5.7 31.15c1.07 5.84 11.28 11 14.18 3.76l11.36-28.42a10.43 10.43 0 0 0-3.71-12c-3.24-2.32-8.45-2.25-10.18 1.95l-8.34 20.24 14.18 3.76a71.1 71.1 0 0 1-1.31-19.45l-15.18-4.05c-.39 18.91 3.68 37.19 11.16 54.5l7.67-11.53c-16.91-7.74-26.65-25-38.35-38.6-13-15.12-29.91-27.89-50.74-27.05l6.9 16.39c4.55-3 5.44-8.48 3.2-13.37-2.79-6.11-8.18-7.89-14.48-7.67-3.57.12-5.29 4.61-5.1 7.55a11 11 0 0 0 6.27 9l5.65 2.7c7.68 3.67 10.19-6.27 7.66-11.53l-13.79-28.67c-1.77-3.69-6.77-6.46-10.66-4.38-4.23 2.27-3.61 7.76-1.93 11.36A86.25 86.25 0 0 1 129 138.5l14.48-2.5-6.54-17.75-13.53 4.75A106.68 106.68 0 0 0 136 143c5.36 6.82 14.67 1.21 12.15-6.74l-6.25-19.73-12.15 6.74a21.94 21.94 0 0 1 4.19 11.06l14.87-.32-6.85-21.19c-1.3-4-5.2-8.06-9.77-7.24s-5.67 5.91-4.7 9.79l3.7 14.69c1 3.81 4.76 7.41 8.8 7.27a6.57 6.57 0 0 0 6.08-7.58q-3.9-23.68-5.92-47.61c-.35-4.09-3.15-8.22-7.25-9.25a6.25 6.25 0 0 0-7.93 5.2l-3.11 17.82c-1.29 7.33 10.18 17.48 14.48 8.13l17.36-37.73-13.93-10.07a193.13 193.13 0 0 1-19.9 39l12.82 11.7a594.67 594.67 0 0 1 25.13-55.85c3.53-6.86-6.44-18.65-12.83-11.69a110.27 110.27 0 0 0-16.31 23.2c-3.55 6.73 7.23 19.24 12.83 11.7l11.92-16.06-12.82-11.7L127.25 83A10.46 10.46 0 0 0 131 95c3.5 2.51 8.1 2 10.18-2L161 54.79l-14.48-8.14a144.9 144.9 0 0 1-11.13 30.48l14.59 6c1-21.88 24.58-34.67 41.22-43.94 7.67-4.26 1.27-14.87-4.95-16.43-7.93-2-15.09 4.82-14.89 12.65.22 9.1 8.37 16.43 17.36 15.43 6.75-.76 5.83-10.39 2.38-14-3.8-4-8.46-6.78-14-7.41-5.28-.59-12.32.78-13.73 6.65-2.93 12.27-3.13 25.9-3.54 38.45a308.41 308.41 0 0 0 7.38 76.62c1.88 8.53 15.66 10.2 14.87-.32L174.24 46 159 44.05c3.81 35.95 5 73.88 17.14 108.24 1.33 3.75 4.49 7.41 8.8 7.26 3.92-.13 6.46-3.73 6.07-7.58-3.72-36.95-7.44-74.31-1.5-111.23l-15.18-4.05a924 924 0 0 0 6.53 116.75c.51 4.32 3.54 9 8.22 9.52s7.14-3.44 7.06-7.6Q195 95.71 199.61 36.17l-14.77-1.82c2.95 10.09 1.74 20.77 1.29 31.13q-.72 16.5-.14 33a434.06 434.06 0 0 0 7.63 65.89c1.66 8.75 15.29 10.07 14.87-.31-1.75-43-3.44-86.21 3.1-128.91l-15.18-4.06c-.58 45.75-.75 91.6 8.55 136.61 1.39 6.72 14.26 11.19 14.77 1.83 2.41-43.78-8.8-88.29.94-131.59l-15.18-4.05a831.92 831.92 0 0 0 4.49 131c1.09 9.61 15 13.84 15.28 1.92L228.72 43l-15.28-1.91 2.62 120.72c.17 7.93 13.71 14.52 15.18 4.06a539.26 539.26 0 0 0 2.61-128.09l-15.28-1.92c3.28 18.82 4.13 37.89 4.67 57q.82 29.19 1.56 58.4c.21 7.88 13.93 14.55 15.18 4.05a618.92 618.92 0 0 0 3.28-110.65L228 42.7c4.13 33.35 3.57 67 2.91 100.48-.13 6.49 11.41 14.56 14.59 6 12.52-33.78 12.3-71.6-1.41-105-1.6-3.91-5-8.1-9.76-7.25-4.26.76-6.16 6-4.7 9.79 8.27 21.37 16.18 44.62 13.57 67.88-2 18.15-10.21 36.26-25.87 46.52-8.17 5.36 0 19.06 8.72 15.75a60.77 60.77 0 0 0 29.17-23.74c8.23-12.61 10.65-27.29 10.32-42.15-.66-29.35-9.16-59-33-77.84-19.54-15.53-46.72-21.55-70.62-13.42a77.26 77.26 0 0 0-49.81 52.81c-7.68 28.52-2.54 68.34 22.91 86.78 3.1 2.25 7.39 2.2 9.64-1.14 2.47-3.66.87-8.08-1.5-11.31-13.65-18.62-18.06-44.5-10.48-66.42 7.17-20.73 24.63-38.47 45.86-44.73 20.91-6.16 44.9-1.34 61.07 13.63 16 14.78 21.77 38.59 19.25 59.69-2.74 22.93-14.63 44.69-35 56.37-8.26 4.74.46 20.49 8.72 15.75Z"
			className="cls-1"
		/>
		<Path
			d="M202 196.87a16.37 16.37 0 0 1 1.64 4.46l10.47-8.26a49.09 49.09 0 0 0-15.4-6.2c-3-.65-5.84 1.81-6.65 4.5-1 3.39.18 6.82 2.33 9.52 4.6 5.77 8.91 12.08 14.29 17.15s11.75 7.57 18.67 9.63c10.85 3.22 11.7-13.4 2.73-16.07-5.09-1.51-10.27-2.9-14-6.9-4.27-4.58-8-9.83-11.87-14.73l-4.33 14a25.53 25.53 0 0 1 7.75 3c6.5 4 12.22-1.17 10.46-8.26a38 38 0 0 0-3.5-8.89c-1.94-3.62-6.67-6.52-10.66-4.38s-3.82 7.85-1.94 11.36Z"
			className="cls-1"
		/>
		<Path
			d="M128.6 173.3a397.84 397.84 0 0 0-13 45.4c-3.12 14.05-8.73 32.14 7.61 40.06 11.85 5.75 29.28 5 40.17-2.68 11.43-8 12.83-25 .9-33.47-4.62-3.29-9.25-1.19-10.77 3.89-1.6 5.33-5.11 14.62-11.85 10.08-5.89-4-11.2-9-18.92-7.33a6.84 6.84 0 0 0-5.11 7.56l.7 4.32c.69 4.31 3.42 9 8.22 9.51s7-3.44 7-7.6a97.38 97.38 0 0 1 6.45-33.83c4.06-10.88 7.6-21.31 4.62-33l-6.65 9.84c5.75.31 10.89 2.12 14.9 6.39L161 180l-21.53-12.49-4.6 15a92.93 92.93 0 0 1 39.24 21.25 91 91 0 0 1 14.39 17.23c4.38 6.75 8.83 13.1 15.31 18a53.19 53.19 0 0 0 39.67 9.7c14.2-2.23 25.38-10.82 33.45-22.4 7.81-11.19 13.3-24.48 23.53-33.8 5.46-5 12.73-7.75 20-8.71 4-.53 12-.76 13.43 4s-2.12 10.34-6 12.71c-6.65 4-15.05 4.38-22.23 7.16-15.18 5.87-21 22.44-33.41 31.8-7.65 5.75-16.29 10.56-24.74 15-8.6 4.56-17.94 8.38-27.87 7.51-20.24-1.76-35.06-17.49-48.24-31.35l-4.32 14c2 .15 4.44 3.49 6 4.87 3.15 2.86 6.39 5.62 9.78 8.2a118 118 0 0 0 19.4 12c13.85 6.8 29.51 10 44.88 8s28.45-9.73 38.48-21.31c10.27-11.85 18.27-25.17 29.69-36.09 6.26-6 14.28-10.52 20-16.93 6-6.67 7.74-16.93 2.48-24.59-3.54-5.16-12.13-7.83-13.83.4-1.46 7-5.21 12.62-10.6 17.27L326.4 202a6 6 0 0 1 1.16-6.94l-13.42-9.76a15.3 15.3 0 0 1-5 7.62l11.59 6.6c-1.21-4 .28-7.51 3.11-10.44L311 177.33a33.61 33.61 0 0 1-7.82 13.55l13.42 9.76c.25-4.36 1.72-8.39 5.35-11.1l-11.9-11a38.84 38.84 0 0 1-9.57 23.86l13.52 7.65a25.53 25.53 0 0 1 6-16l-13.53-7.63a26.26 26.26 0 0 1-1 9.65c-2.1 7.65 10 16.89 14.49 8.14a56.22 56.22 0 0 1 11.78-15.37l-12.82-11.7A54.55 54.55 0 0 1 304 198.21l13.4 9.79a21.87 21.87 0 0 1 5.19-12.48l-11.77-13.32a351.24 351.24 0 0 0-25.38 39.35l13.89 10.07a301.61 301.61 0 0 1 18.09-37.4c3.85-6.72-7.4-19.19-12.82-11.7a372 372 0 0 0-20.37 31.31c-4.58 7.88 8.34 19.25 13.89 10.07a168 168 0 0 0 13.77-28.52 10.26 10.26 0 0 0-2.89-11.29c-2.58-2.27-7.39-3.79-10-.44a181.23 181.23 0 0 0-24 41.57c-3.36 8.19 8.6 19.67 13.89 10.07a378.5 378.5 0 0 0 19.26-40.48 10.21 10.21 0 0 0-2.87-11.26c-2.57-2.26-7.4-3.8-10-.44A138.27 138.27 0 0 0 273 227.23c-2 6.49 7.95 16.12 13.42 9.76a88.24 88.24 0 0 0 15.47-25.67c2.78-7.16-5.66-18.26-12.82-11.7a121.5 121.5 0 0 0-28.61 39.78c-3.3 7.35 5.76 17.82 12.83 11.7a84 84 0 0 0 18.18-22.6c3.78-6.71-7.21-19.12-12.83-11.69A200.87 200.87 0 0 1 261.11 237c-6.45 6.51 4.5 20.33 11.76 13.33l9.79-9.44c5.83-5.63-2.84-18.94-10.25-14.54l-28.81 17.18c-7.11 4.22-1 19.1 6.89 16.39a55.13 55.13 0 0 0 14.92-7.44c6.69-4.87 1.62-18.08-6.9-16.39a175.12 175.12 0 0 1-27.86 3.23c-4.12.15-5.51 5.51-4.91 8.68a10.36 10.36 0 0 0 8 8.4 108.13 108.13 0 0 0 23.92 2.66L254.57 242a196.76 196.76 0 0 1-38.77-2.91l1.2 17.1a76.37 76.37 0 0 1 19.93 3.17c10.84 3.34 11.57-13 2.74-16.07l-25.74-8.91-2.74 16.07 32.44 10.78-1.17-16.55a119.63 119.63 0 0 1-18.82-.92l3.12 17.08a23.35 23.35 0 0 1 10.37 1.16L236 245.45a70.94 70.94 0 0 1-25.2 1l3.12 17.08a95.49 95.49 0 0 1 18.1 1.52L230.8 248a53 53 0 0 1-24.55-6.83l-.78 16.59a75.69 75.69 0 0 1 25.11 11.5l2.65-15.55a45.15 45.15 0 0 1-11.61-5l-.7 15.5a63.19 63.19 0 0 1 23.85.81L241.65 248a39.42 39.42 0 0 1-10.12 1.59c-6.89.18-5.61 10.72-2.38 14a42.48 42.48 0 0 0 12 8.64l.78-16.59a242.31 242.31 0 0 1-24.87-3.36c-3.95-.75-7.91-1.57-11.81-2.57-1.52-.38-5.45-1-6.26-2.44l-5.7 12.05a64.9 64.9 0 0 1 18.71 4.84c9.65 4.14 11.24-10.58 4.6-15q-19.25-12.84-38-26.35l-4.61 15a119.45 119.45 0 0 1 18.6 12.76l4.61-15a105.17 105.17 0 0 1-34.19-27l-9.83 10.91L180 245c8.49 8.09 16.65-2.79 9.83-10.91A526 526 0 0 0 151 192.75l-8.1 12.45a344.49 344.49 0 0 1 38.37 32.37l9.82-10.92A273 273 0 0 1 157 187.28l-9.53 10.48a311.54 311.54 0 0 1 39.29 42.45l9.83-10.92a135.44 135.44 0 0 1-26.52-33.19l-9.53 10.48a323.57 323.57 0 0 1 35.26 35.57l9.83-10.92L187 209.81l-8.15 12.44a113 113 0 0 1 22.49 22.69l8.15-12.44a65.33 65.33 0 0 1-13.79-13.84l-9.83 10.92 15.85 15.91c2.89 2.91 7.54 4.61 10.79 1.21s1.56-8.91-1-12.12L182.73 198l-4.33 14 .71.19-6.88-5.07.4.61-1.34-4.45-.06-.49 1.65-3.57-.59.59 3.35-1.86c-1.41.28-6-3.05-7.32-3.69l-8.87-4.41-17.74-8.85 5.57 13.07 1.7-2.63-14.59-6a93 93 0 0 1-2.21 37.39l14.82 1.85a53.21 53.21 0 0 1-3.54-14.08c-.64-6.17-10.74-14.82-14.59-6a51.18 51.18 0 0 0-4.29 17.09c-.29 4.22 1.32 8.52 5.24 10.61 3.09 1.64 7.81 1.45 9.25-2.48l6.07-16.68-14.58-6a103.14 103.14 0 0 1-.63 20.56c-1 7.65 9.23 16.95 14.48 8.14a94.28 94.28 0 0 0 7.79-16.51l-14.49-8.13q-1.68 11-2.4 22.14c-.28 4.22 1.31 8.52 5.23 10.61 3.26 1.73 7.59 1.35 9.25-2.48a189.68 189.68 0 0 0 8.76-24.95l-15.07-6.2-4 21.22a10.51 10.51 0 0 0 5.23 10.61c3.05 1.63 7.89 1.49 9.25-2.47l6.27-18.16-14.59-6a109.71 109.71 0 0 1-1.45 22c-1.25 7.48 9.72 17.22 14.48 8.14.69-1.32 3.86-9.29 4.91-9.69l-9.28-2.41.39.45-2.63-8.56-.14.62 5-5.42h-.45l8.83 5a3.19 3.19 0 0 1-.4-2.16c-.4-6.75-7.76-12.25-13.52-7.62-3.18 2.55-12.89 10-16.68 6.44-4.22-4-11-4.51-12.45 2.36a34.72 34.72 0 0 0 4.52 25.52c2.16 3.49 6.51 6.61 10.66 4.38 3.92-2.1 4-8 1.94-11.36a15.51 15.51 0 0 1-2-12.34l-12.45 2.36c5.3 5 11.67 7.63 19.06 6.54s13.47-6 19.2-10.58l-13.52-7.62a27.77 27.77 0 0 0 3.09 11.07 9.11 9.11 0 0 0 8.83 5h.45c2.81-.23 4.45-3 5-5.42.8-3.56-.56-6.94-2.87-9.63a8 8 0 0 0-9.28-2.41c-5 1.88-7.77 11-10.07 15.36l14.48 8.13a130.86 130.86 0 0 0 1.66-26.3c-.22-6.16-11.51-14.9-14.58-6l-6.27 18.16 14.48 8.13 4-21.22c1.71-9.12-12-17.18-15.07-6.2a160.42 160.42 0 0 1-7.58 21.08l14.48 8.14q.73-11.13 2.41-22.15a10.6 10.6 0 0 0-5.24-10.61c-3.08-1.64-7.84-1.46-9.25 2.48a93.52 93.52 0 0 1-7.78 16.51l14.45 8.22a125.12 125.12 0 0 0 .83-24.85 10.8 10.8 0 0 0-6.27-9c-2.95-1.19-7.11-.3-8.31 3l-6.08 16.68 14.49 8.13a38.47 38.47 0 0 1 3.1-13.2l-14.58-6a70.41 70.41 0 0 0 4.36 18.55c2.6 6.65 12.29 11.18 14.77 1.82a105.26 105.26 0 0 0 2.41-41.66c-1-7-9.57-13.8-14.58-6l-1.7 2.63c-3 4.68 1.58 11.08 5.58 13.07l17.75 8.84c5.65 2.81 11.37 6.43 17.32 8.54 5.32 1.89 11.2.15 12.39-5.88 1.3-6.58-3.06-12.11-9.2-13.69-3-.77-5.88 1.9-6.66 4.49-1 3.41.19 6.81 2.33 9.52l28.86 36.57 9.82-10.91-15.84-15.92c-2.89-2.9-7.54-4.61-10.8-1.2s-1.48 8.84 1 12.12a81.73 81.73 0 0 0 17.15 16.89c3.09 2.28 7.41 2.19 9.65-1.14 2.45-3.63.89-8.11-1.5-11.3a129.77 129.77 0 0 0-25.85-25.75c-3.07-2.31-7.42-2.16-9.65 1.14-2.34 3.47-1.09 8.32 1.5 11.3l18.61 21.43c2.7 3.1 7.68 4.47 10.8 1.2s1.67-9-1-12.12A353.05 353.05 0 0 0 167 192.6c-7.17-6.17-13.14 4.09-9.53 10.48a151.38 151.38 0 0 0 29.28 37.13c3 2.76 7.45 4.7 10.79 1.2s1.53-8.88-1-12.12a334.52 334.52 0 0 0-42.54-45.5c-6.74-6-14 4.17-9.53 10.47a295.68 295.68 0 0 0 36.84 43.31c2.94 2.83 7.49 4.65 10.79 1.2 3-3.14 1.93-9.28-1-12.12a377.82 377.82 0 0 0-41.72-35.43c-8.37-6.1-14.59 6.28-8.15 12.45A525.72 525.72 0 0 1 180 245l9.83-10.91L163 208.56c-8.49-8.09-16.64 2.79-9.83 10.91a126.32 126.32 0 0 0 41.28 32.15 6.23 6.23 0 0 0 8.61-4c1.26-4.19-.76-8.39-4-11.06a141.72 141.72 0 0 0-22.33-14.84c-3.46-1.89-7.58.52-8.61 4a10.44 10.44 0 0 0 4 11.06q18.8 13.5 38 26.35l4.6-15a79.86 79.86 0 0 0-22.56-6c-6.86-.76-8.32 7.27-5.71 12.05 5.1 9.33 14.95 11.49 24.55 13.64a240.74 240.74 0 0 0 32.16 4.87c4 .33 6.84-2.63 7-6.54a10.74 10.74 0 0 0-6.22-10.06 17.72 17.72 0 0 1-5-3.48l-2.38 14a39.12 39.12 0 0 0 10.16-1.61c9.4-2.75 4.36-15.44-3.13-17.08a74.59 74.59 0 0 0-27.74-.73c-7.44 1.18-5.78 12.46-.7 15.51a72 72 0 0 0 19.25 8.1c3.42.9 6.42-2.46 6.95-5.46a10.71 10.71 0 0 0-4.3-10.09 97.3 97.3 0 0 0-32.76-14.64c-3.95-1-6.86 3.13-7 6.53-.19 4.51 2.42 8 6.22 10.07a63.28 63.28 0 0 0 28.49 7.88c10.93.38 7.6-15.62-1.18-17.12a114.74 114.74 0 0 0-22-1.44c-4.12.09-5.5 5.56-4.91 8.68.77 4 3.79 7.82 8 8.4a83.42 83.42 0 0 0 29.09-1.12c8.32-1.82 5.32-14.29-1.16-16.56a40.52 40.52 0 0 0-18.2-2.13c-9.54 1-4.24 16.19 3.13 17.08a143.56 143.56 0 0 0 22.71.83c3.57-.13 5.3-4.61 5.11-7.56-.23-3.57-2.74-7.81-6.28-9l-32.43-10.78c-10.77-3.58-11.56 13-2.74 16.07l25.74 8.91 2.74-16.07a91.27 91.27 0 0 0-23.85-4.22c-10.93-.38-7.59 15.62 1.18 17.12a215.25 215.25 0 0 0 42.68 2.82c9-.26 4.84-17.08-3.12-17.08a108.13 108.13 0 0 1-23.92-2.66l3.12 17.08a174 174 0 0 0 27.87-3.24l-6.9-16.39a43.07 43.07 0 0 1-11.25 6.15l6.89 16.39 28.82-17.14-10.25-14.51-9.78 9.4 11.76 13.33a202.37 202.37 0 0 0 17.55-20.24l-12.83-11.7a72.67 72.67 0 0 1-16 19.34l12.82 11.7A110.76 110.76 0 0 1 300.84 213L288 201.25a75.55 75.55 0 0 1-13.35 22.42l13.42 9.76a118 118 0 0 1 19.08-37l-12.83-11.7a378.5 378.5 0 0 1-19.26 40.48L289 235.29A166.14 166.14 0 0 1 310.83 197L298 185.28a169.49 169.49 0 0 1-13.77 28.52l13.89 10.07a330.75 330.75 0 0 1 18.24-28.05l-12.83-11.7a300.2 300.2 0 0 0-18.09 37.4c-3.29 8.19 8.56 19.68 13.89 10.07a322 322 0 0 1 23.26-36.1c5.32-7.17-5.17-21.12-11.77-13.32a35.74 35.74 0 0 0-8.49 19.6c-.72 6.9 6.78 15.62 13.42 9.77a64.23 64.23 0 0 0 17.07-24.34c2.84-7.12-5.76-18.34-12.83-11.7a68.34 68.34 0 0 0-13.91 18.63l14.48 8.13a39.64 39.64 0 0 0 1.19-13.93c-.45-5.43-8.47-13.85-13.52-7.62a42.49 42.49 0 0 0-9.49 27.42c0 5.89 8.53 13.35 13.52 7.62a51.75 51.75 0 0 0 12.88-31c.21-3.55-.67-6.87-3.46-9.32-2-1.76-5.88-3.57-8.44-1.65-6.75 5.06-11.2 12.09-11.7 20.66-.35 6.14 7 16.58 13.42 9.76a43.42 43.42 0 0 0 10-16.81 10.36 10.36 0 0 0-2.96-11.25c-2.84-2.5-7-3.47-10-.44-6.78 7-8.57 17.09-5.8 26.31 1.11 3.71 7.1 10.17 11.59 6.6a31 31 0 0 0 11.34-17.16c1.75-6.44-7.89-16.23-13.42-9.76a22.35 22.35 0 0 0-3.85 22.8c2.11 5.38 7.84 9.95 13.11 5.39a43.28 43.28 0 0 0 14.03-24.4l-13.83.39.47.69A4.8 4.8 0 0 1 325 188a32.23 32.23 0 0 1-3.85 4.34c-3.37 2.92-7.12 5.43-10.56 8.29a142.87 142.87 0 0 0-19.66 20c-10.53 13.07-18.85 28.94-34.76 36.24-15 6.9-32.77 5.06-47.59-1.38a97.94 97.94 0 0 1-22-13.69c-6.23-5-12.24-13.56-20.77-14.16-7.78-.55-8.68 9.43-4.32 14 13.5 14.21 28 29.08 47.23 35a52.64 52.64 0 0 0 27.69 1.46c9.54-2.24 18.28-6.86 26.71-11.72 8.05-4.65 16.1-9.36 23.18-15.46 6.59-5.68 11-13 16.73-19.51 6-6.79 13.08-8.43 21.55-10.64 7.79-2 15.25-5.09 19.9-12 9.59-14.22 4.15-35-12.66-40.72-15.75-5.38-34.52 1.86-45.56 13.46-10.53 11.08-15.83 25.92-25.75 37.45a37.18 37.18 0 0 1-37.37 12.09 32.43 32.43 0 0 1-18.39-11.57c-6-7.79-10.67-16.23-17.57-23.38a108.72 108.72 0 0 0-49.62-29.66c-9.54-2.57-12.19 10.62-4.61 15L154.5 194c8.82 5.12 14.45-5.72 8.15-12.44-6.84-7.31-15.81-12.06-25.9-12.6-5.7-.31-7.9 4.91-6.64 9.83 2.42 9.45-4.35 20.25-7 29.06a114.91 114.91 0 0 0-4.79 33.27l15.25 1.88-.69-4.32-5.1 7.56c2.69-.58 5.3 2.81 7.38 4.27 4 2.84 8.55 5 13.59 4.69 12.08-.81 16.82-12.61 19.8-22.55l-10.77 3.89c-.67-.47.18-1.25-.34-.46-.8 1.2-.89 2.37-2.08 3.53-2.81 2.73-7 4-10.72 4.81a33.3 33.3 0 0 1-13.95-.09c-1.66-.38-3.14-1.27-4.72-1.71.83 2.12 1.2 2.3 1.12.52.13-.86.27-1.72.43-2.58a357.91 357.91 0 0 1 15-57.23 10.52 10.52 0 0 0-3.71-12c-3.08-2.2-8.67-2.37-10.18 2ZM111.06 272a225 225 0 0 0 13.77 48c3.23 7.75 6.93 15.22 10.82 22.66 3.4 6.49 7.16 13.49 7.09 21-.14 14.52-12.17 28.74-21 39.28a177 177 0 0 1-16.53 17.23c-5.12 4.67-10.32 9.07-13.9 15.11-9.84 16.63 2.92 32.33 15.46 42.58a6.63 6.63 0 0 0 10.23-2c2.09-4.26-.37-9.29-3.71-12-3.62-3-9.48-7.11-10.06-12.18-.62-5.4 5.16-10.32 8.64-13.57 10.64-9.9 20.74-19.83 29.3-31.64 8.73-12.06 17.15-25.48 16.88-40.92s-9.55-28.57-15.9-42a195.81 195.81 0 0 1-15.77-49.7c-.76-4.3-3.38-9-8.23-9.51a6.58 6.58 0 0 0-7 7.6Z"
			className="cls-1"
		/>
		<Path
			d="M96.9 443.29a217 217 0 0 0 15.71 36.15l11.21-8.95a77.31 77.31 0 0 1-14.83-23c-3.7-8.73-16.82-4.85-13.53 4.77 3.4 9.91 25.53 57.41 39.23 35.77 5.26-8.31 1.54-18.51 5.84-27.14 4.21-8.46 11.93-14.86 18.14-21.8 26.44-29.58 45.2-69.37 41.49-109.81-1.17-12.8-5.79-22.73-12.73-33.32-2.48-3.78-5.22-7.85-4.93-12.59.3-4.9 3-8.9 6.57-12.05 6.08-5.35-3-19.15-10.24-14.54-8.43 5.4-14.58 15.1-24 18.87-10.66 4.29-23.74-3.41-34.24-5.36l1.18 17.12a105.82 105.82 0 0 0 58.54-9.41l-10.25-14.53c-10.52 11.68-8.17 28.6-2.72 42 2.94 7.28 7 14.64 7.93 22.54 1 8.4-1.31 16.94-4 24.82-5.17 15.17-10.76 30.6-18.65 44.59a88.57 88.57 0 0 1-13.21 17.93c-5.23 5.42-11.32 9.94-16.44 15.47-12.63 13.63-15.1 33.55-4.93 49.43 2.21 3.46 6.47 6.63 10.66 4.38s3.61-7.75 1.93-11.36a171.05 171.05 0 0 1-9.57-25.86c-1.15-4.07-1.18-5.08 1.45-8.28s5.4-6.34 8-9.6c11-13.79 21.79-29 28.85-45.25 7.46-17.12 6-34.14-1.35-51-6.85-15.8-18.25-29.46-23.12-46.13l-13.53 4.77q14 27.83 25.71 56.71c1.58 3.91 5 8.09 9.76 7.24s5.49-5.88 4.7-9.79c-4.14-20.7-9.65-40.94-18.51-60.16l-12.6 7A383.46 383.46 0 0 1 159.25 355l14.47-2.55c-8.31-21.76-13.88-44.37-19.13-67l-13.53 4.76 27.87 61.12c1.7 3.73 6.83 6.43 10.66 4.38 4.33-2.32 3.49-7.7 1.94-11.36A251.62 251.62 0 0 1 165.35 289l-13.94 2.53A253.44 253.44 0 0 1 166.05 330l14.46-2.55a193.11 193.11 0 0 1-8.42-34l-14.88.32a293.3 293.3 0 0 1 15 57.61c.66 4.32 3.46 9 8.23 9.52a6.6 6.6 0 0 0 7.05-7.6q-1.4-10.61-1.74-21.29c-.31-9.84-15.64-13.65-15.28-1.92A113.48 113.48 0 0 1 166 364.9l15.07 6.19a36.59 36.59 0 0 1 9.25-18.58l-13.42-9.76-3.14 36.05c-.4 4.52 1.75 9.35 6.17 11.14a6.36 6.36 0 0 0 8.9-4.94l4.82-33.47c1.3-9-12.27-17.39-15.07-6.2l-9.12 36.32c-1.88 7.51 10.34 17.23 14.49 8.14a42.74 42.74 0 0 0 3.43-11.54c1.13-7.58-9.42-17-14.48-8.13L153 405.19l14.48 8.13c2-6.69 6.4-12.17 11.75-16.5l-12.83-11.7q-5.29 8.16-10.07 16.61c-2.46 4.35 1 11.61 5.57 13.07 6.95 2.2 12.1-.8 14.1-7.7 1.6-5.42-6.11-15.17-11.9-11a112.62 112.62 0 0 0-32.17 36c-3.2 5.65 4.87 17.78 11.31 12.9 4-3.06 7.13-6.55 8.88-11.37a10.27 10.27 0 0 0-2.87-11.26c-2.52-2.21-7.47-3.85-10-.44a300.54 300.54 0 0 0-17.75 27.47l14.49 8.14 3.9-14.23c2.08-7.57-10.19-17.06-14.48-8.13a109.9 109.9 0 0 0-7.1 19.82c-2 7.51 10.43 17.23 14.48 8.14A83.16 83.16 0 0 0 139 442c1-6.41-7.35-16.29-13.42-9.76a8.31 8.31 0 0 1-7.94 2.78l8.12 11.65A110.67 110.67 0 0 1 138.29 419l-13.89-10-8.46 26.88a10.61 10.61 0 0 0 3.71 12c3.59 2.58 8 2 10.18-1.95q16.51-29.6 30.7-60.39l-13.89-10.07a74.58 74.58 0 0 0-6.71 33.39c.15 6.18 11.61 14.9 14.58 6l16.87-50.59a10.55 10.55 0 0 0-3.71-12c-3.33-2.39-8.32-2.17-10.18 2a113.59 113.59 0 0 0-9.7 37.21c-.35 4.21 1.36 8.55 5.24 10.61 3 1.58 8 1.53 9.25-2.48L172.46 367 158 358.84a165.14 165.14 0 0 0-5.55 25.82c-1 7.37 9.63 17.35 14.48 8.14a73.35 73.35 0 0 0 5.67-14.29 66.18 66.18 0 0 0 1.6-7c.2-1.17.36-2.35.49-3.53.07-.59.13-1.18.17-1.77.21-1.32 0-1.2-.48.35l-5.29 1.9.57.1-6.89-5.07.36.52-1.34-4.45v.54l3.27-6.91-.42.21 11.6 6.6-4.6-24.62-14.45 2.62a88.66 88.66 0 0 0 10.16 20.53c3 4.34 10.13 8.09 13.25 1.54l5-10.44-14.59-6a72.36 72.36 0 0 1-2.17 30.27l10.74-3.9c-9.31-6.55-16.51 2.27-21.78 9.29a139.05 139.05 0 0 0-15.08 25.3c-3.13 6.79 4.07 15.89 11.31 12.91 6.32-2.61 10.79-7.05 14.47-12.69l-13.89-10.07a90.54 90.54 0 0 1-9.12 15.53c-2.74 3.7-2 8.73 1 12.12 2.42 2.73 8.05 4.93 10.8 1.21a110.33 110.33 0 0 0 11.25-18.79c3.85-8.27-8-19.09-13.89-10.07-2.22 3.41-5.63 5.5-9.3 7l11.3 12.91a122.61 122.61 0 0 1 9.45-17.14c1.76-2.62 3.64-5.16 5.61-7.63 1.06-1.35 2.14-2.71 3.29-4 .74-.81 1.64-.9 1-1l-3.82-1.57.92.65c4.58 3.22 9.31 1.26 10.77-3.89a84 84 0 0 0 2.38-34.54c-.52-3.76-2.59-7.51-6.27-9a6.38 6.38 0 0 0-8.32 3l-5 10.44 13.34 1.54a69.9 69.9 0 0 1-8.3-16.09c-1.39-4-5.12-8.07-9.76-7.25-4.83.86-5.43 5.88-4.7 9.79l4.6 24.63c.9 4.83 7 9 11.59 6.6l.42-.21c2.51-1.28 3.4-4.31 3.28-6.92-.46-9.18-13.44-15.75-16.83-4.81-1.22 4-1 8.41-2.05 12.48a58.12 58.12 0 0 1-5.18 13l14.48 8.13a167.45 167.45 0 0 1 5.5-25.86c2.29-7.65-11.61-17.32-14.48-8.13l-10.19 32.55 14.49 8.14a100.75 100.75 0 0 1 8.51-33.34l-13.89-10.07-16.87 50.59 14.59 6a56.26 56.26 0 0 1 5.32-25.24c3.78-8.25-9.41-19.8-13.89-10.07q-14.19 30.78-30.7 60.39l13.89 10.07 8.46-26.89a10.58 10.58 0 0 0-3.71-12c-3.72-2.67-7.83-1.84-10.18 2a124 124 0 0 0-13.67 31.52c-1.43 5 3.33 11 8.12 11.65a20.69 20.69 0 0 0 18.54-6.56L124 435.82a67.35 67.35 0 0 1-5.07 17.29l14.49 8.13a89.36 89.36 0 0 1 6-16l-14.48-8.14-3.94 14.25c-2.14 7.8 9.65 16.6 14.48 8.13a262 262 0 0 1 15.62-24.21l-12.83-11.7a11.6 11.6 0 0 1-3.72 5.7l11.31 12.91a96.26 96.26 0 0 1 27-30.31l-11.9-11-.32 1.09 1.65-3.56c0 .45-.13.51-.46.16l3.9.49-1.08-.35 5.58 13.07q4.77-8.46 10.07-16.61c4.68-7.2-6.12-17.13-12.83-11.69-7.61 6.16-12.3 14.33-15.05 23.63-2.31 7.78 9.69 16.56 14.48 8.13l19.92-35.07-14.48-8.14a27.65 27.65 0 0 1-2.26 7.67l14.49 8.13 9.11-36.32-15.07-6.2-4.82 33.47 15.07 6.2 3.14-36.03c.53-6.14-7.18-16.62-13.42-9.76A51.2 51.2 0 0 0 166 364.9c-1.64 9.12 11.95 17.17 15.07 6.19a127.59 127.59 0 0 0 4.69-39.09l-15.28-1.92q.35 10.69 1.74 21.29l15.28 1.92a314.88 314.88 0 0 0-15.82-62.08c-1.38-3.74-4.44-7.42-8.8-7.27a6.57 6.57 0 0 0-6.07 7.58 217.1 217.1 0 0 0 9.24 38.48c1.36 4 5.14 8.07 9.76 7.24s5.83-5.94 4.7-9.79A282.66 282.66 0 0 0 164 284.58c-3.25-6.76-15.51-6.59-13.94 2.53a289.74 289.74 0 0 0 18.86 64.15l12.6-7-27.88-61.12c-1.57-3.45-6.07-6-9.74-4.7-4 1.43-4.64 5.78-3.79 9.47 5.26 22.65 10.83 45.26 19.13 67 1.51 3.94 5.05 8.09 9.77 7.24 4.33-.77 6.06-6 4.7-9.79A411.25 411.25 0 0 0 143 285.9c-2-3.56-6.59-6.57-10.66-4.39-4.25 2.28-3.6 7.76-1.94 11.37 8.15 17.67 12.84 36.71 16.65 55.73l14.46-2.55Q149 315 133.94 284.92c-4.27-8.51-16.38-5-13.52 4.76 5.11 17.51 16.47 31.7 23.9 48.11 3.4 7.5 5.82 15.87 4.75 24.16s-5.11 16-9.24 23.23a238.61 238.61 0 0 1-14.41 22.24c-5.19 7.14-11.33 13.56-16.49 20.69-5.9 8.15-4.05 16.39-1.28 25.45A207.34 207.34 0 0 0 118 480.25l12.59-7c-8-12.59-1.26-24.42 8.49-33.47 5.2-4.83 10.69-9.31 15.32-14.73a110.92 110.92 0 0 0 12.46-18.29c7.1-12.77 12.12-26.64 17-40.36 5.59-15.63 9.45-31.56 4.16-47.86-3.85-11.88-16.84-30.07-6.27-41.81 5.56-6.17-2.45-18.22-10.24-14.53a92.13 92.13 0 0 1-50.94 8.09c-10.78-1.34-7.53 15.5 1.18 17.12 12.83 2.38 25.37 9.5 38.63 5.16 11.22-3.67 17.52-13.91 27.1-20L177.31 258c-13.07 11.49-12 29.9-3.35 43.61 4.27 6.76 8.78 12.63 10.29 20.69a84.51 84.51 0 0 1 .48 24.19c-3.52 32.76-21 61.63-43.27 85.14-6 6.35-12.36 13-15.77 21.24a36.78 36.78 0 0 0-2.75 12.27c-.14 2.48.86 10.31-1.75 11.72l3.77-.69c1 .93 1.07 1 .26.1q-.82-.93-1.62-1.89c-.7-.86-1.39-1.72-2.06-2.6a69.08 69.08 0 0 1-4.65-7 81.31 81.31 0 0 1-7-15.1l-13.49 4.81a92.22 92.22 0 0 0 17.6 26.92c6.92 7.39 15.85-.51 11.21-9a190.33 190.33 0 0 1-13.84-31.71c-1.32-4-5.17-8.07-9.76-7.25-4.42.79-6 6-4.7 9.79Z"
			className="cls-1"
		/>
		<Path
			d="m187 280.51 1.13-2.25-11.86.43c8.42 7.69 18 12.23 29.46 13.1 11.86.89 23.46.78 35.23 2.95l-7.54-13.59c1.45-.84 1.4-1-.14-.56a10.64 10.64 0 0 1-1.87-.15 57.23 57.23 0 0 1-6.71-1.32c-4.28-.89-8.54-1.82-12.8-2.76-7.7-1.68-15.53-3.25-21.86-8.24-3.3-2.6-8.27-1.93-10.18 2-2.11 4.3.41 9.23 3.71 12l9 7.6a6.63 6.63 0 0 0 10.18-2c2.11-4.3-.41-9.23-3.71-12l-9-7.6-6.47 14c9.54 7.52 21.59 9.66 33.16 12.18 9.64 2.1 24.44 8 30.59-3.06 3-5.45-2.09-12.59-7.54-13.59a188.79 188.79 0 0 0-29.78-2.74c-8.53-.21-17.34-1.1-23.94-7.14-3.55-3.24-9.15-5-11.86.42l-1.13 2.25c-4.1 8.12 9.06 19.65 13.89 10.07Z"
			className="cls-1"
		/>
		<Path
			d="M234.18 290.16c7.9 14.44 9.95 30.83 11.1 47 1.35 19 2.22 38.07 3.3 57.1l1.64 28.84c.5 8.82.49 17.85 2.27 26.53 2.88 14.13 17.44 30.25 33 21.75 8.36-4.58-.19-19.93-8.73-15.75-11.32 5.55-24.16 10-36.86 10.81a15.31 15.31 0 0 1-6.25-.55 3.17 3.17 0 0 1-.76-.3c.39.31-.34-1.27-.49-2.07-1.29-6.74-1.61-13.82-2.4-20.64-2.8-24.23-3.82-51.16-20.81-70.38-5.32-6-15.59-1.51-12.14 6.73l15.54 37.14c1.63 3.9 5 8.1 9.77 7.24 4.34-.77 6.06-6 4.7-9.79-4.22-11.78-9.41-23.62-12.45-35.77-2.93-11.71 2.62-23.42 2.51-35.23-.22-24.35-17.12-43.82-32.88-60.57l-.55 13.33a20.23 20.23 0 0 0 6.42-5.13l-9.12.33c4.12 2.88 5.82 7.91 7.75 12.37 2.45 5.67 5.1 11.08 9.3 15.7 2.54 2.79 6.79 4.36 10 1.81 3.41-2.69 2.75-7.25 1.18-10.76a107.73 107.73 0 0 1-8-26.86l-12.55 4.5a127.41 127.41 0 0 1 19.56 40.59l13.53-4.76a152.94 152.94 0 0 1-10.75-31.55l-13.53 4.77L213 328.8c4.05 8.43 17.34 4.8 13.53-4.76a282.83 282.83 0 0 1-10.63-32.12l-13.53 4.77 17.73 38.22 12.59-7a144.89 144.89 0 0 1-11.28-32.71L207 297.75a409.59 409.59 0 0 1 14.15 39.14l14.46-2.54a134.92 134.92 0 0 1-7.61-30.26l-13.93 2.53a131.52 131.52 0 0 1 12.21 31.59l14.47-2.55a134.49 134.49 0 0 1-8.39-35.24L218.45 303a257.21 257.21 0 0 1 13.6 35.24l14.47-2.54a226.26 226.26 0 0 1-8.05-31.58l-14.88.32L235.05 334c1.52 3.93 5 8.09 9.76 7.25 4.54-.81 5.81-5.94 4.7-9.8a114.87 114.87 0 0 1-4.26-24.26l-14.87.31a135.07 135.07 0 0 1 7.22 25.5l14.87-.31a175.86 175.86 0 0 1-9.62-32.48L229.32 305a191.09 191.09 0 0 1 10 24.09l14.46-2.55c-3.2-8.31-5.9-17.16-9.83-25.17a17.64 17.64 0 0 0-8.44-8.68 21.93 21.93 0 0 0-5.64-1.54l-3.14-.32c-.84-.23-.82-.23.06 0l2.32 4.18-.38-1.18-4.7 9.79a30.61 30.61 0 0 1 11.38-1.09c10.93 1.06 7.42-15.42-1.18-17.12a107.61 107.61 0 0 1-11.85-3l-.78 16.6a18.36 18.36 0 0 1 7.81 1.91c2.85 1.56 4.65 3.8 8.08 4.32 8 1.22 10.38-8 7.05-13.78-4.61-8.07-16.53-5.23-13.53 4.76a152.88 152.88 0 0 1 6.27 54.78l14.77 1.82a81.83 81.83 0 0 1-4.05-20.5l-15.28-1.92a301.32 301.32 0 0 1 1.65 46.53l14.88-.32a119.86 119.86 0 0 1-2.57-32l-15.18-4.06a553.51 553.51 0 0 1 7 56.94l15.28 1.92a449.5 449.5 0 0 1-5.42-52.4l-14.87.31a358.94 358.94 0 0 1 6.31 48.21l14.88-.31a345.36 345.36 0 0 1-6.84-43.49c-.41-4.32-3.63-9-8.23-9.52s-7.11 3.44-7 7.6a161.32 161.32 0 0 0 4.88 36.79c1.66 6.66 13.71 11.26 14.77 1.83l3-26.87-15.18-4.06a256.07 256.07 0 0 1 2.46 42l14.87-.31-12.58-46.49c-1.84-6.77-13.25-11.16-14.77-1.83a139.14 139.14 0 0 0-.58 41.7l15.28 1.92-8.76-49.81c-.76-4.31-3.39-9-8.23-9.52-4.35-.47-7.5 3.41-7.05 7.6l5.76 53.59 14.87-.31a319.21 319.21 0 0 1-8-54.14l-14.87.31a335 335 0 0 1 10.26 54.21l14.87-.32a305.45 305.45 0 0 1-14.22-50.8l-14.46 2.54q4.95 25.14 8.28 50.54l14.87-.32a345.42 345.42 0 0 1-13.5-62.21l-15.28-1.92 7.92 52.77c.64 4.31 3.45 9 8.22 9.51a6.61 6.61 0 0 0 7.06-7.6l-5.78-46.22-14.88.32q5.4 28.74 9.3 57.74l13.93-2.53a81.28 81.28 0 0 1-9.48-26.07l-14.87.31L218 406l14.46-2.54a212.58 212.58 0 0 1-12.28-40.55l-14.46 2.55a301.72 301.72 0 0 1 9.58 34.93l14.47-2.54a203.37 203.37 0 0 1-8.6-35.24c-.63-4.31-3.46-9-8.23-9.52-4.5-.49-7.3 3.42-7.05 7.6l1.41 23.45 14.87-.32a102.48 102.48 0 0 1-1.07-31.36l-14.77-1.83c9.68 23.19 13.1 48 16.28 72.73l14.87-.32a107.68 107.68 0 0 1-6.43-22.61l-15.28-1.92 5.18 31.2c.71 4.31 3.41 9 8.23 9.52 4.49.49 7.3-3.42 7-7.6l-1.66-26.8-14.87.31a168 168 0 0 1 8.15 32.05c.63 4.32 3.46 9 8.23 9.52 4.35.48 7.49-3.41 7-7.6L240 409.37l-14.88.31a215.16 215.16 0 0 1 6 26c.71 4.31 3.42 9 8.23 9.52 4.38.48 7.46-3.41 7.05-7.6l-2.57-26.44-13.94 2.53a68.89 68.89 0 0 1 5.76 21.73l14.88-.31a184 184 0 0 1-2.9-32.63l-14.87.31a327.08 327.08 0 0 1 7.35 35.46c.64 4.31 3.46 9 8.23 9.52 4.31.47 7.53-3.41 7-7.6l-4.15-36-14.87.32a202 202 0 0 1 6.39 31.51c.51 4.32 3.55 9 8.23 9.52 4.51.49 7.29-3.42 7.05-7.6l-1.79-30.65-14.88.31a195.57 195.57 0 0 1 5.6 32.58c.37 4.32 3.64 9 8.23 9.52s7.28-3.42 7-7.6l-.9-15.92-14.87.32a169.69 169.69 0 0 1 6.14 28.1l14.87-.31-1.84-6.22c-1.2-4-5.27-8-9.77-7.24s-5.74 5.93-4.7 9.79l2.7 10 12.22-6.69-6.07-7.41c-5.46-6.66-14.66-1.31-12.14 6.74a52.74 52.74 0 0 1 2.25 11l12.55-4.5a23.36 23.36 0 0 1-3.63-5.24l-11.21 8.95c-.51-1.18-.55-1-.11.53l14.47-2.55-4.48-10.82c-1.62-3.9-5-8.1-9.77-7.24-4.43.79-5.94 6-4.7 9.79a65.92 65.92 0 0 1 2.75 11.84l13.93-2.53-9.86-22c-1.55-3.46-6.09-6-9.74-4.7-4 1.42-4.67 5.79-3.79 9.47a161.27 161.27 0 0 1 3.33 18.38l14.87-.32-6.52-15.57-14.47 2.54a40 40 0 0 1 3.22 12.8l13.94-2.54-9.09-17.22c-4.55-8.62-15.79-5-13.53 4.76l3.86 16.7 14.47-2.55-7.77-19.12c-1.5-3.72-4.34-7.42-8.79-7.27a6.56 6.56 0 0 0-6.08 7.58l3.64 20.63 14.87-.31a135.08 135.08 0 0 1-6.8-23.73l-14.87.31 5.78 30 14.49-2.52a176.25 176.25 0 0 1-7.66-33.56c-.54-4.32-3.53-9-8.23-9.52-4.29-.47-7.57 3.41-7.05 7.6a199.69 199.69 0 0 0 8.48 38c1.32 4 5.17 8.06 9.76 7.24 4.82-.85 5.45-5.88 4.7-9.79l-5.78-30c-1.65-8.63-16.72-9.95-14.87.31a159 159 0 0 0 7.61 28.2c1.42 3.73 4.42 7.41 8.8 7.26a6.56 6.56 0 0 0 6.08-7.58l-3.64-20.63-14.87.31 7.76 19.13c1.59 3.91 5 8.1 9.77 7.24s5.6-5.9 4.7-9.79l-3.87-16.7-13.53 4.77 9.09 17.23c3.62 6.85 14.63 6.62 13.94-2.54a54.81 54.81 0 0 0-4-17.25c-1.64-3.9-4.95-8.11-9.77-7.25-4.17.75-6.26 6.05-4.7 9.79l6.53 15.58c1.55 3.71 4.31 7.42 8.79 7.27a6.59 6.59 0 0 0 6.08-7.58 203.37 203.37 0 0 0-4.14-22.85l-13.53 4.77 9.86 22c3.17 7.06 15.12 6.45 13.94-2.53a92.75 92.75 0 0 0-3.59-16.31l-14.47 2.55 4.42 10.84c1.62 3.9 5 8.1 9.77 7.24s5.53-5.89 4.7-9.79a21.59 21.59 0 0 0-4.53-8.9c-2.33-3-7-4.24-10-1.81-3.29 2.6-2.93 7.36-1.17 10.76a43.5 43.5 0 0 0 6.39 9.18c4.58 5 13.29 3.25 12.56-4.5a75.92 75.92 0 0 0-3.07-15.45l-12.14 6.73 6.07 7.41c5.61 6.83 14.29 1.23 12.14-6.74l-2.69-10-14.47 2.55 1.84 6.21c1.13 3.79 4.64 7.41 8.8 7.27a6.58 6.58 0 0 0 6.08-7.58 196.69 196.69 0 0 0-7-32.57c-2.49-8.1-15.48-10.5-14.88.32l.9 15.91 15.28 1.92a224.39 224.39 0 0 0-6.41-37c-2.18-8.38-15.5-10.32-14.87.31l1.8 30.53 15.29 1.94a231.3 231.3 0 0 0-7.13-35.94c-1.08-3.8-4.67-7.41-8.8-7.27a6.6 6.6 0 0 0-6.08 7.58l4.15 36 15.28 1.92a367 367 0 0 0-8.17-39.93c-2.27-8.57-14.93-10.18-14.87.32a209.16 209.16 0 0 0 3.71 37.1c1.6 8.62 15.94 10.12 14.87-.32a96.57 96.57 0 0 0-8.44-30.63c-3.27-7.16-14.81-6.41-13.94 2.53l2.57 26.44 15.28 1.92a254.32 254.32 0 0 0-6.84-30.49c-1.11-3.79-4.64-7.4-8.8-7.26-3.91.13-6.48 3.73-6.07 7.58l3.16 29.77 15.28 1.92a191.92 191.92 0 0 0-9-36.52c-1.34-3.75-4.48-7.41-8.8-7.26-4 .14-6.31 3.72-6.08 7.58l1.66 26.8 15.28 1.92-5.18-31.2c-.72-4.31-3.41-9-8.23-9.52a6.6 6.6 0 0 0-7 7.6 128 128 0 0 0 7.19 27.04c1.48 3.72 4.38 7.42 8.8 7.26a6.58 6.58 0 0 0 6.08-7.58c-3.36-26.15-6.87-52.67-17.1-77.18-1.4-3.37-3.83-6.88-7.82-7.29a6.34 6.34 0 0 0-6.95 5.46 129.8 129.8 0 0 0 1.69 40.11c1.69 8.67 15.5 10.12 14.87-.31l-1.41-23.45-15.28-1.92a229 229 0 0 0 9.41 39.7c1.35 4 5.16 8.07 9.77 7.25 4.76-.85 5.52-5.89 4.7-9.79a301.37 301.37 0 0 0-9.59-34.94c-1.35-4-5.15-8.07-9.76-7.24-4.8.85-5.47 5.88-4.7 9.79A211.06 211.06 0 0 0 218 406c1.62 3.9 5 8.1 9.76 7.25s5.54-5.9 4.7-9.79l-7.31-33.87c-.82-3.82-4.85-7.41-8.79-7.27a6.57 6.57 0 0 0-6.08 7.58 107.37 107.37 0 0 0 12.17 35c3.59 6.38 15.22 6.9 13.94-2.53q-4.24-31.25-10.11-62.21c-1.61-8.6-16.17-10.1-14.87.31l5.78 46.23 15.28 1.91-7.92-52.76c-.65-4.32-3.46-9-8.23-9.52-4.3-.47-7.55 3.41-7 7.6a370.33 370.33 0 0 0 14.32 66.68c1.19 3.78 4.58 7.41 8.79 7.27a6.58 6.58 0 0 0 6.08-7.58q-3.66-27.65-9.1-55c-.81-4.1-5.53-8-9.76-7.25-4.83.86-5.44 5.88-4.7 9.79a305.56 305.56 0 0 0 14.22 50.81c1.4 3.74 4.42 7.41 8.79 7.26 3.91-.13 6.48-3.73 6.08-7.58a363.09 363.09 0 0 0-11.08-58.66c-2.28-8.27-15.54-10.39-14.87.31a345.13 345.13 0 0 0 8.85 58.6c2 8.38 16 10.27 14.87-.31L236 344.68l-15.28-1.92 8.71 49.77c.75 4.31 3.38 9 8.23 9.52a6.6 6.6 0 0 0 7.05-7.6 124.19 124.19 0 0 1 .37-37.42l-14.77-1.83 12.59 46.49c2.35 8.7 14.62 10.08 14.87-.31a256.07 256.07 0 0 0-2.46-42c-.58-4.11-3-8.18-7.25-9.25a6.21 6.21 0 0 0-7.92 5.19l-3 26.87 14.77 1.83a141.45 141.45 0 0 1-4.07-32.33l-15.28-1.92a380.69 380.69 0 0 0 7.65 47.95c1.92 8.54 15.55 10.21 14.87-.31a392.92 392.92 0 0 0-7.08-52.64c-1.77-8.69-15.34-10.1-14.88.32a449.28 449.28 0 0 0 5.42 52.4c.71 4.31 3.42 9 8.23 9.52 4.47.49 7.35-3.42 7.05-7.6a552.83 552.83 0 0 0-7-56.94c-.72-4.11-2.88-8.15-7.25-9.26-3.46-.87-7.7 1.17-7.92 5.2a150.34 150.34 0 0 0 3.17 40.75c2 9.06 14.45 9.78 14.87-.32a301.23 301.23 0 0 0-1.69-46.52c-.49-4.32-3.57-9-8.23-9.52-4.47-.49-7.34 3.42-7 7.6a101.08 101.08 0 0 0 4.88 25c1.12 3.39 4 6.89 7.82 7.28 3.24.34 6.71-2 7-5.46a176.5 176.5 0 0 0-6.87-63.52l-13.6 4.73.37.65-.65-8.52-.32.8 2.59-2.84-.77.44 3.78-.69-1.27-.32 3.83 1.58c-5.8-4.22-11.82-7.19-19.08-7.65-9.79-.62-8.41 14.18-.78 16.59a145.1 145.1 0 0 0 15.76 4l-1.18-17.12a42.45 42.45 0 0 0-15.28 1.22c-4.31 1.18-6 5.65-4.69 9.8a15.75 15.75 0 0 0 7.94 9.72 18.35 18.35 0 0 0 5.05 1.7c1.47.28 3.48 0 4.84.59-1.79-.77-.82-.17-.2 1.42.91 2.33 1.8 4.67 2.7 7l4.72 12.26c1.51 3.94 5 8.09 9.76 7.25 4.4-.79 6-6 4.7-9.8a228.35 228.35 0 0 0-11.9-28.51c-1.7-3.41-6-6.05-9.75-4.7-4.07 1.46-4.5 5.74-3.78 9.47a175 175 0 0 0 9.61 32.47c1.5 3.72 4.35 7.42 8.79 7.27a6.57 6.57 0 0 0 6.08-7.58 156.48 156.48 0 0 0-8-30c-1.43-3.74-4.4-7.42-8.79-7.27-4 .14-6.34 3.73-6.08 7.58a136.71 136.71 0 0 0 5.05 28.76l14.46-2.55-11.45-29.62c-1.44-3.73-4.4-7.42-8.79-7.27a6.56 6.56 0 0 0-6.08 7.58 256.5 256.5 0 0 0 8.86 36c1.31 4 5.18 8.07 9.77 7.25s5.87-5.95 4.7-9.79A289.33 289.33 0 0 0 231 296c-3.35-7.06-14.8-6.47-13.93 2.53a151.78 151.78 0 0 0 9.19 39.71c1.51 3.94 5 8.08 9.77 7.24s5.66-5.91 4.7-9.79a150.89 150.89 0 0 0-14.09-36c-3.56-6.53-15.1-6.81-13.94 2.53a154.55 154.55 0 0 0 8.36 34.72c1.47 4 5.07 8.09 9.77 7.25 4.48-.8 5.87-5.95 4.69-9.79a407.63 407.63 0 0 0-14.15-39.14c-1.64-3.9-4.95-8.11-9.76-7.25s-5.56 5.9-4.7 9.79a164.69 164.69 0 0 0 13.15 37.16c1.8 3.68 6.76 6.47 10.66 4.38 4.24-2.27 3.61-7.76 1.93-11.37L215 289.71c-4.07-8.79-16.1-4.91-13.53 4.76a285.5 285.5 0 0 0 10.63 32.12l13.53-4.77-15.5-32.22c-1.65-3.42-6-6-9.75-4.7-4 1.43-4.63 5.78-3.78 9.47a174.66 174.66 0 0 0 12.62 36c4.11 8.67 16.29 4.94 13.53-4.77a153.83 153.83 0 0 0-24.21-49c-4-5.51-13.73-2.91-12.55 4.5a141.4 141.4 0 0 0 10.66 35.76l11.21-8.95c-4-4.35-5.72-10.19-8.14-15.45-2.84-6.15-6.64-11.75-12.26-15.68-2.63-1.84-6.8-2.44-9.11.33a9 9 0 0 1-3.38 2.71c-4.91 2.52-3.67 10-.55 13.33 14.24 15.12 30.45 32.22 26.69 54.71-2 12-3.9 22.5-.49 34.47 3.28 11.52 7.94 22.76 12 34l14.47-2.55q-7.78-18.57-15.55-37.14l-12.14 6.73c8.18 9.27 10.85 21.64 12.51 33.58 2.05 14.83 3.11 29.8 5.24 44.61 2.09 14.59 11.8 22.73 26.51 22 14.38-.75 29-5.9 41.86-12.18l-8.73-15.75c-11.85 6.48-10.76-21.77-11-26.64l-3-52.69c-1.77-31.06-.58-65-16-93.13-2-3.6-6.65-6.53-10.66-4.38s-3.85 7.87-1.94 11.36ZM155.64 197.28a118 118 0 0 1 10.8 12.81c2.39 3.28 7.91 4.36 10.79 1.2 3.29-3.61 1.5-8.73-1-12.12a116.72 116.72 0 0 0-10.8-12.81c-2.8-2.88-7.64-4.66-10.79-1.2-3 3.27-1.92 9.14 1 12.12ZM227 175.68a72.08 72.08 0 0 0 17.7-1.69c9.82-2.26 3.91-19-5.06-17a53.68 53.68 0 0 0-15 5.75c-6.65 3.8-2.25 16.31 4.95 16.43 34.41.59 49.55-34.48 55-63.24 3.22-16.92 1.72-33.77-7.4-48.67a129.46 129.46 0 0 0-31.12-34.8c-14.27-10.85-32.76-16.07-49.79-8.77-8.64 3.7 0 19.5 8.73 15.74 14.76-6.33 30.44 2.23 41 12.47 10.13 9.86 22 22.41 24.47 36.88 1.46 8.48 0 17.24-1.89 25.53a111 111 0 0 1-7.23 22.32c-5.94 12.86-17.6 25.69-32.93 25.43l5 16.43a39.47 39.47 0 0 1 11.3-4.49l-5.06-17a56.45 56.45 0 0 1-13.82 1.6c-10.72-.2-7.93 16.95 1.18 17.12Z"
			className="cls-1"
		/>
		<Path
			d="M195.45 51.73c13.86 3.79 28.46 7.55 40 16.6a35.05 35.05 0 0 1 10.63 13c3 6.75 3.9 13.25 8.34 19.43 4.14 5.76 13.35 2.77 12.55-4.5l-.97-8.68c-.14-1.27-.38-2.58-.43-3.87-.08-2.23-1 1 .17-.86l-2.58 2.84.69-.45-3.77.68h.87l-3.82-1.58c-.72-.42.57.91 1 1.65a20.2 20.2 0 0 1 1.67 3.67 26.37 26.37 0 0 1 1.2 8.89l14.87-.31a9 9 0 0 1-.38-3.72l-15.18-4c0 8.73-.31 17.45-.9 26.16l14.77 1.83-.8-3.43c-2.42-10.33-17.13-8.85-14.47 2.55l.81 3.43c1.54 6.58 14.13 11.29 14.77 1.82.68-10.14 1.07-20.29 1.1-30.45 0-8-14-14.43-15.18-4a31.35 31.35 0 0 0 1 12.45c2.43 8.52 14.84 10.23 14.88-.31 0-9.88-3.95-25.69-13.64-30.6-5.29-2.68-10.47.12-12 5.68-1.57 5.88.31 12.88 1 18.83l12.56-4.5c-1.76-2.44-2-6.3-3-9.13a50.29 50.29 0 0 0-4.75-10.26 62.32 62.32 0 0 0-14.62-16.14c-12.67-10-28.39-14.51-43.69-18.69-10.91-3-11.77 13.61-2.73 16.07Z"
			className="cls-1"
		/>
		<Path
			d="M250.49 167.55c8 3.9 14.66-5.46 18.81-11.08a86.69 86.69 0 0 0 11.28-20.4A92.82 92.82 0 0 0 286 90.41a88.85 88.85 0 0 0-56.08-70.36 87.24 87.24 0 0 0-51-4.11C169.07 18.22 175 35.05 184 33c23.5-5.44 49.31 1.26 67 17.84 18.14 17 24 42.28 18.49 66.15a74.41 74.41 0 0 1-7.22 18.77 64.66 64.66 0 0 1-5.53 8.55q-1.76 2.27-3.67 4.4c-.48.53-1 1.05-1.46 1.57s-1.75 1.27-1.28 1.2l3.9.48-.94-.45c-3.92-1.91-8.19.89-8.91 4.93-.82 4.65 2.11 9.16 6.17 11.13Z"
			className="cls-1"
		/>
		<Path
			d="M259.47 79.33v21.9c0 9.87 15.28 13.63 15.28 1.92v-21.9c0-9.87-15.28-13.63-15.28-1.92ZM401.24 177.08a44.32 44.32 0 0 1 4.2-15.6 39.52 39.52 0 0 1 3.91-6.49c.8-1.06 1.64-2.09 2.52-3.08l1.09-1.16q3.17-2.33-2.47-1.56l-3.06-3.5c-.43-.63-.39 1.45-.72 2.38a29.29 29.29 0 0 1-3.43 6.59 54.28 54.28 0 0 1-10.35 11.46l3.34-1.85-1 .2 7.45 3.06-.52-.47 2.73 6.41v-.69l-3.28 6.91.47-.34c3.74-2.64 4.08-7.5 1.94-11.36-1.76-3.18-6.91-7-10.66-4.38-5.56 3.93-4.43 11.44.37 15.6 5.9 5.1 11 .63 15.26-3.89 7.08-7.51 15-18.22 13.7-29.2-.65-5.38-3.81-11-9.12-13-5.85-2.12-10.34 1.88-13.93 6a56.76 56.76 0 0 0-13.43 31.69c-.42 4.51 1.77 9.36 6.17 11.13 3.78 1.53 8.5-.54 8.91-4.93Z"
			className="cls-1"
		/>
		<Path
			d="M86.34 207a186.88 186.88 0 0 0-7.81 36.21c-.66 5.94 8.58 11.72 10 4.13a158 158 0 0 1 12.27-37.6l-9.66-5.42L88 241.2c-.51 5.88 8.73 11.8 10 4.13a286.77 286.77 0 0 1 9.35-38.55l-9.66-5.42-5 29.15c-1 6.08 8 11.47 10 4.13l8.54-30.33-10-4.13-6 38.43c-.94 6 8.35 11.6 10 4.13a772.16 772.16 0 0 1 20.85-74.37l-7.9.28q-.77-2.55-1.32 0a13.45 13.45 0 0 1-1.66 2.3c-3.17 3.89 1.86 13.2 6.83 9.69 6.09-4.31 6.82-11.67 4.39-18.37-3-8.12-10.81-11.64-15.12-18.64l-6.36 7a174 174 0 0 1 19.17 15l4.31-9.32a37.59 37.59 0 0 1-9.61-7.78c-2.33-2.68-3.62-6-5.83-8.67-5.8-7.12-12.31-.59-16.67 4.37-10.28 11.67-15.49 26.67-19.66 41.38-2.48 8.73-4.69 17.54-7 26.31l-3.53 13.39c-1.22 4.62-3 9.43-3.39 14.21-.58 7.64 4.29 13.66 10.43 17.6 7.84 5 16.22 9.35 24.3 14 3.38 1.94 7.71.56 7.25-4a245.27 245.27 0 0 1-1.24-25.85c0-6.62-9.88-9-10.19-1.28a137.55 137.55 0 0 0 .67 19.78c.53 5 9 9.94 10.12 2.7a141.27 141.27 0 0 0 1.61-24.4c-.13-6.59-10.07-9.09-10.18-1.28l-.36 24.81 9.91-.21c-2.78-9.24-11.08-11.91-19.28-14.88-3.77-1.51-8.01-2.79-7.77-7.65.35-6.47 5.86-12.09 8.83-17.53 11-20.13 7.65-46.27 22.48-64.47l-8.94-6.51q-3.48 26.1-8 52c-1.06 6.1 7.86 11.41 10 4.13L116.78 159l-10.12-2.71a139.92 139.92 0 0 1-9.1 46.07A145.35 145.35 0 0 1 87.79 223q-1.26 2.2-2.6 4.36c-1.11 1.79-3.33 4-4 6-1.39 1-1.37 1.63.08 1.93q1.92 1.42.56-.81c-.24-1.84-1.94-3.76-3.13-5.05-2.32-2.52-8-3.14-8.3 1.57a57.89 57.89 0 0 0 2.6 21c.94 2.94 4.43 6.24 7.73 4.4a20.53 20.53 0 0 0 10.55-15.71L83 242.3a24.62 24.62 0 0 1 7 12.45l9.65-1.7L97.9 248c-2.28-6.59-12.21-5.72-9.64 1.7l1.74 5.05c2.28 6.57 11.48 6 9.65-1.7a37.14 37.14 0 0 0-10.16-18c-2.56-2.5-7.71-3.14-8.3 1.58a11.74 11.74 0 0 1-6.32 9.34l7.73 4.4a42.41 42.41 0 0 1-2.14-15.25l-8.3 1.57c1.37 1.49 1.62 3.92 2.84 5.6a10.64 10.64 0 0 0 5 4c4.43 1.38 7.13-1.42 9.48-4.78a150.9 150.9 0 0 0 14.71-26.18 154.71 154.71 0 0 0 12.59-57.78c.15-5.76-8.19-9.09-10.12-2.7l-14.24 47.53 10 4.13q4.5-25.93 8-52c.53-4-5.08-11.25-9-6.51-16.37 20.08-12.36 48-25.54 69.44-3.51 5.73-7.44 11.12-8.09 18a19.12 19.12 0 0 0 6.52 16.47c3.4 2.9 7.61 4.48 11.78 5.92 2.75.95 8.4 2 9.35 5.13 1.7 5.65 9.81 6.84 9.91-.21l.36-24.81-10.11-1.28a124.34 124.34 0 0 1-1.48 21.55l10.12 2.71a134.72 134.72 0 0 1-.67-19.78l-10.19-1.28a245.14 245.14 0 0 0 1.24 25.85l7.25-4q-10.52-6-21-12c-2.08-1.2-5.72-2.77-7-4.9-1.6-2.59 0-5.92.72-8.71 3.94-14.95 7.7-30 11.86-44.87 3.35-12 7.43-24.5 15-34.59 1.62-2.16 5-4.56 6.07-6.89q2.83-1.59-1.23-2.94l.75 1.36a20.92 20.92 0 0 0 2.57 3.93 47.75 47.75 0 0 0 14.69 13.5c7 4.14 9-5.14 4.31-9.32a173 173 0 0 0-19.16-15c-4.91-3.31-9.19 2.38-6.36 7s6.84 8 10.7 11.86c2.09 2.09 6.4 7.32 2.61 10l6.83 9.69c4.71-5.78 6.47-12.1 1.69-18.42-1.77-2.33-6.73-3.23-7.91.29a795.65 795.65 0 0 0-21.64 77l10 4.13 6-38.43c1-6.06-8-11.5-10-4.13l-8.54 30.33 10 4.13 5-29.15c.84-4.83-7.59-11.86-9.65-5.42A304.84 304.84 0 0 0 88 241.2l10 4.13 3.19-36.86c.4-4.64-6.61-11.91-9.66-5.43a169.63 169.63 0 0 0-13.06 40.19l10 4.13a174.29 174.29 0 0 1 7-33.62 7.06 7.06 0 0 0-2.48-8c-2-1.43-5.85-1.62-6.78 1.3Z"
			className="cls-2"
		/>
		<Path
			d="M127.38 167.34c9.87-1 19.18 1.82 28.28 5.39 6.85 2.69 17.23 5.6 20.06 13.23l4.05-2.25a40.85 40.85 0 0 0-8.78-7.92c-3.25-2.18-4.89 2.83-2.16 4.65a35.78 35.78 0 0 1 7.67 6.91 2.33 2.33 0 0 0 4.05-2.24c-3.4-9.13-12.08-12.89-20.52-16.34-11-4.51-22.28-8.32-34.34-7.11-3.29.33-1.35 6 1.69 5.68ZM105.24 254.07c17.72 14.4 48.91 20.67 68 5.07 2.34-1.92-1.32-6.57-3.92-4.44-8.54 7-21.72 8.33-32.31 7.16a56.61 56.61 0 0 1-29.57-12.45c-3-2.47-4.67 2.62-2.16 4.66Z"
			className="cls-2"
		/>
		<Path
			d="M342.74 260.62a1.08 1.08 0 0 1-.71-1.27l-9 3.17 6.69 10.48c1.87 2.94 6.83 5.37 8.82 1 3.63-7.88-1.66-16.67-9.42-19.34-4.56-1.57-9.63-1.73-14.38-2.3l-17.25-2.08 5 9.06a82.43 82.43 0 0 1 5-7.85c1.13-1.55 3.8-6.31 5.88-6.54 5.12-.58-1.32 11.81-2.26 13.51l9.26 6.71 8.63-18.63c2.11-4.58-4.2-12.5-8.56-7.8a112.61 112.61 0 0 1-37.41 26.8c-5.52 2.44-.44 11.62 4.6 10.93l22.67-3.11 11.33-1.55c3-.42 6.37-.48 8.72-2.71s2.44-5.56 2.79-8.57l1.34-11.63 2.79-24.24c.43-3.78-5.28-11.55-9-6.51a217.88 217.88 0 0 1-57.84 55.14c-4.33 2.79-1.59 10.6 3.3 11a230.24 230.24 0 0 0 34.94-.11q8.64-.69 17.2-2.09c4.35-.71 10.54-.93 13.53-4.72s2.4-10.1 2.7-14.69l1.17-17.93 2.45-37.85a7.19 7.19 0 0 0-3.49-7.07c-2.07-1.14-5.18-.94-6.16 1.65-3.31 8.71-11.83 12.89-19.08 17.91a190.24 190.24 0 0 0-42.45 40.39c-2.52 3.27-6.64 7.34-7.85 11.33-1.39 4.59.32 11.48.62 16.24.22 3.54 4.2 8 8 5.88 10.51-5.86 22.47-5.54 34.13-6.52s23.35-2.95 35.11-3.67c2.41-.15 3.5-3 3.4-5-2.63-56.11-1.86-114.87 23.47-166.33 1.59-3.24-.69-7.35-3.72-8.72a372.7 372.7 0 0 1-44.23-23.16c-2.28-1.42-5.49-1.59-6.78 1.31q-7.36 16.41-14.26 33c-3.41 8.18-6.76 16.4-9.8 24.73-1.89 5.19-4.43 10.91-4.82 16.48-.21 3 1.13 6.23 4.11 7.42 2.47 1 5.73-.33 5.94-3.29.36-5.16 2.74-10.4 4.5-15.18 3-8.22 6.36-16.34 9.74-24.43q6.72-16.11 13.85-32l-6.79 1.3A396.61 396.61 0 0 0 376 113.63l-3.72-8.72c-26.14 53.11-27.12 113.86-24.4 171.77l3.41-5c-12.37.76-24.59 2.88-36.94 3.82-12 .91-23.94 1.21-34.74 7.24l8 5.88-.88-14.16-1.17 3.8a193 193 0 0 1 34.62-38.62A227.67 227.67 0 0 1 340 225.1c6.51-4.41 12.54-9.39 15.41-16.95l-9.66-5.42-2.07 31.87-1 15.94c-.33 5 .18 11-1 15.94-.72 2.91-1.34 2.82-4.29 3.39-2.52.48-5.06.89-7.6 1.27q-7.62 1.14-15.31 1.72a210.83 210.83 0 0 1-31.39 0l3.31 11A225.18 225.18 0 0 0 346.18 227l-8.94-6.51-2.24 19.43-1.12 9.7c-.26 2.23.06 8.51-1.48 10s-6.85 1.2-8.86 1.48l-9.45 1.29-19.83 2.72 4.6 10.93a119.79 119.79 0 0 0 39.44-28.41l-8.56-7.8-8.64 18.69c-2.52 5.44 5.77 13 9.26 6.71 5.26-9.52 8.62-23.69-3-30.31-11.34-6.44-19.59 9.83-24.08 17.77-2 3.47 1.33 8.62 5 9.06l18.22 2.19c1.69.21 13.93.94 12.79 3.41l8.83 1-6.7-10.51c-3.29-5.16-10.86-3.65-9 3.18a14.87 14.87 0 0 0 11.14 11c3 .77 4.81-2.62 4.7-5.07a7 7 0 0 0-5.49-6.34Z"
			className="cls-3"
		/>
		<Path
			d="M302.59 167.54c9.72-3.14 19.14-4.22 28.84-.3 7.68 3.09 13.92 9.64 14.43 18.15l9.29-1.69-5.31-9.28c-1.21-2.12-3.13-4.55-3.68-7-.81-3.49 1.32-7.49 2.49-10.71 1.08-3 2.17-5.92 3.3-8.87 4.65-12.12 10-24.06 17.79-34.51l-8.55-7.8q-9.48 28.22-20.64 55.83l9.26 6.71q10-25.82 21.1-51.17l-9.26-6.72Q351.24 140 343.27 170.5l10.05 4.13 1.89-18c.54-5.16-6-11.21-9.66-5.42a27 27 0 0 0-4.05 15.92c.16 4.51 7 9.45 9.72 4a273.33 273.33 0 0 0 12.56-30.67c3.48-9.8 8.87-20.44 8.8-31 0-6.58-10.23-9.09-10.18-1.27 0 5.18-2.52 10.33-4.22 15.15-1.63 4.63-3.24 9.26-4.9 13.87A254.35 254.35 0 0 1 342 164.43l9.72 4a17.48 17.48 0 0 1 3.13-10.49l-9.65-5.42-1.89 18c-.63 5.95 8.08 11.67 10.05 4.13q7.62-29.2 17.59-57.7c1.91-5.46-6.32-13.42-9.26-6.72q-11.11 25.37-21.1 51.18c-2.16 5.56 6.59 13.32 9.26 6.71q11.15-27.6 20.64-55.82a6.92 6.92 0 0 0-1.91-7.51c-1.69-1.52-5-2.53-6.64-.29-9.4 12.58-15.6 26.86-21 41.51-2.52 6.8-6.27 14.3-4.69 21.72s6.9 14.23 10.57 20.64c2.55 4.45 9.66 4.51 9.29-1.69-.72-12.14-8.38-22.5-18.89-28.25-12-6.56-25.27-6.33-37.93-2.23-6.39 2.07-2.41 13.23 3.37 11.36Z"
			className="cls-3"
		/>
		<Path
			d="M325.31 93.2c4.49 6.42 10.42 9 17.22 12.44A108.94 108.94 0 0 1 364 120.21c4.82 4.12 8.69-2.73 6.35-7-3.71-6.77-9.42-11.43-16.17-15-7.4-3.86-15.54-6-22.1-11.31l-4.31 9.31a163.89 163.89 0 0 1 27 24.32l-1.35-7c-8.8 14.21-17.24 28.73-19.9 45.48-.84 5.27 6.06 11 9.66 5.42a77.16 77.16 0 0 0 9.68-22.88c1.53-6.05-8-11.38-10-4.13l-6 21.06 10 4.13a139.2 139.2 0 0 1 6.84-20.59c2.61-6.13 6.51-12 8-18.57a17.68 17.68 0 0 0-4.07-16.22c-3.49-3.72-8.63-5.42-13.28-2.89s-1.22 10.44 3.3 11a15.33 15.33 0 0 1 8.14 3.29l4.31-9.32-5.34-3.1-3.07 10a7.44 7.44 0 0 1 3.71 2.65l4.18-9c-8.24-2.55-14-8.67-19.79-14.8-3.88-4.14-9.65-1.09-8.09 4.48a50.43 50.43 0 0 0 10.7 19.87l6.55-7.27-16.2-16.54-5.43 8.3a359.21 359.21 0 0 1 27.3 25.48l5.43-8.29a60.61 60.61 0 0 1-15.81-18.92l-6.36 7a63.2 63.2 0 0 1 12.71 16.07c3.13 5.51 10.72 3.46 9-3.18l.37-1.83c1.54-3.31-.66-7.28-3.72-8.72a19.43 19.43 0 0 0-7.51-1.72c-1.72-.07-6.36.69-7.72-.48s-.95-5.44-1.15-7a21.45 21.45 0 0 0-2.72-8.62c-1.51-2.56-5.59-5.07-8.12-2.12a104.21 104.21 0 0 0-20.7 38.81c-1.48 5 7.07 11.47 9.65 5.42a177.4 177.4 0 0 1 13.75-26l-9.26-6.71a317.24 317.24 0 0 0-16.46 43.5l10.06 4.13a312.66 312.66 0 0 1 11-32.85l-9.26-6.71-14.43 36.46 9.73 4a13.2 13.2 0 0 1 2.36-7.86l-9.66-5.43a85.36 85.36 0 0 1-6.51 17.94l9.31 6.73a153.29 153.29 0 0 1 26.86-47.55c2.92-3.48-.56-11.58-5.61-10.12-7.23 2.1-8.67 10.35-11 16.6l-9.78 26.58c-2 5.53 5.29 12.91 9.26 6.71q12.25-19.12 26-37.18l-8.55-7.8-17.79 35.47c-2.25 4.48 4.73 12.84 8.55 7.8L350.47 122l-8.55-7.8A151.94 151.94 0 0 1 327 147c-2.26 3.72 2.11 9.82 6.32 9 5.39-1 7.64-6 10.2-10.28l11-18.64-9.26-6.71q-5.91 12.24-10.74 24.94c-2.1 5.53 6.49 13.34 9.26 6.71l8.7-20.81c2.29-5.47-6.06-13.22-9.26-6.71l-9.15 18.62c-1.64 3.34-2 4-5.91 4.29a62.3 62.3 0 0 1-10.13-.18l.78 11.41 20.77 1.54-2.08-11.39a85.23 85.23 0 0 1-33.45-3.24c-7-2.13-7 6.61-3.07 10 9.82 8.51 23 6.93 34.75 4.28 5-1.12 3.78-8 .47-10.33a22.71 22.71 0 0 1-7.39-8.7l-6.35 7a22.26 22.26 0 0 1 9.5 11.66l4.42-6.55-1.62-.17q-2.38-1.76-2 .78c-1 3.2 1.85-.83 2.23-1.25q3-3.26 6-6.47c2-2.1 1.32-6.2-.64-8.08-4.35-4.14-9.63-5.16-15.07-2.25s-7.77 9.2-13.23 11.87l5.95 10.49c5.55-3.85 13-1.05 18.16-6.52 4.23-4.51 4.17-12.87-1.48-16.27s-11.7 2.91-15.59 6.37c-4.82 4.28-9.37 9.69-15.79 11.53l6.32 9a382.74 382.74 0 0 0 25.15-50.82l-9.65-5.42a149.27 149.27 0 0 1-6.54 29.91l9.66 5.42a215.33 215.33 0 0 1 8.53-31.46l-9.66-5.42a132.12 132.12 0 0 0-3.24 19.24l10.13 2.74a73.83 73.83 0 0 1 .71-20.19l-9.84-1.22 7 21.83c1.1 3.4 7.54 7.79 9.45 2.51a18.71 18.71 0 0 0-1.21-16.18l-6.36 7a59.51 59.51 0 0 0 17.86 9l.52-11.06.85.25 2.67 3.81-.3-1-.91 5.29.48-.6-3.53 1.27-1.09-.61-2.94-5.3.13.78c.44 2.89 2.29 6 5.48 6.35a4.4 4.4 0 0 0 4.7-5.07c-.71-4.54-6.26-11-10.83-6-4.21 4.61 1.06 11.52 6.07 12.23 6.52.94 5.51-9.54.52-11.06a50.2 50.2 0 0 1-15.43-7.61c-5-3.65-8.82 2.5-6.36 7a5.27 5.27 0 0 1 .35 4.81l9.46 2.5-7-21.83c-1.4-4.34-8.74-7.56-9.85-1.21a85.11 85.11 0 0 0-.85 23c.5 4.94 9.45 10 10.12 2.7a132.12 132.12 0 0 1 3.24-19.24c1.23-5-7.44-11.65-9.65-5.42a231.94 231.94 0 0 0-9.32 34c-.95 4.88 7.53 11.79 9.65 5.42a161.54 161.54 0 0 0 7.33-32.49c.54-4.65-7-12-9.66-5.42a382.74 382.74 0 0 1-25.15 50.82c-2.06 3.49 2.06 10.26 6.32 9 5.66-1.62 10.09-4.77 14.44-8.66 3.15-2.82 8.65-10 13.09-10.27l-3.84-1c-.44-3.06-1.13-3.7-2.05-1.93a7.22 7.22 0 0 1-2.15 1.35 15.87 15.87 0 0 1-4.22.65c-3.53.37-6.77.84-9.77 2.92-5.16 3.59 0 13.32 5.82 10.49 3.4-1.66 5.83-4.32 8.27-7.15.73-.85 6-7.21 7.66-5.68l-.65-8.08c-4 4.25-11.71 9.86-10.64 16.39 1.11 6.78 8.42 10.38 14.64 11 3.59.36 5.54-3.43 4.43-6.56-2.83-7.93-7.64-14.74-14.83-19.27-5.18-3.27-8.75 2.25-6.35 7A36.1 36.1 0 0 0 332 158.83l.47-10.33c-9 2-19.46 4.35-27.07-2.25l-3.06 10a97.59 97.59 0 0 0 38.66 3.91c6.22-.63 3-11-2.09-11.39l-20.76-1.53c-7.14-.53-5.26 10.88.78 11.41 6.25.55 17.23 2 21.64-3.51 2.41-3 3.8-7.16 5.5-10.62l6.53-13.3-9.26-6.71-8.7 20.81 9.26 6.71q4.83-12.71 10.74-24.94c2.63-5.44-5.59-12.9-9.26-6.71l-8 13.55c-1.44 2.42-4.32 10.16-7.33 10.72l6.32 9a151.65 151.65 0 0 0 14.89-32.78 6.92 6.92 0 0 0-1.92-7.51c-1.69-1.52-4.94-2.52-6.63-.29l-23.94 31.53 8.55 7.8 17.79-35.48c2.25-4.47-4.72-12.83-8.55-7.8Q322 128.23 309.1 148.48l9.26 6.71 7.76-21.08 3.71-10.11c.5-1.37 1.61-6.85 3.4-7.37l-5.61-10.12a160.89 160.89 0 0 0-28.29 49.72c-1.91 5.42 6 13.36 9.27 6.71a98.79 98.79 0 0 0 7.29-20.51c1.28-5.34-6.22-10.91-9.66-5.43a23 23 0 0 0-3.23 13.34c.13 4.23 7.43 9.78 9.72 4l14.43-36.46c2.22-5.59-6.64-13.3-9.26-6.71A339.8 339.8 0 0 0 306 146.59c-1.65 6 7.91 11.36 10.06 4.13a298.57 298.57 0 0 1 15.56-40.95c2.56-5.5-5.38-12.76-9.26-6.71a177.29 177.29 0 0 0-13.75 26l9.66 5.43a92.41 92.41 0 0 1 18.5-34l-8.12-2.12c1.76 3 1.11 7.08 1.82 10.42a15.83 15.83 0 0 0 4.95 9c5.81 5 12.67 1.61 18.89 4.54l-3.72-8.72a14.19 14.19 0 0 0-.74 10.25l9-3.17a81.55 81.55 0 0 0-16.79-20.73c-4.76-4.27-8.65 2.78-6.36 7a76.32 76.32 0 0 0 19.89 23.58c5.52 4.34 9.47-4.12 5.44-8.29a386.27 386.27 0 0 0-29.54-27.53c-5.35-4.49-9.5 4.15-5.43 8.3l16.2 16.53c5.47 5.6 11.18-2 6.55-7.27a35.72 35.72 0 0 1-7.61-14.29l-8.1 4.49c7 7.46 14.48 15.13 24.52 18.23 6 1.85 7.32-5.2 4.19-9a19.3 19.3 0 0 0-8.44-6.09c-6.38-2.37-7.87 7.22-3.07 10l5.35 3.11c6.82 4 9.5-5.37 4.31-9.32a26.32 26.32 0 0 0-13.18-5.41l3.3 11c3.47-1.89.6 7 .19 7.94-1.61 3.7-3.59 7.22-5.22 10.92a154.65 154.65 0 0 0-8.33 24.79c-1.5 6.06 8 11.39 10 4.13l6-21.06-10-4.13a69 69 0 0 1-8.89 20.29l9.65 5.43c2.51-15.81 10.81-29.5 19.11-42.89 1.28-2.06.1-5.37-1.36-7A177.81 177.81 0 0 0 332 87c-6.47-4.65-9.24 5.29-4.31 9.31 5.69 4.65 12.38 7.27 19.06 10.14 6 2.56 11.88 5.54 15.13 11.46l6.35-7a118 118 0 0 0-18-12.77q-4.35-2.49-8.88-4.65c-2.57-1.23-5.94-2.49-7.64-4.92-1.55-2.21-4.27-4.49-7.11-2.92-2.49 1.38-2.83 5.36-1.29 7.57ZM365.82 90.87l9.47 3.53.52-11.06a38.91 38.91 0 0 1-11.46-2l-.52 11.06c4.84 0 9 4.65 13.14 6.79a37.41 37.41 0 0 0 7.16 2.75c1.94.54 4.88.66 6.34 2.15 4.76 4.86 10.38-.25 7.47-6a137 137 0 0 1-6.51-14.73c-1.65-4.49-2.36-9.95-4.7-14.11-5.82-10.36-17.62 3-23.09 7.23-4.21 3.22-1.67 10.1 3.3 11l-.74-.37-2.48-8 1-.68c-6.6 1.21-2.65 12.31 3.38 11.36 4.21-.67 10.9-.44 13.25-4.78s-.66-9.47-4.71-11.12c-4.36-1.78-6.5 2.55-5.73 6.2a52.62 52.62 0 0 0 5.69 15c3 5.28 11.72 3.29 9-3.18a47.92 47.92 0 0 1-3.43-12.32l-9.3 1.69a104.67 104.67 0 0 1 6.25 12.26l9-3.18a88.81 88.81 0 0 1-4.32-13l-8.09 4.49a24 24 0 0 1 6.79 9.84l8.09-4.48a33.78 33.78 0 0 1-6-12.51l-9 3.18a48.87 48.87 0 0 1 5.93 16.51c.46 2.88 2.28 6 5.48 6.34a4.39 4.39 0 0 0 4.7-5.07 65.82 65.82 0 0 0-7.7-22.57c-3.12-5.49-10.75-3.46-9 3.18a49.42 49.42 0 0 0 9.08 18.08 4.65 4.65 0 0 0 8.1-4.48 37.41 37.41 0 0 0-9.88-15.43c-4.07-3.75-9.59-1.36-8.1 4.49a108.82 108.82 0 0 0 5.56 16c2.49 5.78 11.67 3.09 9-3.18a129.19 129.19 0 0 0-7.49-15.21c-2.44-4.19-10.12-4.66-9.29 1.68a59.08 59.08 0 0 0 4 15.3l9-3.18a41.59 41.59 0 0 1-4.45-12l-5.73 6.2.89.36-3.91-4.5c-1-2.72 1.8-3.43-2.48-2.76l-4.6.73 3.38 11.36a6 6 0 0 0 4.9-4c1-2.7.14-6.42-2.47-8a11.45 11.45 0 0 0-4.36-1.73l3.3 11 7.34-5.63c1.14-.88 5.34-4.67 5.59-4.67l-3.66-2.06c-1.65-1.85-.53-.64 0 1.19.33 1.13.67 2.26 1 3.39.9 2.81 1.88 5.6 3 8.35q3 7.77 6.82 15.21l7.47-6c-4.76-4.86-10.81-4.85-16.69-7.58S370 80.87 363.05 81c-6.42.07-5.75 9.26-.52 11.06a48.24 48.24 0 0 0 14.06 2.74c6.62.26 5.48-9.21.52-11.06l-9.47-3.53c-7.08-2.64-7.65 8.54-1.82 10.71Z"
			className="cls-3"
		/>
		<Path
			d="M389.24 76.92c11.8 8.24 25.22 13.15 39.1 16.64 3.33.84 2.44-4.56.26-5.53-9.62-4.31-19.66-7.61-29.28-11.92l-.91 5.36c10.28 4.54 21 8.13 31.25 12.67l-1.5-4.9a199.33 199.33 0 0 0-20.06 38.37l2.77-1c-14.06-4-19.78 11-24 21.34-3.92 9.54-13.19 23.85-5.1 33.49 1.53 1.82 4.34 1 4.19-1.5l-.42-6.85-5 .11c2.39 6.31-1.63 12.53-4 18.24a89.45 89.45 0 0 0-5.2 15.94 65.31 65.31 0 0 0 1.33 32.62l1-3.05c-3.78 1.87-8 2-11.8 3.83l4 2.94c.33-15.09.21-30.59 2.73-45.5 2.86-16.93 8.76-33.3 14.62-49.38 2.81-7.7 6-15.37 10.84-22.05 3.67-5.07 8.33-9.71 10-15.92 1.44-5.42-.11-10.6-2.6-15.45-2.82-5.48-7.73-11-6.63-17.52l-4.61.13A97.46 97.46 0 0 1 403.3 106c1 3.38 5.82 2.94 4.82-.85L401.73 81l-4.51 1.59a74.36 74.36 0 0 1 11.37 24.72l4.51-1.59a41.81 41.81 0 0 1-4.71-20.58l-4.64.85a56 56 0 0 1 8.11 17.68l4.83-.85a31.09 31.09 0 0 1-1.84-12.5l-3.59 1.3a13 13 0 0 1 4.36 7.74l4.82-.85q-1.08-2.73 1.47-3.58c0 1.88 2.95 4.56 4.51 2.54l2-2.58c1.83-2.37-1.41-6.79-3.92-4.44a71 71 0 0 0-21.12 37.72c-.63 3 4 5.72 5 2.07l6.62-23.78c.7-2.51-3.46-5.72-4.83-2.71a160.78 160.78 0 0 1-18.24 30.75c-1.84 2.42 1.9 7.08 3.92 4.44a95.91 95.91 0 0 0 15.27-29.09c.67-2.11-2.18-6.63-4.28-3.9-30.14 39.06-47 86.89-43.51 136.46.11 1.66 1.59 3.41 3.39 3.16 4.59-.67 7.94-.94 8.57-6.28.74-6.33-1.12-13.2-1.31-19.58a129.59 129.59 0 0 1 6.75-45l-4.86-2c1.81 11.69-4.66 23.59-6.9 34.93a136.9 136.9 0 0 0-2.23 34.23c.19 3.27 5.32 4.55 5.1.64a130.71 130.71 0 0 1 2.89-36.51c2.45-10.75 7.94-21.44 6.19-32.7-.28-1.8-3.79-5.17-4.86-2a137 137 0 0 0-7.05 36 135.58 135.58 0 0 0 .12 17.34c.23 3 .66 6 .94 9 .15 1.58.23 4.81-1.46 5.81-.82.48-2.72.31-3.62.44l3.39 3.16c-3.37-48.18 13.05-94.7 42.34-132.66l-4.27-3.9a91.92 91.92 0 0 1-14.56 28l3.92 4.44a167.78 167.78 0 0 0 19-31.83l-4.83-2.71-6.57 23.72 5 2.07a66.72 66.72 0 0 1 20-35.35l-3.92-4.44-2 2.58 4.5 2.54c.08-3.7-3.54-7.06-7.33-6.25-4.57 1-5 6.39-4.05 10 .9 3.44 5.59 3 4.82-.85a20 20 0 0 0-7-11.55c-1.21-1-3.48-.48-3.59 1.29a38.64 38.64 0 0 0 2 15.42c1.15 3.27 5.84 3 4.83-.85a61.22 61.22 0 0 0-8.75-19.16c-1.47-2.16-4.58-2.31-4.64.84a48.06 48.06 0 0 0 5.62 23.6c1.48 2.85 5.34 1.67 4.51-1.59a79.24 79.24 0 0 0-12-26.2c-1.72-2.44-5.44-1.91-4.51 1.59l6.4 24.2 4.82-.85a102.87 102.87 0 0 0-13.75-29.52c-1.13-1.67-4.15-2.66-4.61.13-.92 5.47.94 10.32 3.55 15.06 3.35 6.07 8.13 12.11 5.14 19.34-2.81 6.81-8.84 12.1-12.49 18.5-3.91 6.84-6.57 14.29-9.17 21.68-5.46 15.53-11 31.22-13.55 47.55-2.29 14.8-2.18 30.16-2.51 45.11 0 1.9 2.18 3.85 4 3 3.77-1.87 8-2 11.8-3.83 1.08-.53 1.26-2 1-3a61.14 61.14 0 0 1 1-37.5c3.12-9.19 10.65-19.23 6.85-29.26-.95-2.52-5.18-3.63-5 .11l.42 6.85 4.19-1.5c-3.38-4-.27-10.14 1.41-14.26s3.36-8.16 5-12.24c3.15-7.51 7.6-22.55 18.6-19.37a2.13 2.13 0 0 0 2.77-1 193.08 193.08 0 0 1 19.35-37.28 3.35 3.35 0 0 0-1.51-4.9c-10.28-4.55-21-8.14-31.25-12.68-3.45-1.53-3.72 4.1-.91 5.36 9.62 4.3 19.66 7.61 29.28 11.91l.26-5.53C415 84.6 402.41 80 391.39 72.26c-3.2-2.24-4.84 2.78-2.15 4.66ZM413.91 75.17l8.8 2.67c1.2.37 7.05 1.3 7.46 2.5l4.05-2.24a34.37 34.37 0 0 1-7.15-20.1c-.09-2.32-3.42-4.63-4.86-2a34.57 34.57 0 0 1-9.8 11.3c-2.41 1.8-.44 5.59 2.3 5.47a35.59 35.59 0 0 0 10-1.88c1.89-.63 1.95-2.38 1.26-4a5 5 0 0 0-4.5-3.25c-2.76-.19-2.65 3.08-1.44 4.67a19.58 19.58 0 0 0 9.59 6.86c2.33.77 3.87-1.91 2.55-3.84a34.37 34.37 0 0 1-3.8-7.13l-4.51 1.59c.64 1.14 4.88 9.24 4.77 9.31-.55.36-6.58-5-7.34-5.74l-2.72 4.15 3.26 2c3.32 2 5-2.92 2.16-4.66l-3.26-2c-2.89-1.79-4.88 2-2.72 4.15 2.61 2.61 10.21 10.41 14.3 7.22 4.47-3.49-2.44-13.51-4.26-16.76-1.48-2.65-5.76-1.68-4.51 1.59a41.41 41.41 0 0 0 4.43 8.6l2.56-3.84a14.23 14.23 0 0 1-7.22-5.14l-1.44 4.67-.1-.12 1.26-4a36.07 36.07 0 0 1-10 1.87l2.3 5.46a40 40 0 0 0 11.52-13.2l-4.87-2a41.93 41.93 0 0 0 9 24.34 2.32 2.32 0 0 0 4-2.25c-1-2.92-2.93-4.3-5.76-5.3-4.72-1.67-9.63-2.92-14.41-4.38-3.62-1.09-3.9 4.45-.91 5.36Z"
			className="cls-3"
		/>
		<Path
			d="m428.46 81.53 1.63 3.24a6.85 6.85 0 0 0 3.28 3 4.48 4.48 0 0 0 3.82-.11c2.67-1.68 2.56-5 1.29-7.57l-1.62-3.25a6.87 6.87 0 0 0-3.29-3 4.52 4.52 0 0 0-3.82.11c-2.67 1.68-2.55 5-1.29 7.58Z"
			className="cls-3"
		/>
		<Path
			d="M441.43 85.56C436 74.22 432.4 62 426.37 51c-.84-1.53-3-2.22-4-.46-2.27 4-5.56 7.94-8.29 11.78-2 2.77-5.1 6-6.73 9.28-1.91-.75-3.82-1.49-5.72-2.25-3.72-1.48-7.43-3-11.09-4.58-1.32-.57-2.6-1.26-3.92-1.81a3.36 3.36 0 0 1-.87-.51c-.07-.07-.13-.15-.21-.22s-.13-.16-.06 0l-.23-.19a2.11 2.11 0 0 0-3.74.82Q368.62 73 356.43 84.13q-16.23-8.28-31.8-17.82c-1-.62-2.49-.73-3.05.59q-23.74 55.1-44.17 111.6c-6.12 6.85-10.45 14.75-14.66 22.84-4.3 8.24-9.61 16.56-18.34 20.64a22 22 0 0 1-2.92 1.11 3.43 3.43 0 0 0 0-.76 90.54 90.54 0 0 0-8.71-25.83c-1.55-3-5.33-.91-3.78 2.1a81.82 81.82 0 0 1 7.91 23.16 3.28 3.28 0 0 0 1.42 2.09 36.47 36.47 0 0 1-20-2.21c-5.61-2.5-9.61-8.32-13.35-12.95-2.83-3.52-5.76-7.07-8.92-10.3a2.94 2.94 0 0 0-.31-1.23c-10.76-22.9-34.38-39.86-60.17-38.42-23.68-16.69-35-47.41-29.68-75.67S132 31 157.75 19.13C188 5.16 224.6 8 254 23c14.83 7.56 26.88 18.73 34.12 33.84 6.67 13.94 9.09 29.93 8 45.29-2.47 35.59-25.15 73.39-64.3 74.71-2.94.1-1.21 5.21 1.52 5.12 36.23-1.23 60.11-33.62 65.94-66.84 5.56-31.71-2.94-67.15-29.27-87.48C241.79 5.84 200.66-.84 166.87 9.89c-29.5 9.36-54.44 32.92-63.42 62.81a84 84 0 0 0 2.39 54.12 24.72 24.72 0 0 0-16.08 5.35c-5.87 4.73-8.3 11.67-10.29 18.7-5.47 19.23-10.54 38.57-15.81 57.85-3.83 14-12.53 32.81-1.37 45.63 10.35 11.89 28 18.91 42.89 22.58a2.22 2.22 0 0 0 .48.07v.58c1.82 19.84 8.2 37.21 17.72 54.57 5.23 9.55 10.61 19.47 11.5 30.54.78 9.61-2.83 16.88-8.61 24.26-6.57 8.4-13.23 16.71-20.26 24.74S91.6 428 85.87 437.22c-6 9.68-1 16 4.89 24.12 6.48 8.89 12.44 19.09 20.66 26.5 5.35 4.82 13.37 9.63 20.61 5.9 7.92-4.09 7.77-13.7 8.82-21.35 1.32-9.64 7.77-17 14.32-23.73s13.07-13.48 19.13-20.78c10.65-12.82 19.07-26.31 24.39-41.75 4.26 11.22 8.51 22.49 11.44 34.14 3.27 13 4.37 26.29 6.24 39.54 1.79 12.69 8.15 22.56 21.34 25.15 14.39 2.83 29.19-4.94 41.93-10.61 4.9-2.17 13.77-4.44 15.92-10.08 1.52-4-.34-8.62-3.36-11.36a12.75 12.75 0 0 0-6.75-3c-3.47-.52-6.42 1-9.74 1-5.25 0-4.71-6.32-5.13-10.24q-.66-6.27-1-12.56c-1.74-28.68 1.48-57.47-1.27-86.1-2.15-22.36-9.58-43.3-15.92-64.69a66.37 66.37 0 0 0 11.94-5q1.95 11.31 3.89 22.63c.24 1.42 1.34 3.15 3.05 2.84 31-5.63 62.74-6.67 94.06-9.91 1.44-.15 1.63-1.86 1.41-2.94a210.78 210.78 0 0 1-3.91-30c.09 0 .18 0 .28-.05 7.09-2.26 13.62-5.86 20.7-8.11 1.67-.53 1.79-2.18 1.13-3.6-9.57-20.6-.78-43 8.55-61.94l.65.17c6.57 1.39 12.47-2 17-6.49 9.37-9.31 18.43-23.66 13.12-37.29a16.16 16.16 0 0 0-4.35-6.14c6.58-11.83 13.34-23.57 19.85-35.45 1.89-3.49 5.24-7.59 1.67-10.48Zm-22.62-20.94c1.84-2.6 3.89-5.16 5.7-7.84 4.08 8.29 7.11 17.07 10.75 25.56-3.37-1.42-6.9-2.59-10.21-3.89l-12.89-5c1.84-3.12 4.76-6.18 6.65-8.83Zm-35.16 3.27A183.32 183.32 0 0 1 395 101.64q-17-6.81-33.5-14.92 10.79-9.72 22.15-18.83Zm-160 160.23c14.47 2.84 27-.22 36.28-12.28 5.19-6.73 8.26-14.77 12.65-22a77.25 77.25 0 0 1 7.65-10.58 1.54 1.54 0 0 0 1.1-1.11l.07-.19a57.76 57.76 0 0 1 8.89-8c13.67-9.87 35.86-13.18 48.24.79a25.63 25.63 0 0 1 5.76 21.8c-1.85 8.51-8.5 13.47-16 16.93s-15 5.87-21.56 10.94c-6.33 4.93-11.4 11.17-16.43 17.38-10.39 12.82-22.23 25.07-38.36 30.29s-35.72 4-51.34-2.2c-16.44-6.55-27.94-20-34.07-36.33-1.1-2.92-5.58-2.55-4.34.77a81 81 0 0 0 7.37 15c-16.48 14.71-44 14-59.4-2 2.24-26.64 10.24-53.15 21.8-76.71a67 67 0 0 1 38 14.59c-2.53.43-1.64 5 .92 5.11 13.33.77 22 10.34 29.81 20.09 6.52 7.99 12.31 15.59 22.98 17.71ZM109.74 253c17.29 15.45 45.19 16.11 62.84.73.78 1.06 1.59 2.1 2.44 3.11-17.54 16.5-47.5 17.36-65.47 1 .04-1.63.1-3.24.19-4.84Zm-4.91 18.81c-13.48-3.32-29.52-9.64-39.09-20.15-5.69-6.25-4.74-14.08-2.83-21.66 1.92-7.78 4.2-15.49 6.32-23.22q6.24-22.89 12.5-45.77c2-7.13 3.3-15.36 8-21.3a21 21 0 0 1 18.14-7.71 1.08 1.08 0 0 0 .18 0 77.91 77.91 0 0 0 25.66 31 2.56 2.56 0 0 0 1 .47 2.3 2.3 0 0 0 1.48.43c20.7-1.5 39.79 10.17 51 27a34.91 34.91 0 0 0-9.43-4.52 3 3 0 0 0-.55-.71 72.19 72.19 0 0 0-42.91-20c.54-2.36-3-5.18-4.35-2.51C112.94 196 103.11 234.68 105.3 272a2.64 2.64 0 0 0-.47-.2ZM261.39 325c4.86 25.71 3.07 51.87 3 77.87a326.49 326.49 0 0 0 2.18 41.82c.53 4.17.75 10.22 5.74 11.59 5.66 1.54 14.57-5.48 18.58 1.72 3.55 6.37-12.41 11-16.39 12.74-7.13 3.11-14.36 6.46-21.94 8.32-6.45 1.58-13.34 2-19.6-.58-8.58-3.54-11.09-11.2-12.18-19.76-1.64-13-3-25.93-6.12-38.65s-7.8-24.77-12.41-36.89a3 3 0 0 0-2-1.85q.82-2.76 1.52-5.59c5.37-22.32 3.6-46.55-8-66.66-1.69-2.93-5.47-.86-3.78 2.09 19.32 33.57 9 76.83-13.77 106a235.93 235.93 0 0 1-17.31 20.19c-5.79 5.89-12 11.53-16.66 18.41s-5.57 13.67-6.69 21.78c-.61 4.42-1.77 9.32-6.14 11.47-5 2.48-10.49-.75-14.38-3.93-8-6.55-13.59-16.41-19.62-24.69-3.49-4.8-9.93-10.8-7.1-17.15 2.19-4.92 6.15-9.53 9.5-13.72 11.78-14.78 25.57-28.22 36-44 9.39-14.2 5.7-30.75-1.26-45.21-4.14-8.58-9.32-16.63-13.2-25.33a109.5 109.5 0 0 1-7.72-26.21 159.2 159.2 0 0 1-2.16-25.19c20 15.69 50.39 15 69.1-2.78a59.41 59.41 0 0 0 11.42 9.01c13.52 8.2 29.63 10.89 45.26 10.36a65.21 65.21 0 0 0 12.85-1.7c4.61 15.41 10.3 30.75 13.28 46.52Zm7.28-53.35a3.08 3.08 0 0 0-.71-1.46 77.61 77.61 0 0 0 10.61-7.87c14-12.3 22.62-30.6 39.95-38.87 7.69-3.68 16.23-5.94 22.72-11.73a25.28 25.28 0 0 0 8.14-18.46c.36-15.56-10.57-28.48-25.48-32-13.9-3.26-27.61 1.28-38.48 9.74q18.43-50.1 39.5-99.16a467.14 467.14 0 0 0 70 34.88c-13.68 18.34-22.41 40-28.21 62a275.68 275.68 0 0 0-8.81 76.62 228.32 228.32 0 0 0 4 37.62c-29.85 3-60 4.16-89.63 9.29q-1.84-10.25-3.6-20.57ZM420.76 149c-1.42 8.8-7.81 17.28-14.35 23.12-3.53 3.16-8.58 5.82-13.42 4-5.49-2.06-4.67-8.64-3.44-13.16 2.53-9.31 7.46-18.28 12.91-26.17a2.15 2.15 0 0 0 .29-.68c2.28-3.6 8.61-4.58 12.24-2.83 5.83 2.72 6.68 10.01 5.77 15.72Zm-5.18-20.23c-5.84-2.73-12.93-2.1-17 4.3a2.07 2.07 0 0 0-.23.56A104.53 104.53 0 0 0 387.86 153c-2.3 5.66-4.77 12.16-3.47 18.37a13.25 13.25 0 0 0 4.54 7.68c-9.66 19.83-17.45 42.12-9 63.51-5.9 2.13-11.48 5-17.42 7a270.19 270.19 0 0 1 1.1-35.78c2.36-24.78 7.78-49.56 17.59-72.5a146.11 146.11 0 0 1 19.48-33.45 3 3 0 0 0-.65-4 189.62 189.62 0 0 0-10.86-34c2.77 1.1 5.57 1.92 7 2.51 9.58 3.91 19.26 7.56 28.88 11.34 3.77 1.48 7.56 2.94 11.27 4.56.28.12.8.44 1.35.75-3.1 4.74-5.51 10.2-8.28 15.12q-6.91 12.26-13.81 24.61Z"
			className="cls-4"
		/>
		<Path
			d="M207.22 103.81a41.8 41.8 0 0 0 .62-16c-.28-1.73-1.38-3.59-3.3-3.81a2.64 2.64 0 0 0-2.82 3 36.53 36.53 0 0 1-.53 14.28c-.8 3.72 5.05 6.96 6.03 2.53ZM257 107.27a86.24 86.24 0 0 0 1.14-17.58c-.16-3.93-6.3-5.46-6.11-.77A77.51 77.51 0 0 1 251 104.8c-.66 3.65 5.24 6.95 6 2.47Z"
			className="cls-4"
		/>
	</Svg>
);
export default SvgComponent;
