// @ts-nocheck
import * as React from 'react';
import Svg, { G, Path } from 'react-native-svg';
const SvgComponent = (props) => (
	<Svg
		xmlns="http://www.w3.org/2000/svg"
		width={163.839}
		height={163.839}
		fillRule="evenodd"
		clipRule="evenodd"
		imageRendering="optimizeQuality"
		shapeRendering="geometricPrecision"
		textRendering="geometricPrecision"
		viewBox="0 0 4335 4335"
		{...props}
	>
		<G fill="#fcfcfc">
			<Path d="M1713 3595c13 21-13 16 28 16l79-7c26 69 94 207 54 293-99 212-687 201-776-10-16-3-16 12-44-42-126-243 132-497 395-363 92 47 98 114 221 114l40-14c11-36 33-60 50-95 108-226 165-533 452-530 177 2 248 125 309 258 29 64 56 131 84 195 57 134 67 111 102 174 131 13 95-24 165-52 66-113 306-120 403-35 112 98 133 280 19 387-3 24-13 32-43 37-110 182-693 146-735-57-17-83 28-223 68-268l74 7c28-4 14 7 23-8-165-181-170-613-486-611-166 1-243 126-296 251-35 82-119 318-186 358zm-124-919c-12 28-35 42-63 61-253 173-458 183-592 253-341 178-229 775-8 1014 184 199 497 216 759 169 281-50 263-131 321-170l-14-70-23-105c1-1 4-3 5-4s4-3 5-4l28-27c-54 4-57 16-76-28-23-53-64-191-60-245l61-18c1-174-30-188 90-193-8-50-27-50-29-104 21-35 57-68 108-70 47-2 60 52 96 75 11-10 16-14 29-23l1 3c30-60 71-82 140-29 66 52 14 78 10 153 127-26 83 65 87 174 74 20 78 64 49 100-13 81-28 141-61 200l-64 1 41 30c-4 63-27 98-27 159 51 196 444 216 669 192 295-31 411-155 510-376 107-239 134-470 1-702-105-182-536-187-587-298-87 1-371-255-453-329-64-58-157-111-237-146-19-8-10-4-32-10l-26-8-111 4c-56 26-107 34-162 66-49 29-89 63-131 100-47 41-201 187-255 203zM871 1182c58-9 203-46 252-39 8-5-2-2 20-8 8-2 22-4 31-5 83-18 239-36 328-30 72-37 579-29 700-29h136c66 0 362-5 397 18 52-8 310 18 374 27 32 2 127 9 144 21 68-9 213 39 296 44l-2-53c-40-398-75-672-365-821-280-144-645-183-1011-175-350 7-733 40-995 191-267 154-329 459-340 851l36 8z" />
			<Path d="M1127 2220c-28 16-27 13-64 15-34 25-109 35-149 114-34 68-10 149 16 209l198 336 237-119c3-13 138-113 153-125 55-48 95-89 143-144l138-149c31-36 106-120 154-141 33-41 109-89 182-105 94-20 172 13 235 51 61 37 276 230 296 284 17 10 69 66 86 83 30 30 60 58 89 87 59 61 125 105 191 158 80 23 145 91 242 109 34-143 310-404 177-573-40-51-114-66-188-91-741-247-853-880-1447-411-148 117-461 364-689 413z" />
			<Path d="M2343 1408c4-23-18-10 21-26 44-18 524 26 567 30l229 13c45 1 198-4 238 21 86 54-56 383-88 435-103 169-233 55-346-18-108-69-220-142-336-206-62-34-114-64-176-95-70-35-128-51-128-145l20-10zM969 1532c-13-68 4-92 70-95 55-3 113-5 168-7 143-6 688-57 773-54 35 1 73 1 70 37 71 41-65 124-97 141-60 31-115 59-171 91-114 65-214 136-322 204-110 69-260 198-351 78-60-80-127-264-139-394zm-152-163-9 8c-3 3-6 5-9 8-23 26-16 35-15 106 1 50 1 101 1 151-1 97-4 205-11 302-10 122-45 296 7 404 16 33 54 69 58 97 11 7 12 6 26 12 0-32 7-59 7-83 0-42-15-29-30-70l-7-13c-13 5-9 5-5-8-55-50-8-213 0-286 9-80-10-233 27-292 51 174 12 420 240 488 62-3 249-96 303-128 234-139 316-234 496-349 386-246 567-12 863 194 95 66 419 290 570 274 18-18 25-28 56-27 16-39 40-49 62-85 44-72 68-267 82-352 1 2 2 5 3 6l39 366c11 50 33 171-10 189-14 44-33 46-39 73-5 22 5 68 7 95 17-9 21-11 35-18 1-38 35-58 52-95 45-98 7-271 3-382-7-177 9-395-19-564-157-21-696-124-795-123-151 7-349-16-510-18-308-4-715 10-1019 52-87 12-394 75-456 67z" />
		</G>
		<Path
			fill="#2a2a2a"
			d="M3603 3060c-9-5-27-17-39-27-17-14-18-23-34-37-26-22-54-28-74-59 66 22 112 62 161 90-5 18-7 23-14 33zm-125-157c9-28 14-34 34-52l164 91-34 62c-50-19-133-66-164-100zm52-84c13-23 27-55 47-72 47 19 122 57 156 92-6 28-22 47-39 72-35-5-133-70-163-91zm171 506c-10-16-77-217-75-228l330-578c72 24 109 128 93 223-24 145-186 383-278 503-43 56-39 70-70 81zm-72-678c58 8 130 63 164 95-11 25-25 50-40 70l-157-94 33-72zm142-54c31 21 53 26 77 47-9 38-13 43-36 64-45-17-126-65-153-96l34-57c32 10 54 26 79 43zm-39-122c48 10 129 66 160 89l-25 47-157-85zm183 58c-35-7-57-24-86-41-34-21-60-32-73-55l15-33c36 9 68 32 96 50 50 33 58 25 48 79zm-2821-335c2 2 6 4 8 5 70 49 1-21 25 20 228-48 540-295 689-413 594-469 706 164 1447 411 75 25 148 40 188 91 134 169-143 430-177 573-97-18-162-86-242-109l-9 27-28-5c50 111 482 116 587 298 133 231 106 463-1 702-99 221-214 345-510 376-226 24-619 4-669-192l-68-3 5 59c21 102 215 192 333 216 260 52 630 52 832-150 14-14 17-23 32-40 82-92 151-238 188-370 52-181-8-238 83-332 23-23 44-52 64-79 58-78 171-277 233-325 108-83 170-287 136-401-21-70-35-126-91-188l-152-126-10 2c-13 2-17-2-33 10l-34 7c13 25 104 83 130 111 36 37 66 86 83 148 31 120-10 326-89 360 27-150 144-268-155-450l-139-91c17 28 10 11-3 22-8 80-114 238-153 300-29 46-60 90-89 134-28 42-57 101-91 133l-94-32c9-123 204-352 256-453l-15-10c-14 7-18 9-35 18-1-27-11-73-7-95 6-28 26-29 39-73-11 3-6 1-16 5l-11 9c-22-46-103-34-198-76l-7-35c-151 16-475-208-570-274-297-206-478-440-863-194-180 115-262 210-496 349-54 32-241 126-303 128z"
		/>
		<Path
			fill="#262626"
			d="m752 1117 69 51c5 9-9 1 9 18 13 12 0 7 17 6 23-1 11 0 24-10l-36-8c12-392 74-698 340-851 262-151 644-184 995-191 366-8 730 32 1011 175 290 149 325 423 365 821 61 23 26 3 83-17 0-403-114-743-377-883-296-158-647-198-986-198-443 0-829 46-1135 200-296 150-334 466-370 738-6 44-10 106-10 149z"
		/>
		<Path
			fill="#272727"
			d="M780 3072c-20-43 10-48 52-72 29-16 66-41 98-52-9 11-3 6-14 16l-30 19c-78 50-45 62-107 89zm-63-112c31-38 109-80 162-100 22 18 23 25 31 52-32 30-119 85-166 102l-28-54zm-68-115c39-18 127-83 167-85 22 25 34 41 41 73l-167 94-41-81zm-55-93c20-29 117-90 165-96l33 75c-54 22-110 70-167 86l-32-66zm247-446c15 41 30 28 30 70 0 24-7 51-7 83-14-6-15-5-26-12 10 43 6 16-6 26 49 103 229 308 240 431-22 13-52 21-79 26-32 5-38-14-50-32-44-63-196-335-234-359l-6 15 25 63c-32 31-108 81-161 97l-27-65c22-16 23-9 39-30-27-3-10 16-19-20-36 16-26 25-53 8l-26-5c27 96 144 272 196 356 44 71 102 134 84 177-65 157-28 78-69 203-45-25-121-139-153-186-36-53-92-158-131-200l-37 27c-12 6-27 11-40 15 17 71 179 300 249 373 42 44 53 71 54 154 1 240 161 556 361 675 55 33 77 42 144 63 100 33 254 41 373 28 142-16 202-6 349-66 58-24 84-37 127-81l97-121-1-54c-51-1-70 2-75 55l-1-15c-58 39-40 119-321 170-262 47-576 29-759-169-221-239-333-836 8-1014 134-70 339-80 592-253 28-19 50-34 63-61-109 30-71 13-84 43-14 33-38 21-77 40-17 9-84 89-63 16l-237 119-198-336c-26-59-50-141-16-209 40-79 114-89 149-114-13-9-20-13-38-8-12 3-15 8-25 17-76 70-52 5-101 50-22 20-18 32-60 12z"
		/>
		<Path
			fill="#222"
			d="M633 2441c-16 21-96 69-125 84-26 14-28 20-39-1-22-40 116-110 149-115zm-288 448c-74-37-212-347 38-553 160-132 141-83 306-55-14 43-33 40-65 65-34 27-33 35-70 58-105 66-235 132-249 261-12 102 28 144 40 225zm364-642c-109-2-135-1-152-106-12-78-17-163-18-242 0-225 26-271 60-463l144-1c19 142-3 674-35 812zm-380 744c13-4 28-9 40-15l37-27c4-54-123-223-51-346 18-31 45-67 77-74 30 31 20 43 46 71l26 5-10-39c39-24 107-75 159-91l22 54-118 68c9 37-9 17 19 20 22-10 45-20 65-32 22-13 35-26 60-33l6-15c2-40-50-108-66-153 20-27 49-46 79-69 43 49 50 118 110 157 12-10 16 16 6-26-3-28-42-64-58-97-52-108-17-282-7-404 8-97 10-205 11-302 0-50 0-101-1-151-1-71-8-80 15-106 3-3 6-5 9-8l9-8c-45-10-74-36-112-50 0 90-36 43-100 48-99 8-102 35-129 206-39 258-23 103-84 162-15 14-21 49-22 75-4 98 41 85 80 103 0 99 24 188 24 287-95 8-282 187-322 332-47 172 54 428 178 457z"
		/>
		<Path
			fill="#151515"
			d="m1503 1100 15 18 69-13c10 54 18 65 35 107-64 8-6-26-55-21-24 2-8 6-32 39-33 46-49 29-96 8-7 7-15 17-26 23-43 23-25 5-32 1 13-30-7-1 22-14l-17-42c-34 11-16 13-24 38-14 44-58 13-112 28-21 6-23 21-33-12 16-19 16-13 42-27l36-28c-30-20-43-28-77-10l-12-20c-8-12-1-1-10-14-22-30-12 7-20-32-9 1-23 3-31 5-22 6-12 3-20 8l28 6c-7 48-27 6-60 60-3 5-5 10-9 16l-38-11-9 28-21-25c-15 14-19 9-21 34 2 2 8 4 10 5 1 1 4 2 5 3 25 14-16-11 10 5 12 8 8 2 16 14-23 27-7 4-78 13-89 12-32 33-103 44l17-52c-42 14-24 9-62-6l-9 47-14-33c0-1-14-33-14-34-10-16-28-23-41-44-28 13-18 7-20 47-2 36-2 30-7 59 38 14 67 40 112 50 62 8 369-55 456-67 304-42 711-56 1019-52 162 2 359 24 510 18 22-24 55-6 112-5 125 2 224 37 303 2 34 43 32 19 61 21 35 3 20 16 42-5 0-42 11-24-21-33 35 3 24 7 62 6-9-26-5-20-36-28l23-18c-90 2-76-50-158-13-90 41 18 41-75 41 0-2 2-6 2-4 0 0 14-11 12-61 25 13 12 12 40 24 21-19 7-11 30-22 2-29 7-21-18-30l74-5c-17-12-112-19-144-21-8 18-27 19-36 27l28 27c1-1 3 3 5 4-35 17-32-4-26 48-24 5-33 6-44 26-18 35 14-12-4 11-66-23-85-5-105-37-22 34-7 20-31 26l-12 4c-52 12-116 2-139-55-9 12-19 24-28 36-36-6-34 1-49-23l-18 27c-17-4-33-8-56-5 4-47 25-45-8-81-15-17-30-29-48-48 22-5 14 1 29-13 31 49 77 56 97 45-12-33-12-4-45-32l116-13c-34-23-331-18-397-18l34 21c33 10 20 1 54-4l68 3c-119 90-135 49-221 90-14 7-5 4-15 10-2 1-3 2-5 3s-4 2-5 3c-5 2-25 6-32 8-52 13-55 34-122 0-40-20-10-8-34-35-33 13-60 19-75 33-18 17 10 11-22 18-39-32-8-14-25-66 71-12 65-41 73-66 89-2 166 14 193-17-121 0-628-8-700 29zM2871 3534c-71 28-34 65-165 52-13 23-8 4-9 36h-40c-17-6-44 0-58 13-16 14-3 21-20 51l43 11c-47 45-73 55 1 89 9-9 6 10 13-41 42-7 43-8 69-29 9 18 11 16 22 33-12 41-39 103-81 124-1 0-3 2-4 2s-3 1-4 1h-4c-2 0-15-7-24-9 11 29 37 35 64 51 14-24-3-13 29-21l-5-41 53-2c12 47 7 18-13 52 0 0-1 2-1 3 7 4 25 17 57-6 21-15 19-26 24-57l-42-21c-8-58 20 26-1-16-10-20-14 21-11-22 2-1 6-4 7-2l13-2c36 4 38 36 39 59 20-2 43-2 64 12 0 0 33-11 6 60-30-34-4-35-56-46l-42 79c33-3 19-10 47 9 8-46-7-42 35-27-13 30-11 6-13 45 71-4 47-10 68-19l11-1h6s2-1 3-1c88-38 17-8 101-23l-51-67 70-9c8-19 4-13 0-40 62-3 2 7 48-30l42 17c-11 31-1 13-25 38-33 35-50 57-58 116 67-10 114-8 137-35l7-9s17-14 18-15v3s-12 8 11 27c29-5 39-13 43-37l11-33c-16-14-10-15-33-20-36-8-22 13-37-36-16-4 5-4-11 4-28 13 16 7-6 4-24-34-10-32-7-48l2-16c2-11 0-8 7-21 16-25 47-37 70-58 24 14 11 23 38 20 19-2 23-8 21-28-2-17-14-20-19-34-1-2-4-18-5-19-8-20-2-6-9-15-69-98-62-9-125-91-25 19-14 17-54 24-36 6-95 38-116 33s-24-21-36-37c-106 1-42 22-113 19zM1097 3888l61-5c0 51-4 23 10 30 2 1 36 3 46 2l4 36c45 4 35 6 56 32l12 13c21-17 7-5 12-17l4-15c24 25 7 3 0 49 51-12 16-15 56-42l-3 44c16-2 0 2 14-9 9-7 2-7 21-18l42 37c2-5 1-32 14-46 66 1 15 4 64 31 8-14 4 8 4-15 0-4-3-23-4-28l36 9c-1-36-8-23 12-35 36 31 10-3 72 6l-16-55-44-3-9-39-56 7c-7-17-8-35-6-51 1-5 3-39 4-43 26-11 30-7 48-24-12-5-21 2-45 5 5-25 8-14 1-43-24 31-70 41-40 82-55-25-23 15-56-40l-9 11c-21 28-12 27-33 43l-13-62c-1 0-3 2-4 2l-18 9h-4c-16 0 20 3-9-1-89-12 18 20-42-78 27-19 6-17 32-20 16-2 16 7 52 4-10-27-31-64-32-100 32-18-15 12 20-6 27-14 23-35 60-14-18 22-14 12-9 48 25 16 49 7 80 36 52 48-7 17 60 37 42-23 13-15 50-20l66-27c2-1 5-1 6-5 1-3 4-3 6-5-123 0-129-67-221-114-262-134-521 119-395 363 28 54 28 40 44 42z"
		/>
		<Path
			fill="#232323"
			d="M3651 1433c129-31 142 16 158 87 35 152 57 540-4 682-12 28-40 23-120 39-34-82-67-733-34-808zm-334-152c-22 21-7 8-42 5-29-2-27 21-61-21-78 36-178 0-303-2-57-1-90-19-112 5 99-1 639 101 795 123 28 170 12 387 19 564 4 111 43 283-3 382-17 37-50 57-52 95l15 10c42-20 54-94 94-129 30 16 43 43 76 47 14-11 20 7 3-22-10-32-31-21-47-57 28-18 73-19 105-29 54-18 70-4 112 8l34-7c17-12 21-7 33-10l10-2c-23-31-54-38-89-56l32-287c68 0 73-20 72-88 0-24-1-58-9-71-13-22-32-17-63-24-21-90-29-188-49-262-36-135-90-68-214-97 0-45 5-91-8-123-56 29-55 28-52 61l-41-10-10 39c-89-11-133 15-176-15l-9-8c-1-1-3-2-5-3-43-21-18 19-58-18z"
		/>
		<Path
			fill="#1b1b1b"
			d="M3186 1936c42-72 51-30 111-210 21-63 44-213 69-256 47 19 25 76 15 125-22 102-80 332-195 341zm-27-510c8 20 8 24 8 54 31 8 32 10 51 35l-23 16c-1 1-4 2-6 3 31 11 24 9 38 25-21 7-22 10-36 25-2-1-4-5-5-4-9 20-8-6-10-7-13-6 1-7-20-3-14 2-35 17-42 23-38 36-10 44 6 74-56-33 8 27-92-20 19-36 12-5 41-33-48-33-37-11-59-28-11 12-11 4-17 35l41 28-59 78c-14 11-11 2-31 13 12 37 15-5 6 44-35-12-32-20-65-26-60-12-53-20-117-59-30-18-40-15-68-28-14-33-1-15-23-41-18-22-18-16-28-46-106 19-29-4-95-23-37-11-14 5-46-3-14-3-27-13-43-19-56-20-52-3-85-50-16-23-43-48-40-80l-20 10c0 94 58 110 128 145 62 31 115 61 176 95 116 64 228 137 336 206 113 72 243 186 346 18 32-51 173-381 88-435-40-25-192-20-238-21z"
		/>
		<Path
			fill="#fcfcfc"
			d="M3701 3326c31-10 27-25 70-81 92-120 254-358 278-503 16-94-21-198-93-223l-330 578c-2 11 65 213 75 228z"
		/>
		<Path
			fill="#121212"
			d="m2227 3191-1-3 18 77-49-1-8-35c-25 11-6 11-38 4l3-32-54-12c6 49 19 15 11 58-12 60 11 24-9 55l-5-12c-14-34 4-9-14-35l-36 23c11 25 13 10 15 28 4 62 11 84-20 102 0 0-5-15 26 12-23 92-7 25-15 93l-34 19c-2 1-4 3-6 5 17 17 11 34 11 61l38 11c-17 25-26 39-19 72l29 17c28-9 23-19 66-31l-36 24c11 27-9 11 23 21-35 3-13 0-31 9l-25 15c-35 17-4-13-51-2 21 34 97 67 95 110 28 23 23 41 46 64 19-8 4 1 17-16 16-20 21-40 56-49-7 51-21 79 47 54l21 32 17-47c25-7 9-4 39 2 0-35 5-44-24-57 31-27 11-17 35-48l-83-64c26-52 15-4 57-72 3 11 0 7 5 20 9 22 2 9 12 20l48-24c22-8 8 2 21-10-43-33-12-17-76-15 16-30-12-9 1-71-6-6-2-4-16-9l-18-28c-37-5-20 15-67-6-53-25-11 4-67-7l1-85-82-3c-21-4-26 12-30-34 46-3 29 39 72 1 36-32-8-33 51-49l-9 51 66-11s-2 25 11 40c7-12 11-16 20-28 7-10 16 8 12-29-1-11-6-30-35-41-3-43 6-87 18-127l32-4-24-28c-22 9-26 12-58 23z"
		/>
		<Path
			fill="#fcfcfc"
			d="M407 2950c38 42 95 147 131 200 32 47 108 161 153 186 41-125 4-46 69-203 18-43-40-106-84-177-52-84-169-260-196-356-26-28-16-40-46-71-32 7-59 43-77 74-72 124 55 293 51 346zM710 2248c32-138 54-670 35-812l-144 1c-34 192-61 238-60 463 0 79 5 164 18 242 16 105 43 104 152 106z"
		/>
		<Path
			fill="#191919"
			d="M1358 1604c-17 12-10 5-24 26-40 62-28 52-22 76 26-9 1-13 32-21 15 21 17 16 23 45l-54-3c-21 40-16 32 5 65l-65-12c6-43 11-28-13-63-16 11-21 12-30 35-24-49 7-39-44-52-33 55 12 52 28 79-10 19-13 18-29 31-29 25-8 19-30 19 11 48 37 70 55 109-80-22-107-104-140-188-28-72-63-177-57-266-2 2-4 4-4 5-1 1-3 4-4 6l-3 6c-1 2-1 5-2 7-1 5 0 18 0 24-7 7 11 19-14 0 12 130 79 313 139 394 90 120 241-9 351-78 108-68 208-138 322-204 56-32 112-60 171-91 32-17 168-100 97-141-11 26-11 15-16 46-23-9-15-13-42-8-9 16-31 44-25 71-41 4-83 31-101 49-21-27 0-4-28-14-15-5-16-5-30-11-8 29-1 14-28 28-20-8-2 0-16-16-5-6-18-38-54-16 5 25 16 19 30 33-18 16-32 34-48 47-23-10-17-13-43-24l-34 95c-1-2-2-5-2-7l-8-20c-29 19-10 13-27 16l-27-20c41-44 28-79 52-102l-63-10-20 75-49 8c9-21 21-36 32-53l-57 6-14-33c-9 14-13 20-19 30 9 13 13 21 24 33 12 13 12 10 22 22-20 27-13 35-29 60-30-29-33-23-31-71-29-4-37 0-41-22z"
		/>
		<Path
			fill="#fcfcfc"
			d="M3651 1433c-33 75 0 726 34 808 80-16 108-11 120-39 61-142 39-530 4-682-16-71-29-119-158-87z"
		/>
		<Path
			fill="#111"
			d="M1206 1430c-34 47-3 54 8 95 39-10 6-16 64-16 7 61 4-13 32 47 12 25-12 1 14 25l27 18c2 1 4 3 6 4 4 21 12 18 41 22-2 48 1 42 31 71 16-25 9-34 29-60-10-13-10-9-22-22-11-13-15-21-24-33 6-10 10-16 19-30l14 33 57-6c-11 17-22 32-32 53l49-8 20-75 63 10c-24 23-11 58-52 102l27 20c18-3-2 3 27-16l8 20c1 2 2 4 2 7l34-95c27 11 20 14 43 24 16-12 29-31 48-47-15-14-26-8-30-33 36-22 49 10 54 16 14 16-4 8 16 16 27-14 20 1 28-28 14 6 15 6 30 11 28 10 7-13 28 14 18-18 59-45 101-49-6-27 16-54 25-71 27-5 19-1 42 8 5-31 5-20 16-46 3-36-35-36-70-37-85-2-631 48-773 54z"
		/>
		<Path
			fill="#121212"
			d="M2343 1408c-3 32 24 57 40 80 34 47 29 30 85 50 17 6 30 16 43 19 32 8 10-8 46 3 66 19-12 43 95 23 44 1 29-10 29-10 8-37-32 12 1-32 36 22-1 24 53 25l-16 88c33-15 28-25 45-29l6 40c8 19 26 36 47 43l18-20 4-4c2-2 7-6 9-7 22-21 17-12 19-49 13 10-13 16 32 3-3-56 6 20 25-102 10-62 54-79-4-97 1-1 9-17 11-19-43-4-523-48-567-30-39 16-17 3-21 26z"
		/>
		<Path
			fill="#1a1a1a"
			d="M3250 3923c-23-19-11-27-11-27 0-1 1-2 0-3-1 0-18 15-18 15l-7 9c-23 27-70 25-137 35 8-58 25-80 58-116 24-26 14-7 25-38l-42-17c-46 37 14 27-48 30 4 27 8 22 0 40l-70 9 51 67c-85 14-13-15-101 23-1 0-2 1-3 1h-6l-11 1c-21 8 3 15-68 19 2-39 0-15 13-45-42-15-27-19-35 27-28-19-14-12-47-9l42-79c52 11 26 13 56 46 27-72-5-60-6-60-21-14-45-14-64-12-1-24-3-55-39-59l-13 2c-1-2-5 1-7 2-3 43 1 2 11 22 21 42-7-42 1 16l42 21c-6 31-3 42-24 57-33 23-50 11-57 6 0-1 1-2 1-3 20-33 26-5 13-52l-53 2 5 41c-32 8-15-3-29 21-27-16-53-22-64-51 10 3 23 9 24 9h4c1 0 3-1 4-1s3-2 4-2c42-21 69-83 81-124-11-17-13-15-22-33-26 20-27 22-69 29-7 52-4 33-13 41-75-35-48-44-1-89l-43-11c17-31 4-37 20-51 14-13 41-19 58-13v-15l-74-7c-40 45-85 185-68 268 42 203 625 238 735 57z"
		/>
		<Path
			fill="#151515"
			d="M1953 2216c3 33 25 79 43 95 49 7 44-8 71-16 39-13 57-8 69 13l111-4c54-14 29 5 74 2 38-3 14-18 53-13 14 2 83 38 99 45 20 34-10-33 3 13 6 21 11 23 37 50 33 34 43 26 78 3 46 64 18 25 55 53l-35 12c19 25 4 30 34 19 20-7 18-23 21-42-21-54-235-247-296-284-63-38-141-71-235-51-74 16-149 64-182 105z"
		/>
		<Path
			fill="#191919"
			d="m1740 3611 30 21c31 20 52 23 54 54 3 39-20 19-1 51 14 23 12 3 24 44-28 20-35 7-53 10-48 9-7 12-29 49-18 30-27-9-28-18-4-26 14-27-29-36 9-41 27-17 8-76-25 14-11 17-35 23-29-31-23-36-42-63-26 10-38 8-42 46v8c-2 53-72 37-32 98 27-51 5-40 80-56l-20 53c-10 28 0 10-25 32 43 5 36-3 38-42 29 13 16 10 46-7-5 40 0 43 8 83-16 17-23 17-39 31l40 10c-8 24 3 4-17 15l-48 30c-28 23-23-8-50 14-8-32-8-15-20-42-20 12-13-1-12 35l-36-9c1 5 4 24 4 28 0 23 4 1-4 15-49-27 2-30-64-31-13 14-12 41-14 46l-42-37c-18 11-11 11-21 18-14 11 2 6-14 9l3-44c-39 27-5 30-56 42 7-46 24-24 0-49l-4 15c-6 12 9 0-12 17l-12-13c-21-26-11-28-56-32l-4-36c-10 1-44-1-46-2-14-7-10 21-10-30l-61 5c89 210 677 222 776 10 40-86-28-225-54-293l-79 7z"
		/>
		<Path
			fill="#fcfcfc"
			d="M3576 2442c-52 102-247 331-256 453l94 32c33-32 63-91 91-133 29-44 60-88 89-134 38-62 144-219 153-300-33-3-46-30-76-47-39 34-51 108-94 129zM708 2538c38 24 189 296 234 359 12 18 18 37 50 32 27-4 58-13 79-26-11-123-191-327-240-431-60-39-67-107-110-157-29 23-59 42-79 69 16 45 68 112 66 153z"
		/>
		<Path
			fill="#191919"
			d="m2109 3846-8 31c-18-9-21-10-30-36l-14 51c-8 27 15 26 34 46-41-2-43-14-72-35l-13 16c-10 12-5 6-13 14l14 70 1 15c5-53 24-56 75-55l1 54c30 4 38-1 65-5 35-4 39-4 64-2 55 5 81 24 127 25l-5-59 68 3c0-62 23-97 27-159l-41-30 64-1c33-59 49-118 61-200-62 19-44 38-45 56v5l-2 8c-35-15-6-5-19-27-24-41-39-7-61-81l-54 6c14 5 10 3 16 9-12 62 15 41-1 71 64-2 33-18 76 15-13 12 0 2-21 10l-48 24c-10-12-3 1-12-20-5-12-2-8-5-20-41 67-31 20-57 72l83 64c-24 31-3 21-35 48 29 13 23 22 24 57-30-6-14-9-39-2l-17 47-21-32c-68 25-53-3-47-54-35 9-40 29-56 49-13 16 2 8-17 16-23-22-18-41-46-64z"
		/>
		<Path
			fill="#121212"
			d="M968 1533c25 19 7 7 14 0 0-5-1-19 0-24 1-2 1-5 2-7l3-6c1-2 3-4 4-6s3-4 4-5l29-10c32 65 59 323 113 355 21 0 0 7 30-19 16-14 19-12 29-31-16-27-61-24-28-79 51 13 20 3 44 52 9-23 13-25 30-35 24 35 18 19 13 63l65 12c-21-32-26-24-5-65l54 3c-6-29-8-24-23-45-31 8-5 12-32 21-6-24-19-14 22-76 14-21 7-14 24-26-2-2-5-3-6-4l-27-18c-26-24-2 0-14-25-28-60-26 14-32-47-57 0-25 5-64 16-11-41-42-48-8-95-55 2-113 5-168 7-66 3-83 27-70 95z"
		/>
		<Path
			fill="#151515"
			d="M2652 1584c10 30 10 24 28 46 22 26 9 8 23 41 27 13 38 9 68 28 64 39 57 47 117 59 33 7 30 14 65 26 9-49 6-7-6-44 21-11 18-2 31-13l59-78-41-28c6-30 6-22 17-35 22 17 10-5 59 28-29 28-22-3-41 33 100 47 36-14 92 20-16-30-44-39-6-74 7-6 28-21 42-23 21-3 7-3 20 3 2 1 0 26 10 7 1-2 3 3 5 4 14-15 15-18 36-25-14-17-8-14-38-25 2-1 5-2 6-3l23-16c-19-25-19-27-51-35 0-30 0-34-8-54l-229-13c-1 2-10 18-11 19 58 18 14 35 4 97-20 122-28 47-25 102-45 13-19 7-32-3-2 37 3 28-19 49-2 2-7 6-9 7l-4 4-18 20c-21-7-40-23-47-43l-6-40c-18 4-13 14-45 29l16-88c-54-1-17-3-53-25-32 44 7-5-1 32 0 0 16 12-29 10zM2332 3556l54-6c22 75 37 40 61 81 12 21-16 11 19 27l2-8v-5c1-17-17-37 45-56 29-36 25-80-49-100-4-109 40-201-87-174-48-22-25-39-19-86-34-12-22-18-50-33l-32 4c-12 40-22 84-18 127 29 11 34 30 35 41 4 37-5 19-12 29-9 13-13 17-20 28-13-14-11-40-11-40l-66 11 9-51c-58 16-15 17-51 49-43 38-26-4-72-1 3 47 9 30 30 34l82 3-1 85c56 10 14-18 67 7 47 22 29 2 67 6l18 28z"
		/>
		<Path
			fill="#fcfcfc"
			d="M345 2890c-12-80-51-122-40-225 15-129 144-195 249-261 37-23 36-31 70-58 32-25 51-22 65-65-165-28-146-77-306 55-250 206-112 517-38 553zM3749 2339l139 91c300 182 182 300 155 450 80-34 120-240 89-360-16-63-47-111-83-148-26-27-118-86-130-111-42-12-58-25-112-8-32 10-78 11-105 29 16 36 37 25 47 57z"
		/>
		<Path
			fill="#1b1b1b"
			d="M1366 2775c-22 73 45-8 63-16 39-20 63-7 77-40 13-30-25-13 84-43 54-16 209-162 255-203 42-37 82-71 131-100 54-32 106-40 162-66-13-20-31-25-69-13-27 9-22 23-71 16-19-16-41-62-43-95-48 20-123 105-154 141l-138 149c-48 55-89 96-143 144-14 13-150 112-153 125z"
		/>
		<Path
			fill="#0f0f0f"
			d="M3109 1116c-64-9-322-35-374-27l-116 13c33 28 33-1 45 32-20 11-66 3-97-45-16 14-7 9-29 13 18 19 32 31 48 48 32 36 12 34 8 81 23-2 39 1 56 5l18-27c16 24 14 17 49 23 9-12 19-24 28-36 23 58 86 67 139 55l12-4c24-6 9 7 31-26 20 33 39 14 105 37 18-23-14 24 4-11 11-21 19-21 44-26-6-52-9-30 26-48-2-1-4-5-5-4l-28-27c9-8 28-9 36-27z"
		/>
		<Path
			fill="#151515"
			d="m1932 3503-61 18c-5 55 37 193 60 245 19 44 22 32 76 28l-28 27c-1 1-4 3-5 4s-3 2-5 4l23 105c9-8 3-2 13-14l13-16c28 21 30 33 72 35-19-20-42-19-34-46l14-51c9 25 12 27 30 36l8-31c2-43-74-76-95-110 46-10 16 19 51 2l25-15c19-8-4-5 31-9-32-11-12 5-23-21l36-24c-44 12-38 22-66 31l-29-17c-7-33 2-47 19-72l-38-11c0-27 6-44-11-61 2-2 4-3 6-5l34-19c7-68-8-2 15-93-30-27-25-12-26-12-13 6-18 3-24 23l-6 56c-14-16-29-16-55-20l-21 33z"
		/>
		<Path
			fill="#121212"
			d="M1669 3598c-2 2-5 2-6 5s-4 4-6 5l-66 27c-37 5-8-3-50 20v23h-32c-11 13-2 14-4 26 7 29 4 18-1 43 25-3 33-11 45-5-18 17-22 13-48 24-1 4-3 37-4 43-2 15 0 33 6 51l56-7 9 39 44 3 16 55c-62-9-36 25-72-6 12 27 13 10 20 42 26-21 22 9 50-14l48-30c21-12 9 9 17-15l-40-10c15-13 23-14 39-31-8-40-13-43-8-83-30 17-16 20-46 7-2 39 5 47-38 42 25-22 15-4 25-32l20-53c-74 16-52 5-80 56-41-61 29-45 32-98v-8c4-39 15-36 42-46 20 27 13 32 42 63 25-6 11-8 35-23 19 60 1 35-8 76 43 9 25 10 29 36 1 9 9 48 28 18 22-37-18-40 29-49 18-3 25 10 53-10-12-41-11-21-24-44-19-32 3-12 1-51-2-30-22-34-54-54l-30-21c-40 0-15 4-28-16 7-18 7-4-4-12l-40 14z"
		/>
		<Path
			fill="#111"
			d="m3547 1128 2 53c-83-6-229-53-296-44l-74 5c25 9 20 1 18 30-23 11-9 3-30 22-28-12-15-11-40-24 2 51-11 61-12 61 0-1-2 3-2 4 93 0-15 0 75-41 81-37 68 15 158 13l-23 18c31 8 27 2 36 28-38 1-27-3-62-6 31 10 21-8 21 33 40 37 15-2 58 18 1 1 3 2 5 3l9 8c43 29 88 3 176 15l10-39 41 10c-3-33-3-32 52-61-1-31-7-34-19-57-13-22-18-37-21-66-56 20-22 40-83 17z"
		/>
		<Path
			fill="#1e1e1e"
			d="M828 2285c8-33 15-76 18-114 43 5 55-9 91-17-3 47 7 67-21 93-29-33 15-22-25-36-15 38 0 24-2 49-3 27-9 10-25 40l-30-6 7 13c41 20 37 9 60-12 49-45 26 20 101-50 10-9 12-14 25-17 18-5 25-1 38 8 37-2 36 1 64-15-24-41 46 29-25-20-2-2-5-3-8-5-228-68-188-314-240-488-36 59-18 213-27 292-8 73-55 236 0 286z"
		/>
		<Path
			fill="#222"
			d="m2248 2304 26 8c21 6 13 1 32 10 80 35 173 88 237 146 82 74 366 330 453 329l28 5 9-27c-67-53-132-96-191-158-28-29-58-57-89-87-17-17-70-73-86-83-3 19-1 34-21 42-30 11-15 6-34-19l35-12c-37-28-9 11-55-53-35 23-45 32-78-3-26-27-31-29-37-50-13-46 17 21-3-13-16-7-85-43-99-45-39-5-14 10-53 13-45 4-20-16-74-2z"
		/>
		<Path
			fill="#1e1e1e"
			d="M2871 3534c71 3 7-18 113-19 11 16 15 33 36 37 21 5 80-28 116-33 40-6 29-4 54-24 63 82 57-7 125 91 7 10 1-4 9 15 1 2 4 18 5 19 6 15 18 17 19 34 2 19-2 26-21 28-28 3-14-6-38-20-23 20-54 32-70 58-8 13-5 9-7 21l-2 16c-3 16-17 13 7 48 22 3-21 10 6-4 16-8-5-8 11-4 14 49 1 28 37 36 23 5 17 6 33 20l-11 33c115-107 93-289-19-387-97-85-337-78-403 35z"
		/>
		<Path
			fill="#101010"
			d="M1174 1130c8 40-3 2 20 32 9 13 2 2 10 14l12 20c34-19 47-10 77 10l-36 28c-25 13-26 8-42 27 9 33 12 18 33 12 54-15 98 15 112-28 8-25-10-27 24-38l17 42c-29 13-10-16-22 14 8 4-10 21 32-1 11-6 19-16 26-23 47 21 63 38 96-8 24-33 8-36 32-39 49-5-9 29 55 21-17-41-25-53-35-107l-69 13-15-18c-90-6-245 12-328 30z"
		/>
		<Path
			fill="#0f0f0f"
			d="M2338 1071h-136c-26 31-104 15-193 17-8 26-2 55-73 66 18 52-14 35 25 66 32-7 4-2 22-18 15-15 42-21 75-33 25 27-6 15 34 35 67 34 71 13 122 0 6-2 26-6 32-8 2-1 4-2 5-3 2-1 3-2 5-3 10-5 1-3 15-10 87-41 103 0 221-90l-68-3c-34 5-21 14-54 4l-34-21z"
		/>
		<Path
			fill="#282828"
			d="M1709 3583c11 8 11-7 4 12 67-40 151-275 186-358 53-124 130-249 296-251 316-3 321 430 486 611-10 15 5 4-23 8v15h40c1-32-4-12 9-36-35-63-45-40-102-174-27-65-55-132-84-195-61-132-132-256-309-258-288-3-344 304-452 530-17 35-39 59-50 95z"
		/>
		<Path
			fill="#101010"
			d="M731 1214c13 21 31 28 41 44 0 1 14 33 14 34l14 33 9-47c38 15 20 20 62 6l-17 52c71-11 14-32 103-44 72-9 55 14 78-13-8-13-3-6-16-14-26-16 15 8-10-5-1-1-4-2-5-3-2-1-8-3-10-5 2-26 6-21 21-34l21 25 9-28 38 11c3-6 6-12 9-16 33-54 53-12 60-60l-28-6c-49-7-194 29-252 39-13 10-1 9-24 10-18 1-4 5-17-6-19-16-4-8-9-18l-69-51c0 73-28 43-21 96z"
		/>
		<Path
			fill="#191919"
			d="m1932 3503 21-33c26 3 41 4 55 20l6-56c6-20 11-17 24-23 31-18 25-41 20-102-1-18-4-3-15-28l36-23c18 25 0 1 14 35l5 12c21-31-3 5 9-55 9-42-5-9-11-58l54 12-3 32c32 7 13 7 38-4l8 35 49 1-18-77c-13 9-18 13-29 23-36-22-49-77-96-75-51 2-87 35-108 70 1 53 21 54 29 104-120 4-89 19-90 193z"
		/>
		<Path
			fill="#111"
			d="M1505 3703c2-11-7-13 4-26h32v-23c-67-20-9 11-60-37-31-29-55-20-80-36-5-36-9-26 9-48-37-22-33-1-60 14-34 18 12-12-20 6 1 36 22 72 32 100-36 3-36-6-52-4-25 3-5 1-32 20 60 98-47 65 42 78 29 4-7 2 9 1h4l18-9c1 0 2-2 4-2l13 62c21-16 13-15 33-43l9-11c33 55 1 14 56 40-30-41 16-51 40-82z"
		/>
		<Path
			fill="#1b1b1b"
			d="M3382 2158c-31 0-38 10-56 27l7 35c96 42 176 30 198 76l11-9c9-4 4-2 16-5 43-19 21-139 10-189-2-1-4-3-5-4l-29-24c-48 23-25 32-66 55l-26 13c-34 22-11 15-59 25z"
		/>
		<Path
			fill="#272727"
			d="M3382 2158c48-10 26-3 59-25l26-13c42-23 18-32 66-55l29 24c1 1 4 3 5 4l-39-366c-1-1-2-4-3-6-14 85-39 280-82 352-22 37-46 47-62 85z"
		/>
		<Path
			fill="#fcfcfc"
			d="M3186 1936c115-9 173-240 195-341 11-48 32-106-15-125-26 43-48 193-69 256-60 180-69 138-111 210z"
		/>
		<Path
			fill="#fbfbfb"
			d="M1136 1830c-54-32-81-290-113-355l-29 10c-6 89 29 195 57 266 33 84 60 166 140 188-18-38-45-61-55-109z"
		/>
		<Path d="m649 2845 41 81 167-94c-7-32-19-48-41-73-40 2-128 67-167 85zM3530 2820c30 22 129 86 163 91 18-25 33-44 39-72-34-34-109-72-156-92-19 17-33 49-47 72zM594 2752l32 66c57-17 112-64 167-86l-33-75c-48 6-145 67-165 96zM3597 2720l157 94c15-20 28-45 40-70-34-32-106-88-164-95l-33 72zM577 2618c-16 22-16 14-39 30l27 65c53-16 129-66 161-97l-25-63c-25 7-39 20-60 33-19 12-43 21-65 32zM3660 2608c28 31 108 80 153 96 23-21 27-26 36-64-24-21-45-26-77-47-25-17-47-33-79-43l-34 57zM717 2960l28 54c47-17 133-72 166-102-9-27-9-34-31-52-54 20-131 62-162 100zM3478 2904c31 34 115 81 164 100l34-62-164-91c-20 19-25 24-34 52zM505 2606c27 17 17 7 53-8l118-68-22-54c-51 16-119 67-159 91z" />
		<Path
			fill="#191919"
			d="M2227 3191c32-10 36-14 58-23l24 28c27 14 15 21 50 33-6 47-29 64 19 86 4-74 56-101-10-153-69-54-110-31-140 29z"
		/>
		<Path d="m3712 2522 157 85 25-47c-32-24-112-79-160-89z" />
		<Path
			fill="#131313"
			d="M828 2285c-4 13-7 12 5 8l30 6c16-30 22-13 25-40 3-24-13-10 2-49 39 14-4 3 25 36 28-26 18-45 21-93-35 8-47 23-91 17-3 39-11 81-18 114z"
		/>
		<Path d="m633 2441-15-32c-33 5-171 75-149 115 11 21 13 15 39 1 29-15 110-64 125-84zM3757 2433c13 23 39 34 73 55 28 17 51 34 86 41 10-54 2-46-48-79-28-18-60-41-96-50z" />
		<Path
			fill="#020202"
			d="M3603 3060c7-11 9-16 14-33-49-27-95-67-161-90 20 31 48 36 74 59 16 14 17 23 34 37 12 10 30 23 39 27zM780 3072c61-26 29-39 107-89l30-19c11-10 5-4 14-16-32 11-69 35-98 52-42 24-72 29-52 72z"
		/>
		<G fill="#fcfcfc">
			<Path d="M1713 3595c13 21-13 16 28 16l79-7c26 69 94 207 54 293-99 212-687 201-776-10-16-3-16 12-44-42-126-243 132-497 395-363 92 47 98 114 221 114l40-14c11-36 33-60 50-95 108-226 165-533 452-530 177 2 248 125 309 258 29 64 56 131 84 195 57 134 67 111 102 174 131 13 95-24 165-52 66-113 306-120 403-35 112 98 133 280 19 387-3 24-13 32-43 37-110 182-693 146-735-57-17-83 28-223 68-268l74 7c28-4 14 7 23-8-165-181-170-613-486-611-166 1-243 126-296 251-35 82-119 318-186 358zm-124-919c-12 28-35 42-63 61-253 173-458 183-592 253-341 178-229 775-8 1014 184 199 497 216 759 169 281-50 263-131 321-170l-14-70-23-105c1-1 4-3 5-4s4-3 5-4l28-27c-54 4-57 16-76-28-23-53-64-191-60-245l61-18c1-174-30-188 90-193-8-50-27-50-29-104 21-35 57-68 108-70 47-2 60 52 96 75 11-10 16-14 29-23l1 3c30-60 71-82 140-29 66 52 14 78 10 153 127-26 83 65 87 174 74 20 78 64 49 100-13 81-28 141-61 200l-64 1 41 30c-4 63-27 98-27 159 51 196 444 216 669 192 295-31 411-155 510-376 107-239 134-470 1-702-105-182-536-187-587-298-87 1-371-255-453-329-64-58-157-111-237-146-19-8-10-4-32-10l-26-8-111 4c-56 26-107 34-162 66-49 29-89 63-131 100-47 41-201 187-255 203zM871 1182c58-9 203-46 252-39 8-5-2-2 20-8 8-2 22-4 31-5 83-18 239-36 328-30 72-37 579-29 700-29h136c66 0 362-5 397 18 52-8 310 18 374 27 32 2 127 9 144 21 68-9 213 39 296 44l-2-53c-40-398-75-672-365-821-280-144-645-183-1011-175-350 7-733 40-995 191-267 154-329 459-340 851l36 8z" />
			<Path d="M1127 2220c-28 16-27 13-64 15-34 25-109 35-149 114-34 68-10 149 16 209l198 336 237-119c3-13 138-113 153-125 55-48 95-89 143-144l138-149c31-36 106-120 154-141 33-41 109-89 182-105 94-20 172 13 235 51 61 37 276 230 296 284 17 10 69 66 86 83 30 30 60 58 89 87 59 61 125 105 191 158 80 23 145 91 242 109 34-143 310-404 177-573-40-51-114-66-188-91-741-247-853-880-1447-411-148 117-461 364-689 413z" />
			<Path d="M2343 1408c4-23-18-10 21-26 44-18 524 26 567 30l229 13c45 1 198-4 238 21 86 54-56 383-88 435-103 169-233 55-346-18-108-69-220-142-336-206-62-34-114-64-176-95-70-35-128-51-128-145l20-10zM969 1532c-13-68 4-92 70-95 55-3 113-5 168-7 143-6 688-57 773-54 35 1 73 1 70 37 71 41-65 124-97 141-60 31-115 59-171 91-114 65-214 136-322 204-110 69-260 198-351 78-60-80-127-264-139-394zm-152-163-9 8c-3 3-6 5-9 8-23 26-16 35-15 106 1 50 1 101 1 151-1 97-4 205-11 302-10 122-45 296 7 404 16 33 54 69 58 97 11 7 12 6 26 12 0-32 7-59 7-83 0-42-15-29-30-70l-7-13c-13 5-9 5-5-8-55-50-8-213 0-286 9-80-10-233 27-292 51 174 12 420 240 488 62-3 249-96 303-128 234-139 316-234 496-349 386-246 567-12 863 194 95 66 419 290 570 274 18-18 25-28 56-27 16-39 40-49 62-85 44-72 68-267 82-352 1 2 2 5 3 6l39 366c11 50 33 171-10 189-14 44-33 46-39 73-5 22 5 68 7 95 17-9 21-11 35-18 1-38 35-58 52-95 45-98 7-271 3-382-7-177 9-395-19-564-157-21-696-124-795-123-151 7-349-16-510-18-308-4-715 10-1019 52-87 12-394 75-456 67z" />
		</G>
		<Path
			fill="#2a2a2a"
			d="M3603 3060c-9-5-27-17-39-27-17-14-18-23-34-37-26-22-54-28-74-59 66 22 112 62 161 90-5 18-7 23-14 33zm-125-157c9-28 14-34 34-52l164 91-34 62c-50-19-133-66-164-100zm52-84c13-23 27-55 47-72 47 19 122 57 156 92-6 28-22 47-39 72-35-5-133-70-163-91zm171 506c-10-16-77-217-75-228l330-578c72 24 109 128 93 223-24 145-186 383-278 503-43 56-39 70-70 81zm-72-678c58 8 130 63 164 95-11 25-25 50-40 70l-157-94 33-72zm142-54c31 21 53 26 77 47-9 38-13 43-36 64-45-17-126-65-153-96l34-57c32 10 54 26 79 43zm-39-122c48 10 129 66 160 89l-25 47-157-85zm183 58c-35-7-57-24-86-41-34-21-60-32-73-55l15-33c36 9 68 32 96 50 50 33 58 25 48 79zm-2821-335c2 2 6 4 8 5 70 49 1-21 25 20 228-48 540-295 689-413 594-469 706 164 1447 411 75 25 148 40 188 91 134 169-143 430-177 573-97-18-162-86-242-109l-9 27-28-5c50 111 482 116 587 298 133 231 106 463-1 702-99 221-214 345-510 376-226 24-619 4-669-192l-68-3 5 59c21 102 215 192 333 216 260 52 630 52 832-150 14-14 17-23 32-40 82-92 151-238 188-370 52-181-8-238 83-332 23-23 44-52 64-79 58-78 171-277 233-325 108-83 170-287 136-401-21-70-35-126-91-188l-152-126-10 2c-13 2-17-2-33 10l-34 7c13 25 104 83 130 111 36 37 66 86 83 148 31 120-10 326-89 360 27-150 144-268-155-450l-139-91c17 28 10 11-3 22-8 80-114 238-153 300-29 46-60 90-89 134-28 42-57 101-91 133l-94-32c9-123 204-352 256-453l-15-10c-14 7-18 9-35 18-1-27-11-73-7-95 6-28 26-29 39-73-11 3-6 1-16 5l-11 9c-22-46-103-34-198-76l-7-35c-151 16-475-208-570-274-297-206-478-440-863-194-180 115-262 210-496 349-54 32-241 126-303 128z"
		/>
		<Path
			fill="#262626"
			d="m752 1117 69 51c5 9-9 1 9 18 13 12 0 7 17 6 23-1 11 0 24-10l-36-8c12-392 74-698 340-851 262-151 644-184 995-191 366-8 730 32 1011 175 290 149 325 423 365 821 61 23 26 3 83-17 0-403-114-743-377-883-296-158-647-198-986-198-443 0-829 46-1135 200-296 150-334 466-370 738-6 44-10 106-10 149z"
		/>
		<Path
			fill="#272727"
			d="M780 3072c-20-43 10-48 52-72 29-16 66-41 98-52-9 11-3 6-14 16l-30 19c-78 50-45 62-107 89zm-63-112c31-38 109-80 162-100 22 18 23 25 31 52-32 30-119 85-166 102l-28-54zm-68-115c39-18 127-83 167-85 22 25 34 41 41 73l-167 94-41-81zm-55-93c20-29 117-90 165-96l33 75c-54 22-110 70-167 86l-32-66zm247-446c15 41 30 28 30 70 0 24-7 51-7 83-14-6-15-5-26-12 10 43 6 16-6 26 49 103 229 308 240 431-22 13-52 21-79 26-32 5-38-14-50-32-44-63-196-335-234-359l-6 15 25 63c-32 31-108 81-161 97l-27-65c22-16 23-9 39-30-27-3-10 16-19-20-36 16-26 25-53 8l-26-5c27 96 144 272 196 356 44 71 102 134 84 177-65 157-28 78-69 203-45-25-121-139-153-186-36-53-92-158-131-200l-37 27c-12 6-27 11-40 15 17 71 179 300 249 373 42 44 53 71 54 154 1 240 161 556 361 675 55 33 77 42 144 63 100 33 254 41 373 28 142-16 202-6 349-66 58-24 84-37 127-81l97-121-1-54c-51-1-70 2-75 55l-1-15c-58 39-40 119-321 170-262 47-576 29-759-169-221-239-333-836 8-1014 134-70 339-80 592-253 28-19 50-34 63-61-109 30-71 13-84 43-14 33-38 21-77 40-17 9-84 89-63 16l-237 119-198-336c-26-59-50-141-16-209 40-79 114-89 149-114-13-9-20-13-38-8-12 3-15 8-25 17-76 70-52 5-101 50-22 20-18 32-60 12z"
		/>
		<Path
			fill="#222"
			d="M633 2441c-16 21-96 69-125 84-26 14-28 20-39-1-22-40 116-110 149-115zm-288 448c-74-37-212-347 38-553 160-132 141-83 306-55-14 43-33 40-65 65-34 27-33 35-70 58-105 66-235 132-249 261-12 102 28 144 40 225zm364-642c-109-2-135-1-152-106-12-78-17-163-18-242 0-225 26-271 60-463l144-1c19 142-3 674-35 812zm-380 744c13-4 28-9 40-15l37-27c4-54-123-223-51-346 18-31 45-67 77-74 30 31 20 43 46 71l26 5-10-39c39-24 107-75 159-91l22 54-118 68c9 37-9 17 19 20 22-10 45-20 65-32 22-13 35-26 60-33l6-15c2-40-50-108-66-153 20-27 49-46 79-69 43 49 50 118 110 157 12-10 16 16 6-26-3-28-42-64-58-97-52-108-17-282-7-404 8-97 10-205 11-302 0-50 0-101-1-151-1-71-8-80 15-106 3-3 6-5 9-8l9-8c-45-10-74-36-112-50 0 90-36 43-100 48-99 8-102 35-129 206-39 258-23 103-84 162-15 14-21 49-22 75-4 98 41 85 80 103 0 99 24 188 24 287-95 8-282 187-322 332-47 172 54 428 178 457z"
		/>
		<Path
			fill="#151515"
			d="m1503 1100 15 18 69-13c10 54 18 65 35 107-64 8-6-26-55-21-24 2-8 6-32 39-33 46-49 29-96 8-7 7-15 17-26 23-43 23-25 5-32 1 13-30-7-1 22-14l-17-42c-34 11-16 13-24 38-14 44-58 13-112 28-21 6-23 21-33-12 16-19 16-13 42-27l36-28c-30-20-43-28-77-10l-12-20c-8-12-1-1-10-14-22-30-12 7-20-32-9 1-23 3-31 5-22 6-12 3-20 8l28 6c-7 48-27 6-60 60-3 5-5 10-9 16l-38-11-9 28-21-25c-15 14-19 9-21 34 2 2 8 4 10 5 1 1 4 2 5 3 25 14-16-11 10 5 12 8 8 2 16 14-23 27-7 4-78 13-89 12-32 33-103 44l17-52c-42 14-24 9-62-6l-9 47-14-33c0-1-14-33-14-34-10-16-28-23-41-44-28 13-18 7-20 47-2 36-2 30-7 59 38 14 67 40 112 50 62 8 369-55 456-67 304-42 711-56 1019-52 162 2 359 24 510 18 22-24 55-6 112-5 125 2 224 37 303 2 34 43 32 19 61 21 35 3 20 16 42-5 0-42 11-24-21-33 35 3 24 7 62 6-9-26-5-20-36-28l23-18c-90 2-76-50-158-13-90 41 18 41-75 41 0-2 2-6 2-4 0 0 14-11 12-61 25 13 12 12 40 24 21-19 7-11 30-22 2-29 7-21-18-30l74-5c-17-12-112-19-144-21-8 18-27 19-36 27l28 27c1-1 3 3 5 4-35 17-32-4-26 48-24 5-33 6-44 26-18 35 14-12-4 11-66-23-85-5-105-37-22 34-7 20-31 26l-12 4c-52 12-116 2-139-55-9 12-19 24-28 36-36-6-34 1-49-23l-18 27c-17-4-33-8-56-5 4-47 25-45-8-81-15-17-30-29-48-48 22-5 14 1 29-13 31 49 77 56 97 45-12-33-12-4-45-32l116-13c-34-23-331-18-397-18l34 21c33 10 20 1 54-4l68 3c-119 90-135 49-221 90-14 7-5 4-15 10-2 1-3 2-5 3s-4 2-5 3c-5 2-25 6-32 8-52 13-55 34-122 0-40-20-10-8-34-35-33 13-60 19-75 33-18 17 10 11-22 18-39-32-8-14-25-66 71-12 65-41 73-66 89-2 166 14 193-17-121 0-628-8-700 29zM2871 3534c-71 28-34 65-165 52-13 23-8 4-9 36h-40c-17-6-44 0-58 13-16 14-3 21-20 51l43 11c-47 45-73 55 1 89 9-9 6 10 13-41 42-7 43-8 69-29 9 18 11 16 22 33-12 41-39 103-81 124-1 0-3 2-4 2s-3 1-4 1h-4c-2 0-15-7-24-9 11 29 37 35 64 51 14-24-3-13 29-21l-5-41 53-2c12 47 7 18-13 52 0 0-1 2-1 3 7 4 25 17 57-6 21-15 19-26 24-57l-42-21c-8-58 20 26-1-16-10-20-14 21-11-22 2-1 6-4 7-2l13-2c36 4 38 36 39 59 20-2 43-2 64 12 0 0 33-11 6 60-30-34-4-35-56-46l-42 79c33-3 19-10 47 9 8-46-7-42 35-27-13 30-11 6-13 45 71-4 47-10 68-19l11-1h6s2-1 3-1c88-38 17-8 101-23l-51-67 70-9c8-19 4-13 0-40 62-3 2 7 48-30l42 17c-11 31-1 13-25 38-33 35-50 57-58 116 67-10 114-8 137-35l7-9s17-14 18-15v3s-12 8 11 27c29-5 39-13 43-37l11-33c-16-14-10-15-33-20-36-8-22 13-37-36-16-4 5-4-11 4-28 13 16 7-6 4-24-34-10-32-7-48l2-16c2-11 0-8 7-21 16-25 47-37 70-58 24 14 11 23 38 20 19-2 23-8 21-28-2-17-14-20-19-34-1-2-4-18-5-19-8-20-2-6-9-15-69-98-62-9-125-91-25 19-14 17-54 24-36 6-95 38-116 33s-24-21-36-37c-106 1-42 22-113 19zM1097 3888l61-5c0 51-4 23 10 30 2 1 36 3 46 2l4 36c45 4 35 6 56 32l12 13c21-17 7-5 12-17l4-15c24 25 7 3 0 49 51-12 16-15 56-42l-3 44c16-2 0 2 14-9 9-7 2-7 21-18l42 37c2-5 1-32 14-46 66 1 15 4 64 31 8-14 4 8 4-15 0-4-3-23-4-28l36 9c-1-36-8-23 12-35 36 31 10-3 72 6l-16-55-44-3-9-39-56 7c-7-17-8-35-6-51 1-5 3-39 4-43 26-11 30-7 48-24-12-5-21 2-45 5 5-25 8-14 1-43-24 31-70 41-40 82-55-25-23 15-56-40l-9 11c-21 28-12 27-33 43l-13-62c-1 0-3 2-4 2l-18 9h-4c-16 0 20 3-9-1-89-12 18 20-42-78 27-19 6-17 32-20 16-2 16 7 52 4-10-27-31-64-32-100 32-18-15 12 20-6 27-14 23-35 60-14-18 22-14 12-9 48 25 16 49 7 80 36 52 48-7 17 60 37 42-23 13-15 50-20l66-27c2-1 5-1 6-5 1-3 4-3 6-5-123 0-129-67-221-114-262-134-521 119-395 363 28 54 28 40 44 42z"
		/>
		<Path
			fill="#232323"
			d="M3651 1433c129-31 142 16 158 87 35 152 57 540-4 682-12 28-40 23-120 39-34-82-67-733-34-808zm-334-152c-22 21-7 8-42 5-29-2-27 21-61-21-78 36-178 0-303-2-57-1-90-19-112 5 99-1 639 101 795 123 28 170 12 387 19 564 4 111 43 283-3 382-17 37-50 57-52 95l15 10c42-20 54-94 94-129 30 16 43 43 76 47 14-11 20 7 3-22-10-32-31-21-47-57 28-18 73-19 105-29 54-18 70-4 112 8l34-7c17-12 21-7 33-10l10-2c-23-31-54-38-89-56l32-287c68 0 73-20 72-88 0-24-1-58-9-71-13-22-32-17-63-24-21-90-29-188-49-262-36-135-90-68-214-97 0-45 5-91-8-123-56 29-55 28-52 61l-41-10-10 39c-89-11-133 15-176-15l-9-8c-1-1-3-2-5-3-43-21-18 19-58-18z"
		/>
		<Path
			fill="#1b1b1b"
			d="M3186 1936c42-72 51-30 111-210 21-63 44-213 69-256 47 19 25 76 15 125-22 102-80 332-195 341zm-27-510c8 20 8 24 8 54 31 8 32 10 51 35l-23 16c-1 1-4 2-6 3 31 11 24 9 38 25-21 7-22 10-36 25-2-1-4-5-5-4-9 20-8-6-10-7-13-6 1-7-20-3-14 2-35 17-42 23-38 36-10 44 6 74-56-33 8 27-92-20 19-36 12-5 41-33-48-33-37-11-59-28-11 12-11 4-17 35l41 28-59 78c-14 11-11 2-31 13 12 37 15-5 6 44-35-12-32-20-65-26-60-12-53-20-117-59-30-18-40-15-68-28-14-33-1-15-23-41-18-22-18-16-28-46-106 19-29-4-95-23-37-11-14 5-46-3-14-3-27-13-43-19-56-20-52-3-85-50-16-23-43-48-40-80l-20 10c0 94 58 110 128 145 62 31 115 61 176 95 116 64 228 137 336 206 113 72 243 186 346 18 32-51 173-381 88-435-40-25-192-20-238-21z"
		/>
		<Path
			fill="#fcfcfc"
			d="M3701 3326c31-10 27-25 70-81 92-120 254-358 278-503 16-94-21-198-93-223l-330 578c-2 11 65 213 75 228z"
		/>
		<Path
			fill="#121212"
			d="m2227 3191-1-3 18 77-49-1-8-35c-25 11-6 11-38 4l3-32-54-12c6 49 19 15 11 58-12 60 11 24-9 55l-5-12c-14-34 4-9-14-35l-36 23c11 25 13 10 15 28 4 62 11 84-20 102 0 0-5-15 26 12-23 92-7 25-15 93l-34 19c-2 1-4 3-6 5 17 17 11 34 11 61l38 11c-17 25-26 39-19 72l29 17c28-9 23-19 66-31l-36 24c11 27-9 11 23 21-35 3-13 0-31 9l-25 15c-35 17-4-13-51-2 21 34 97 67 95 110 28 23 23 41 46 64 19-8 4 1 17-16 16-20 21-40 56-49-7 51-21 79 47 54l21 32 17-47c25-7 9-4 39 2 0-35 5-44-24-57 31-27 11-17 35-48l-83-64c26-52 15-4 57-72 3 11 0 7 5 20 9 22 2 9 12 20l48-24c22-8 8 2 21-10-43-33-12-17-76-15 16-30-12-9 1-71-6-6-2-4-16-9l-18-28c-37-5-20 15-67-6-53-25-11 4-67-7l1-85-82-3c-21-4-26 12-30-34 46-3 29 39 72 1 36-32-8-33 51-49l-9 51 66-11s-2 25 11 40c7-12 11-16 20-28 7-10 16 8 12-29-1-11-6-30-35-41-3-43 6-87 18-127l32-4-24-28c-22 9-26 12-58 23z"
		/>
		<Path
			fill="#fcfcfc"
			d="M407 2950c38 42 95 147 131 200 32 47 108 161 153 186 41-125 4-46 69-203 18-43-40-106-84-177-52-84-169-260-196-356-26-28-16-40-46-71-32 7-59 43-77 74-72 124 55 293 51 346zM710 2248c32-138 54-670 35-812l-144 1c-34 192-61 238-60 463 0 79 5 164 18 242 16 105 43 104 152 106z"
		/>
		<Path
			fill="#191919"
			d="M1358 1604c-17 12-10 5-24 26-40 62-28 52-22 76 26-9 1-13 32-21 15 21 17 16 23 45l-54-3c-21 40-16 32 5 65l-65-12c6-43 11-28-13-63-16 11-21 12-30 35-24-49 7-39-44-52-33 55 12 52 28 79-10 19-13 18-29 31-29 25-8 19-30 19 11 48 37 70 55 109-80-22-107-104-140-188-28-72-63-177-57-266-2 2-4 4-4 5-1 1-3 4-4 6l-3 6c-1 2-1 5-2 7-1 5 0 18 0 24-7 7 11 19-14 0 12 130 79 313 139 394 90 120 241-9 351-78 108-68 208-138 322-204 56-32 112-60 171-91 32-17 168-100 97-141-11 26-11 15-16 46-23-9-15-13-42-8-9 16-31 44-25 71-41 4-83 31-101 49-21-27 0-4-28-14-15-5-16-5-30-11-8 29-1 14-28 28-20-8-2 0-16-16-5-6-18-38-54-16 5 25 16 19 30 33-18 16-32 34-48 47-23-10-17-13-43-24l-34 95c-1-2-2-5-2-7l-8-20c-29 19-10 13-27 16l-27-20c41-44 28-79 52-102l-63-10-20 75-49 8c9-21 21-36 32-53l-57 6-14-33c-9 14-13 20-19 30 9 13 13 21 24 33 12 13 12 10 22 22-20 27-13 35-29 60-30-29-33-23-31-71-29-4-37 0-41-22z"
		/>
		<Path
			fill="#fcfcfc"
			d="M3651 1433c-33 75 0 726 34 808 80-16 108-11 120-39 61-142 39-530 4-682-16-71-29-119-158-87z"
		/>
		<Path
			fill="#111"
			d="M1206 1430c-34 47-3 54 8 95 39-10 6-16 64-16 7 61 4-13 32 47 12 25-12 1 14 25l27 18c2 1 4 3 6 4 4 21 12 18 41 22-2 48 1 42 31 71 16-25 9-34 29-60-10-13-10-9-22-22-11-13-15-21-24-33 6-10 10-16 19-30l14 33 57-6c-11 17-22 32-32 53l49-8 20-75 63 10c-24 23-11 58-52 102l27 20c18-3-2 3 27-16l8 20c1 2 2 4 2 7l34-95c27 11 20 14 43 24 16-12 29-31 48-47-15-14-26-8-30-33 36-22 49 10 54 16 14 16-4 8 16 16 27-14 20 1 28-28 14 6 15 6 30 11 28 10 7-13 28 14 18-18 59-45 101-49-6-27 16-54 25-71 27-5 19-1 42 8 5-31 5-20 16-46 3-36-35-36-70-37-85-2-631 48-773 54z"
		/>
		<Path
			fill="#121212"
			d="M2343 1408c-3 32 24 57 40 80 34 47 29 30 85 50 17 6 30 16 43 19 32 8 10-8 46 3 66 19-12 43 95 23 44 1 29-10 29-10 8-37-32 12 1-32 36 22-1 24 53 25l-16 88c33-15 28-25 45-29l6 40c8 19 26 36 47 43l18-20 4-4c2-2 7-6 9-7 22-21 17-12 19-49 13 10-13 16 32 3-3-56 6 20 25-102 10-62 54-79-4-97 1-1 9-17 11-19-43-4-523-48-567-30-39 16-17 3-21 26z"
		/>
		<Path
			fill="#1a1a1a"
			d="M3250 3923c-23-19-11-27-11-27 0-1 1-2 0-3-1 0-18 15-18 15l-7 9c-23 27-70 25-137 35 8-58 25-80 58-116 24-26 14-7 25-38l-42-17c-46 37 14 27-48 30 4 27 8 22 0 40l-70 9 51 67c-85 14-13-15-101 23-1 0-2 1-3 1h-6l-11 1c-21 8 3 15-68 19 2-39 0-15 13-45-42-15-27-19-35 27-28-19-14-12-47-9l42-79c52 11 26 13 56 46 27-72-5-60-6-60-21-14-45-14-64-12-1-24-3-55-39-59l-13 2c-1-2-5 1-7 2-3 43 1 2 11 22 21 42-7-42 1 16l42 21c-6 31-3 42-24 57-33 23-50 11-57 6 0-1 1-2 1-3 20-33 26-5 13-52l-53 2 5 41c-32 8-15-3-29 21-27-16-53-22-64-51 10 3 23 9 24 9h4c1 0 3-1 4-1s3-2 4-2c42-21 69-83 81-124-11-17-13-15-22-33-26 20-27 22-69 29-7 52-4 33-13 41-75-35-48-44-1-89l-43-11c17-31 4-37 20-51 14-13 41-19 58-13v-15l-74-7c-40 45-85 185-68 268 42 203 625 238 735 57z"
		/>
		<Path
			fill="#151515"
			d="M1953 2216c3 33 25 79 43 95 49 7 44-8 71-16 39-13 57-8 69 13l111-4c54-14 29 5 74 2 38-3 14-18 53-13 14 2 83 38 99 45 20 34-10-33 3 13 6 21 11 23 37 50 33 34 43 26 78 3 46 64 18 25 55 53l-35 12c19 25 4 30 34 19 20-7 18-23 21-42-21-54-235-247-296-284-63-38-141-71-235-51-74 16-149 64-182 105z"
		/>
		<Path
			fill="#191919"
			d="m1740 3611 30 21c31 20 52 23 54 54 3 39-20 19-1 51 14 23 12 3 24 44-28 20-35 7-53 10-48 9-7 12-29 49-18 30-27-9-28-18-4-26 14-27-29-36 9-41 27-17 8-76-25 14-11 17-35 23-29-31-23-36-42-63-26 10-38 8-42 46v8c-2 53-72 37-32 98 27-51 5-40 80-56l-20 53c-10 28 0 10-25 32 43 5 36-3 38-42 29 13 16 10 46-7-5 40 0 43 8 83-16 17-23 17-39 31l40 10c-8 24 3 4-17 15l-48 30c-28 23-23-8-50 14-8-32-8-15-20-42-20 12-13-1-12 35l-36-9c1 5 4 24 4 28 0 23 4 1-4 15-49-27 2-30-64-31-13 14-12 41-14 46l-42-37c-18 11-11 11-21 18-14 11 2 6-14 9l3-44c-39 27-5 30-56 42 7-46 24-24 0-49l-4 15c-6 12 9 0-12 17l-12-13c-21-26-11-28-56-32l-4-36c-10 1-44-1-46-2-14-7-10 21-10-30l-61 5c89 210 677 222 776 10 40-86-28-225-54-293l-79 7z"
		/>
		<Path
			fill="#fcfcfc"
			d="M3576 2442c-52 102-247 331-256 453l94 32c33-32 63-91 91-133 29-44 60-88 89-134 38-62 144-219 153-300-33-3-46-30-76-47-39 34-51 108-94 129zM708 2538c38 24 189 296 234 359 12 18 18 37 50 32 27-4 58-13 79-26-11-123-191-327-240-431-60-39-67-107-110-157-29 23-59 42-79 69 16 45 68 112 66 153z"
		/>
		<Path
			fill="#191919"
			d="m2109 3846-8 31c-18-9-21-10-30-36l-14 51c-8 27 15 26 34 46-41-2-43-14-72-35l-13 16c-10 12-5 6-13 14l14 70 1 15c5-53 24-56 75-55l1 54c30 4 38-1 65-5 35-4 39-4 64-2 55 5 81 24 127 25l-5-59 68 3c0-62 23-97 27-159l-41-30 64-1c33-59 49-118 61-200-62 19-44 38-45 56v5l-2 8c-35-15-6-5-19-27-24-41-39-7-61-81l-54 6c14 5 10 3 16 9-12 62 15 41-1 71 64-2 33-18 76 15-13 12 0 2-21 10l-48 24c-10-12-3 1-12-20-5-12-2-8-5-20-41 67-31 20-57 72l83 64c-24 31-3 21-35 48 29 13 23 22 24 57-30-6-14-9-39-2l-17 47-21-32c-68 25-53-3-47-54-35 9-40 29-56 49-13 16 2 8-17 16-23-22-18-41-46-64z"
		/>
		<Path
			fill="#121212"
			d="M968 1533c25 19 7 7 14 0 0-5-1-19 0-24 1-2 1-5 2-7l3-6c1-2 3-4 4-6s3-4 4-5l29-10c32 65 59 323 113 355 21 0 0 7 30-19 16-14 19-12 29-31-16-27-61-24-28-79 51 13 20 3 44 52 9-23 13-25 30-35 24 35 18 19 13 63l65 12c-21-32-26-24-5-65l54 3c-6-29-8-24-23-45-31 8-5 12-32 21-6-24-19-14 22-76 14-21 7-14 24-26-2-2-5-3-6-4l-27-18c-26-24-2 0-14-25-28-60-26 14-32-47-57 0-25 5-64 16-11-41-42-48-8-95-55 2-113 5-168 7-66 3-83 27-70 95z"
		/>
		<Path
			fill="#151515"
			d="M2652 1584c10 30 10 24 28 46 22 26 9 8 23 41 27 13 38 9 68 28 64 39 57 47 117 59 33 7 30 14 65 26 9-49 6-7-6-44 21-11 18-2 31-13l59-78-41-28c6-30 6-22 17-35 22 17 10-5 59 28-29 28-22-3-41 33 100 47 36-14 92 20-16-30-44-39-6-74 7-6 28-21 42-23 21-3 7-3 20 3 2 1 0 26 10 7 1-2 3 3 5 4 14-15 15-18 36-25-14-17-8-14-38-25 2-1 5-2 6-3l23-16c-19-25-19-27-51-35 0-30 0-34-8-54l-229-13c-1 2-10 18-11 19 58 18 14 35 4 97-20 122-28 47-25 102-45 13-19 7-32-3-2 37 3 28-19 49-2 2-7 6-9 7l-4 4-18 20c-21-7-40-23-47-43l-6-40c-18 4-13 14-45 29l16-88c-54-1-17-3-53-25-32 44 7-5-1 32 0 0 16 12-29 10zM2332 3556l54-6c22 75 37 40 61 81 12 21-16 11 19 27l2-8v-5c1-17-17-37 45-56 29-36 25-80-49-100-4-109 40-201-87-174-48-22-25-39-19-86-34-12-22-18-50-33l-32 4c-12 40-22 84-18 127 29 11 34 30 35 41 4 37-5 19-12 29-9 13-13 17-20 28-13-14-11-40-11-40l-66 11 9-51c-58 16-15 17-51 49-43 38-26-4-72-1 3 47 9 30 30 34l82 3-1 85c56 10 14-18 67 7 47 22 29 2 67 6l18 28z"
		/>
		<Path
			fill="#fcfcfc"
			d="M345 2890c-12-80-51-122-40-225 15-129 144-195 249-261 37-23 36-31 70-58 32-25 51-22 65-65-165-28-146-77-306 55-250 206-112 517-38 553zM3749 2339l139 91c300 182 182 300 155 450 80-34 120-240 89-360-16-63-47-111-83-148-26-27-118-86-130-111-42-12-58-25-112-8-32 10-78 11-105 29 16 36 37 25 47 57z"
		/>
		<Path
			fill="#1b1b1b"
			d="M1366 2775c-22 73 45-8 63-16 39-20 63-7 77-40 13-30-25-13 84-43 54-16 209-162 255-203 42-37 82-71 131-100 54-32 106-40 162-66-13-20-31-25-69-13-27 9-22 23-71 16-19-16-41-62-43-95-48 20-123 105-154 141l-138 149c-48 55-89 96-143 144-14 13-150 112-153 125z"
		/>
		<Path
			fill="#0f0f0f"
			d="M3109 1116c-64-9-322-35-374-27l-116 13c33 28 33-1 45 32-20 11-66 3-97-45-16 14-7 9-29 13 18 19 32 31 48 48 32 36 12 34 8 81 23-2 39 1 56 5l18-27c16 24 14 17 49 23 9-12 19-24 28-36 23 58 86 67 139 55l12-4c24-6 9 7 31-26 20 33 39 14 105 37 18-23-14 24 4-11 11-21 19-21 44-26-6-52-9-30 26-48-2-1-4-5-5-4l-28-27c9-8 28-9 36-27z"
		/>
		<Path
			fill="#151515"
			d="m1932 3503-61 18c-5 55 37 193 60 245 19 44 22 32 76 28l-28 27c-1 1-4 3-5 4s-3 2-5 4l23 105c9-8 3-2 13-14l13-16c28 21 30 33 72 35-19-20-42-19-34-46l14-51c9 25 12 27 30 36l8-31c2-43-74-76-95-110 46-10 16 19 51 2l25-15c19-8-4-5 31-9-32-11-12 5-23-21l36-24c-44 12-38 22-66 31l-29-17c-7-33 2-47 19-72l-38-11c0-27 6-44-11-61 2-2 4-3 6-5l34-19c7-68-8-2 15-93-30-27-25-12-26-12-13 6-18 3-24 23l-6 56c-14-16-29-16-55-20l-21 33z"
		/>
		<Path
			fill="#121212"
			d="M1669 3598c-2 2-5 2-6 5s-4 4-6 5l-66 27c-37 5-8-3-50 20v23h-32c-11 13-2 14-4 26 7 29 4 18-1 43 25-3 33-11 45-5-18 17-22 13-48 24-1 4-3 37-4 43-2 15 0 33 6 51l56-7 9 39 44 3 16 55c-62-9-36 25-72-6 12 27 13 10 20 42 26-21 22 9 50-14l48-30c21-12 9 9 17-15l-40-10c15-13 23-14 39-31-8-40-13-43-8-83-30 17-16 20-46 7-2 39 5 47-38 42 25-22 15-4 25-32l20-53c-74 16-52 5-80 56-41-61 29-45 32-98v-8c4-39 15-36 42-46 20 27 13 32 42 63 25-6 11-8 35-23 19 60 1 35-8 76 43 9 25 10 29 36 1 9 9 48 28 18 22-37-18-40 29-49 18-3 25 10 53-10-12-41-11-21-24-44-19-32 3-12 1-51-2-30-22-34-54-54l-30-21c-40 0-15 4-28-16 7-18 7-4-4-12l-40 14z"
		/>
		<Path
			fill="#111"
			d="m3547 1128 2 53c-83-6-229-53-296-44l-74 5c25 9 20 1 18 30-23 11-9 3-30 22-28-12-15-11-40-24 2 51-11 61-12 61 0-1-2 3-2 4 93 0-15 0 75-41 81-37 68 15 158 13l-23 18c31 8 27 2 36 28-38 1-27-3-62-6 31 10 21-8 21 33 40 37 15-2 58 18 1 1 3 2 5 3l9 8c43 29 88 3 176 15l10-39 41 10c-3-33-3-32 52-61-1-31-7-34-19-57-13-22-18-37-21-66-56 20-22 40-83 17z"
		/>
		<Path
			fill="#1e1e1e"
			d="M828 2285c8-33 15-76 18-114 43 5 55-9 91-17-3 47 7 67-21 93-29-33 15-22-25-36-15 38 0 24-2 49-3 27-9 10-25 40l-30-6 7 13c41 20 37 9 60-12 49-45 26 20 101-50 10-9 12-14 25-17 18-5 25-1 38 8 37-2 36 1 64-15-24-41 46 29-25-20-2-2-5-3-8-5-228-68-188-314-240-488-36 59-18 213-27 292-8 73-55 236 0 286z"
		/>
		<Path
			fill="#222"
			d="m2248 2304 26 8c21 6 13 1 32 10 80 35 173 88 237 146 82 74 366 330 453 329l28 5 9-27c-67-53-132-96-191-158-28-29-58-57-89-87-17-17-70-73-86-83-3 19-1 34-21 42-30 11-15 6-34-19l35-12c-37-28-9 11-55-53-35 23-45 32-78-3-26-27-31-29-37-50-13-46 17 21-3-13-16-7-85-43-99-45-39-5-14 10-53 13-45 4-20-16-74-2z"
		/>
		<Path
			fill="#1e1e1e"
			d="M2871 3534c71 3 7-18 113-19 11 16 15 33 36 37 21 5 80-28 116-33 40-6 29-4 54-24 63 82 57-7 125 91 7 10 1-4 9 15 1 2 4 18 5 19 6 15 18 17 19 34 2 19-2 26-21 28-28 3-14-6-38-20-23 20-54 32-70 58-8 13-5 9-7 21l-2 16c-3 16-17 13 7 48 22 3-21 10 6-4 16-8-5-8 11-4 14 49 1 28 37 36 23 5 17 6 33 20l-11 33c115-107 93-289-19-387-97-85-337-78-403 35z"
		/>
		<Path
			fill="#101010"
			d="M1174 1130c8 40-3 2 20 32 9 13 2 2 10 14l12 20c34-19 47-10 77 10l-36 28c-25 13-26 8-42 27 9 33 12 18 33 12 54-15 98 15 112-28 8-25-10-27 24-38l17 42c-29 13-10-16-22 14 8 4-10 21 32-1 11-6 19-16 26-23 47 21 63 38 96-8 24-33 8-36 32-39 49-5-9 29 55 21-17-41-25-53-35-107l-69 13-15-18c-90-6-245 12-328 30z"
		/>
		<Path
			fill="#0f0f0f"
			d="M2338 1071h-136c-26 31-104 15-193 17-8 26-2 55-73 66 18 52-14 35 25 66 32-7 4-2 22-18 15-15 42-21 75-33 25 27-6 15 34 35 67 34 71 13 122 0 6-2 26-6 32-8 2-1 4-2 5-3 2-1 3-2 5-3 10-5 1-3 15-10 87-41 103 0 221-90l-68-3c-34 5-21 14-54 4l-34-21z"
		/>
		<Path
			fill="#282828"
			d="M1709 3583c11 8 11-7 4 12 67-40 151-275 186-358 53-124 130-249 296-251 316-3 321 430 486 611-10 15 5 4-23 8v15h40c1-32-4-12 9-36-35-63-45-40-102-174-27-65-55-132-84-195-61-132-132-256-309-258-288-3-344 304-452 530-17 35-39 59-50 95z"
		/>
		<Path
			fill="#101010"
			d="M731 1214c13 21 31 28 41 44 0 1 14 33 14 34l14 33 9-47c38 15 20 20 62 6l-17 52c71-11 14-32 103-44 72-9 55 14 78-13-8-13-3-6-16-14-26-16 15 8-10-5-1-1-4-2-5-3-2-1-8-3-10-5 2-26 6-21 21-34l21 25 9-28 38 11c3-6 6-12 9-16 33-54 53-12 60-60l-28-6c-49-7-194 29-252 39-13 10-1 9-24 10-18 1-4 5-17-6-19-16-4-8-9-18l-69-51c0 73-28 43-21 96z"
		/>
		<Path
			fill="#191919"
			d="m1932 3503 21-33c26 3 41 4 55 20l6-56c6-20 11-17 24-23 31-18 25-41 20-102-1-18-4-3-15-28l36-23c18 25 0 1 14 35l5 12c21-31-3 5 9-55 9-42-5-9-11-58l54 12-3 32c32 7 13 7 38-4l8 35 49 1-18-77c-13 9-18 13-29 23-36-22-49-77-96-75-51 2-87 35-108 70 1 53 21 54 29 104-120 4-89 19-90 193z"
		/>
		<Path
			fill="#111"
			d="M1505 3703c2-11-7-13 4-26h32v-23c-67-20-9 11-60-37-31-29-55-20-80-36-5-36-9-26 9-48-37-22-33-1-60 14-34 18 12-12-20 6 1 36 22 72 32 100-36 3-36-6-52-4-25 3-5 1-32 20 60 98-47 65 42 78 29 4-7 2 9 1h4l18-9c1 0 2-2 4-2l13 62c21-16 13-15 33-43l9-11c33 55 1 14 56 40-30-41 16-51 40-82z"
		/>
		<Path
			fill="#1b1b1b"
			d="M3382 2158c-31 0-38 10-56 27l7 35c96 42 176 30 198 76l11-9c9-4 4-2 16-5 43-19 21-139 10-189-2-1-4-3-5-4l-29-24c-48 23-25 32-66 55l-26 13c-34 22-11 15-59 25z"
		/>
		<Path
			fill="#272727"
			d="M3382 2158c48-10 26-3 59-25l26-13c42-23 18-32 66-55l29 24c1 1 4 3 5 4l-39-366c-1-1-2-4-3-6-14 85-39 280-82 352-22 37-46 47-62 85z"
		/>
		<Path
			fill="#fcfcfc"
			d="M3186 1936c115-9 173-240 195-341 11-48 32-106-15-125-26 43-48 193-69 256-60 180-69 138-111 210z"
		/>
		<Path
			fill="#fbfbfb"
			d="M1136 1830c-54-32-81-290-113-355l-29 10c-6 89 29 195 57 266 33 84 60 166 140 188-18-38-45-61-55-109z"
		/>
		<Path d="m649 2845 41 81 167-94c-7-32-19-48-41-73-40 2-128 67-167 85zM3530 2820c30 22 129 86 163 91 18-25 33-44 39-72-34-34-109-72-156-92-19 17-33 49-47 72zM594 2752l32 66c57-17 112-64 167-86l-33-75c-48 6-145 67-165 96zM3597 2720l157 94c15-20 28-45 40-70-34-32-106-88-164-95l-33 72zM577 2618c-16 22-16 14-39 30l27 65c53-16 129-66 161-97l-25-63c-25 7-39 20-60 33-19 12-43 21-65 32zM3660 2608c28 31 108 80 153 96 23-21 27-26 36-64-24-21-45-26-77-47-25-17-47-33-79-43l-34 57zM717 2960l28 54c47-17 133-72 166-102-9-27-9-34-31-52-54 20-131 62-162 100zM3478 2904c31 34 115 81 164 100l34-62-164-91c-20 19-25 24-34 52zM505 2606c27 17 17 7 53-8l118-68-22-54c-51 16-119 67-159 91z" />
		<Path
			fill="#191919"
			d="M2227 3191c32-10 36-14 58-23l24 28c27 14 15 21 50 33-6 47-29 64 19 86 4-74 56-101-10-153-69-54-110-31-140 29z"
		/>
		<Path d="m3712 2522 157 85 25-47c-32-24-112-79-160-89z" />
		<Path
			fill="#131313"
			d="M828 2285c-4 13-7 12 5 8l30 6c16-30 22-13 25-40 3-24-13-10 2-49 39 14-4 3 25 36 28-26 18-45 21-93-35 8-47 23-91 17-3 39-11 81-18 114z"
		/>
		<Path d="m633 2441-15-32c-33 5-171 75-149 115 11 21 13 15 39 1 29-15 110-64 125-84zM3757 2433c13 23 39 34 73 55 28 17 51 34 86 41 10-54 2-46-48-79-28-18-60-41-96-50z" />
		<Path
			fill="#020202"
			d="M3603 3060c7-11 9-16 14-33-49-27-95-67-161-90 20 31 48 36 74 59 16 14 17 23 34 37 12 10 30 23 39 27zM780 3072c61-26 29-39 107-89l30-19c11-10 5-4 14-16-32 11-69 35-98 52-42 24-72 29-52 72z"
		/>
		<G fill="#fcfcfc">
			<Path d="M1713 3595c13 21-13 16 28 16l79-7c26 69 94 207 54 293-99 212-687 201-776-10-16-3-16 12-44-42-126-243 132-497 395-363 92 47 98 114 221 114l40-14c11-36 33-60 50-95 108-226 165-533 452-530 177 2 248 125 309 258 29 64 56 131 84 195 57 134 67 111 102 174 131 13 95-24 165-52 66-113 306-120 403-35 112 98 133 280 19 387-3 24-13 32-43 37-110 182-693 146-735-57-17-83 28-223 68-268l74 7c28-4 14 7 23-8-165-181-170-613-486-611-166 1-243 126-296 251-35 82-119 318-186 358zm-124-919c-12 28-35 42-63 61-253 173-458 183-592 253-341 178-229 775-8 1014 184 199 497 216 759 169 281-50 263-131 321-170l-14-70-23-105c1-1 4-3 5-4s4-3 5-4l28-27c-54 4-57 16-76-28-23-53-64-191-60-245l61-18c1-174-30-188 90-193-8-50-27-50-29-104 21-35 57-68 108-70 47-2 60 52 96 75 11-10 16-14 29-23l1 3c30-60 71-82 140-29 66 52 14 78 10 153 127-26 83 65 87 174 74 20 78 64 49 100-13 81-28 141-61 200l-64 1 41 30c-4 63-27 98-27 159 51 196 444 216 669 192 295-31 411-155 510-376 107-239 134-470 1-702-105-182-536-187-587-298-87 1-371-255-453-329-64-58-157-111-237-146-19-8-10-4-32-10l-26-8-111 4c-56 26-107 34-162 66-49 29-89 63-131 100-47 41-201 187-255 203zM871 1182c58-9 203-46 252-39 8-5-2-2 20-8 8-2 22-4 31-5 83-18 239-36 328-30 72-37 579-29 700-29h136c66 0 362-5 397 18 52-8 310 18 374 27 32 2 127 9 144 21 68-9 213 39 296 44l-2-53c-40-398-75-672-365-821-280-144-645-183-1011-175-350 7-733 40-995 191-267 154-329 459-340 851l36 8z" />
			<Path d="M1127 2220c-28 16-27 13-64 15-34 25-109 35-149 114-34 68-10 149 16 209l198 336 237-119c3-13 138-113 153-125 55-48 95-89 143-144l138-149c31-36 106-120 154-141 33-41 109-89 182-105 94-20 172 13 235 51 61 37 276 230 296 284 17 10 69 66 86 83 30 30 60 58 89 87 59 61 125 105 191 158 80 23 145 91 242 109 34-143 310-404 177-573-40-51-114-66-188-91-741-247-853-880-1447-411-148 117-461 364-689 413z" />
			<Path d="M2343 1408c4-23-18-10 21-26 44-18 524 26 567 30l229 13c45 1 198-4 238 21 86 54-56 383-88 435-103 169-233 55-346-18-108-69-220-142-336-206-62-34-114-64-176-95-70-35-128-51-128-145l20-10zM969 1532c-13-68 4-92 70-95 55-3 113-5 168-7 143-6 688-57 773-54 35 1 73 1 70 37 71 41-65 124-97 141-60 31-115 59-171 91-114 65-214 136-322 204-110 69-260 198-351 78-60-80-127-264-139-394zm-152-163-9 8c-3 3-6 5-9 8-23 26-16 35-15 106 1 50 1 101 1 151-1 97-4 205-11 302-10 122-45 296 7 404 16 33 54 69 58 97 11 7 12 6 26 12 0-32 7-59 7-83 0-42-15-29-30-70l-7-13c-13 5-9 5-5-8-55-50-8-213 0-286 9-80-10-233 27-292 51 174 12 420 240 488 62-3 249-96 303-128 234-139 316-234 496-349 386-246 567-12 863 194 95 66 419 290 570 274 18-18 25-28 56-27 16-39 40-49 62-85 44-72 68-267 82-352 1 2 2 5 3 6l39 366c11 50 33 171-10 189-14 44-33 46-39 73-5 22 5 68 7 95 17-9 21-11 35-18 1-38 35-58 52-95 45-98 7-271 3-382-7-177 9-395-19-564-157-21-696-124-795-123-151 7-349-16-510-18-308-4-715 10-1019 52-87 12-394 75-456 67z" />
		</G>
		<Path
			fill="#2a2a2a"
			d="M3603 3060c-9-5-27-17-39-27-17-14-18-23-34-37-26-22-54-28-74-59 66 22 112 62 161 90-5 18-7 23-14 33zm-125-157c9-28 14-34 34-52l164 91-34 62c-50-19-133-66-164-100zm52-84c13-23 27-55 47-72 47 19 122 57 156 92-6 28-22 47-39 72-35-5-133-70-163-91zm171 506c-10-16-77-217-75-228l330-578c72 24 109 128 93 223-24 145-186 383-278 503-43 56-39 70-70 81zm-72-678c58 8 130 63 164 95-11 25-25 50-40 70l-157-94 33-72zm142-54c31 21 53 26 77 47-9 38-13 43-36 64-45-17-126-65-153-96l34-57c32 10 54 26 79 43zm-39-122c48 10 129 66 160 89l-25 47-157-85zm183 58c-35-7-57-24-86-41-34-21-60-32-73-55l15-33c36 9 68 32 96 50 50 33 58 25 48 79zm-2821-335c2 2 6 4 8 5 70 49 1-21 25 20 228-48 540-295 689-413 594-469 706 164 1447 411 75 25 148 40 188 91 134 169-143 430-177 573-97-18-162-86-242-109l-9 27-28-5c50 111 482 116 587 298 133 231 106 463-1 702-99 221-214 345-510 376-226 24-619 4-669-192l-68-3 5 59c21 102 215 192 333 216 260 52 630 52 832-150 14-14 17-23 32-40 82-92 151-238 188-370 52-181-8-238 83-332 23-23 44-52 64-79 58-78 171-277 233-325 108-83 170-287 136-401-21-70-35-126-91-188l-152-126-10 2c-13 2-17-2-33 10l-34 7c13 25 104 83 130 111 36 37 66 86 83 148 31 120-10 326-89 360 27-150 144-268-155-450l-139-91c17 28 10 11-3 22-8 80-114 238-153 300-29 46-60 90-89 134-28 42-57 101-91 133l-94-32c9-123 204-352 256-453l-15-10c-14 7-18 9-35 18-1-27-11-73-7-95 6-28 26-29 39-73-11 3-6 1-16 5l-11 9c-22-46-103-34-198-76l-7-35c-151 16-475-208-570-274-297-206-478-440-863-194-180 115-262 210-496 349-54 32-241 126-303 128z"
		/>
		<Path
			fill="#262626"
			d="m752 1117 69 51c5 9-9 1 9 18 13 12 0 7 17 6 23-1 11 0 24-10l-36-8c12-392 74-698 340-851 262-151 644-184 995-191 366-8 730 32 1011 175 290 149 325 423 365 821 61 23 26 3 83-17 0-403-114-743-377-883-296-158-647-198-986-198-443 0-829 46-1135 200-296 150-334 466-370 738-6 44-10 106-10 149z"
		/>
		<Path
			fill="#272727"
			d="M780 3072c-20-43 10-48 52-72 29-16 66-41 98-52-9 11-3 6-14 16l-30 19c-78 50-45 62-107 89zm-63-112c31-38 109-80 162-100 22 18 23 25 31 52-32 30-119 85-166 102l-28-54zm-68-115c39-18 127-83 167-85 22 25 34 41 41 73l-167 94-41-81zm-55-93c20-29 117-90 165-96l33 75c-54 22-110 70-167 86l-32-66zm247-446c15 41 30 28 30 70 0 24-7 51-7 83-14-6-15-5-26-12 10 43 6 16-6 26 49 103 229 308 240 431-22 13-52 21-79 26-32 5-38-14-50-32-44-63-196-335-234-359l-6 15 25 63c-32 31-108 81-161 97l-27-65c22-16 23-9 39-30-27-3-10 16-19-20-36 16-26 25-53 8l-26-5c27 96 144 272 196 356 44 71 102 134 84 177-65 157-28 78-69 203-45-25-121-139-153-186-36-53-92-158-131-200l-37 27c-12 6-27 11-40 15 17 71 179 300 249 373 42 44 53 71 54 154 1 240 161 556 361 675 55 33 77 42 144 63 100 33 254 41 373 28 142-16 202-6 349-66 58-24 84-37 127-81l97-121-1-54c-51-1-70 2-75 55l-1-15c-58 39-40 119-321 170-262 47-576 29-759-169-221-239-333-836 8-1014 134-70 339-80 592-253 28-19 50-34 63-61-109 30-71 13-84 43-14 33-38 21-77 40-17 9-84 89-63 16l-237 119-198-336c-26-59-50-141-16-209 40-79 114-89 149-114-13-9-20-13-38-8-12 3-15 8-25 17-76 70-52 5-101 50-22 20-18 32-60 12z"
		/>
		<Path
			fill="#222"
			d="M633 2441c-16 21-96 69-125 84-26 14-28 20-39-1-22-40 116-110 149-115zm-288 448c-74-37-212-347 38-553 160-132 141-83 306-55-14 43-33 40-65 65-34 27-33 35-70 58-105 66-235 132-249 261-12 102 28 144 40 225zm364-642c-109-2-135-1-152-106-12-78-17-163-18-242 0-225 26-271 60-463l144-1c19 142-3 674-35 812zm-380 744c13-4 28-9 40-15l37-27c4-54-123-223-51-346 18-31 45-67 77-74 30 31 20 43 46 71l26 5-10-39c39-24 107-75 159-91l22 54-118 68c9 37-9 17 19 20 22-10 45-20 65-32 22-13 35-26 60-33l6-15c2-40-50-108-66-153 20-27 49-46 79-69 43 49 50 118 110 157 12-10 16 16 6-26-3-28-42-64-58-97-52-108-17-282-7-404 8-97 10-205 11-302 0-50 0-101-1-151-1-71-8-80 15-106 3-3 6-5 9-8l9-8c-45-10-74-36-112-50 0 90-36 43-100 48-99 8-102 35-129 206-39 258-23 103-84 162-15 14-21 49-22 75-4 98 41 85 80 103 0 99 24 188 24 287-95 8-282 187-322 332-47 172 54 428 178 457z"
		/>
		<Path
			fill="#151515"
			d="m1503 1100 15 18 69-13c10 54 18 65 35 107-64 8-6-26-55-21-24 2-8 6-32 39-33 46-49 29-96 8-7 7-15 17-26 23-43 23-25 5-32 1 13-30-7-1 22-14l-17-42c-34 11-16 13-24 38-14 44-58 13-112 28-21 6-23 21-33-12 16-19 16-13 42-27l36-28c-30-20-43-28-77-10l-12-20c-8-12-1-1-10-14-22-30-12 7-20-32-9 1-23 3-31 5-22 6-12 3-20 8l28 6c-7 48-27 6-60 60-3 5-5 10-9 16l-38-11-9 28-21-25c-15 14-19 9-21 34 2 2 8 4 10 5 1 1 4 2 5 3 25 14-16-11 10 5 12 8 8 2 16 14-23 27-7 4-78 13-89 12-32 33-103 44l17-52c-42 14-24 9-62-6l-9 47-14-33c0-1-14-33-14-34-10-16-28-23-41-44-28 13-18 7-20 47-2 36-2 30-7 59 38 14 67 40 112 50 62 8 369-55 456-67 304-42 711-56 1019-52 162 2 359 24 510 18 22-24 55-6 112-5 125 2 224 37 303 2 34 43 32 19 61 21 35 3 20 16 42-5 0-42 11-24-21-33 35 3 24 7 62 6-9-26-5-20-36-28l23-18c-90 2-76-50-158-13-90 41 18 41-75 41 0-2 2-6 2-4 0 0 14-11 12-61 25 13 12 12 40 24 21-19 7-11 30-22 2-29 7-21-18-30l74-5c-17-12-112-19-144-21-8 18-27 19-36 27l28 27c1-1 3 3 5 4-35 17-32-4-26 48-24 5-33 6-44 26-18 35 14-12-4 11-66-23-85-5-105-37-22 34-7 20-31 26l-12 4c-52 12-116 2-139-55-9 12-19 24-28 36-36-6-34 1-49-23l-18 27c-17-4-33-8-56-5 4-47 25-45-8-81-15-17-30-29-48-48 22-5 14 1 29-13 31 49 77 56 97 45-12-33-12-4-45-32l116-13c-34-23-331-18-397-18l34 21c33 10 20 1 54-4l68 3c-119 90-135 49-221 90-14 7-5 4-15 10-2 1-3 2-5 3s-4 2-5 3c-5 2-25 6-32 8-52 13-55 34-122 0-40-20-10-8-34-35-33 13-60 19-75 33-18 17 10 11-22 18-39-32-8-14-25-66 71-12 65-41 73-66 89-2 166 14 193-17-121 0-628-8-700 29zM2871 3534c-71 28-34 65-165 52-13 23-8 4-9 36h-40c-17-6-44 0-58 13-16 14-3 21-20 51l43 11c-47 45-73 55 1 89 9-9 6 10 13-41 42-7 43-8 69-29 9 18 11 16 22 33-12 41-39 103-81 124-1 0-3 2-4 2s-3 1-4 1h-4c-2 0-15-7-24-9 11 29 37 35 64 51 14-24-3-13 29-21l-5-41 53-2c12 47 7 18-13 52 0 0-1 2-1 3 7 4 25 17 57-6 21-15 19-26 24-57l-42-21c-8-58 20 26-1-16-10-20-14 21-11-22 2-1 6-4 7-2l13-2c36 4 38 36 39 59 20-2 43-2 64 12 0 0 33-11 6 60-30-34-4-35-56-46l-42 79c33-3 19-10 47 9 8-46-7-42 35-27-13 30-11 6-13 45 71-4 47-10 68-19l11-1h6s2-1 3-1c88-38 17-8 101-23l-51-67 70-9c8-19 4-13 0-40 62-3 2 7 48-30l42 17c-11 31-1 13-25 38-33 35-50 57-58 116 67-10 114-8 137-35l7-9s17-14 18-15v3s-12 8 11 27c29-5 39-13 43-37l11-33c-16-14-10-15-33-20-36-8-22 13-37-36-16-4 5-4-11 4-28 13 16 7-6 4-24-34-10-32-7-48l2-16c2-11 0-8 7-21 16-25 47-37 70-58 24 14 11 23 38 20 19-2 23-8 21-28-2-17-14-20-19-34-1-2-4-18-5-19-8-20-2-6-9-15-69-98-62-9-125-91-25 19-14 17-54 24-36 6-95 38-116 33s-24-21-36-37c-106 1-42 22-113 19zM1097 3888l61-5c0 51-4 23 10 30 2 1 36 3 46 2l4 36c45 4 35 6 56 32l12 13c21-17 7-5 12-17l4-15c24 25 7 3 0 49 51-12 16-15 56-42l-3 44c16-2 0 2 14-9 9-7 2-7 21-18l42 37c2-5 1-32 14-46 66 1 15 4 64 31 8-14 4 8 4-15 0-4-3-23-4-28l36 9c-1-36-8-23 12-35 36 31 10-3 72 6l-16-55-44-3-9-39-56 7c-7-17-8-35-6-51 1-5 3-39 4-43 26-11 30-7 48-24-12-5-21 2-45 5 5-25 8-14 1-43-24 31-70 41-40 82-55-25-23 15-56-40l-9 11c-21 28-12 27-33 43l-13-62c-1 0-3 2-4 2l-18 9h-4c-16 0 20 3-9-1-89-12 18 20-42-78 27-19 6-17 32-20 16-2 16 7 52 4-10-27-31-64-32-100 32-18-15 12 20-6 27-14 23-35 60-14-18 22-14 12-9 48 25 16 49 7 80 36 52 48-7 17 60 37 42-23 13-15 50-20l66-27c2-1 5-1 6-5 1-3 4-3 6-5-123 0-129-67-221-114-262-134-521 119-395 363 28 54 28 40 44 42z"
		/>
		<Path
			fill="#232323"
			d="M3651 1433c129-31 142 16 158 87 35 152 57 540-4 682-12 28-40 23-120 39-34-82-67-733-34-808zm-334-152c-22 21-7 8-42 5-29-2-27 21-61-21-78 36-178 0-303-2-57-1-90-19-112 5 99-1 639 101 795 123 28 170 12 387 19 564 4 111 43 283-3 382-17 37-50 57-52 95l15 10c42-20 54-94 94-129 30 16 43 43 76 47 14-11 20 7 3-22-10-32-31-21-47-57 28-18 73-19 105-29 54-18 70-4 112 8l34-7c17-12 21-7 33-10l10-2c-23-31-54-38-89-56l32-287c68 0 73-20 72-88 0-24-1-58-9-71-13-22-32-17-63-24-21-90-29-188-49-262-36-135-90-68-214-97 0-45 5-91-8-123-56 29-55 28-52 61l-41-10-10 39c-89-11-133 15-176-15l-9-8c-1-1-3-2-5-3-43-21-18 19-58-18z"
		/>
		<Path
			fill="#1b1b1b"
			d="M3186 1936c42-72 51-30 111-210 21-63 44-213 69-256 47 19 25 76 15 125-22 102-80 332-195 341zm-27-510c8 20 8 24 8 54 31 8 32 10 51 35l-23 16c-1 1-4 2-6 3 31 11 24 9 38 25-21 7-22 10-36 25-2-1-4-5-5-4-9 20-8-6-10-7-13-6 1-7-20-3-14 2-35 17-42 23-38 36-10 44 6 74-56-33 8 27-92-20 19-36 12-5 41-33-48-33-37-11-59-28-11 12-11 4-17 35l41 28-59 78c-14 11-11 2-31 13 12 37 15-5 6 44-35-12-32-20-65-26-60-12-53-20-117-59-30-18-40-15-68-28-14-33-1-15-23-41-18-22-18-16-28-46-106 19-29-4-95-23-37-11-14 5-46-3-14-3-27-13-43-19-56-20-52-3-85-50-16-23-43-48-40-80l-20 10c0 94 58 110 128 145 62 31 115 61 176 95 116 64 228 137 336 206 113 72 243 186 346 18 32-51 173-381 88-435-40-25-192-20-238-21z"
		/>
		<Path
			fill="#fcfcfc"
			d="M3701 3326c31-10 27-25 70-81 92-120 254-358 278-503 16-94-21-198-93-223l-330 578c-2 11 65 213 75 228z"
		/>
		<Path
			fill="#121212"
			d="m2227 3191-1-3 18 77-49-1-8-35c-25 11-6 11-38 4l3-32-54-12c6 49 19 15 11 58-12 60 11 24-9 55l-5-12c-14-34 4-9-14-35l-36 23c11 25 13 10 15 28 4 62 11 84-20 102 0 0-5-15 26 12-23 92-7 25-15 93l-34 19c-2 1-4 3-6 5 17 17 11 34 11 61l38 11c-17 25-26 39-19 72l29 17c28-9 23-19 66-31l-36 24c11 27-9 11 23 21-35 3-13 0-31 9l-25 15c-35 17-4-13-51-2 21 34 97 67 95 110 28 23 23 41 46 64 19-8 4 1 17-16 16-20 21-40 56-49-7 51-21 79 47 54l21 32 17-47c25-7 9-4 39 2 0-35 5-44-24-57 31-27 11-17 35-48l-83-64c26-52 15-4 57-72 3 11 0 7 5 20 9 22 2 9 12 20l48-24c22-8 8 2 21-10-43-33-12-17-76-15 16-30-12-9 1-71-6-6-2-4-16-9l-18-28c-37-5-20 15-67-6-53-25-11 4-67-7l1-85-82-3c-21-4-26 12-30-34 46-3 29 39 72 1 36-32-8-33 51-49l-9 51 66-11s-2 25 11 40c7-12 11-16 20-28 7-10 16 8 12-29-1-11-6-30-35-41-3-43 6-87 18-127l32-4-24-28c-22 9-26 12-58 23z"
		/>
		<Path
			fill="#fcfcfc"
			d="M407 2950c38 42 95 147 131 200 32 47 108 161 153 186 41-125 4-46 69-203 18-43-40-106-84-177-52-84-169-260-196-356-26-28-16-40-46-71-32 7-59 43-77 74-72 124 55 293 51 346zM710 2248c32-138 54-670 35-812l-144 1c-34 192-61 238-60 463 0 79 5 164 18 242 16 105 43 104 152 106z"
		/>
		<Path
			fill="#191919"
			d="M1358 1604c-17 12-10 5-24 26-40 62-28 52-22 76 26-9 1-13 32-21 15 21 17 16 23 45l-54-3c-21 40-16 32 5 65l-65-12c6-43 11-28-13-63-16 11-21 12-30 35-24-49 7-39-44-52-33 55 12 52 28 79-10 19-13 18-29 31-29 25-8 19-30 19 11 48 37 70 55 109-80-22-107-104-140-188-28-72-63-177-57-266-2 2-4 4-4 5-1 1-3 4-4 6l-3 6c-1 2-1 5-2 7-1 5 0 18 0 24-7 7 11 19-14 0 12 130 79 313 139 394 90 120 241-9 351-78 108-68 208-138 322-204 56-32 112-60 171-91 32-17 168-100 97-141-11 26-11 15-16 46-23-9-15-13-42-8-9 16-31 44-25 71-41 4-83 31-101 49-21-27 0-4-28-14-15-5-16-5-30-11-8 29-1 14-28 28-20-8-2 0-16-16-5-6-18-38-54-16 5 25 16 19 30 33-18 16-32 34-48 47-23-10-17-13-43-24l-34 95c-1-2-2-5-2-7l-8-20c-29 19-10 13-27 16l-27-20c41-44 28-79 52-102l-63-10-20 75-49 8c9-21 21-36 32-53l-57 6-14-33c-9 14-13 20-19 30 9 13 13 21 24 33 12 13 12 10 22 22-20 27-13 35-29 60-30-29-33-23-31-71-29-4-37 0-41-22z"
		/>
		<Path
			fill="#fcfcfc"
			d="M3651 1433c-33 75 0 726 34 808 80-16 108-11 120-39 61-142 39-530 4-682-16-71-29-119-158-87z"
		/>
		<Path
			fill="#111"
			d="M1206 1430c-34 47-3 54 8 95 39-10 6-16 64-16 7 61 4-13 32 47 12 25-12 1 14 25l27 18c2 1 4 3 6 4 4 21 12 18 41 22-2 48 1 42 31 71 16-25 9-34 29-60-10-13-10-9-22-22-11-13-15-21-24-33 6-10 10-16 19-30l14 33 57-6c-11 17-22 32-32 53l49-8 20-75 63 10c-24 23-11 58-52 102l27 20c18-3-2 3 27-16l8 20c1 2 2 4 2 7l34-95c27 11 20 14 43 24 16-12 29-31 48-47-15-14-26-8-30-33 36-22 49 10 54 16 14 16-4 8 16 16 27-14 20 1 28-28 14 6 15 6 30 11 28 10 7-13 28 14 18-18 59-45 101-49-6-27 16-54 25-71 27-5 19-1 42 8 5-31 5-20 16-46 3-36-35-36-70-37-85-2-631 48-773 54z"
		/>
		<Path
			fill="#121212"
			d="M2343 1408c-3 32 24 57 40 80 34 47 29 30 85 50 17 6 30 16 43 19 32 8 10-8 46 3 66 19-12 43 95 23 44 1 29-10 29-10 8-37-32 12 1-32 36 22-1 24 53 25l-16 88c33-15 28-25 45-29l6 40c8 19 26 36 47 43l18-20 4-4c2-2 7-6 9-7 22-21 17-12 19-49 13 10-13 16 32 3-3-56 6 20 25-102 10-62 54-79-4-97 1-1 9-17 11-19-43-4-523-48-567-30-39 16-17 3-21 26z"
		/>
		<Path
			fill="#1a1a1a"
			d="M3250 3923c-23-19-11-27-11-27 0-1 1-2 0-3-1 0-18 15-18 15l-7 9c-23 27-70 25-137 35 8-58 25-80 58-116 24-26 14-7 25-38l-42-17c-46 37 14 27-48 30 4 27 8 22 0 40l-70 9 51 67c-85 14-13-15-101 23-1 0-2 1-3 1h-6l-11 1c-21 8 3 15-68 19 2-39 0-15 13-45-42-15-27-19-35 27-28-19-14-12-47-9l42-79c52 11 26 13 56 46 27-72-5-60-6-60-21-14-45-14-64-12-1-24-3-55-39-59l-13 2c-1-2-5 1-7 2-3 43 1 2 11 22 21 42-7-42 1 16l42 21c-6 31-3 42-24 57-33 23-50 11-57 6 0-1 1-2 1-3 20-33 26-5 13-52l-53 2 5 41c-32 8-15-3-29 21-27-16-53-22-64-51 10 3 23 9 24 9h4c1 0 3-1 4-1s3-2 4-2c42-21 69-83 81-124-11-17-13-15-22-33-26 20-27 22-69 29-7 52-4 33-13 41-75-35-48-44-1-89l-43-11c17-31 4-37 20-51 14-13 41-19 58-13v-15l-74-7c-40 45-85 185-68 268 42 203 625 238 735 57z"
		/>
		<Path
			fill="#151515"
			d="M1953 2216c3 33 25 79 43 95 49 7 44-8 71-16 39-13 57-8 69 13l111-4c54-14 29 5 74 2 38-3 14-18 53-13 14 2 83 38 99 45 20 34-10-33 3 13 6 21 11 23 37 50 33 34 43 26 78 3 46 64 18 25 55 53l-35 12c19 25 4 30 34 19 20-7 18-23 21-42-21-54-235-247-296-284-63-38-141-71-235-51-74 16-149 64-182 105z"
		/>
		<Path
			fill="#191919"
			d="m1740 3611 30 21c31 20 52 23 54 54 3 39-20 19-1 51 14 23 12 3 24 44-28 20-35 7-53 10-48 9-7 12-29 49-18 30-27-9-28-18-4-26 14-27-29-36 9-41 27-17 8-76-25 14-11 17-35 23-29-31-23-36-42-63-26 10-38 8-42 46v8c-2 53-72 37-32 98 27-51 5-40 80-56l-20 53c-10 28 0 10-25 32 43 5 36-3 38-42 29 13 16 10 46-7-5 40 0 43 8 83-16 17-23 17-39 31l40 10c-8 24 3 4-17 15l-48 30c-28 23-23-8-50 14-8-32-8-15-20-42-20 12-13-1-12 35l-36-9c1 5 4 24 4 28 0 23 4 1-4 15-49-27 2-30-64-31-13 14-12 41-14 46l-42-37c-18 11-11 11-21 18-14 11 2 6-14 9l3-44c-39 27-5 30-56 42 7-46 24-24 0-49l-4 15c-6 12 9 0-12 17l-12-13c-21-26-11-28-56-32l-4-36c-10 1-44-1-46-2-14-7-10 21-10-30l-61 5c89 210 677 222 776 10 40-86-28-225-54-293l-79 7z"
		/>
		<Path
			fill="#fcfcfc"
			d="M3576 2442c-52 102-247 331-256 453l94 32c33-32 63-91 91-133 29-44 60-88 89-134 38-62 144-219 153-300-33-3-46-30-76-47-39 34-51 108-94 129zM708 2538c38 24 189 296 234 359 12 18 18 37 50 32 27-4 58-13 79-26-11-123-191-327-240-431-60-39-67-107-110-157-29 23-59 42-79 69 16 45 68 112 66 153z"
		/>
		<Path
			fill="#191919"
			d="m2109 3846-8 31c-18-9-21-10-30-36l-14 51c-8 27 15 26 34 46-41-2-43-14-72-35l-13 16c-10 12-5 6-13 14l14 70 1 15c5-53 24-56 75-55l1 54c30 4 38-1 65-5 35-4 39-4 64-2 55 5 81 24 127 25l-5-59 68 3c0-62 23-97 27-159l-41-30 64-1c33-59 49-118 61-200-62 19-44 38-45 56v5l-2 8c-35-15-6-5-19-27-24-41-39-7-61-81l-54 6c14 5 10 3 16 9-12 62 15 41-1 71 64-2 33-18 76 15-13 12 0 2-21 10l-48 24c-10-12-3 1-12-20-5-12-2-8-5-20-41 67-31 20-57 72l83 64c-24 31-3 21-35 48 29 13 23 22 24 57-30-6-14-9-39-2l-17 47-21-32c-68 25-53-3-47-54-35 9-40 29-56 49-13 16 2 8-17 16-23-22-18-41-46-64z"
		/>
		<Path
			fill="#121212"
			d="M968 1533c25 19 7 7 14 0 0-5-1-19 0-24 1-2 1-5 2-7l3-6c1-2 3-4 4-6s3-4 4-5l29-10c32 65 59 323 113 355 21 0 0 7 30-19 16-14 19-12 29-31-16-27-61-24-28-79 51 13 20 3 44 52 9-23 13-25 30-35 24 35 18 19 13 63l65 12c-21-32-26-24-5-65l54 3c-6-29-8-24-23-45-31 8-5 12-32 21-6-24-19-14 22-76 14-21 7-14 24-26-2-2-5-3-6-4l-27-18c-26-24-2 0-14-25-28-60-26 14-32-47-57 0-25 5-64 16-11-41-42-48-8-95-55 2-113 5-168 7-66 3-83 27-70 95z"
		/>
		<Path
			fill="#151515"
			d="M2652 1584c10 30 10 24 28 46 22 26 9 8 23 41 27 13 38 9 68 28 64 39 57 47 117 59 33 7 30 14 65 26 9-49 6-7-6-44 21-11 18-2 31-13l59-78-41-28c6-30 6-22 17-35 22 17 10-5 59 28-29 28-22-3-41 33 100 47 36-14 92 20-16-30-44-39-6-74 7-6 28-21 42-23 21-3 7-3 20 3 2 1 0 26 10 7 1-2 3 3 5 4 14-15 15-18 36-25-14-17-8-14-38-25 2-1 5-2 6-3l23-16c-19-25-19-27-51-35 0-30 0-34-8-54l-229-13c-1 2-10 18-11 19 58 18 14 35 4 97-20 122-28 47-25 102-45 13-19 7-32-3-2 37 3 28-19 49-2 2-7 6-9 7l-4 4-18 20c-21-7-40-23-47-43l-6-40c-18 4-13 14-45 29l16-88c-54-1-17-3-53-25-32 44 7-5-1 32 0 0 16 12-29 10zM2332 3556l54-6c22 75 37 40 61 81 12 21-16 11 19 27l2-8v-5c1-17-17-37 45-56 29-36 25-80-49-100-4-109 40-201-87-174-48-22-25-39-19-86-34-12-22-18-50-33l-32 4c-12 40-22 84-18 127 29 11 34 30 35 41 4 37-5 19-12 29-9 13-13 17-20 28-13-14-11-40-11-40l-66 11 9-51c-58 16-15 17-51 49-43 38-26-4-72-1 3 47 9 30 30 34l82 3-1 85c56 10 14-18 67 7 47 22 29 2 67 6l18 28z"
		/>
		<Path
			fill="#fcfcfc"
			d="M345 2890c-12-80-51-122-40-225 15-129 144-195 249-261 37-23 36-31 70-58 32-25 51-22 65-65-165-28-146-77-306 55-250 206-112 517-38 553zM3749 2339l139 91c300 182 182 300 155 450 80-34 120-240 89-360-16-63-47-111-83-148-26-27-118-86-130-111-42-12-58-25-112-8-32 10-78 11-105 29 16 36 37 25 47 57z"
		/>
		<Path
			fill="#1b1b1b"
			d="M1366 2775c-22 73 45-8 63-16 39-20 63-7 77-40 13-30-25-13 84-43 54-16 209-162 255-203 42-37 82-71 131-100 54-32 106-40 162-66-13-20-31-25-69-13-27 9-22 23-71 16-19-16-41-62-43-95-48 20-123 105-154 141l-138 149c-48 55-89 96-143 144-14 13-150 112-153 125z"
		/>
		<Path
			fill="#0f0f0f"
			d="M3109 1116c-64-9-322-35-374-27l-116 13c33 28 33-1 45 32-20 11-66 3-97-45-16 14-7 9-29 13 18 19 32 31 48 48 32 36 12 34 8 81 23-2 39 1 56 5l18-27c16 24 14 17 49 23 9-12 19-24 28-36 23 58 86 67 139 55l12-4c24-6 9 7 31-26 20 33 39 14 105 37 18-23-14 24 4-11 11-21 19-21 44-26-6-52-9-30 26-48-2-1-4-5-5-4l-28-27c9-8 28-9 36-27z"
		/>
		<Path
			fill="#151515"
			d="m1932 3503-61 18c-5 55 37 193 60 245 19 44 22 32 76 28l-28 27c-1 1-4 3-5 4s-3 2-5 4l23 105c9-8 3-2 13-14l13-16c28 21 30 33 72 35-19-20-42-19-34-46l14-51c9 25 12 27 30 36l8-31c2-43-74-76-95-110 46-10 16 19 51 2l25-15c19-8-4-5 31-9-32-11-12 5-23-21l36-24c-44 12-38 22-66 31l-29-17c-7-33 2-47 19-72l-38-11c0-27 6-44-11-61 2-2 4-3 6-5l34-19c7-68-8-2 15-93-30-27-25-12-26-12-13 6-18 3-24 23l-6 56c-14-16-29-16-55-20l-21 33z"
		/>
		<Path
			fill="#121212"
			d="M1669 3598c-2 2-5 2-6 5s-4 4-6 5l-66 27c-37 5-8-3-50 20v23h-32c-11 13-2 14-4 26 7 29 4 18-1 43 25-3 33-11 45-5-18 17-22 13-48 24-1 4-3 37-4 43-2 15 0 33 6 51l56-7 9 39 44 3 16 55c-62-9-36 25-72-6 12 27 13 10 20 42 26-21 22 9 50-14l48-30c21-12 9 9 17-15l-40-10c15-13 23-14 39-31-8-40-13-43-8-83-30 17-16 20-46 7-2 39 5 47-38 42 25-22 15-4 25-32l20-53c-74 16-52 5-80 56-41-61 29-45 32-98v-8c4-39 15-36 42-46 20 27 13 32 42 63 25-6 11-8 35-23 19 60 1 35-8 76 43 9 25 10 29 36 1 9 9 48 28 18 22-37-18-40 29-49 18-3 25 10 53-10-12-41-11-21-24-44-19-32 3-12 1-51-2-30-22-34-54-54l-30-21c-40 0-15 4-28-16 7-18 7-4-4-12l-40 14z"
		/>
		<Path
			fill="#111"
			d="m3547 1128 2 53c-83-6-229-53-296-44l-74 5c25 9 20 1 18 30-23 11-9 3-30 22-28-12-15-11-40-24 2 51-11 61-12 61 0-1-2 3-2 4 93 0-15 0 75-41 81-37 68 15 158 13l-23 18c31 8 27 2 36 28-38 1-27-3-62-6 31 10 21-8 21 33 40 37 15-2 58 18 1 1 3 2 5 3l9 8c43 29 88 3 176 15l10-39 41 10c-3-33-3-32 52-61-1-31-7-34-19-57-13-22-18-37-21-66-56 20-22 40-83 17z"
		/>
		<Path
			fill="#1e1e1e"
			d="M828 2285c8-33 15-76 18-114 43 5 55-9 91-17-3 47 7 67-21 93-29-33 15-22-25-36-15 38 0 24-2 49-3 27-9 10-25 40l-30-6 7 13c41 20 37 9 60-12 49-45 26 20 101-50 10-9 12-14 25-17 18-5 25-1 38 8 37-2 36 1 64-15-24-41 46 29-25-20-2-2-5-3-8-5-228-68-188-314-240-488-36 59-18 213-27 292-8 73-55 236 0 286z"
		/>
		<Path
			fill="#222"
			d="m2248 2304 26 8c21 6 13 1 32 10 80 35 173 88 237 146 82 74 366 330 453 329l28 5 9-27c-67-53-132-96-191-158-28-29-58-57-89-87-17-17-70-73-86-83-3 19-1 34-21 42-30 11-15 6-34-19l35-12c-37-28-9 11-55-53-35 23-45 32-78-3-26-27-31-29-37-50-13-46 17 21-3-13-16-7-85-43-99-45-39-5-14 10-53 13-45 4-20-16-74-2z"
		/>
		<Path
			fill="#1e1e1e"
			d="M2871 3534c71 3 7-18 113-19 11 16 15 33 36 37 21 5 80-28 116-33 40-6 29-4 54-24 63 82 57-7 125 91 7 10 1-4 9 15 1 2 4 18 5 19 6 15 18 17 19 34 2 19-2 26-21 28-28 3-14-6-38-20-23 20-54 32-70 58-8 13-5 9-7 21l-2 16c-3 16-17 13 7 48 22 3-21 10 6-4 16-8-5-8 11-4 14 49 1 28 37 36 23 5 17 6 33 20l-11 33c115-107 93-289-19-387-97-85-337-78-403 35z"
		/>
		<Path
			fill="#101010"
			d="M1174 1130c8 40-3 2 20 32 9 13 2 2 10 14l12 20c34-19 47-10 77 10l-36 28c-25 13-26 8-42 27 9 33 12 18 33 12 54-15 98 15 112-28 8-25-10-27 24-38l17 42c-29 13-10-16-22 14 8 4-10 21 32-1 11-6 19-16 26-23 47 21 63 38 96-8 24-33 8-36 32-39 49-5-9 29 55 21-17-41-25-53-35-107l-69 13-15-18c-90-6-245 12-328 30z"
		/>
		<Path
			fill="#0f0f0f"
			d="M2338 1071h-136c-26 31-104 15-193 17-8 26-2 55-73 66 18 52-14 35 25 66 32-7 4-2 22-18 15-15 42-21 75-33 25 27-6 15 34 35 67 34 71 13 122 0 6-2 26-6 32-8 2-1 4-2 5-3 2-1 3-2 5-3 10-5 1-3 15-10 87-41 103 0 221-90l-68-3c-34 5-21 14-54 4l-34-21z"
		/>
		<Path
			fill="#282828"
			d="M1709 3583c11 8 11-7 4 12 67-40 151-275 186-358 53-124 130-249 296-251 316-3 321 430 486 611-10 15 5 4-23 8v15h40c1-32-4-12 9-36-35-63-45-40-102-174-27-65-55-132-84-195-61-132-132-256-309-258-288-3-344 304-452 530-17 35-39 59-50 95z"
		/>
		<Path
			fill="#101010"
			d="M731 1214c13 21 31 28 41 44 0 1 14 33 14 34l14 33 9-47c38 15 20 20 62 6l-17 52c71-11 14-32 103-44 72-9 55 14 78-13-8-13-3-6-16-14-26-16 15 8-10-5-1-1-4-2-5-3-2-1-8-3-10-5 2-26 6-21 21-34l21 25 9-28 38 11c3-6 6-12 9-16 33-54 53-12 60-60l-28-6c-49-7-194 29-252 39-13 10-1 9-24 10-18 1-4 5-17-6-19-16-4-8-9-18l-69-51c0 73-28 43-21 96z"
		/>
		<Path
			fill="#191919"
			d="m1932 3503 21-33c26 3 41 4 55 20l6-56c6-20 11-17 24-23 31-18 25-41 20-102-1-18-4-3-15-28l36-23c18 25 0 1 14 35l5 12c21-31-3 5 9-55 9-42-5-9-11-58l54 12-3 32c32 7 13 7 38-4l8 35 49 1-18-77c-13 9-18 13-29 23-36-22-49-77-96-75-51 2-87 35-108 70 1 53 21 54 29 104-120 4-89 19-90 193z"
		/>
		<Path
			fill="#111"
			d="M1505 3703c2-11-7-13 4-26h32v-23c-67-20-9 11-60-37-31-29-55-20-80-36-5-36-9-26 9-48-37-22-33-1-60 14-34 18 12-12-20 6 1 36 22 72 32 100-36 3-36-6-52-4-25 3-5 1-32 20 60 98-47 65 42 78 29 4-7 2 9 1h4l18-9c1 0 2-2 4-2l13 62c21-16 13-15 33-43l9-11c33 55 1 14 56 40-30-41 16-51 40-82z"
		/>
		<Path
			fill="#1b1b1b"
			d="M3382 2158c-31 0-38 10-56 27l7 35c96 42 176 30 198 76l11-9c9-4 4-2 16-5 43-19 21-139 10-189-2-1-4-3-5-4l-29-24c-48 23-25 32-66 55l-26 13c-34 22-11 15-59 25z"
		/>
		<Path
			fill="#272727"
			d="M3382 2158c48-10 26-3 59-25l26-13c42-23 18-32 66-55l29 24c1 1 4 3 5 4l-39-366c-1-1-2-4-3-6-14 85-39 280-82 352-22 37-46 47-62 85z"
		/>
		<Path
			fill="#fcfcfc"
			d="M3186 1936c115-9 173-240 195-341 11-48 32-106-15-125-26 43-48 193-69 256-60 180-69 138-111 210z"
		/>
		<Path
			fill="#fbfbfb"
			d="M1136 1830c-54-32-81-290-113-355l-29 10c-6 89 29 195 57 266 33 84 60 166 140 188-18-38-45-61-55-109z"
		/>
		<Path d="m649 2845 41 81 167-94c-7-32-19-48-41-73-40 2-128 67-167 85zM3530 2820c30 22 129 86 163 91 18-25 33-44 39-72-34-34-109-72-156-92-19 17-33 49-47 72zM594 2752l32 66c57-17 112-64 167-86l-33-75c-48 6-145 67-165 96zM3597 2720l157 94c15-20 28-45 40-70-34-32-106-88-164-95l-33 72zM577 2618c-16 22-16 14-39 30l27 65c53-16 129-66 161-97l-25-63c-25 7-39 20-60 33-19 12-43 21-65 32zM3660 2608c28 31 108 80 153 96 23-21 27-26 36-64-24-21-45-26-77-47-25-17-47-33-79-43l-34 57zM717 2960l28 54c47-17 133-72 166-102-9-27-9-34-31-52-54 20-131 62-162 100zM3478 2904c31 34 115 81 164 100l34-62-164-91c-20 19-25 24-34 52zM505 2606c27 17 17 7 53-8l118-68-22-54c-51 16-119 67-159 91z" />
		<Path
			fill="#191919"
			d="M2227 3191c32-10 36-14 58-23l24 28c27 14 15 21 50 33-6 47-29 64 19 86 4-74 56-101-10-153-69-54-110-31-140 29z"
		/>
		<Path d="m3712 2522 157 85 25-47c-32-24-112-79-160-89z" />
		<Path
			fill="#131313"
			d="M828 2285c-4 13-7 12 5 8l30 6c16-30 22-13 25-40 3-24-13-10 2-49 39 14-4 3 25 36 28-26 18-45 21-93-35 8-47 23-91 17-3 39-11 81-18 114z"
		/>
		<Path d="m633 2441-15-32c-33 5-171 75-149 115 11 21 13 15 39 1 29-15 110-64 125-84zM3757 2433c13 23 39 34 73 55 28 17 51 34 86 41 10-54 2-46-48-79-28-18-60-41-96-50z" />
		<Path
			fill="#020202"
			d="M3603 3060c7-11 9-16 14-33-49-27-95-67-161-90 20 31 48 36 74 59 16 14 17 23 34 37 12 10 30 23 39 27zM780 3072c61-26 29-39 107-89l30-19c11-10 5-4 14-16-32 11-69 35-98 52-42 24-72 29-52 72z"
		/>
	</Svg>
);
export default SvgComponent;
