import { Image } from 'expo-image';

type AppAvatarProps = {
	uri: string;
	size?: number;
};

export function AppAvatar({ uri, size }: AppAvatarProps) {
	return (
		<Image
			source={{ uri: uri }}
			style={{
				width: size || 48,
				height: size || 48,
				borderRadius: size ? size / 2 : 48 / 2,
				borderWidth: 1.5,
				borderColor: '#888',
			}}
		/>
	);
}
