import { Stack } from 'expo-router/stack';
import {
	useActiveUserSession,
	useAppActiveSession,
	useAppTheme,
} from '#/states/global/hooks';
import { Redirect } from 'expo-router';

function Layout() {
	const { theme } = useAppTheme();
	const { acct } = useActiveUserSession();
	const { session } = useAppActiveSession();

	if (!acct || session.state !== 'valid') return <Redirect href={'/'} />;

	return (
		<Stack
			initialRouteName={'index'}
			screenOptions={{
				headerShown: false,
				navigationBarColor: theme.background.a0,
			}}
		/>
	);
}

export default Layout;
