import { queryOptions } from '@tanstack/react-query';
import { defaultResultPage, DriverService, PostParser, } from '@dhaaga/bridge';
export function userProfileQueryOpts(client, query) {
    return queryOptions({
        queryKey: [client.key, 'dhaaga/user', query],
        queryFn: () => client.user.findOne(query).then((o) => o.unwrap()),
        enabled: !!client,
    });
}
export function userFollowsQueryOpts(client, userId, maxId) {
    return queryOptions({
        queryKey: [client.key, 'dhaaga/user/follows', maxId],
        queryFn: () => client.user
            .getFollows({
            id: userId,
            limit: 10,
            maxId,
            allowPartial: true,
        })
            .then((o) => o.unwrapOrElse(defaultResultPage)),
        enabled: !!client,
        initialData: defaultResultPage,
    });
}
export function userFollowersQueryOpts(client, acctId, maxId) {
    return queryOptions({
        queryKey: [client.key, 'dhaaga/user/followers', acctId, maxId],
        queryFn: () => client.user
            .getFollowers({
            id: acctId,
            limit: 10,
            maxId,
            allowPartial: true,
        })
            .then((o) => o.unwrapOrElse(defaultResultPage)),
        enabled: !!client,
        initialData: defaultResultPage,
    });
}
async function api(client, userId) {
    const result = await client.accounts.statuses(userId, {
        limit: 40,
        userId,
        onlyMedia: true,
        excludeReblogs: true,
        allowPartial: true,
        withFiles: true,
        withRenotes: false,
        withReplies: false,
        bskyFilter: DriverService.supportsAtProto(client.driver)
            ? 'posts_with_media'
            : undefined,
    });
    if (!result.isOk())
        return [];
    const data = result.unwrap();
    return DriverService.supportsAtProto(client.driver)
        ? PostParser.parse(data.data.feed, client.driver, client.server).filter((o) => !o.meta.isReply)
        : PostParser.parse(data, client.driver, client.server);
}
export function userGalleryQueryOpts(client, userId) {
    return queryOptions({
        queryKey: [`dhaaga/profile/gallery`, userId],
        queryFn: () => api(client, userId),
        enabled: !!client && !!userId,
        initialData: [],
    });
}
//# sourceMappingURL=user.js.map