import { ApiTargetInterface, DriverUserFindQueryType } from '@dhaaga/bridge';
export declare function userProfileQueryOpts(client: ApiTargetInterface, query: DriverUserFindQueryType): import("@tanstack/react-query").OmitKeyof<import("@tanstack/react-query").UseQueryOptions<{
    id: string;
    avatarUrl: string;
    displayName: string | null;
    parsedDisplayName: any[];
    handle: string;
    instance: string;
    banner?: string | null | undefined;
    meta: {
        isProfileLocked: boolean;
        isBot: boolean;
        fields: {
            name?: string | undefined;
            value?: string | undefined;
            verifiedAt?: string | null | undefined;
            cid?: string | undefined;
            cts?: string | undefined;
            src?: string | undefined;
            uri?: string | undefined;
            val?: string | undefined;
        }[];
    };
    description: string;
    parsedDescription: any[];
    stats: {
        posts: number | null;
        followers: number | null;
        following: number | null;
    };
    calculated: {
        emojis: Map<string, string>;
    };
    relationship: {
        blocking: boolean | null;
        blockedBy: boolean | null;
        domainBlocking: boolean | null;
        followedBy: boolean | null;
        following: boolean | null;
        muting: boolean | null;
        mutingNotifications: boolean | null;
        note: string | null;
        requested: boolean | null;
        requestedBy: boolean | null;
        showingReblogs: boolean | null;
    };
}, Error, {
    id: string;
    avatarUrl: string;
    displayName: string | null;
    parsedDisplayName: any[];
    handle: string;
    instance: string;
    banner?: string | null | undefined;
    meta: {
        isProfileLocked: boolean;
        isBot: boolean;
        fields: {
            name?: string | undefined;
            value?: string | undefined;
            verifiedAt?: string | null | undefined;
            cid?: string | undefined;
            cts?: string | undefined;
            src?: string | undefined;
            uri?: string | undefined;
            val?: string | undefined;
        }[];
    };
    description: string;
    parsedDescription: any[];
    stats: {
        posts: number | null;
        followers: number | null;
        following: number | null;
    };
    calculated: {
        emojis: Map<string, string>;
    };
    relationship: {
        blocking: boolean | null;
        blockedBy: boolean | null;
        domainBlocking: boolean | null;
        followedBy: boolean | null;
        following: boolean | null;
        muting: boolean | null;
        mutingNotifications: boolean | null;
        note: string | null;
        requested: boolean | null;
        requestedBy: boolean | null;
        showingReblogs: boolean | null;
    };
}, readonly unknown[]>, "queryFn"> & {
    queryFn?: import("@tanstack/react-query").QueryFunction<{
        id: string;
        avatarUrl: string;
        displayName: string | null;
        parsedDisplayName: any[];
        handle: string;
        instance: string;
        banner?: string | null | undefined;
        meta: {
            isProfileLocked: boolean;
            isBot: boolean;
            fields: {
                name?: string | undefined;
                value?: string | undefined;
                verifiedAt?: string | null | undefined;
                cid?: string | undefined;
                cts?: string | undefined;
                src?: string | undefined;
                uri?: string | undefined;
                val?: string | undefined;
            }[];
        };
        description: string;
        parsedDescription: any[];
        stats: {
            posts: number | null;
            followers: number | null;
            following: number | null;
        };
        calculated: {
            emojis: Map<string, string>;
        };
        relationship: {
            blocking: boolean | null;
            blockedBy: boolean | null;
            domainBlocking: boolean | null;
            followedBy: boolean | null;
            following: boolean | null;
            muting: boolean | null;
            mutingNotifications: boolean | null;
            note: string | null;
            requested: boolean | null;
            requestedBy: boolean | null;
            showingReblogs: boolean | null;
        };
    }, readonly unknown[], never> | undefined;
} & {
    queryKey: readonly unknown[] & {
        [dataTagSymbol]: {
            id: string;
            avatarUrl: string;
            displayName: string | null;
            parsedDisplayName: any[];
            handle: string;
            instance: string;
            banner?: string | null | undefined;
            meta: {
                isProfileLocked: boolean;
                isBot: boolean;
                fields: {
                    name?: string | undefined;
                    value?: string | undefined;
                    verifiedAt?: string | null | undefined;
                    cid?: string | undefined;
                    cts?: string | undefined;
                    src?: string | undefined;
                    uri?: string | undefined;
                    val?: string | undefined;
                }[];
            };
            description: string;
            parsedDescription: any[];
            stats: {
                posts: number | null;
                followers: number | null;
                following: number | null;
            };
            calculated: {
                emojis: Map<string, string>;
            };
            relationship: {
                blocking: boolean | null;
                blockedBy: boolean | null;
                domainBlocking: boolean | null;
                followedBy: boolean | null;
                following: boolean | null;
                muting: boolean | null;
                mutingNotifications: boolean | null;
                note: string | null;
                requested: boolean | null;
                requestedBy: boolean | null;
                showingReblogs: boolean | null;
            };
        };
        [dataTagErrorSymbol]: Error;
    };
};
export declare function userFollowsQueryOpts(client: ApiTargetInterface, userId: string, maxId: string | null): import("@tanstack/react-query").UseQueryOptions<import("@dhaaga/bridge").ResultPage<{
    id: string;
    avatarUrl: string;
    displayName: string | null;
    parsedDisplayName: any[];
    handle: string;
    instance: string;
    banner?: string | null | undefined;
    meta: {
        isProfileLocked: boolean;
        isBot: boolean;
        fields: {
            name?: string | undefined;
            value?: string | undefined;
            verifiedAt?: string | null | undefined;
            cid?: string | undefined;
            cts?: string | undefined;
            src?: string | undefined;
            uri?: string | undefined;
            val?: string | undefined;
        }[];
    };
    description: string;
    parsedDescription: any[];
    stats: {
        posts: number | null;
        followers: number | null;
        following: number | null;
    };
    calculated: {
        emojis: Map<string, string>;
    };
    relationship: {
        blocking: boolean | null;
        blockedBy: boolean | null;
        domainBlocking: boolean | null;
        followedBy: boolean | null;
        following: boolean | null;
        muting: boolean | null;
        mutingNotifications: boolean | null;
        note: string | null;
        requested: boolean | null;
        requestedBy: boolean | null;
        showingReblogs: boolean | null;
    };
}>, Error, import("@dhaaga/bridge").ResultPage<{
    id: string;
    avatarUrl: string;
    displayName: string | null;
    parsedDisplayName: any[];
    handle: string;
    instance: string;
    banner?: string | null | undefined;
    meta: {
        isProfileLocked: boolean;
        isBot: boolean;
        fields: {
            name?: string | undefined;
            value?: string | undefined;
            verifiedAt?: string | null | undefined;
            cid?: string | undefined;
            cts?: string | undefined;
            src?: string | undefined;
            uri?: string | undefined;
            val?: string | undefined;
        }[];
    };
    description: string;
    parsedDescription: any[];
    stats: {
        posts: number | null;
        followers: number | null;
        following: number | null;
    };
    calculated: {
        emojis: Map<string, string>;
    };
    relationship: {
        blocking: boolean | null;
        blockedBy: boolean | null;
        domainBlocking: boolean | null;
        followedBy: boolean | null;
        following: boolean | null;
        muting: boolean | null;
        mutingNotifications: boolean | null;
        note: string | null;
        requested: boolean | null;
        requestedBy: boolean | null;
        showingReblogs: boolean | null;
    };
}>, (string | null)[]> & {
    initialData?: import("@tanstack/react-query").InitialDataFunction<import("@dhaaga/bridge").ResultPage<{
        id: string;
        avatarUrl: string;
        displayName: string | null;
        parsedDisplayName: any[];
        handle: string;
        instance: string;
        banner?: string | null | undefined;
        meta: {
            isProfileLocked: boolean;
            isBot: boolean;
            fields: {
                name?: string | undefined;
                value?: string | undefined;
                verifiedAt?: string | null | undefined;
                cid?: string | undefined;
                cts?: string | undefined;
                src?: string | undefined;
                uri?: string | undefined;
                val?: string | undefined;
            }[];
        };
        description: string;
        parsedDescription: any[];
        stats: {
            posts: number | null;
            followers: number | null;
            following: number | null;
        };
        calculated: {
            emojis: Map<string, string>;
        };
        relationship: {
            blocking: boolean | null;
            blockedBy: boolean | null;
            domainBlocking: boolean | null;
            followedBy: boolean | null;
            following: boolean | null;
            muting: boolean | null;
            mutingNotifications: boolean | null;
            note: string | null;
            requested: boolean | null;
            requestedBy: boolean | null;
            showingReblogs: boolean | null;
        };
    }>> | import("@dhaaga/bridge").ResultPage<{
        id: string;
        avatarUrl: string;
        displayName: string | null;
        parsedDisplayName: any[];
        handle: string;
        instance: string;
        banner?: string | null | undefined;
        meta: {
            isProfileLocked: boolean;
            isBot: boolean;
            fields: {
                name?: string | undefined;
                value?: string | undefined;
                verifiedAt?: string | null | undefined;
                cid?: string | undefined;
                cts?: string | undefined;
                src?: string | undefined;
                uri?: string | undefined;
                val?: string | undefined;
            }[];
        };
        description: string;
        parsedDescription: any[];
        stats: {
            posts: number | null;
            followers: number | null;
            following: number | null;
        };
        calculated: {
            emojis: Map<string, string>;
        };
        relationship: {
            blocking: boolean | null;
            blockedBy: boolean | null;
            domainBlocking: boolean | null;
            followedBy: boolean | null;
            following: boolean | null;
            muting: boolean | null;
            mutingNotifications: boolean | null;
            note: string | null;
            requested: boolean | null;
            requestedBy: boolean | null;
            showingReblogs: boolean | null;
        };
    }> | undefined;
} & {
    queryKey: (string | null)[] & {
        [dataTagSymbol]: import("@dhaaga/bridge").ResultPage<{
            id: string;
            avatarUrl: string;
            displayName: string | null;
            parsedDisplayName: any[];
            handle: string;
            instance: string;
            banner?: string | null | undefined;
            meta: {
                isProfileLocked: boolean;
                isBot: boolean;
                fields: {
                    name?: string | undefined;
                    value?: string | undefined;
                    verifiedAt?: string | null | undefined;
                    cid?: string | undefined;
                    cts?: string | undefined;
                    src?: string | undefined;
                    uri?: string | undefined;
                    val?: string | undefined;
                }[];
            };
            description: string;
            parsedDescription: any[];
            stats: {
                posts: number | null;
                followers: number | null;
                following: number | null;
            };
            calculated: {
                emojis: Map<string, string>;
            };
            relationship: {
                blocking: boolean | null;
                blockedBy: boolean | null;
                domainBlocking: boolean | null;
                followedBy: boolean | null;
                following: boolean | null;
                muting: boolean | null;
                mutingNotifications: boolean | null;
                note: string | null;
                requested: boolean | null;
                requestedBy: boolean | null;
                showingReblogs: boolean | null;
            };
        }>;
        [dataTagErrorSymbol]: Error;
    };
};
export declare function userFollowersQueryOpts(client: ApiTargetInterface, acctId: string, maxId: string | null): import("@tanstack/react-query").UseQueryOptions<import("@dhaaga/bridge").ResultPage<{
    id: string;
    avatarUrl: string;
    displayName: string | null;
    parsedDisplayName: any[];
    handle: string;
    instance: string;
    banner?: string | null | undefined;
    meta: {
        isProfileLocked: boolean;
        isBot: boolean;
        fields: {
            name?: string | undefined;
            value?: string | undefined;
            verifiedAt?: string | null | undefined;
            cid?: string | undefined;
            cts?: string | undefined;
            src?: string | undefined;
            uri?: string | undefined;
            val?: string | undefined;
        }[];
    };
    description: string;
    parsedDescription: any[];
    stats: {
        posts: number | null;
        followers: number | null;
        following: number | null;
    };
    calculated: {
        emojis: Map<string, string>;
    };
    relationship: {
        blocking: boolean | null;
        blockedBy: boolean | null;
        domainBlocking: boolean | null;
        followedBy: boolean | null;
        following: boolean | null;
        muting: boolean | null;
        mutingNotifications: boolean | null;
        note: string | null;
        requested: boolean | null;
        requestedBy: boolean | null;
        showingReblogs: boolean | null;
    };
}>, Error, import("@dhaaga/bridge").ResultPage<{
    id: string;
    avatarUrl: string;
    displayName: string | null;
    parsedDisplayName: any[];
    handle: string;
    instance: string;
    banner?: string | null | undefined;
    meta: {
        isProfileLocked: boolean;
        isBot: boolean;
        fields: {
            name?: string | undefined;
            value?: string | undefined;
            verifiedAt?: string | null | undefined;
            cid?: string | undefined;
            cts?: string | undefined;
            src?: string | undefined;
            uri?: string | undefined;
            val?: string | undefined;
        }[];
    };
    description: string;
    parsedDescription: any[];
    stats: {
        posts: number | null;
        followers: number | null;
        following: number | null;
    };
    calculated: {
        emojis: Map<string, string>;
    };
    relationship: {
        blocking: boolean | null;
        blockedBy: boolean | null;
        domainBlocking: boolean | null;
        followedBy: boolean | null;
        following: boolean | null;
        muting: boolean | null;
        mutingNotifications: boolean | null;
        note: string | null;
        requested: boolean | null;
        requestedBy: boolean | null;
        showingReblogs: boolean | null;
    };
}>, (string | null)[]> & {
    initialData?: import("@tanstack/react-query").InitialDataFunction<import("@dhaaga/bridge").ResultPage<{
        id: string;
        avatarUrl: string;
        displayName: string | null;
        parsedDisplayName: any[];
        handle: string;
        instance: string;
        banner?: string | null | undefined;
        meta: {
            isProfileLocked: boolean;
            isBot: boolean;
            fields: {
                name?: string | undefined;
                value?: string | undefined;
                verifiedAt?: string | null | undefined;
                cid?: string | undefined;
                cts?: string | undefined;
                src?: string | undefined;
                uri?: string | undefined;
                val?: string | undefined;
            }[];
        };
        description: string;
        parsedDescription: any[];
        stats: {
            posts: number | null;
            followers: number | null;
            following: number | null;
        };
        calculated: {
            emojis: Map<string, string>;
        };
        relationship: {
            blocking: boolean | null;
            blockedBy: boolean | null;
            domainBlocking: boolean | null;
            followedBy: boolean | null;
            following: boolean | null;
            muting: boolean | null;
            mutingNotifications: boolean | null;
            note: string | null;
            requested: boolean | null;
            requestedBy: boolean | null;
            showingReblogs: boolean | null;
        };
    }>> | import("@dhaaga/bridge").ResultPage<{
        id: string;
        avatarUrl: string;
        displayName: string | null;
        parsedDisplayName: any[];
        handle: string;
        instance: string;
        banner?: string | null | undefined;
        meta: {
            isProfileLocked: boolean;
            isBot: boolean;
            fields: {
                name?: string | undefined;
                value?: string | undefined;
                verifiedAt?: string | null | undefined;
                cid?: string | undefined;
                cts?: string | undefined;
                src?: string | undefined;
                uri?: string | undefined;
                val?: string | undefined;
            }[];
        };
        description: string;
        parsedDescription: any[];
        stats: {
            posts: number | null;
            followers: number | null;
            following: number | null;
        };
        calculated: {
            emojis: Map<string, string>;
        };
        relationship: {
            blocking: boolean | null;
            blockedBy: boolean | null;
            domainBlocking: boolean | null;
            followedBy: boolean | null;
            following: boolean | null;
            muting: boolean | null;
            mutingNotifications: boolean | null;
            note: string | null;
            requested: boolean | null;
            requestedBy: boolean | null;
            showingReblogs: boolean | null;
        };
    }> | undefined;
} & {
    queryKey: (string | null)[] & {
        [dataTagSymbol]: import("@dhaaga/bridge").ResultPage<{
            id: string;
            avatarUrl: string;
            displayName: string | null;
            parsedDisplayName: any[];
            handle: string;
            instance: string;
            banner?: string | null | undefined;
            meta: {
                isProfileLocked: boolean;
                isBot: boolean;
                fields: {
                    name?: string | undefined;
                    value?: string | undefined;
                    verifiedAt?: string | null | undefined;
                    cid?: string | undefined;
                    cts?: string | undefined;
                    src?: string | undefined;
                    uri?: string | undefined;
                    val?: string | undefined;
                }[];
            };
            description: string;
            parsedDescription: any[];
            stats: {
                posts: number | null;
                followers: number | null;
                following: number | null;
            };
            calculated: {
                emojis: Map<string, string>;
            };
            relationship: {
                blocking: boolean | null;
                blockedBy: boolean | null;
                domainBlocking: boolean | null;
                followedBy: boolean | null;
                following: boolean | null;
                muting: boolean | null;
                mutingNotifications: boolean | null;
                note: string | null;
                requested: boolean | null;
                requestedBy: boolean | null;
                showingReblogs: boolean | null;
            };
        }>;
        [dataTagErrorSymbol]: Error;
    };
};
export declare function userGalleryQueryOpts(client: ApiTargetInterface, userId: string): Omit<import("@tanstack/react-query").UseQueryOptions<{
    uuid: string;
    id: string;
    visibility: string;
    createdAt: string;
    postedBy: {
        id: string;
        avatarUrl: string;
        displayName?: string | null | undefined;
        parsedDisplayName: any[];
        handle: string;
        instance: string;
    };
    content: {
        raw?: string | null | undefined;
        parsed: any[];
        media: {
            url: string;
            previewUrl?: string | null | undefined;
            width?: number | null | undefined;
            height?: number | null | undefined;
            alt: string | null;
            type: string;
            blurhash: string | null;
        }[];
    };
    interaction: {
        boosted: boolean;
        liked: boolean;
        bookmarked: boolean;
    };
    stats: {
        replyCount: number;
        boostCount: number;
        likeCount: number;
        reactions: {
            id: string;
            count: number;
            me: boolean;
            accounts: string[];
            url?: string | null | undefined;
        }[];
    };
    calculated: {
        mediaContainerHeight: number;
        emojis: Map<string, string>;
        translationOutput?: string | undefined;
        translationType?: string | undefined;
        reactionEmojis: {
            height?: number | null | undefined;
            width?: number | null | undefined;
            name: string;
            url: string;
        }[];
        mentions: {
            id?: string | null | undefined;
            text?: string | undefined;
            url?: string | null | undefined;
            username?: string | null | undefined;
            acct?: string | null | undefined;
        }[];
    };
    meta: {
        sensitive: boolean;
        cw: string | null;
        isBoost: boolean;
        isReply: boolean;
        mentions: {
            id: string;
            handle?: string | undefined;
            url?: string | undefined;
            acct?: string | null | undefined;
            username?: string | null | undefined;
        }[];
        cid?: string | null | undefined;
        uri?: string | null | undefined;
    };
    state: {
        isBookmarkStateFinal: boolean;
    };
    atProto?: {
        viewer?: {
            like?: string | null | undefined;
            embeddingDisabled?: boolean | undefined;
            pinned?: any;
            repost?: any;
            replyDisabled?: boolean | undefined;
            threadMuted?: boolean | undefined;
        } | undefined;
    } | null | undefined;
    replyTo?: {
        uuid: string;
        id: string;
        visibility: string;
        createdAt: string;
        postedBy: {
            id: string;
            avatarUrl: string;
            displayName?: string | null | undefined;
            parsedDisplayName: any[];
            handle: string;
            instance: string;
        };
        content: {
            raw?: string | null | undefined;
            parsed: any[];
            media: {
                url: string;
                previewUrl?: string | null | undefined;
                width?: number | null | undefined;
                height?: number | null | undefined;
                alt: string | null;
                type: string;
                blurhash: string | null;
            }[];
        };
        interaction: {
            boosted: boolean;
            liked: boolean;
            bookmarked: boolean;
        };
        stats: {
            replyCount: number;
            boostCount: number;
            likeCount: number;
            reactions: {
                id: string;
                count: number;
                me: boolean;
                accounts: string[];
                url?: string | null | undefined;
            }[];
        };
        calculated: {
            mediaContainerHeight: number;
            emojis: Map<string, string>;
            translationOutput?: string | undefined;
            translationType?: string | undefined;
            reactionEmojis: {
                height?: number | null | undefined;
                width?: number | null | undefined;
                name: string;
                url: string;
            }[];
            mentions: {
                id?: string | null | undefined;
                text?: string | undefined;
                url?: string | null | undefined;
                username?: string | null | undefined;
                acct?: string | null | undefined;
            }[];
        };
        meta: {
            sensitive: boolean;
            cw: string | null;
            isBoost: boolean;
            isReply: boolean;
            mentions: {
                id: string;
                handle?: string | undefined;
                url?: string | undefined;
                acct?: string | null | undefined;
                username?: string | null | undefined;
            }[];
            cid?: string | null | undefined;
            uri?: string | null | undefined;
        };
        state: {
            isBookmarkStateFinal: boolean;
        };
        atProto?: {
            viewer?: {
                like?: string | null | undefined;
                embeddingDisabled?: boolean | undefined;
                pinned?: any;
                repost?: any;
                replyDisabled?: boolean | undefined;
                threadMuted?: boolean | undefined;
            } | undefined;
        } | null | undefined;
        replyTo?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
        boostedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
        quotedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
    } | null | undefined;
    boostedFrom?: {
        uuid: string;
        id: string;
        visibility: string;
        createdAt: string;
        postedBy: {
            id: string;
            avatarUrl: string;
            displayName?: string | null | undefined;
            parsedDisplayName: any[];
            handle: string;
            instance: string;
        };
        content: {
            raw?: string | null | undefined;
            parsed: any[];
            media: {
                url: string;
                previewUrl?: string | null | undefined;
                width?: number | null | undefined;
                height?: number | null | undefined;
                alt: string | null;
                type: string;
                blurhash: string | null;
            }[];
        };
        interaction: {
            boosted: boolean;
            liked: boolean;
            bookmarked: boolean;
        };
        stats: {
            replyCount: number;
            boostCount: number;
            likeCount: number;
            reactions: {
                id: string;
                count: number;
                me: boolean;
                accounts: string[];
                url?: string | null | undefined;
            }[];
        };
        calculated: {
            mediaContainerHeight: number;
            emojis: Map<string, string>;
            translationOutput?: string | undefined;
            translationType?: string | undefined;
            reactionEmojis: {
                height?: number | null | undefined;
                width?: number | null | undefined;
                name: string;
                url: string;
            }[];
            mentions: {
                id?: string | null | undefined;
                text?: string | undefined;
                url?: string | null | undefined;
                username?: string | null | undefined;
                acct?: string | null | undefined;
            }[];
        };
        meta: {
            sensitive: boolean;
            cw: string | null;
            isBoost: boolean;
            isReply: boolean;
            mentions: {
                id: string;
                handle?: string | undefined;
                url?: string | undefined;
                acct?: string | null | undefined;
                username?: string | null | undefined;
            }[];
            cid?: string | null | undefined;
            uri?: string | null | undefined;
        };
        state: {
            isBookmarkStateFinal: boolean;
        };
        atProto?: {
            viewer?: {
                like?: string | null | undefined;
                embeddingDisabled?: boolean | undefined;
                pinned?: any;
                repost?: any;
                replyDisabled?: boolean | undefined;
                threadMuted?: boolean | undefined;
            } | undefined;
        } | null | undefined;
        replyTo?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
        boostedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
        quotedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
    } | null | undefined;
    quotedFrom?: {
        uuid: string;
        id: string;
        visibility: string;
        createdAt: string;
        postedBy: {
            id: string;
            avatarUrl: string;
            displayName?: string | null | undefined;
            parsedDisplayName: any[];
            handle: string;
            instance: string;
        };
        content: {
            raw?: string | null | undefined;
            parsed: any[];
            media: {
                url: string;
                previewUrl?: string | null | undefined;
                width?: number | null | undefined;
                height?: number | null | undefined;
                alt: string | null;
                type: string;
                blurhash: string | null;
            }[];
        };
        interaction: {
            boosted: boolean;
            liked: boolean;
            bookmarked: boolean;
        };
        stats: {
            replyCount: number;
            boostCount: number;
            likeCount: number;
            reactions: {
                id: string;
                count: number;
                me: boolean;
                accounts: string[];
                url?: string | null | undefined;
            }[];
        };
        calculated: {
            mediaContainerHeight: number;
            emojis: Map<string, string>;
            translationOutput?: string | undefined;
            translationType?: string | undefined;
            reactionEmojis: {
                height?: number | null | undefined;
                width?: number | null | undefined;
                name: string;
                url: string;
            }[];
            mentions: {
                id?: string | null | undefined;
                text?: string | undefined;
                url?: string | null | undefined;
                username?: string | null | undefined;
                acct?: string | null | undefined;
            }[];
        };
        meta: {
            sensitive: boolean;
            cw: string | null;
            isBoost: boolean;
            isReply: boolean;
            mentions: {
                id: string;
                handle?: string | undefined;
                url?: string | undefined;
                acct?: string | null | undefined;
                username?: string | null | undefined;
            }[];
            cid?: string | null | undefined;
            uri?: string | null | undefined;
        };
        state: {
            isBookmarkStateFinal: boolean;
        };
        atProto?: {
            viewer?: {
                like?: string | null | undefined;
                embeddingDisabled?: boolean | undefined;
                pinned?: any;
                repost?: any;
                replyDisabled?: boolean | undefined;
                threadMuted?: boolean | undefined;
            } | undefined;
        } | null | undefined;
        replyTo?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
        boostedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
        quotedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
    } | null | undefined;
    rootPost?: {
        uuid: string;
        id: string;
        visibility: string;
        createdAt: string;
        postedBy: {
            id: string;
            avatarUrl: string;
            displayName?: string | null | undefined;
            parsedDisplayName: any[];
            handle: string;
            instance: string;
        };
        content: {
            raw?: string | null | undefined;
            parsed: any[];
            media: {
                url: string;
                previewUrl?: string | null | undefined;
                width?: number | null | undefined;
                height?: number | null | undefined;
                alt: string | null;
                type: string;
                blurhash: string | null;
            }[];
        };
        interaction: {
            boosted: boolean;
            liked: boolean;
            bookmarked: boolean;
        };
        stats: {
            replyCount: number;
            boostCount: number;
            likeCount: number;
            reactions: {
                id: string;
                count: number;
                me: boolean;
                accounts: string[];
                url?: string | null | undefined;
            }[];
        };
        calculated: {
            mediaContainerHeight: number;
            emojis: Map<string, string>;
            translationOutput?: string | undefined;
            translationType?: string | undefined;
            reactionEmojis: {
                height?: number | null | undefined;
                width?: number | null | undefined;
                name: string;
                url: string;
            }[];
            mentions: {
                id?: string | null | undefined;
                text?: string | undefined;
                url?: string | null | undefined;
                username?: string | null | undefined;
                acct?: string | null | undefined;
            }[];
        };
        meta: {
            sensitive: boolean;
            cw: string | null;
            isBoost: boolean;
            isReply: boolean;
            mentions: {
                id: string;
                handle?: string | undefined;
                url?: string | undefined;
                acct?: string | null | undefined;
                username?: string | null | undefined;
            }[];
            cid?: string | null | undefined;
            uri?: string | null | undefined;
        };
        state: {
            isBookmarkStateFinal: boolean;
        };
        atProto?: {
            viewer?: {
                like?: string | null | undefined;
                embeddingDisabled?: boolean | undefined;
                pinned?: any;
                repost?: any;
                replyDisabled?: boolean | undefined;
                threadMuted?: boolean | undefined;
            } | undefined;
        } | null | undefined;
    } | null | undefined;
}[], Error, {
    uuid: string;
    id: string;
    visibility: string;
    createdAt: string;
    postedBy: {
        id: string;
        avatarUrl: string;
        displayName?: string | null | undefined;
        parsedDisplayName: any[];
        handle: string;
        instance: string;
    };
    content: {
        raw?: string | null | undefined;
        parsed: any[];
        media: {
            url: string;
            previewUrl?: string | null | undefined;
            width?: number | null | undefined;
            height?: number | null | undefined;
            alt: string | null;
            type: string;
            blurhash: string | null;
        }[];
    };
    interaction: {
        boosted: boolean;
        liked: boolean;
        bookmarked: boolean;
    };
    stats: {
        replyCount: number;
        boostCount: number;
        likeCount: number;
        reactions: {
            id: string;
            count: number;
            me: boolean;
            accounts: string[];
            url?: string | null | undefined;
        }[];
    };
    calculated: {
        mediaContainerHeight: number;
        emojis: Map<string, string>;
        translationOutput?: string | undefined;
        translationType?: string | undefined;
        reactionEmojis: {
            height?: number | null | undefined;
            width?: number | null | undefined;
            name: string;
            url: string;
        }[];
        mentions: {
            id?: string | null | undefined;
            text?: string | undefined;
            url?: string | null | undefined;
            username?: string | null | undefined;
            acct?: string | null | undefined;
        }[];
    };
    meta: {
        sensitive: boolean;
        cw: string | null;
        isBoost: boolean;
        isReply: boolean;
        mentions: {
            id: string;
            handle?: string | undefined;
            url?: string | undefined;
            acct?: string | null | undefined;
            username?: string | null | undefined;
        }[];
        cid?: string | null | undefined;
        uri?: string | null | undefined;
    };
    state: {
        isBookmarkStateFinal: boolean;
    };
    atProto?: {
        viewer?: {
            like?: string | null | undefined;
            embeddingDisabled?: boolean | undefined;
            pinned?: any;
            repost?: any;
            replyDisabled?: boolean | undefined;
            threadMuted?: boolean | undefined;
        } | undefined;
    } | null | undefined;
    replyTo?: {
        uuid: string;
        id: string;
        visibility: string;
        createdAt: string;
        postedBy: {
            id: string;
            avatarUrl: string;
            displayName?: string | null | undefined;
            parsedDisplayName: any[];
            handle: string;
            instance: string;
        };
        content: {
            raw?: string | null | undefined;
            parsed: any[];
            media: {
                url: string;
                previewUrl?: string | null | undefined;
                width?: number | null | undefined;
                height?: number | null | undefined;
                alt: string | null;
                type: string;
                blurhash: string | null;
            }[];
        };
        interaction: {
            boosted: boolean;
            liked: boolean;
            bookmarked: boolean;
        };
        stats: {
            replyCount: number;
            boostCount: number;
            likeCount: number;
            reactions: {
                id: string;
                count: number;
                me: boolean;
                accounts: string[];
                url?: string | null | undefined;
            }[];
        };
        calculated: {
            mediaContainerHeight: number;
            emojis: Map<string, string>;
            translationOutput?: string | undefined;
            translationType?: string | undefined;
            reactionEmojis: {
                height?: number | null | undefined;
                width?: number | null | undefined;
                name: string;
                url: string;
            }[];
            mentions: {
                id?: string | null | undefined;
                text?: string | undefined;
                url?: string | null | undefined;
                username?: string | null | undefined;
                acct?: string | null | undefined;
            }[];
        };
        meta: {
            sensitive: boolean;
            cw: string | null;
            isBoost: boolean;
            isReply: boolean;
            mentions: {
                id: string;
                handle?: string | undefined;
                url?: string | undefined;
                acct?: string | null | undefined;
                username?: string | null | undefined;
            }[];
            cid?: string | null | undefined;
            uri?: string | null | undefined;
        };
        state: {
            isBookmarkStateFinal: boolean;
        };
        atProto?: {
            viewer?: {
                like?: string | null | undefined;
                embeddingDisabled?: boolean | undefined;
                pinned?: any;
                repost?: any;
                replyDisabled?: boolean | undefined;
                threadMuted?: boolean | undefined;
            } | undefined;
        } | null | undefined;
        replyTo?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
        boostedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
        quotedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
    } | null | undefined;
    boostedFrom?: {
        uuid: string;
        id: string;
        visibility: string;
        createdAt: string;
        postedBy: {
            id: string;
            avatarUrl: string;
            displayName?: string | null | undefined;
            parsedDisplayName: any[];
            handle: string;
            instance: string;
        };
        content: {
            raw?: string | null | undefined;
            parsed: any[];
            media: {
                url: string;
                previewUrl?: string | null | undefined;
                width?: number | null | undefined;
                height?: number | null | undefined;
                alt: string | null;
                type: string;
                blurhash: string | null;
            }[];
        };
        interaction: {
            boosted: boolean;
            liked: boolean;
            bookmarked: boolean;
        };
        stats: {
            replyCount: number;
            boostCount: number;
            likeCount: number;
            reactions: {
                id: string;
                count: number;
                me: boolean;
                accounts: string[];
                url?: string | null | undefined;
            }[];
        };
        calculated: {
            mediaContainerHeight: number;
            emojis: Map<string, string>;
            translationOutput?: string | undefined;
            translationType?: string | undefined;
            reactionEmojis: {
                height?: number | null | undefined;
                width?: number | null | undefined;
                name: string;
                url: string;
            }[];
            mentions: {
                id?: string | null | undefined;
                text?: string | undefined;
                url?: string | null | undefined;
                username?: string | null | undefined;
                acct?: string | null | undefined;
            }[];
        };
        meta: {
            sensitive: boolean;
            cw: string | null;
            isBoost: boolean;
            isReply: boolean;
            mentions: {
                id: string;
                handle?: string | undefined;
                url?: string | undefined;
                acct?: string | null | undefined;
                username?: string | null | undefined;
            }[];
            cid?: string | null | undefined;
            uri?: string | null | undefined;
        };
        state: {
            isBookmarkStateFinal: boolean;
        };
        atProto?: {
            viewer?: {
                like?: string | null | undefined;
                embeddingDisabled?: boolean | undefined;
                pinned?: any;
                repost?: any;
                replyDisabled?: boolean | undefined;
                threadMuted?: boolean | undefined;
            } | undefined;
        } | null | undefined;
        replyTo?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
        boostedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
        quotedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
    } | null | undefined;
    quotedFrom?: {
        uuid: string;
        id: string;
        visibility: string;
        createdAt: string;
        postedBy: {
            id: string;
            avatarUrl: string;
            displayName?: string | null | undefined;
            parsedDisplayName: any[];
            handle: string;
            instance: string;
        };
        content: {
            raw?: string | null | undefined;
            parsed: any[];
            media: {
                url: string;
                previewUrl?: string | null | undefined;
                width?: number | null | undefined;
                height?: number | null | undefined;
                alt: string | null;
                type: string;
                blurhash: string | null;
            }[];
        };
        interaction: {
            boosted: boolean;
            liked: boolean;
            bookmarked: boolean;
        };
        stats: {
            replyCount: number;
            boostCount: number;
            likeCount: number;
            reactions: {
                id: string;
                count: number;
                me: boolean;
                accounts: string[];
                url?: string | null | undefined;
            }[];
        };
        calculated: {
            mediaContainerHeight: number;
            emojis: Map<string, string>;
            translationOutput?: string | undefined;
            translationType?: string | undefined;
            reactionEmojis: {
                height?: number | null | undefined;
                width?: number | null | undefined;
                name: string;
                url: string;
            }[];
            mentions: {
                id?: string | null | undefined;
                text?: string | undefined;
                url?: string | null | undefined;
                username?: string | null | undefined;
                acct?: string | null | undefined;
            }[];
        };
        meta: {
            sensitive: boolean;
            cw: string | null;
            isBoost: boolean;
            isReply: boolean;
            mentions: {
                id: string;
                handle?: string | undefined;
                url?: string | undefined;
                acct?: string | null | undefined;
                username?: string | null | undefined;
            }[];
            cid?: string | null | undefined;
            uri?: string | null | undefined;
        };
        state: {
            isBookmarkStateFinal: boolean;
        };
        atProto?: {
            viewer?: {
                like?: string | null | undefined;
                embeddingDisabled?: boolean | undefined;
                pinned?: any;
                repost?: any;
                replyDisabled?: boolean | undefined;
                threadMuted?: boolean | undefined;
            } | undefined;
        } | null | undefined;
        replyTo?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
        boostedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
        quotedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
    } | null | undefined;
    rootPost?: {
        uuid: string;
        id: string;
        visibility: string;
        createdAt: string;
        postedBy: {
            id: string;
            avatarUrl: string;
            displayName?: string | null | undefined;
            parsedDisplayName: any[];
            handle: string;
            instance: string;
        };
        content: {
            raw?: string | null | undefined;
            parsed: any[];
            media: {
                url: string;
                previewUrl?: string | null | undefined;
                width?: number | null | undefined;
                height?: number | null | undefined;
                alt: string | null;
                type: string;
                blurhash: string | null;
            }[];
        };
        interaction: {
            boosted: boolean;
            liked: boolean;
            bookmarked: boolean;
        };
        stats: {
            replyCount: number;
            boostCount: number;
            likeCount: number;
            reactions: {
                id: string;
                count: number;
                me: boolean;
                accounts: string[];
                url?: string | null | undefined;
            }[];
        };
        calculated: {
            mediaContainerHeight: number;
            emojis: Map<string, string>;
            translationOutput?: string | undefined;
            translationType?: string | undefined;
            reactionEmojis: {
                height?: number | null | undefined;
                width?: number | null | undefined;
                name: string;
                url: string;
            }[];
            mentions: {
                id?: string | null | undefined;
                text?: string | undefined;
                url?: string | null | undefined;
                username?: string | null | undefined;
                acct?: string | null | undefined;
            }[];
        };
        meta: {
            sensitive: boolean;
            cw: string | null;
            isBoost: boolean;
            isReply: boolean;
            mentions: {
                id: string;
                handle?: string | undefined;
                url?: string | undefined;
                acct?: string | null | undefined;
                username?: string | null | undefined;
            }[];
            cid?: string | null | undefined;
            uri?: string | null | undefined;
        };
        state: {
            isBookmarkStateFinal: boolean;
        };
        atProto?: {
            viewer?: {
                like?: string | null | undefined;
                embeddingDisabled?: boolean | undefined;
                pinned?: any;
                repost?: any;
                replyDisabled?: boolean | undefined;
                threadMuted?: boolean | undefined;
            } | undefined;
        } | null | undefined;
    } | null | undefined;
}[], readonly unknown[]>, "queryFn"> & {
    initialData: {
        uuid: string;
        id: string;
        visibility: string;
        createdAt: string;
        postedBy: {
            id: string;
            avatarUrl: string;
            displayName?: string | null | undefined;
            parsedDisplayName: any[];
            handle: string;
            instance: string;
        };
        content: {
            raw?: string | null | undefined;
            parsed: any[];
            media: {
                url: string;
                previewUrl?: string | null | undefined;
                width?: number | null | undefined;
                height?: number | null | undefined;
                alt: string | null;
                type: string;
                blurhash: string | null;
            }[];
        };
        interaction: {
            boosted: boolean;
            liked: boolean;
            bookmarked: boolean;
        };
        stats: {
            replyCount: number;
            boostCount: number;
            likeCount: number;
            reactions: {
                id: string;
                count: number;
                me: boolean;
                accounts: string[];
                url?: string | null | undefined;
            }[];
        };
        calculated: {
            mediaContainerHeight: number;
            emojis: Map<string, string>;
            translationOutput?: string | undefined;
            translationType?: string | undefined;
            reactionEmojis: {
                height?: number | null | undefined;
                width?: number | null | undefined;
                name: string;
                url: string;
            }[];
            mentions: {
                id?: string | null | undefined;
                text?: string | undefined;
                url?: string | null | undefined;
                username?: string | null | undefined;
                acct?: string | null | undefined;
            }[];
        };
        meta: {
            sensitive: boolean;
            cw: string | null;
            isBoost: boolean;
            isReply: boolean;
            mentions: {
                id: string;
                handle?: string | undefined;
                url?: string | undefined;
                acct?: string | null | undefined;
                username?: string | null | undefined;
            }[];
            cid?: string | null | undefined;
            uri?: string | null | undefined;
        };
        state: {
            isBookmarkStateFinal: boolean;
        };
        atProto?: {
            viewer?: {
                like?: string | null | undefined;
                embeddingDisabled?: boolean | undefined;
                pinned?: any;
                repost?: any;
                replyDisabled?: boolean | undefined;
                threadMuted?: boolean | undefined;
            } | undefined;
        } | null | undefined;
        replyTo?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
            replyTo?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            boostedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            quotedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
        } | null | undefined;
        boostedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
            replyTo?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            boostedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            quotedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
        } | null | undefined;
        quotedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
            replyTo?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            boostedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            quotedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
        } | null | undefined;
        rootPost?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
    }[] | (() => {
        uuid: string;
        id: string;
        visibility: string;
        createdAt: string;
        postedBy: {
            id: string;
            avatarUrl: string;
            displayName?: string | null | undefined;
            parsedDisplayName: any[];
            handle: string;
            instance: string;
        };
        content: {
            raw?: string | null | undefined;
            parsed: any[];
            media: {
                url: string;
                previewUrl?: string | null | undefined;
                width?: number | null | undefined;
                height?: number | null | undefined;
                alt: string | null;
                type: string;
                blurhash: string | null;
            }[];
        };
        interaction: {
            boosted: boolean;
            liked: boolean;
            bookmarked: boolean;
        };
        stats: {
            replyCount: number;
            boostCount: number;
            likeCount: number;
            reactions: {
                id: string;
                count: number;
                me: boolean;
                accounts: string[];
                url?: string | null | undefined;
            }[];
        };
        calculated: {
            mediaContainerHeight: number;
            emojis: Map<string, string>;
            translationOutput?: string | undefined;
            translationType?: string | undefined;
            reactionEmojis: {
                height?: number | null | undefined;
                width?: number | null | undefined;
                name: string;
                url: string;
            }[];
            mentions: {
                id?: string | null | undefined;
                text?: string | undefined;
                url?: string | null | undefined;
                username?: string | null | undefined;
                acct?: string | null | undefined;
            }[];
        };
        meta: {
            sensitive: boolean;
            cw: string | null;
            isBoost: boolean;
            isReply: boolean;
            mentions: {
                id: string;
                handle?: string | undefined;
                url?: string | undefined;
                acct?: string | null | undefined;
                username?: string | null | undefined;
            }[];
            cid?: string | null | undefined;
            uri?: string | null | undefined;
        };
        state: {
            isBookmarkStateFinal: boolean;
        };
        atProto?: {
            viewer?: {
                like?: string | null | undefined;
                embeddingDisabled?: boolean | undefined;
                pinned?: any;
                repost?: any;
                replyDisabled?: boolean | undefined;
                threadMuted?: boolean | undefined;
            } | undefined;
        } | null | undefined;
        replyTo?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
            replyTo?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            boostedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            quotedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
        } | null | undefined;
        boostedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
            replyTo?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            boostedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            quotedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
        } | null | undefined;
        quotedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
            replyTo?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            boostedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            quotedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
        } | null | undefined;
        rootPost?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
    }[]);
    queryFn?: import("@tanstack/react-query").QueryFunction<{
        uuid: string;
        id: string;
        visibility: string;
        createdAt: string;
        postedBy: {
            id: string;
            avatarUrl: string;
            displayName?: string | null | undefined;
            parsedDisplayName: any[];
            handle: string;
            instance: string;
        };
        content: {
            raw?: string | null | undefined;
            parsed: any[];
            media: {
                url: string;
                previewUrl?: string | null | undefined;
                width?: number | null | undefined;
                height?: number | null | undefined;
                alt: string | null;
                type: string;
                blurhash: string | null;
            }[];
        };
        interaction: {
            boosted: boolean;
            liked: boolean;
            bookmarked: boolean;
        };
        stats: {
            replyCount: number;
            boostCount: number;
            likeCount: number;
            reactions: {
                id: string;
                count: number;
                me: boolean;
                accounts: string[];
                url?: string | null | undefined;
            }[];
        };
        calculated: {
            mediaContainerHeight: number;
            emojis: Map<string, string>;
            translationOutput?: string | undefined;
            translationType?: string | undefined;
            reactionEmojis: {
                height?: number | null | undefined;
                width?: number | null | undefined;
                name: string;
                url: string;
            }[];
            mentions: {
                id?: string | null | undefined;
                text?: string | undefined;
                url?: string | null | undefined;
                username?: string | null | undefined;
                acct?: string | null | undefined;
            }[];
        };
        meta: {
            sensitive: boolean;
            cw: string | null;
            isBoost: boolean;
            isReply: boolean;
            mentions: {
                id: string;
                handle?: string | undefined;
                url?: string | undefined;
                acct?: string | null | undefined;
                username?: string | null | undefined;
            }[];
            cid?: string | null | undefined;
            uri?: string | null | undefined;
        };
        state: {
            isBookmarkStateFinal: boolean;
        };
        atProto?: {
            viewer?: {
                like?: string | null | undefined;
                embeddingDisabled?: boolean | undefined;
                pinned?: any;
                repost?: any;
                replyDisabled?: boolean | undefined;
                threadMuted?: boolean | undefined;
            } | undefined;
        } | null | undefined;
        replyTo?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
            replyTo?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            boostedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            quotedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
        } | null | undefined;
        boostedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
            replyTo?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            boostedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            quotedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
        } | null | undefined;
        quotedFrom?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
            replyTo?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            boostedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
            quotedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
        } | null | undefined;
        rootPost?: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
        } | null | undefined;
    }[], readonly unknown[]> | undefined;
} & {
    queryKey: readonly unknown[] & {
        [dataTagSymbol]: {
            uuid: string;
            id: string;
            visibility: string;
            createdAt: string;
            postedBy: {
                id: string;
                avatarUrl: string;
                displayName?: string | null | undefined;
                parsedDisplayName: any[];
                handle: string;
                instance: string;
            };
            content: {
                raw?: string | null | undefined;
                parsed: any[];
                media: {
                    url: string;
                    previewUrl?: string | null | undefined;
                    width?: number | null | undefined;
                    height?: number | null | undefined;
                    alt: string | null;
                    type: string;
                    blurhash: string | null;
                }[];
            };
            interaction: {
                boosted: boolean;
                liked: boolean;
                bookmarked: boolean;
            };
            stats: {
                replyCount: number;
                boostCount: number;
                likeCount: number;
                reactions: {
                    id: string;
                    count: number;
                    me: boolean;
                    accounts: string[];
                    url?: string | null | undefined;
                }[];
            };
            calculated: {
                mediaContainerHeight: number;
                emojis: Map<string, string>;
                translationOutput?: string | undefined;
                translationType?: string | undefined;
                reactionEmojis: {
                    height?: number | null | undefined;
                    width?: number | null | undefined;
                    name: string;
                    url: string;
                }[];
                mentions: {
                    id?: string | null | undefined;
                    text?: string | undefined;
                    url?: string | null | undefined;
                    username?: string | null | undefined;
                    acct?: string | null | undefined;
                }[];
            };
            meta: {
                sensitive: boolean;
                cw: string | null;
                isBoost: boolean;
                isReply: boolean;
                mentions: {
                    id: string;
                    handle?: string | undefined;
                    url?: string | undefined;
                    acct?: string | null | undefined;
                    username?: string | null | undefined;
                }[];
                cid?: string | null | undefined;
                uri?: string | null | undefined;
            };
            state: {
                isBookmarkStateFinal: boolean;
            };
            atProto?: {
                viewer?: {
                    like?: string | null | undefined;
                    embeddingDisabled?: boolean | undefined;
                    pinned?: any;
                    repost?: any;
                    replyDisabled?: boolean | undefined;
                    threadMuted?: boolean | undefined;
                } | undefined;
            } | null | undefined;
            replyTo?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
                replyTo?: {
                    uuid: string;
                    id: string;
                    visibility: string;
                    createdAt: string;
                    postedBy: {
                        id: string;
                        avatarUrl: string;
                        displayName?: string | null | undefined;
                        parsedDisplayName: any[];
                        handle: string;
                        instance: string;
                    };
                    content: {
                        raw?: string | null | undefined;
                        parsed: any[];
                        media: {
                            url: string;
                            previewUrl?: string | null | undefined;
                            width?: number | null | undefined;
                            height?: number | null | undefined;
                            alt: string | null;
                            type: string;
                            blurhash: string | null;
                        }[];
                    };
                    interaction: {
                        boosted: boolean;
                        liked: boolean;
                        bookmarked: boolean;
                    };
                    stats: {
                        replyCount: number;
                        boostCount: number;
                        likeCount: number;
                        reactions: {
                            id: string;
                            count: number;
                            me: boolean;
                            accounts: string[];
                            url?: string | null | undefined;
                        }[];
                    };
                    calculated: {
                        mediaContainerHeight: number;
                        emojis: Map<string, string>;
                        translationOutput?: string | undefined;
                        translationType?: string | undefined;
                        reactionEmojis: {
                            height?: number | null | undefined;
                            width?: number | null | undefined;
                            name: string;
                            url: string;
                        }[];
                        mentions: {
                            id?: string | null | undefined;
                            text?: string | undefined;
                            url?: string | null | undefined;
                            username?: string | null | undefined;
                            acct?: string | null | undefined;
                        }[];
                    };
                    meta: {
                        sensitive: boolean;
                        cw: string | null;
                        isBoost: boolean;
                        isReply: boolean;
                        mentions: {
                            id: string;
                            handle?: string | undefined;
                            url?: string | undefined;
                            acct?: string | null | undefined;
                            username?: string | null | undefined;
                        }[];
                        cid?: string | null | undefined;
                        uri?: string | null | undefined;
                    };
                    state: {
                        isBookmarkStateFinal: boolean;
                    };
                    atProto?: {
                        viewer?: {
                            like?: string | null | undefined;
                            embeddingDisabled?: boolean | undefined;
                            pinned?: any;
                            repost?: any;
                            replyDisabled?: boolean | undefined;
                            threadMuted?: boolean | undefined;
                        } | undefined;
                    } | null | undefined;
                } | null | undefined;
                boostedFrom?: {
                    uuid: string;
                    id: string;
                    visibility: string;
                    createdAt: string;
                    postedBy: {
                        id: string;
                        avatarUrl: string;
                        displayName?: string | null | undefined;
                        parsedDisplayName: any[];
                        handle: string;
                        instance: string;
                    };
                    content: {
                        raw?: string | null | undefined;
                        parsed: any[];
                        media: {
                            url: string;
                            previewUrl?: string | null | undefined;
                            width?: number | null | undefined;
                            height?: number | null | undefined;
                            alt: string | null;
                            type: string;
                            blurhash: string | null;
                        }[];
                    };
                    interaction: {
                        boosted: boolean;
                        liked: boolean;
                        bookmarked: boolean;
                    };
                    stats: {
                        replyCount: number;
                        boostCount: number;
                        likeCount: number;
                        reactions: {
                            id: string;
                            count: number;
                            me: boolean;
                            accounts: string[];
                            url?: string | null | undefined;
                        }[];
                    };
                    calculated: {
                        mediaContainerHeight: number;
                        emojis: Map<string, string>;
                        translationOutput?: string | undefined;
                        translationType?: string | undefined;
                        reactionEmojis: {
                            height?: number | null | undefined;
                            width?: number | null | undefined;
                            name: string;
                            url: string;
                        }[];
                        mentions: {
                            id?: string | null | undefined;
                            text?: string | undefined;
                            url?: string | null | undefined;
                            username?: string | null | undefined;
                            acct?: string | null | undefined;
                        }[];
                    };
                    meta: {
                        sensitive: boolean;
                        cw: string | null;
                        isBoost: boolean;
                        isReply: boolean;
                        mentions: {
                            id: string;
                            handle?: string | undefined;
                            url?: string | undefined;
                            acct?: string | null | undefined;
                            username?: string | null | undefined;
                        }[];
                        cid?: string | null | undefined;
                        uri?: string | null | undefined;
                    };
                    state: {
                        isBookmarkStateFinal: boolean;
                    };
                    atProto?: {
                        viewer?: {
                            like?: string | null | undefined;
                            embeddingDisabled?: boolean | undefined;
                            pinned?: any;
                            repost?: any;
                            replyDisabled?: boolean | undefined;
                            threadMuted?: boolean | undefined;
                        } | undefined;
                    } | null | undefined;
                } | null | undefined;
                quotedFrom?: {
                    uuid: string;
                    id: string;
                    visibility: string;
                    createdAt: string;
                    postedBy: {
                        id: string;
                        avatarUrl: string;
                        displayName?: string | null | undefined;
                        parsedDisplayName: any[];
                        handle: string;
                        instance: string;
                    };
                    content: {
                        raw?: string | null | undefined;
                        parsed: any[];
                        media: {
                            url: string;
                            previewUrl?: string | null | undefined;
                            width?: number | null | undefined;
                            height?: number | null | undefined;
                            alt: string | null;
                            type: string;
                            blurhash: string | null;
                        }[];
                    };
                    interaction: {
                        boosted: boolean;
                        liked: boolean;
                        bookmarked: boolean;
                    };
                    stats: {
                        replyCount: number;
                        boostCount: number;
                        likeCount: number;
                        reactions: {
                            id: string;
                            count: number;
                            me: boolean;
                            accounts: string[];
                            url?: string | null | undefined;
                        }[];
                    };
                    calculated: {
                        mediaContainerHeight: number;
                        emojis: Map<string, string>;
                        translationOutput?: string | undefined;
                        translationType?: string | undefined;
                        reactionEmojis: {
                            height?: number | null | undefined;
                            width?: number | null | undefined;
                            name: string;
                            url: string;
                        }[];
                        mentions: {
                            id?: string | null | undefined;
                            text?: string | undefined;
                            url?: string | null | undefined;
                            username?: string | null | undefined;
                            acct?: string | null | undefined;
                        }[];
                    };
                    meta: {
                        sensitive: boolean;
                        cw: string | null;
                        isBoost: boolean;
                        isReply: boolean;
                        mentions: {
                            id: string;
                            handle?: string | undefined;
                            url?: string | undefined;
                            acct?: string | null | undefined;
                            username?: string | null | undefined;
                        }[];
                        cid?: string | null | undefined;
                        uri?: string | null | undefined;
                    };
                    state: {
                        isBookmarkStateFinal: boolean;
                    };
                    atProto?: {
                        viewer?: {
                            like?: string | null | undefined;
                            embeddingDisabled?: boolean | undefined;
                            pinned?: any;
                            repost?: any;
                            replyDisabled?: boolean | undefined;
                            threadMuted?: boolean | undefined;
                        } | undefined;
                    } | null | undefined;
                } | null | undefined;
            } | null | undefined;
            boostedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
                replyTo?: {
                    uuid: string;
                    id: string;
                    visibility: string;
                    createdAt: string;
                    postedBy: {
                        id: string;
                        avatarUrl: string;
                        displayName?: string | null | undefined;
                        parsedDisplayName: any[];
                        handle: string;
                        instance: string;
                    };
                    content: {
                        raw?: string | null | undefined;
                        parsed: any[];
                        media: {
                            url: string;
                            previewUrl?: string | null | undefined;
                            width?: number | null | undefined;
                            height?: number | null | undefined;
                            alt: string | null;
                            type: string;
                            blurhash: string | null;
                        }[];
                    };
                    interaction: {
                        boosted: boolean;
                        liked: boolean;
                        bookmarked: boolean;
                    };
                    stats: {
                        replyCount: number;
                        boostCount: number;
                        likeCount: number;
                        reactions: {
                            id: string;
                            count: number;
                            me: boolean;
                            accounts: string[];
                            url?: string | null | undefined;
                        }[];
                    };
                    calculated: {
                        mediaContainerHeight: number;
                        emojis: Map<string, string>;
                        translationOutput?: string | undefined;
                        translationType?: string | undefined;
                        reactionEmojis: {
                            height?: number | null | undefined;
                            width?: number | null | undefined;
                            name: string;
                            url: string;
                        }[];
                        mentions: {
                            id?: string | null | undefined;
                            text?: string | undefined;
                            url?: string | null | undefined;
                            username?: string | null | undefined;
                            acct?: string | null | undefined;
                        }[];
                    };
                    meta: {
                        sensitive: boolean;
                        cw: string | null;
                        isBoost: boolean;
                        isReply: boolean;
                        mentions: {
                            id: string;
                            handle?: string | undefined;
                            url?: string | undefined;
                            acct?: string | null | undefined;
                            username?: string | null | undefined;
                        }[];
                        cid?: string | null | undefined;
                        uri?: string | null | undefined;
                    };
                    state: {
                        isBookmarkStateFinal: boolean;
                    };
                    atProto?: {
                        viewer?: {
                            like?: string | null | undefined;
                            embeddingDisabled?: boolean | undefined;
                            pinned?: any;
                            repost?: any;
                            replyDisabled?: boolean | undefined;
                            threadMuted?: boolean | undefined;
                        } | undefined;
                    } | null | undefined;
                } | null | undefined;
                boostedFrom?: {
                    uuid: string;
                    id: string;
                    visibility: string;
                    createdAt: string;
                    postedBy: {
                        id: string;
                        avatarUrl: string;
                        displayName?: string | null | undefined;
                        parsedDisplayName: any[];
                        handle: string;
                        instance: string;
                    };
                    content: {
                        raw?: string | null | undefined;
                        parsed: any[];
                        media: {
                            url: string;
                            previewUrl?: string | null | undefined;
                            width?: number | null | undefined;
                            height?: number | null | undefined;
                            alt: string | null;
                            type: string;
                            blurhash: string | null;
                        }[];
                    };
                    interaction: {
                        boosted: boolean;
                        liked: boolean;
                        bookmarked: boolean;
                    };
                    stats: {
                        replyCount: number;
                        boostCount: number;
                        likeCount: number;
                        reactions: {
                            id: string;
                            count: number;
                            me: boolean;
                            accounts: string[];
                            url?: string | null | undefined;
                        }[];
                    };
                    calculated: {
                        mediaContainerHeight: number;
                        emojis: Map<string, string>;
                        translationOutput?: string | undefined;
                        translationType?: string | undefined;
                        reactionEmojis: {
                            height?: number | null | undefined;
                            width?: number | null | undefined;
                            name: string;
                            url: string;
                        }[];
                        mentions: {
                            id?: string | null | undefined;
                            text?: string | undefined;
                            url?: string | null | undefined;
                            username?: string | null | undefined;
                            acct?: string | null | undefined;
                        }[];
                    };
                    meta: {
                        sensitive: boolean;
                        cw: string | null;
                        isBoost: boolean;
                        isReply: boolean;
                        mentions: {
                            id: string;
                            handle?: string | undefined;
                            url?: string | undefined;
                            acct?: string | null | undefined;
                            username?: string | null | undefined;
                        }[];
                        cid?: string | null | undefined;
                        uri?: string | null | undefined;
                    };
                    state: {
                        isBookmarkStateFinal: boolean;
                    };
                    atProto?: {
                        viewer?: {
                            like?: string | null | undefined;
                            embeddingDisabled?: boolean | undefined;
                            pinned?: any;
                            repost?: any;
                            replyDisabled?: boolean | undefined;
                            threadMuted?: boolean | undefined;
                        } | undefined;
                    } | null | undefined;
                } | null | undefined;
                quotedFrom?: {
                    uuid: string;
                    id: string;
                    visibility: string;
                    createdAt: string;
                    postedBy: {
                        id: string;
                        avatarUrl: string;
                        displayName?: string | null | undefined;
                        parsedDisplayName: any[];
                        handle: string;
                        instance: string;
                    };
                    content: {
                        raw?: string | null | undefined;
                        parsed: any[];
                        media: {
                            url: string;
                            previewUrl?: string | null | undefined;
                            width?: number | null | undefined;
                            height?: number | null | undefined;
                            alt: string | null;
                            type: string;
                            blurhash: string | null;
                        }[];
                    };
                    interaction: {
                        boosted: boolean;
                        liked: boolean;
                        bookmarked: boolean;
                    };
                    stats: {
                        replyCount: number;
                        boostCount: number;
                        likeCount: number;
                        reactions: {
                            id: string;
                            count: number;
                            me: boolean;
                            accounts: string[];
                            url?: string | null | undefined;
                        }[];
                    };
                    calculated: {
                        mediaContainerHeight: number;
                        emojis: Map<string, string>;
                        translationOutput?: string | undefined;
                        translationType?: string | undefined;
                        reactionEmojis: {
                            height?: number | null | undefined;
                            width?: number | null | undefined;
                            name: string;
                            url: string;
                        }[];
                        mentions: {
                            id?: string | null | undefined;
                            text?: string | undefined;
                            url?: string | null | undefined;
                            username?: string | null | undefined;
                            acct?: string | null | undefined;
                        }[];
                    };
                    meta: {
                        sensitive: boolean;
                        cw: string | null;
                        isBoost: boolean;
                        isReply: boolean;
                        mentions: {
                            id: string;
                            handle?: string | undefined;
                            url?: string | undefined;
                            acct?: string | null | undefined;
                            username?: string | null | undefined;
                        }[];
                        cid?: string | null | undefined;
                        uri?: string | null | undefined;
                    };
                    state: {
                        isBookmarkStateFinal: boolean;
                    };
                    atProto?: {
                        viewer?: {
                            like?: string | null | undefined;
                            embeddingDisabled?: boolean | undefined;
                            pinned?: any;
                            repost?: any;
                            replyDisabled?: boolean | undefined;
                            threadMuted?: boolean | undefined;
                        } | undefined;
                    } | null | undefined;
                } | null | undefined;
            } | null | undefined;
            quotedFrom?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
                replyTo?: {
                    uuid: string;
                    id: string;
                    visibility: string;
                    createdAt: string;
                    postedBy: {
                        id: string;
                        avatarUrl: string;
                        displayName?: string | null | undefined;
                        parsedDisplayName: any[];
                        handle: string;
                        instance: string;
                    };
                    content: {
                        raw?: string | null | undefined;
                        parsed: any[];
                        media: {
                            url: string;
                            previewUrl?: string | null | undefined;
                            width?: number | null | undefined;
                            height?: number | null | undefined;
                            alt: string | null;
                            type: string;
                            blurhash: string | null;
                        }[];
                    };
                    interaction: {
                        boosted: boolean;
                        liked: boolean;
                        bookmarked: boolean;
                    };
                    stats: {
                        replyCount: number;
                        boostCount: number;
                        likeCount: number;
                        reactions: {
                            id: string;
                            count: number;
                            me: boolean;
                            accounts: string[];
                            url?: string | null | undefined;
                        }[];
                    };
                    calculated: {
                        mediaContainerHeight: number;
                        emojis: Map<string, string>;
                        translationOutput?: string | undefined;
                        translationType?: string | undefined;
                        reactionEmojis: {
                            height?: number | null | undefined;
                            width?: number | null | undefined;
                            name: string;
                            url: string;
                        }[];
                        mentions: {
                            id?: string | null | undefined;
                            text?: string | undefined;
                            url?: string | null | undefined;
                            username?: string | null | undefined;
                            acct?: string | null | undefined;
                        }[];
                    };
                    meta: {
                        sensitive: boolean;
                        cw: string | null;
                        isBoost: boolean;
                        isReply: boolean;
                        mentions: {
                            id: string;
                            handle?: string | undefined;
                            url?: string | undefined;
                            acct?: string | null | undefined;
                            username?: string | null | undefined;
                        }[];
                        cid?: string | null | undefined;
                        uri?: string | null | undefined;
                    };
                    state: {
                        isBookmarkStateFinal: boolean;
                    };
                    atProto?: {
                        viewer?: {
                            like?: string | null | undefined;
                            embeddingDisabled?: boolean | undefined;
                            pinned?: any;
                            repost?: any;
                            replyDisabled?: boolean | undefined;
                            threadMuted?: boolean | undefined;
                        } | undefined;
                    } | null | undefined;
                } | null | undefined;
                boostedFrom?: {
                    uuid: string;
                    id: string;
                    visibility: string;
                    createdAt: string;
                    postedBy: {
                        id: string;
                        avatarUrl: string;
                        displayName?: string | null | undefined;
                        parsedDisplayName: any[];
                        handle: string;
                        instance: string;
                    };
                    content: {
                        raw?: string | null | undefined;
                        parsed: any[];
                        media: {
                            url: string;
                            previewUrl?: string | null | undefined;
                            width?: number | null | undefined;
                            height?: number | null | undefined;
                            alt: string | null;
                            type: string;
                            blurhash: string | null;
                        }[];
                    };
                    interaction: {
                        boosted: boolean;
                        liked: boolean;
                        bookmarked: boolean;
                    };
                    stats: {
                        replyCount: number;
                        boostCount: number;
                        likeCount: number;
                        reactions: {
                            id: string;
                            count: number;
                            me: boolean;
                            accounts: string[];
                            url?: string | null | undefined;
                        }[];
                    };
                    calculated: {
                        mediaContainerHeight: number;
                        emojis: Map<string, string>;
                        translationOutput?: string | undefined;
                        translationType?: string | undefined;
                        reactionEmojis: {
                            height?: number | null | undefined;
                            width?: number | null | undefined;
                            name: string;
                            url: string;
                        }[];
                        mentions: {
                            id?: string | null | undefined;
                            text?: string | undefined;
                            url?: string | null | undefined;
                            username?: string | null | undefined;
                            acct?: string | null | undefined;
                        }[];
                    };
                    meta: {
                        sensitive: boolean;
                        cw: string | null;
                        isBoost: boolean;
                        isReply: boolean;
                        mentions: {
                            id: string;
                            handle?: string | undefined;
                            url?: string | undefined;
                            acct?: string | null | undefined;
                            username?: string | null | undefined;
                        }[];
                        cid?: string | null | undefined;
                        uri?: string | null | undefined;
                    };
                    state: {
                        isBookmarkStateFinal: boolean;
                    };
                    atProto?: {
                        viewer?: {
                            like?: string | null | undefined;
                            embeddingDisabled?: boolean | undefined;
                            pinned?: any;
                            repost?: any;
                            replyDisabled?: boolean | undefined;
                            threadMuted?: boolean | undefined;
                        } | undefined;
                    } | null | undefined;
                } | null | undefined;
                quotedFrom?: {
                    uuid: string;
                    id: string;
                    visibility: string;
                    createdAt: string;
                    postedBy: {
                        id: string;
                        avatarUrl: string;
                        displayName?: string | null | undefined;
                        parsedDisplayName: any[];
                        handle: string;
                        instance: string;
                    };
                    content: {
                        raw?: string | null | undefined;
                        parsed: any[];
                        media: {
                            url: string;
                            previewUrl?: string | null | undefined;
                            width?: number | null | undefined;
                            height?: number | null | undefined;
                            alt: string | null;
                            type: string;
                            blurhash: string | null;
                        }[];
                    };
                    interaction: {
                        boosted: boolean;
                        liked: boolean;
                        bookmarked: boolean;
                    };
                    stats: {
                        replyCount: number;
                        boostCount: number;
                        likeCount: number;
                        reactions: {
                            id: string;
                            count: number;
                            me: boolean;
                            accounts: string[];
                            url?: string | null | undefined;
                        }[];
                    };
                    calculated: {
                        mediaContainerHeight: number;
                        emojis: Map<string, string>;
                        translationOutput?: string | undefined;
                        translationType?: string | undefined;
                        reactionEmojis: {
                            height?: number | null | undefined;
                            width?: number | null | undefined;
                            name: string;
                            url: string;
                        }[];
                        mentions: {
                            id?: string | null | undefined;
                            text?: string | undefined;
                            url?: string | null | undefined;
                            username?: string | null | undefined;
                            acct?: string | null | undefined;
                        }[];
                    };
                    meta: {
                        sensitive: boolean;
                        cw: string | null;
                        isBoost: boolean;
                        isReply: boolean;
                        mentions: {
                            id: string;
                            handle?: string | undefined;
                            url?: string | undefined;
                            acct?: string | null | undefined;
                            username?: string | null | undefined;
                        }[];
                        cid?: string | null | undefined;
                        uri?: string | null | undefined;
                    };
                    state: {
                        isBookmarkStateFinal: boolean;
                    };
                    atProto?: {
                        viewer?: {
                            like?: string | null | undefined;
                            embeddingDisabled?: boolean | undefined;
                            pinned?: any;
                            repost?: any;
                            replyDisabled?: boolean | undefined;
                            threadMuted?: boolean | undefined;
                        } | undefined;
                    } | null | undefined;
                } | null | undefined;
            } | null | undefined;
            rootPost?: {
                uuid: string;
                id: string;
                visibility: string;
                createdAt: string;
                postedBy: {
                    id: string;
                    avatarUrl: string;
                    displayName?: string | null | undefined;
                    parsedDisplayName: any[];
                    handle: string;
                    instance: string;
                };
                content: {
                    raw?: string | null | undefined;
                    parsed: any[];
                    media: {
                        url: string;
                        previewUrl?: string | null | undefined;
                        width?: number | null | undefined;
                        height?: number | null | undefined;
                        alt: string | null;
                        type: string;
                        blurhash: string | null;
                    }[];
                };
                interaction: {
                    boosted: boolean;
                    liked: boolean;
                    bookmarked: boolean;
                };
                stats: {
                    replyCount: number;
                    boostCount: number;
                    likeCount: number;
                    reactions: {
                        id: string;
                        count: number;
                        me: boolean;
                        accounts: string[];
                        url?: string | null | undefined;
                    }[];
                };
                calculated: {
                    mediaContainerHeight: number;
                    emojis: Map<string, string>;
                    translationOutput?: string | undefined;
                    translationType?: string | undefined;
                    reactionEmojis: {
                        height?: number | null | undefined;
                        width?: number | null | undefined;
                        name: string;
                        url: string;
                    }[];
                    mentions: {
                        id?: string | null | undefined;
                        text?: string | undefined;
                        url?: string | null | undefined;
                        username?: string | null | undefined;
                        acct?: string | null | undefined;
                    }[];
                };
                meta: {
                    sensitive: boolean;
                    cw: string | null;
                    isBoost: boolean;
                    isReply: boolean;
                    mentions: {
                        id: string;
                        handle?: string | undefined;
                        url?: string | undefined;
                        acct?: string | null | undefined;
                        username?: string | null | undefined;
                    }[];
                    cid?: string | null | undefined;
                    uri?: string | null | undefined;
                };
                state: {
                    isBookmarkStateFinal: boolean;
                };
                atProto?: {
                    viewer?: {
                        like?: string | null | undefined;
                        embeddingDisabled?: boolean | undefined;
                        pinned?: any;
                        repost?: any;
                        replyDisabled?: boolean | undefined;
                        threadMuted?: boolean | undefined;
                    } | undefined;
                } | null | undefined;
            } | null | undefined;
        }[];
        [dataTagErrorSymbol]: Error;
    };
};
//# sourceMappingURL=user.d.ts.map