import { ActivityPubService, defaultResultPage, DriverService, FeedParser, KNOWN_SOFTWARE, PostParser, UserParser, } from '@dhaaga/bridge';
import { queryOptions } from '@tanstack/react-query';
export function searchFeedsQueryOpts(client, driver, server, q, maxId) {
    async function api() {
        if (!q)
            return defaultResultPage;
        const { data, error } = await client.search.findFeeds({
            limit: 5,
            query: q,
            cursor: maxId,
        });
        if (error)
            return defaultResultPage;
        return {
            ...defaultResultPage,
            items: FeedParser.parse(data.feeds, driver, server),
            maxId: data.cursor,
        };
    }
    return queryOptions({
        queryKey: ['search/feeds', server, q, maxId],
        queryFn: api,
        enabled: !!client && DriverService.supportsAtProto(driver),
        initialData: defaultResultPage,
    });
}
export function searchPostsQueryOpts(client, driver, server, q, maxId, sort) {
    async function api() {
        const FALLBACK_TO_OFFSET = [
            KNOWN_SOFTWARE.AKKOMA,
            KNOWN_SOFTWARE.SHARKEY,
        ].includes(driver);
        const offset = FALLBACK_TO_OFFSET
            ? maxId
                ? parseInt(maxId)
                : undefined
            : undefined;
        const _maxId = FALLBACK_TO_OFFSET ? undefined : maxId;
        const _untilId = FALLBACK_TO_OFFSET ? undefined : maxId;
        const { data, error } = await client.search.findPosts({
            maxId: _maxId,
            q,
            limit: 10,
            query: q,
            type: 'statuses',
            sort: sort, // for bluesky
            untilId: !!_untilId ? _untilId : undefined,
            offset,
        });
        if (error) {
            console.log('[WARN]: error searching for posts', error.message);
            throw new Error(error.message);
        }
        if (DriverService.supportsAtProto(driver)) {
            const _data = data;
            return {
                ...defaultResultPage,
                maxId: _data.data.cursor,
                items: PostParser.parse(_data.data.posts, driver, server),
            };
        }
        const _posts = PostParser.parse(data, driver, server);
        let __maxId = null;
        if (FALLBACK_TO_OFFSET) {
            try {
                __maxId = (parseInt(__maxId ?? '0') + _posts.length).toString();
            }
            catch (e) {
                console.log('[WARN]:could not generate post pagination token for certain drivers');
            }
        }
        else {
            __maxId = data[_posts.length - 1].id;
        }
        return {
            maxId: __maxId,
            items: _posts,
            minId: null,
        };
    }
    return queryOptions({
        queryKey: ['search/posts', server, q, maxId, sort],
        queryFn: api,
        enabled: client !== null && !!q,
        initialData: defaultResultPage,
    });
}
export function searchUsersQueryOpts(client, driver, server, q, maxId) {
    async function api() {
        const { data, error } = await client.search.findUsers({
            maxId,
            q,
            limit: 10,
            query: q,
            type: 'accounts',
            untilId: maxId,
        });
        if (error) {
            console.log('[WARN]: error searching for posts', error.message);
            throw new Error(error.message);
        }
        if (ActivityPubService.blueskyLike(driver)) {
            return UserParser.parse(data.data.actors, driver, server);
        }
        else {
            return UserParser.parse(data, driver, server);
        }
    }
    return queryOptions({
        queryKey: ['search/users', server, q, maxId],
        queryFn: api,
        enabled: client !== null && !!q,
        initialData: [],
    });
}
//# sourceMappingURL=search.js.map