import { ApiTargetInterface, AtprotoApiAdapter, type FeedObjectType, KNOWN_SOFTWARE, type PostObjectType, type ResultPage } from '@dhaaga/bridge';
type PostResultPage = ResultPage<PostObjectType>;
type FeedResultPage = ResultPage<FeedObjectType>;
export declare function searchFeedsQueryOpts(client: AtprotoApiAdapter, driver: KNOWN_SOFTWARE, server: string, q: string, maxId?: string): Omit<import("@tanstack/react-query").UseQueryOptions<FeedResultPage, Error, FeedResultPage, readonly unknown[]>, "queryFn"> & {
    initialData: FeedResultPage | (() => FeedResultPage);
    queryFn?: import("@tanstack/react-query").QueryFunction<FeedResultPage, readonly unknown[]> | undefined;
} & {
    queryKey: readonly unknown[] & {
        [dataTagSymbol]: FeedResultPage;
        [dataTagErrorSymbol]: Error;
    };
};
export declare function searchPostsQueryOpts(client: ApiTargetInterface, driver: KNOWN_SOFTWARE, server: string, q: string, maxId?: string, sort?: 'top' | 'latest'): Omit<import("@tanstack/react-query").UseQueryOptions<PostResultPage, Error, PostResultPage, readonly unknown[]>, "queryFn"> & {
    initialData: PostResultPage | (() => PostResultPage);
    queryFn?: import("@tanstack/react-query").QueryFunction<PostResultPage, readonly unknown[]> | undefined;
} & {
    queryKey: readonly unknown[] & {
        [dataTagSymbol]: PostResultPage;
        [dataTagErrorSymbol]: Error;
    };
};
export declare function searchUsersQueryOpts(client: AtprotoApiAdapter, driver: KNOWN_SOFTWARE, server: string, q: string, maxId?: string): Omit<import("@tanstack/react-query").UseQueryOptions<{
    id: string;
    avatarUrl: string;
    displayName: string | null;
    parsedDisplayName: any[];
    handle: string;
    instance: string;
    banner?: string | null | undefined;
    meta: {
        isProfileLocked: boolean;
        isBot: boolean;
        fields: {
            name?: string | undefined;
            value?: string | undefined;
            verifiedAt?: string | null | undefined;
            cid?: string | undefined;
            cts?: string | undefined;
            src?: string | undefined;
            uri?: string | undefined;
            val?: string | undefined;
        }[];
    };
    description: string;
    parsedDescription: any[];
    stats: {
        posts: number | null;
        followers: number | null;
        following: number | null;
    };
    calculated: {
        emojis: Map<string, string>;
    };
    relationship: {
        blocking: boolean | null;
        blockedBy: boolean | null;
        domainBlocking: boolean | null;
        followedBy: boolean | null;
        following: boolean | null;
        muting: boolean | null;
        mutingNotifications: boolean | null;
        note: string | null;
        requested: boolean | null;
        requestedBy: boolean | null;
        showingReblogs: boolean | null;
    };
}[], Error, {
    id: string;
    avatarUrl: string;
    displayName: string | null;
    parsedDisplayName: any[];
    handle: string;
    instance: string;
    banner?: string | null | undefined;
    meta: {
        isProfileLocked: boolean;
        isBot: boolean;
        fields: {
            name?: string | undefined;
            value?: string | undefined;
            verifiedAt?: string | null | undefined;
            cid?: string | undefined;
            cts?: string | undefined;
            src?: string | undefined;
            uri?: string | undefined;
            val?: string | undefined;
        }[];
    };
    description: string;
    parsedDescription: any[];
    stats: {
        posts: number | null;
        followers: number | null;
        following: number | null;
    };
    calculated: {
        emojis: Map<string, string>;
    };
    relationship: {
        blocking: boolean | null;
        blockedBy: boolean | null;
        domainBlocking: boolean | null;
        followedBy: boolean | null;
        following: boolean | null;
        muting: boolean | null;
        mutingNotifications: boolean | null;
        note: string | null;
        requested: boolean | null;
        requestedBy: boolean | null;
        showingReblogs: boolean | null;
    };
}[], readonly unknown[]>, "queryFn"> & {
    initialData: {
        id: string;
        avatarUrl: string;
        displayName: string | null;
        parsedDisplayName: any[];
        handle: string;
        instance: string;
        banner?: string | null | undefined;
        meta: {
            isProfileLocked: boolean;
            isBot: boolean;
            fields: {
                name?: string | undefined;
                value?: string | undefined;
                verifiedAt?: string | null | undefined;
                cid?: string | undefined;
                cts?: string | undefined;
                src?: string | undefined;
                uri?: string | undefined;
                val?: string | undefined;
            }[];
        };
        description: string;
        parsedDescription: any[];
        stats: {
            posts: number | null;
            followers: number | null;
            following: number | null;
        };
        calculated: {
            emojis: Map<string, string>;
        };
        relationship: {
            blocking: boolean | null;
            blockedBy: boolean | null;
            domainBlocking: boolean | null;
            followedBy: boolean | null;
            following: boolean | null;
            muting: boolean | null;
            mutingNotifications: boolean | null;
            note: string | null;
            requested: boolean | null;
            requestedBy: boolean | null;
            showingReblogs: boolean | null;
        };
    }[] | (() => {
        id: string;
        avatarUrl: string;
        displayName: string | null;
        parsedDisplayName: any[];
        handle: string;
        instance: string;
        banner?: string | null | undefined;
        meta: {
            isProfileLocked: boolean;
            isBot: boolean;
            fields: {
                name?: string | undefined;
                value?: string | undefined;
                verifiedAt?: string | null | undefined;
                cid?: string | undefined;
                cts?: string | undefined;
                src?: string | undefined;
                uri?: string | undefined;
                val?: string | undefined;
            }[];
        };
        description: string;
        parsedDescription: any[];
        stats: {
            posts: number | null;
            followers: number | null;
            following: number | null;
        };
        calculated: {
            emojis: Map<string, string>;
        };
        relationship: {
            blocking: boolean | null;
            blockedBy: boolean | null;
            domainBlocking: boolean | null;
            followedBy: boolean | null;
            following: boolean | null;
            muting: boolean | null;
            mutingNotifications: boolean | null;
            note: string | null;
            requested: boolean | null;
            requestedBy: boolean | null;
            showingReblogs: boolean | null;
        };
    }[]);
    queryFn?: import("@tanstack/react-query").QueryFunction<{
        id: string;
        avatarUrl: string;
        displayName: string | null;
        parsedDisplayName: any[];
        handle: string;
        instance: string;
        banner?: string | null | undefined;
        meta: {
            isProfileLocked: boolean;
            isBot: boolean;
            fields: {
                name?: string | undefined;
                value?: string | undefined;
                verifiedAt?: string | null | undefined;
                cid?: string | undefined;
                cts?: string | undefined;
                src?: string | undefined;
                uri?: string | undefined;
                val?: string | undefined;
            }[];
        };
        description: string;
        parsedDescription: any[];
        stats: {
            posts: number | null;
            followers: number | null;
            following: number | null;
        };
        calculated: {
            emojis: Map<string, string>;
        };
        relationship: {
            blocking: boolean | null;
            blockedBy: boolean | null;
            domainBlocking: boolean | null;
            followedBy: boolean | null;
            following: boolean | null;
            muting: boolean | null;
            mutingNotifications: boolean | null;
            note: string | null;
            requested: boolean | null;
            requestedBy: boolean | null;
            showingReblogs: boolean | null;
        };
    }[], readonly unknown[]> | undefined;
} & {
    queryKey: readonly unknown[] & {
        [dataTagSymbol]: {
            id: string;
            avatarUrl: string;
            displayName: string | null;
            parsedDisplayName: any[];
            handle: string;
            instance: string;
            banner?: string | null | undefined;
            meta: {
                isProfileLocked: boolean;
                isBot: boolean;
                fields: {
                    name?: string | undefined;
                    value?: string | undefined;
                    verifiedAt?: string | null | undefined;
                    cid?: string | undefined;
                    cts?: string | undefined;
                    src?: string | undefined;
                    uri?: string | undefined;
                    val?: string | undefined;
                }[];
            };
            description: string;
            parsedDescription: any[];
            stats: {
                posts: number | null;
                followers: number | null;
                following: number | null;
            };
            calculated: {
                emojis: Map<string, string>;
            };
            relationship: {
                blocking: boolean | null;
                blockedBy: boolean | null;
                domainBlocking: boolean | null;
                followedBy: boolean | null;
                following: boolean | null;
                muting: boolean | null;
                mutingNotifications: boolean | null;
                note: string | null;
                requested: boolean | null;
                requestedBy: boolean | null;
                showingReblogs: boolean | null;
            };
        }[];
        [dataTagErrorSymbol]: Error;
    };
};
export {};
//# sourceMappingURL=search.d.ts.map