import { DriverService, PostParser, } from '@dhaaga/bridge';
import { queryOptions } from '@tanstack/react-query';
export function postDetailsInterfaceQueryOpts(client, driver, postId) {
    async function api() {
        if (!client)
            throw new Error('_client not initialized');
        const { data, error } = await client.statuses.get(postId);
        if (error)
            throw new Error(error.message);
        return PostParser.rawToInterface(data, driver);
    }
    return queryOptions({
        queryKey: ['post/view', postId],
        queryFn: api,
        enabled: client && postId !== undefined,
    });
}
export function postHierarchyQueryOpts(client, driver, postId) {
    async function api() {
        const { data, error } = await client.statuses.getContext(postId);
        if (error)
            return null;
        if (DriverService.supportsAtProto(driver))
            return data;
        return {
            ancestors: PostParser.rawToInterface(data.ancestors, driver),
            descendants: PostParser.rawToInterface(data.descendants, driver),
        };
    }
    return queryOptions({
        queryKey: ['post/hierarchy', postId],
        queryFn: api,
        enabled: !!client && postId !== undefined,
    });
}
//# sourceMappingURL=post.js.map