import { useEffect, useState, useRef } from 'react';
import { RandomUtil, verifyMisskeyToken } from '@dhaaga/bridge';
function useMiauthLogin(instance, signInUrl) {
    const [Code, setCode] = useState(null);
    const [IsLoading, setIsLoading] = useState(false);
    const [Error, setError] = useState(null);
    const [UserData, setUserData] = useState();
    const [AuthCompleted, setAuthCompleted] = useState(false);
    async function autoVerifyFromSession(session) {
        if (AuthCompleted)
            return;
        const res = await verifyMisskeyToken(`https://${instance}`, session);
        if (res.ok) {
            setCode(res.token);
            setUserData({
                id: res?.user?.id,
                displayName: res?.user?.name,
                username: res?.user?.username,
                avatar: res?.user?.avatarUrl,
            });
            setAuthCompleted(true);
        }
    }
    const lastState = useRef(null);
    function resetAuth() {
        setIsLoading(false);
        setCode(null);
        setError(null);
        setUserData(null);
        setAuthCompleted(false);
    }
    function RNWebviewStateChangeCallback(state) {
        console.log(state);
        if (state.url === lastState.current)
            return;
        const regex = /^https:\/\/suvam\.io\/\?session=([^&]+)/;
        const match = state.url.match(regex);
        if (match) {
            const session = match[1];
            lastState.current = state.url;
            autoVerifyFromSession(session);
        }
    }
    useEffect(() => {
        try {
            const regex = /^https:\/\/(.*?)\/miauth\/(.*?)\?.*?/;
            if (regex.test(signInUrl)) {
                const session = regex.exec(signInUrl)[2];
                setCode(session);
            }
        }
        catch (e) {
            setCode(RandomUtil.nanoId());
        }
    }, []);
    async function authenticate() {
        return UserData;
    }
    return {
        RNWebviewStateChangeCallback,
        authenticate,
        completed: AuthCompleted,
        loading: IsLoading,
        error: Error,
        userData: UserData,
        code: Code,
        setCode,
        reset: resetAuth,
    };
}
export default useMiauthLogin;
//# sourceMappingURL=useMiauthLogin.js.map