import { useState, useRef } from 'react';
import { ActivityPubService } from '@dhaaga/bridge';
function useDhaagaAuthGate(strategy = 'activitypub', placeholder = 'mastodon.social') {
    const [Instance, setInstance] = useState(placeholder);
    const [Software, setSoftware] = useState(null);
    const [IsLoading, setIsLoading] = useState(false);
    const [Error, setError] = useState(null);
    const cachedClientTokens = useRef(null);
    async function detectSoftware() { }
    async function processAuth() {
        setIsLoading(true);
        try {
            const { data: signInStrategy, error } = await ActivityPubService.signInUrl(Instance, cachedClientTokens.current);
            if (error) {
                console.log(error);
                setIsLoading(false);
                return {
                    strategy: 'error',
                    params: {
                        code: 'E_Failed_To_Detect_Software',
                        message: 'Failed to detect software',
                    },
                };
            }
            switch (strategy) {
                case 'activitypub': {
                    return {
                        strategy: 'activitypub',
                        params: {
                            signInUrl: signInStrategy?.loginUrl,
                            instance: Instance,
                            software: signInStrategy?.software,
                            clientId: signInStrategy?.clientId,
                            clientSecret: signInStrategy?.clientSecret,
                        },
                    };
                }
                case 'miauth': {
                    return {
                        strategy: 'miauth',
                        params: {
                            signInUrl: signInStrategy?.loginUrl,
                            instance: Instance,
                            software: signInStrategy?.software,
                        },
                    };
                }
                default: {
                    return {
                        strategy: 'error',
                        params: {
                            code: 'E_Failed_To_Generate_Strategy',
                            message: 'Something went wrong',
                        },
                    };
                }
            }
        }
        catch (e) {
            return {
                strategy: 'error',
                params: {
                    code: 'E_Failed_To_Generate_Strategy',
                    message: 'Something went wrong',
                },
            };
        }
        finally {
            setIsLoading(false);
        }
    }
    return {
        resolve: processAuth,
        Instance,
        setInstance,
        isLoading: IsLoading,
        cachedClientTokens,
    };
}
export default useDhaagaAuthGate;
//# sourceMappingURL=useDhaagaAuthGate.js.map