import { useState } from 'react';
import { BaseApiAdapter } from '@dhaaga/bridge';
function useActivityPubAuth(instance, _clientId, _clientSecret) {
    const [Code, setCode] = useState(null);
    const [IsLoading, setIsLoading] = useState(false);
    const [Error, setError] = useState(null);
    const [UserData, setUserData] = useState();
    function reset() {
        setIsLoading(false);
        setCode(null);
        setError(null);
        setUserData(null);
    }
    function RNWebviewStateChangeCallback(state) {
        const regex = /^https:\/\/(.*?)\/oauth\/authorize\/native\?code=(.*?)$/;
        if (regex.test(state.url)) {
            const code = state.url.match(regex)[2];
            setCode(code);
        }
        else {
            setCode(null);
        }
    }
    async function authenticate() {
        if (!_clientId || !_clientSecret) {
            setError('E_Missing_Client_Credentials');
            return null;
        }
        setIsLoading(true);
        try {
            const token = await new BaseApiAdapter().instances.getMastodonAccessToken(instance, Code, _clientId, _clientSecret);
            const { data: verified, error } = await new BaseApiAdapter().instances.verifyCredentials(instance, token || Code);
            if (error) {
                setError(error.code);
                return null;
            }
            else {
                setUserData(verified);
                return { userData: verified, accessToken: token ?? Code };
            }
        }
        catch (e) {
            return null;
        }
        finally {
            setIsLoading(false);
        }
    }
    return {
        RNWebviewStateChangeCallback,
        userData: UserData,
        code: Code,
        setCode,
        loading: IsLoading,
        authenticate,
        error: Error,
        reset,
    };
}
export default useActivityPubAuth;
//# sourceMappingURL=useActivityPubAuth.js.map