import { type Result } from '@dhaaga/bridge';
declare enum DbErrorCode {
    UNKNOWN = "E_UNKNOWN_ERROR",
    NOT_FOUND = "E_NOT_FOUND",
    DUPLICATE = "E_DUPLICATE",
    WRITE_FAILED = "E_WRITE_FAILED",
    NOT_IMPLEMENTED = "E_NOT_IMPLEMENTED"
}
type DbResult<T> = Result<T, DbErrorCode>;
type DbAsyncResult<T> = Promise<Result<T, DbErrorCode>>;
declare function Ok<T>(value: T): Result<T, DbErrorCode>;
declare function Err<T>(error: DbErrorCode): Result<T, DbErrorCode>;
export { DbErrorCode, Ok, Err };
export type { DbResult, DbAsyncResult };
//# sourceMappingURL=db-result.d.ts.map