import * as SQLite from 'expo-sqlite';
import { SQLiteDatabase } from 'expo-sqlite';
import { KnownServer } from '../_schema.js';
import { DbErrorCode, Err, Ok } from '../utils/db-result.js';
import { DATABASE_NAME } from '../types/db.types.js';
class Repo {
    static find(serverId, identifier) {
        const db = SQLite.openDatabaseSync(DATABASE_NAME);
        try {
            const emoji = db.getFirstSync(`select * from serverEmoji where serverId = ? and shortCode = ?;`, serverId, identifier);
            if (emoji)
                return Ok(emoji);
            return Err(DbErrorCode.NOT_FOUND);
        }
        catch (e) {
            return Err(DbErrorCode.UNKNOWN);
        }
    }
}
class Service {
    static find(server, identifier) {
        return Repo.find(server.id, identifier);
    }
    static async upsertMany(db, server, items) {
        for await (const item of items) {
        }
    }
}
export { Repo as ServerEmojiRepo, Service as ServerEmojiService };
//# sourceMappingURL=server-emoji.js.map