import { DbErrorHandler } from './_base.repo.js';
import { SQLiteDatabase } from 'expo-sqlite';
import { DbErrorCode, Err, Ok } from '../utils/db-result.js';
@DbErrorHandler()
class Repo {
    static upsert(db, name) {
        db.runSync(`insert into hashtag (name) values (?)
				on conflict(name) do nothing;
		`, name);
        const result = db.getFirstSync(`select * from hashtag where name = ?`, name);
        return result ? Ok(result) : Err(DbErrorCode.WRITE_FAILED);
    }
}
class Service {
    static upsert(db, name) {
        return Repo.upsert(db, name);
    }
}
export { Repo as HashtagRepo, Service as HashtagService };
//# sourceMappingURL=hashtag.js.map