import { SQLiteDatabase } from 'expo-sqlite';
import { z } from 'zod';
import { DataSource } from '../dataSource.js';
export const AppSettingCreateDTO = z.object({
    key: z.string(),
    value: z.string(),
    type: z.enum(['boolean', 'string', 'json', 'csv']),
});
class Repo {
    static async get(db, key) { }
    static async toggle(db, key) { }
}
class Service {
    static getValue(db, key) {
        const setting = db.appSetting.findOne({
            key,
        });
        if (!setting)
            return null;
        try {
            switch (setting.type) {
                case 'boolean':
                    return Boolean(setting.value);
                case 'string':
                    return setting.value;
                case 'json':
                    return JSON.parse(setting.value);
            }
        }
        catch (e) {
            console.log('[WARN]: error parsing setting');
            return null;
        }
        return null;
    }
    static toggle(db, key) {
        return null;
    }
    static setValue(db, input) {
        const conflict = db.appSetting.findOne({
            key: input.key,
        });
        if (conflict) {
            db.appSetting.updateById(conflict.id, {
                value: input.type === 'json'
                    ? JSON.stringify(input.value)
                    : input.value.toString(),
                type: input.type,
            });
        }
        else {
            db.appSetting.insert({
                key: input.key,
                value: input.type === 'json'
                    ? JSON.stringify(input.value)
                    : input.value.toString(),
                type: input.type,
            });
        }
    }
    static setValueNoUpsert(db, input) {
        const conflict = db.appSetting.findOne({
            key: input.key,
        });
        if (conflict)
            return;
        db.appSetting.insert({
            key: input.key,
            value: input.type === 'json'
                ? JSON.stringify(input.value)
                : input.value.toString(),
            type: input.type,
        });
    }
    static init(db) { }
}
export { Repo as AppSettingRepo, Service as AppSettingService };
//# sourceMappingURL=app-setting.js.map