import { SQLiteDatabase } from 'expo-sqlite';
import { z } from 'zod';
import { DataSource } from '../dataSource.js';
import type { AppSetting } from '../_schema.js';
export declare const AppSettingCreateDTO: z.ZodObject<{
    key: z.ZodString;
    value: z.ZodString;
    type: z.ZodEnum<{
        boolean: "boolean";
        csv: "csv";
        json: "json";
        string: "string";
    }>;
}, z.core.$strip>;
export type AppSettingType = z.infer<typeof AppSettingCreateDTO>;
declare class Repo {
    static get(db: SQLiteDatabase, key: string): Promise<void>;
    static toggle(db: SQLiteDatabase, key: string): Promise<void>;
}
declare class Service {
    static getValue<T>(db: DataSource, key: string): T | null;
    static toggle(db: DataSource, key: string): AppSetting | null;
    static setValue(db: DataSource, input: AppSettingType): void;
    static setValueNoUpsert(db: DataSource, input: AppSettingType): void;
    static init(db: SQLiteDatabase): void;
}
export { Repo as AppSettingRepo, Service as AppSettingService };
//# sourceMappingURL=app-setting.d.ts.map