import { z } from 'zod';
import { Account } from '../_schema.js';
import { type AccountMetadataRecordType } from './account-metadata.js';
import { KNOWN_SOFTWARE } from '@dhaaga/bridge';
import { DataSource } from '../dataSource.js';
export declare const accountInsertDto: z.ZodObject<{
    uuid: z.ZodString;
    identifier: z.ZodString;
    driver: z.ZodString;
    server: z.ZodString;
    username: z.ZodString;
    avatarUrl: z.ZodNullable<z.ZodString>;
    displayName: z.ZodNullable<z.ZodString>;
}, z.core.$strip>;
export declare class Repo {
    static getById(db: DataSource, id: number | string): Account | null;
    static getByHandleFragments(db: DataSource, server: string, username: string): Account | null;
    static upsert(db: DataSource, dto: z.infer<typeof accountInsertDto>): Account;
    static updateSelectionFlag(db: DataSource, id: number, flag: boolean): void;
    static deselectAll(db: DataSource): void;
    static updateSoftware(db: DataSource, id: number, driver: string): void;
    static getAll(db: DataSource): Account[];
    static removeById(db: DataSource, id: number): import("expo-sqlite").SQLiteRunResult;
    static getFirstSelected(db: DataSource): Account | null;
}
declare class Service {
    static upsert(db: DataSource, acct: z.infer<typeof accountInsertDto>, metadata: AccountMetadataRecordType[]): Account;
    static selectSync(db: DataSource, acct: Account): Promise<void>;
    static select(db: DataSource, acct: Account): void;
    static deselect(db: DataSource, acct: Account): void;
    static getAll(db: DataSource): Account[];
    static getAllWithProfiles(db: DataSource): Account[];
    static remove(db: DataSource, acct: Account): import("expo-sqlite").SQLiteRunResult;
    static removeById(db: DataSource, id: number): import("expo-sqlite").SQLiteRunResult;
    static updateDriver(db: DataSource, acct: Account, driver: KNOWN_SOFTWARE | string): void;
    static getSelected(db: DataSource): Account | null;
    static getById(db: DataSource, id: number | string): Account | null;
    static ensureAccountSelection(db: DataSource): void;
    static _postSelect(db: DataSource, acct: Account): void;
}
export { Service as AccountService, Repo as AccountRepo };
//# sourceMappingURL=account.d.ts.map