import { RepoTemplate } from './_base.repo.js';
import { Account, AccountSavedPost } from '../_schema.js';
import { DataSource } from '../dataSource.js';
import type { PostObjectType } from '@dhaaga/bridge';
declare class Repo implements RepoTemplate<AccountSavedPost> {
}
declare class Service {
    static getByIdentifier(db: DataSource, acct: Account, identifier: string): AccountSavedPost | null;
    static find(db: DataSource, acct: Account, id: string): AccountSavedPost | null;
    static upsert(db: DataSource, acct: Account, post: PostObjectType): AccountSavedPost | null;
    static listForCollectionId(db: DataSource, collectionId: number): AccountSavedPost[];
}
export { Repo as AccountSavedPostRepo, Service as AccountSavedPostService };
//# sourceMappingURL=account-saved-post.d.ts.map