import { z } from 'zod';
import { RepoTemplate } from './_base.repo.js';
import { Account, AccountMetadata } from '../_schema.js';
import { DataSource } from '../dataSource.js';
export type AccountMetadataRecordType = {
    key: string;
    value: string;
    type: 'string' | 'integer' | 'json';
};
export declare const accountMetadataRecordDto: z.ZodObject<{
    key: z.ZodString;
    value: z.ZodString;
    type: z.ZodString;
}, z.core.$strip>;
export type AppAtpSessionData = {
    accessJwt: string;
    refreshJwt: string;
    handle: string;
    did: string;
};
export declare const accountMetadataUpsertDto: z.ZodObject<{
    key: z.ZodString;
    value: z.ZodString;
    type: z.ZodString;
    accountId: z.ZodOptional<z.ZodNumber>;
}, z.core.$strip>;
export declare enum ACCOUNT_METADATA_KEY {
    USER_IDENTIFIER = "userIdentifier",
    AVATAR_URL = "avatarUrl",
    DISPLAY_NAME = "displayName",
    ACCESS_TOKEN = "accessToken",
    REFRESH_TOKEN = "refreshToken",
    ATPROTO_SESSION_OBJECT = "atprotoSessionObject",
    ATPROTO_DID = "atprotoDid",
    ATPROTO_APP_PASSWORD = "atprotoAppPassword",
    ATPROTO_SESSION = "atprotoSession"
}
declare class Repo implements RepoTemplate<AccountMetadata> {
    static getAllKeysForAccount(db: DataSource, accountId: number): AccountMetadata[];
    static getByAccountAndKeySync(db: DataSource, acctId: number, key: string): AccountMetadata | null;
    static upsert(db: DataSource, dto: z.infer<typeof accountMetadataUpsertDto>): void;
    static upsertMultiple(db: DataSource, inputs: z.infer<typeof accountMetadataUpsertDto>[]): void;
}
declare class Service {
    static upsertMultiple(db: DataSource, acct: Account, metadata: AccountMetadataRecordType[]): void;
    static getAccountDid(db: DataSource, acct: Account): string | undefined;
    static upsert(db: DataSource, acct: Account, input: AccountMetadataRecordType): void;
    static getAtpSessionData(db: DataSource, acct: Account): Promise<{
        accessJwt: string;
        refreshJwt: string;
        handle: string;
        did: string;
    } | null>;
    static getKeyValueForAccountSync(db: DataSource, acct: Account, key: string): string | undefined;
    static getAllKeysForAccount(db: DataSource, acct: Account): AccountMetadata[];
}
export { Repo as AccountMetadataRepo, Service as AccountMetadataService };
//# sourceMappingURL=account-metadata.d.ts.map