import { DataSource } from '../dataSource.js';
import { RandomUtil } from '@dhaaga/bridge';
import { Account, AccountCollection, AccountSavedPost } from '../_schema.js';
export { ReservedCollection };
var ReservedCollection;
(function (ReservedCollection) {
    ReservedCollection["DEFAULT"] = "__default__";
    ReservedCollection["LIKES"] = "__likes__";
    ReservedCollection["BOOKMARKS"] = "__bookmarks__";
})(ReservedCollection || (ReservedCollection = {}));
export const reservedCollectionName = {
    [ReservedCollection.LIKES]: 'Likes',
    [ReservedCollection.BOOKMARKS]: 'Bookmarks',
    [ReservedCollection.DEFAULT]: 'Default',
};
class Repo {
}
class Service {
    static renameCollection(db, id, name) {
        db.accountCollection.updateById(id, {
            alias: name,
        });
    }
    static addCollection(db, acct, name) {
        db.accountCollection.insert({
            uuid: RandomUtil.nanoId(),
            identifier: RandomUtil.nanoId(),
            alias: name,
            accountId: acct.id,
        });
    }
    static describeCollection(db, id, desc) {
        db.accountCollection.updateById(id, {
            desc,
        });
    }
    static removeCollection(db, id) {
        db.accountCollection.updateById(id, {
            active: false,
        });
        return db.accountCollection.findOne({ id });
    }
    static listAll(db) {
        return db.accountCollection.find({ active: true });
    }
    static listAllForAccount(db, acct) {
        return db.accountCollection.find({ active: true, accountId: acct.id });
    }
    static toggleLink(db, collection, savedPost) {
        if (!collection || !savedPost)
            return;
        const conflict = db.collectionSavedPost.findOne({
            collectionId: collection.id,
            savedPostId: savedPost.id,
        });
        if (conflict) {
            db.collectionSavedPost.updateById(conflict.id, {
                active: !conflict.active,
            });
        }
        else {
            db.collectionSavedPost.insert({
                collectionId: collection.id,
                savedPostId: savedPost.id,
            });
        }
        return db.collectionSavedPost.findOne({
            collectionId: collection.id,
            savedPostId: savedPost.id,
        });
    }
    static upsertReservedCollections(db, acct, identifier) {
        const conflict = db.accountCollection.findOne({
            active: true,
            identifier: identifier,
            accountId: acct.id,
        });
        if (conflict)
            return;
        db.accountCollection.insert({
            uuid: RandomUtil.nanoId(),
            identifier: identifier,
            alias: reservedCollectionName[identifier],
            accountId: acct.id,
        });
    }
}
export { Repo as AccountCollectionRepo, Service as AccountCollectionService };
//# sourceMappingURL=account-collection.js.map