import { DbErrorCode, Err } from '../utils/db-result.js';
export class RepoTemplate {
    static describe() { }
    static list() {
        return Err(DbErrorCode.NOT_IMPLEMENTED);
    }
}
function TryCatchDecorator(target, propertyKey, descriptor) {
    const originalMethod = descriptor.value;
    descriptor.value = async function (...args) {
        try {
            return await originalMethod.apply(this, args);
        }
        catch (error) {
            console.error(`Error in method ${propertyKey}:`, error);
            throw error;
        }
    };
    return descriptor;
}
export function DbErrorHandler() {
    return (constructor) => {
        const methodNames = Object.getOwnPropertyNames(constructor.prototype).filter((key) => key !== 'constructor' &&
            typeof constructor.prototype[key] === 'function');
        for (const methodName of methodNames) {
            const descriptor = Object.getOwnPropertyDescriptor(constructor.prototype, methodName);
            if (descriptor) {
                Object.defineProperty(constructor.prototype, methodName, TryCatchDecorator(constructor.prototype, methodName, descriptor));
            }
        }
    };
}
//# sourceMappingURL=_base.repo.js.map