import { BaseEntity, Entity } from '@dhaaga/orm';
@Entity('account')
export class Account extends BaseEntity {
    uuid;
    identifier;
    driver;
    server;
    username;
    avatarUrl;
    displayName;
    selected;
    active;
    metadata;
    profiles;
}
@Entity('accountSavedUser')
export class AccountSavedUser extends BaseEntity {
    uuid;
    identifier;
    isRemote;
    remoteServer;
    username;
    avatarUrl;
    displayName;
    active;
    accountId;
    account;
}
@Entity('accountSavedPost')
export class AccountSavedPost extends BaseEntity {
    uuid;
    identifier;
    textContent;
    authoredAt;
    spoilerText;
    remoteUrl;
    sensitive;
    active;
    accountId;
    savedUserId;
    account;
    savedUser;
    medias;
}
@Entity('savedPostMediaAttachment')
export class SavedPostMediaAttachment extends BaseEntity {
    uuid;
    previewUrl;
    url;
    alt;
    height;
    width;
    mimeType;
    active;
    savedPostId;
    savedPost;
}
@Entity('accountCollection')
export class AccountCollection extends BaseEntity {
    uuid;
    identifier;
    alias;
    itemOrder;
    active;
    desc;
    accountId;
    account;
}
@Entity('collectionSavedPost')
export class CollectionSavedPost extends BaseEntity {
    savedPostId;
    collectionId;
    active;
    savedPost;
    collection;
}
@Entity('accountMetadata')
export class AccountMetadata extends BaseEntity {
    key;
    value;
    type;
    active;
    accountId;
    account;
}
@Entity('profile')
export class Profile extends BaseEntity {
    uuid;
    name;
    selected;
    active;
    accountId;
    visible;
    itemOrder;
    account;
}
@Entity('appSetting')
export class AppSetting extends BaseEntity {
    key;
    value;
    type;
}
@Entity('accountSetting')
export class AccountSetting extends BaseEntity {
    key;
    value;
    type;
}
@Entity('profileSetting')
export class ProfileSetting extends BaseEntity {
    key;
    value;
    type;
}
@Entity('migrations')
export class Migration extends BaseEntity {
    userVersion;
    versionCode;
    name;
}
@Entity('knownServer')
export class KnownServer extends BaseEntity {
    uuid;
    server;
    driver;
    profileId;
    profile;
}
@Entity('profilePinnedTimeline')
export class ProfilePinnedTimeline extends BaseEntity {
    uuid;
    server;
    category;
    driver;
    required;
    show;
    itemOrder;
    page;
    alias;
    minId;
    maxId;
    minIdNext;
    maxIdNext;
    minIdDraft;
    maxIdDraft;
    unseenCount;
    lastCommitMaxId;
    profile;
    uri;
    displayName;
    avatarUrl;
    profileId;
    active;
}
@Entity('profilePinnedUser')
export class ProfilePinnedUser extends BaseEntity {
    uuid;
    server;
    category;
    driver;
    required;
    show;
    itemOrder;
    page;
    alias;
    minId;
    maxId;
    minIdNext;
    maxIdNext;
    minIdDraft;
    maxIdDraft;
    unseenCount;
    lastCommitMaxId;
    profile;
    identifier;
    username;
    avatarUrl;
    displayName;
    profileId;
    active;
}
@Entity('profilePinnedTag')
export class ProfilePinnedTag extends BaseEntity {
    uuid;
    server;
    category;
    driver;
    required;
    show;
    itemOrder;
    page;
    alias;
    minId;
    maxId;
    minIdNext;
    maxIdNext;
    minIdDraft;
    maxIdDraft;
    unseenCount;
    lastCommitMaxId;
    profile;
    identifier;
    name;
    profileId;
    active;
}
@Entity('knownServerMetadata')
export class KnownServerMetadata extends BaseEntity {
    key;
    value;
    type;
    active;
    knownServerId;
    knownServer;
}
//# sourceMappingURL=_schema.js.map