import { BaseEntity } from '@dhaaga/orm';
import type { APP_PINNED_OBJECT_TYPE } from './types/db.types.js';
export declare class Account extends BaseEntity<Account> {
    uuid: string;
    identifier: string;
    driver: string;
    server: string;
    username: string;
    avatarUrl: string | null;
    displayName: string | null;
    selected: boolean;
    active: boolean;
    metadata: AccountMetadata[] | undefined;
    profiles: Profile[] | undefined;
}
export declare class AccountSavedUser extends BaseEntity<AccountSavedUser> {
    uuid: string;
    identifier: string;
    isRemote: boolean;
    remoteServer: string;
    username: string;
    avatarUrl: string | null;
    displayName: string | null;
    active: boolean;
    accountId: number | null;
    account: Account | undefined;
}
export declare class AccountSavedPost extends BaseEntity<AccountSavedPost> {
    uuid: string;
    identifier: string;
    textContent: string | null;
    authoredAt: string;
    spoilerText: string | null;
    remoteUrl: string;
    sensitive: boolean;
    active: boolean;
    accountId: number | null;
    savedUserId: number | null;
    account?: Account;
    savedUser?: AccountSavedUser;
    medias?: SavedPostMediaAttachment[];
}
export declare class SavedPostMediaAttachment extends BaseEntity<SavedPostMediaAttachment> {
    uuid: string;
    previewUrl: string | null;
    url: string | null;
    alt: string | null;
    height: number | null;
    width: number | null;
    mimeType: string | null;
    active: boolean;
    savedPostId: number | null;
    savedPost?: AccountSavedPost;
}
export declare class AccountCollection extends BaseEntity<AccountCollection> {
    uuid: string;
    identifier: string;
    alias: string;
    itemOrder: number;
    active: boolean;
    desc: string | null;
    accountId: number | null;
    account?: Account;
}
export declare class CollectionSavedPost extends BaseEntity<CollectionSavedPost> {
    savedPostId: number | null;
    collectionId: number | null;
    active: boolean;
    savedPost?: AccountSavedPost;
    collection?: AccountCollection;
}
export declare class AccountMetadata extends BaseEntity<AccountMetadata> {
    key: string;
    value: string;
    type: string;
    active: boolean;
    accountId: number | null;
    account?: Account;
}
export declare class Profile extends BaseEntity<Profile> {
    uuid: string;
    name: string;
    selected: boolean;
    active: boolean;
    accountId: number | null;
    visible: boolean;
    itemOrder: number;
    account?: Account;
}
export declare class AppSetting extends BaseEntity<AppSetting> {
    key: string;
    value: string;
    type: string;
}
export declare class AccountSetting extends BaseEntity<AccountSetting> {
    key: string;
    value: string;
    type: string;
}
export declare class ProfileSetting extends BaseEntity<ProfileSetting> {
    key: string;
    value: string;
    type: string;
}
export declare class Migration extends BaseEntity<Migration> {
    userVersion: string;
    versionCode: string;
    name: string;
}
export declare class KnownServer extends BaseEntity<KnownServer> {
    uuid: string;
    server: string;
    driver: string;
    profileId: number | null;
    profile?: Profile;
}
export declare class ProfilePinnedTimeline extends BaseEntity<ProfilePinnedTimeline> {
    uuid: string;
    server: string;
    category: APP_PINNED_OBJECT_TYPE;
    driver: string;
    required: boolean;
    show: boolean;
    itemOrder: number;
    page: number;
    alias: string | null;
    minId: string | null;
    maxId: string | null;
    minIdNext: string | null;
    maxIdNext: string | null;
    minIdDraft: string | null;
    maxIdDraft: string | null;
    unseenCount: number;
    lastCommitMaxId: string | null;
    profile?: Profile;
    uri: string | null;
    displayName: string | null;
    avatarUrl: string | null;
    profileId: number | null;
    active: boolean;
}
export declare class ProfilePinnedUser extends BaseEntity<ProfilePinnedUser> {
    uuid: string;
    server: string;
    category: APP_PINNED_OBJECT_TYPE;
    driver: string;
    required: boolean;
    show: boolean;
    itemOrder: number;
    page: number;
    alias: string | null;
    minId: string | null;
    maxId: string | null;
    minIdNext: string | null;
    maxIdNext: string | null;
    minIdDraft: string | null;
    maxIdDraft: string | null;
    unseenCount: number;
    lastCommitMaxId: string | null;
    profile?: Profile;
    identifier: string;
    username: string;
    avatarUrl: string | null;
    displayName: string | null;
    profileId: number | null;
    active: boolean;
}
export declare class ProfilePinnedTag extends BaseEntity<ProfilePinnedTag> {
    uuid: string;
    server: string;
    category: APP_PINNED_OBJECT_TYPE;
    driver: string;
    required: boolean;
    show: boolean;
    itemOrder: number;
    page: number;
    alias: string | null;
    minId: string | null;
    maxId: string | null;
    minIdNext: string | null;
    maxIdNext: string | null;
    minIdDraft: string | null;
    maxIdDraft: string | null;
    unseenCount: number;
    lastCommitMaxId: string | null;
    profile?: Profile;
    identifier: string;
    name: string;
    profileId: number | null;
    active: boolean;
}
export declare class KnownServerMetadata extends BaseEntity<KnownServerMetadata> {
    key: string;
    value: string;
    type: string;
    active: boolean;
    knownServerId: number | null;
    knownServer?: KnownServer;
}
export type ServerEmoji = {
    shortCode: string;
    url: string;
    staticUrl: string;
    visibleInPicker?: boolean;
    timesUsed: number;
    serverId: number;
    category?: string;
};
export type ServerEmojiAlias = {
    serverEmojiId: number;
    alias: string;
};
export type Hashtag = {
    name: string;
};
export type AccountHashtag = {
    followed: boolean;
    private: boolean;
    hashtagId: number | null;
    accountId: number | null;
    account?: Account;
    hashtag?: Hashtag;
};
export type PostMediaAttachment = {
    altText?: string;
    blurhash?: string;
    attachmentId?: string;
    previewUrl?: string;
    url: string;
    type?: string;
    height?: number;
    width?: number;
    postId: number;
};
export type Post = {
    identifier: string;
    content: string;
    replyToUserId: string;
    replyToPostId: string;
    shared: boolean;
    favourited: boolean;
    bookmarked: boolean;
    spoilerText: string;
    visibility: string;
    url: string;
    shareCount: number;
    replyCount: number;
    isSensitive: boolean;
    postCreatedAt: Date;
    postEditedAt: Date;
};
export type Setting = {
    key: string;
    value: string;
    type: string;
};
//# sourceMappingURL=_schema.d.ts.map