import { type Result } from '@dhaaga/bridge';
declare enum AppErrorCode {
    UNKNOWN = "E_UNKNOWN_ERROR",
    PARSING_ERROR = "E_PARSING_ERROR"
}
type AppResult<T> = Result<T, AppErrorCode>;
type AppAsyncResult<T> = Promise<Result<T, AppErrorCode>>;
declare function Ok<T>(value: T): Result<T, AppErrorCode>;
declare function Err<T>(error: AppErrorCode): Result<T, AppErrorCode>;
export { AppErrorCode, Ok, Err };
export type { AppResult, AppAsyncResult };
//# sourceMappingURL=app-result.d.ts.map