import { jsx as _jsx } from "react/jsx-runtime";
import { DataSource } from '@dhaaga/db';
import { RandomUtil } from '@dhaaga/bridge';
import { produce } from 'immer';
import { createContext, useContext, useReducer, } from 'react';
import { timelineReducerBaseDefaults, } from './_timeline.shared.js';
const DEFAULT = {
    ...timelineReducerBaseDefaults,
    items: [],
};
var ACTION;
(function (ACTION) {
    ACTION[ACTION["INIT"] = 0] = "INIT";
    ACTION[ACTION["RESET"] = 1] = "RESET";
    ACTION[ACTION["APPEND"] = 2] = "APPEND";
    ACTION[ACTION["REQUEST_LOAD_MORE"] = 3] = "REQUEST_LOAD_MORE";
    ACTION[ACTION["SET_QUERY_OPTS"] = 4] = "SET_QUERY_OPTS";
})(ACTION || (ACTION = {}));
function reducer(state, action) {
    switch (action.type) {
        case ACTION.INIT: {
            return produce(state, (draft) => {
                draft.db = action.payload.db;
                draft.seen = new Set();
                draft.sessionId = RandomUtil.nanoId();
            });
        }
        case ACTION.REQUEST_LOAD_MORE: {
            return produce(state, (draft) => {
                draft.appliedMaxId = state.maxId;
            });
        }
        case ACTION.RESET: {
            return produce(state, (draft) => {
                draft.items = [];
                draft.maxId = null;
                draft.minId = null;
                draft.isEol = false;
                draft.isFirstLoad = false;
                draft.seen = new Set();
            });
        }
        case ACTION.APPEND: {
            const copy = Array.from(state.items);
            return produce(state, (draft) => {
                for (const item of action.payload.items) {
                    if (draft.seen.has(item.id))
                        continue;
                    draft.seen.add(item.id);
                    copy.push(item);
                }
                draft.items = copy;
                draft.maxId = action.payload.maxId;
            });
        }
        case ACTION.SET_QUERY_OPTS: {
            return produce(state, (draft) => {
                draft.opts = action.payload;
            });
        }
    }
}
const StateCtx = createContext(null);
const DispatchCtx = createContext(null);
const useUserTimelineState = () => useContext(StateCtx);
const useUserTimelineDispatch = () => useContext(DispatchCtx);
function Ctx({ children }) {
    const [state, dispatch] = useReducer(reducer, DEFAULT);
    return (_jsx(StateCtx.Provider, { value: state, children: _jsx(DispatchCtx.Provider, { value: dispatch, children: children }) }));
}
export { Ctx as UserTimelineCtx, useUserTimelineState, useUserTimelineDispatch, ACTION as UserTimelineStateAction, };
//# sourceMappingURL=user-timeline.js.map