import type { PostObjectType, UserObjectType } from '@dhaaga/bridge';
import { type Dispatch, type ReactNode } from 'react';
declare const searchTabs: readonly ["top", "latest", "feeds", "posts", "users", "tags", "links", "news", "home"];
type SearchTabType = (typeof searchTabs)[number];
declare const searchResultTypes: readonly ["posts", "users", "links", "tags", "feeds"];
type SearchResultType = (typeof searchResultTypes)[number];
export type DiscoverTabSearchResultType = {
    users: UserObjectType[];
    posts: PostObjectType[];
    tags: any[];
    links: string[];
};
type State = {
    text: string | null;
    q: string | null;
    category: SearchResultType | null;
    tab: SearchTabType;
    results: DiscoverTabSearchResultType;
    searchStatus: 'idle' | 'loading';
};
export declare const defaultAppSearchResults: {
    users: never[];
    posts: never[];
    tags: never[];
    links: never[];
};
declare enum ACTION {
    SET_SEARCH = 0,
    CLEAR_SEARCH = 1,
    APPLY_SEARCH = 2,
    SET_CATEGORY = 3,
    SET_CATEGORY_POSTS = 4,
    SET_CATEGORY_USERS = 5,
    SET_CATEGORY_TAGS = 6,
    SET_CATEGORY_LINKS = 7,
    SET_SEARCH_RESULTS = 8,
    MARK_LOADING_DONE = 9
}
type Actions = {
    type: ACTION.SET_SEARCH;
    payload: {
        q: string;
    };
} | {
    type: ACTION.CLEAR_SEARCH;
} | {
    type: ACTION.APPLY_SEARCH;
} | {
    type: ACTION.SET_CATEGORY;
    payload: {
        tab: SearchTabType;
    };
} | {
    type: ACTION.SET_CATEGORY_POSTS;
} | {
    type: ACTION.SET_CATEGORY_USERS;
} | {
    type: ACTION.SET_CATEGORY_TAGS;
} | {
    type: ACTION.SET_CATEGORY_LINKS;
} | {
    type: ACTION.SET_SEARCH_RESULTS;
    payload: DiscoverTabSearchResultType;
} | {
    type: ACTION.MARK_LOADING_DONE;
};
type DispatchType = Dispatch<Actions>;
declare const useDiscoverState: () => State;
declare const useDiscoverDispatch: () => DispatchType | null;
declare function Ctx({ children }: {
    children: ReactNode;
}): import("react/jsx-runtime").JSX.Element;
export { Ctx as DiscoverCtx, useDiscoverState, useDiscoverDispatch, ACTION as DiscoverStateAction, };
export type { State as DiscoverStateType, DispatchType as DiscoverDispatchType, SearchTabType, };
//# sourceMappingURL=search-results.d.ts.map