class OkClass {
    value;
    constructor(value) {
        this.value = value;
    }
    isOk() {
        return true;
    }
    isErr() {
        return false;
    }
    map(fn) {
        return new OkClass(fn(this.value));
    }
    flatMap(fn) {
        return fn(this.value);
    }
    fold(onOk, onErr) {
        return onOk(this.value);
    }
    toPromise() {
        return Promise.resolve(this.value);
    }
    filter(predicate, error) {
        return predicate(this.value) ? this : new ErrClass(error);
    }
    unwrap() {
        return this.value;
    }
    unwrapOrElse(defaultValue) {
        return this.value;
    }
    unwrapOr(fallback) {
        return this.value;
    }
    tap(fn) {
        if (this.isOk()) {
            fn(this.value);
        }
        return this;
    }
    tapError(fn) {
        return this;
    }
}
class ErrClass {
    error;
    constructor(error) {
        this.error = error;
    }
    isOk() {
        return false;
    }
    isErr() {
        return true;
    }
    map(fn) {
        return this;
    }
    flatMap(fn) {
        return this;
    }
    fold(onOk, onErr) {
        return onErr(this.error);
    }
    toPromise() {
        return Promise.reject(this.error);
    }
    filter(predicate, error) {
        return this;
    }
    unwrap() {
        throw new Error(`Attempted to unwrap an Err: ${JSON.stringify(this.error)}`);
    }
    unwrapOrElse(defaultValue) {
        return defaultValue;
    }
    unwrapOr(fallback) {
        return fallback;
    }
    tap(fn) {
        return this;
    }
    tapError(fn) {
        if (this.isErr()) {
            fn(this.error);
        }
        return this;
    }
}
function ResultOk(value) {
    return new OkClass(value);
}
function ResultErr(error) {
    return new ErrClass(error);
}
function Ok(value) {
    return new OkClass(value);
}
function Err(error) {
    return new ErrClass(error);
}
export { ResultOk, ResultErr, Ok, Err };
//# sourceMappingURL=result.js.map