declare class OkClass<T, E> {
    value: T;
    constructor(value: T);
    isOk(): this is OkClass<T, E>;
    isErr(): this is ErrClass<T, E>;
    map<U>(fn: (value: T) => U): Result<U, E>;
    flatMap<U>(fn: (value: T) => Result<U, E>): Result<U, E>;
    fold<B>(onOk: (value: T) => B, onErr: (error: E) => B): B;
    toPromise(): Promise<T>;
    filter(predicate: (value: T) => boolean, error: E): Result<T, E>;
    unwrap(): T;
    unwrapOrElse(defaultValue: T): T;
    unwrapOr(fallback: T): T;
    tap(fn: (value: T) => void): Result<T, E>;
    tapError(fn: (error: E) => void): Result<T, E>;
}
declare class ErrClass<T, E> {
    error: E;
    constructor(error: E);
    isOk(): this is OkClass<T, E>;
    isErr(): this is ErrClass<T, E>;
    map<U>(fn: (value: T) => U): Result<U, E>;
    flatMap<U>(fn: (value: T) => Result<U, E>): Result<U, E>;
    fold<B>(onOk: (value: T) => B, onErr: (error: E) => B): B;
    toPromise(): Promise<T>;
    filter(predicate: (value: T) => boolean, error: E): Result<T, E>;
    unwrap(): never;
    unwrapOrElse(defaultValue: T): T;
    unwrapOr(fallback: never): never;
    tap(fn: (value: T) => void): Result<T, E>;
    tapError(fn: (error: E) => void): Result<T, E>;
}
type Result<T, E> = OkClass<T, E> | ErrClass<T, E>;
type AsyncResult<T, E> = Promise<Result<T, E>>;
declare function ResultOk<T, E>(value: T): Result<T, E>;
declare function ResultErr<T, E>(error: E): Result<T, E>;
declare function Ok<T>(value: T): Result<T, string>;
declare function Err<T>(error: string): Result<T, string>;
export { ResultOk, ResultErr, Ok, Err };
export type { Result, AsyncResult };
//# sourceMappingURL=result.d.ts.map