import { z } from 'zod';
const DriverWebfingerSchema = z.object({
    username: z.string(),
    host: z.string().nullable(),
});
const userFindQuerySchema = z
    .object({
    use: z.literal('did'),
    did: z.string(),
})
    .or(z.object({
    use: z.literal('userId'),
    userId: z.string(),
}))
    .or(z.object({
    use: z.literal('handle'),
    handle: z.string(),
}))
    .or(z.object({
    use: z.literal('webfinger'),
    webfinger: DriverWebfingerSchema,
}));
export { userFindQuerySchema };
//# sourceMappingURL=query.types.js.map