import { AppBskyActorDefs } from '@atproto/api';
import '../adapters/index.js';
class AtprotoPostService {
    static async toggleLike(client, uri, cid, viewer) {
        const _client = client;
        if (viewer.like === undefined)
            return _client.statuses.atProtoLike(uri, cid);
        return _client.statuses.atProtoDeleteLike(viewer.like);
    }
    static async toggleRepost(client, uri, cid, repostView) {
        const _client = client;
        if (repostView === undefined) {
            const result = await _client.statuses.atProtoRepost(uri, cid);
            if (result.success)
                return { state: result.liked, uri: result.uri, success: true };
            return { state: false, uri: undefined, success: false };
        }
        const result = await _client.statuses.atProtoDeleteRepost(repostView);
        if (result.success)
            return { state: result.liked, success: true };
        return { state: true, uri: repostView, success: false };
    }
}
class AtprotoFeedService {
    static extractFeedPreferences(pref) {
        const match = pref.preferences.find(AppBskyActorDefs.isSavedFeedsPrefV2);
        return match ? match.items : [];
    }
}
export { AtprotoPostService, AtprotoFeedService };
//# sourceMappingURL=atproto.service.js.map