import { Dispatch, SetStateAction } from 'react';
import { z } from 'zod';
import { InstanceApi_CustomEmojiDTO } from '../adapters/_client/_router/routes/instance.js';
import { ApiTargetInterface } from '../adapters/index.js';
import { DriverReactionResolvedType } from '../types/activitypub.js';
declare const activityPubReactionItemSchema: z.ZodObject<{
    id: z.ZodString;
    count: z.ZodNumber;
    me: z.ZodBoolean;
    accounts: z.ZodArray<z.ZodString>;
    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.core.$strip>;
type ActivityPubReactionItemType = z.infer<typeof activityPubReactionItemSchema>;
declare const ActivityPubReactionStateSchema: z.ZodArray<z.ZodObject<{
    id: z.ZodString;
    count: z.ZodNumber;
    me: z.ZodBoolean;
    accounts: z.ZodArray<z.ZodString>;
    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.core.$strip>>;
type ActivityPubReactionStateType = z.infer<typeof ActivityPubReactionStateSchema>;
declare class ActivityPubReactionsService {
    static extractReactionCode(input: string, domain: string, subdomain: string): {
        id: string;
    };
    static cannotReact(id: string): boolean;
    static renderData(input: ActivityPubReactionStateType, { me, calculated, cache }: {
        calculated: {
            url?: string;
            width?: number;
            height?: number;
            name?: string;
        }[];
        cache: InstanceApi_CustomEmojiDTO[];
        me: string;
    }): DriverReactionResolvedType[];
    static removeReaction(client: ApiTargetInterface, postId: string, reactionId: string, domain: string, setLoading: (val: boolean) => void): Promise<any>;
    private static syncMisskeyReactionState;
    static addReaction(client: ApiTargetInterface, postId: string, reactionId: string, domain: string, setLoading: Dispatch<SetStateAction<boolean>>): Promise<ActivityPubReactionStateType>;
}
export { activityPubReactionItemSchema, ActivityPubReactionStateSchema };
export type { ActivityPubReactionStateType, ActivityPubReactionItemType };
export default ActivityPubReactionsService;
//# sourceMappingURL=activitypub-reactions.service.d.ts.map