import { z } from 'zod';
import { KNOWN_SOFTWARE } from '../data/driver.js';
import { UserTargetInterface } from '../implementors/profile/_interface.js';
export declare const appUserObjectSchema: z.ZodObject<{
    id: z.ZodString;
    avatarUrl: z.ZodString;
    displayName: z.ZodNullable<z.ZodString>;
    parsedDisplayName: z.ZodArray<z.ZodAny>;
    handle: z.ZodString;
    instance: z.ZodString;
    banner: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    meta: z.ZodObject<{
        isProfileLocked: z.ZodBoolean;
        isBot: z.ZodBoolean;
        fields: z.ZodArray<z.ZodObject<{
            name: z.ZodOptional<z.ZodString>;
            value: z.ZodOptional<z.ZodString>;
            verifiedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            cid: z.ZodOptional<z.ZodString>;
            cts: z.ZodOptional<z.ZodString>;
            src: z.ZodOptional<z.ZodString>;
            uri: z.ZodOptional<z.ZodString>;
            val: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
    }, z.core.$strip>;
    description: z.ZodString;
    parsedDescription: z.ZodArray<z.ZodAny>;
    stats: z.ZodObject<{
        posts: z.ZodNullable<z.ZodNumber>;
        followers: z.ZodNullable<z.ZodNumber>;
        following: z.ZodNullable<z.ZodNumber>;
    }, z.core.$strip>;
    calculated: z.ZodObject<{
        emojis: z.ZodMap<z.ZodString, z.ZodString>;
    }, z.core.$strip>;
    relationship: z.ZodObject<{
        blocking: z.ZodNullable<z.ZodBoolean>;
        blockedBy: z.ZodNullable<z.ZodBoolean>;
        domainBlocking: z.ZodNullable<z.ZodBoolean>;
        followedBy: z.ZodNullable<z.ZodBoolean>;
        following: z.ZodNullable<z.ZodBoolean>;
        muting: z.ZodNullable<z.ZodBoolean>;
        mutingNotifications: z.ZodNullable<z.ZodBoolean>;
        note: z.ZodNullable<z.ZodString>;
        requested: z.ZodNullable<z.ZodBoolean>;
        requestedBy: z.ZodNullable<z.ZodBoolean>;
        showingReblogs: z.ZodNullable<z.ZodBoolean>;
    }, z.core.$strip>;
}, z.core.$strip>;
export declare const APP_USER_DEFAULT_RELATIONSHIP: {
    blocking: null;
    blockedBy: null;
    domainBlocking: null;
    followedBy: null;
    following: null;
    muting: null;
    mutingNotifications: null;
    note: null;
    requested: null;
    requestedBy: null;
    showingReblogs: null;
};
type UserObjectType = z.infer<typeof appUserObjectSchema>;
declare class Parser {
    static rawToInterface<T>(input: T | T[], driver: string | KNOWN_SOFTWARE): T extends unknown[] ? UserTargetInterface[] : UserTargetInterface;
    static interfaceToJson(input: UserTargetInterface, { driver, server }: {
        driver: KNOWN_SOFTWARE | string;
        server: string;
    }): {
        id: string;
        avatarUrl: string;
        displayName: string | null;
        parsedDisplayName: any[];
        handle: string;
        instance: string;
        banner?: string | null | undefined;
        meta: {
            isProfileLocked: boolean;
            isBot: boolean;
            fields: {
                name?: string | undefined;
                value?: string | undefined;
                verifiedAt?: string | null | undefined;
                cid?: string | undefined;
                cts?: string | undefined;
                src?: string | undefined;
                uri?: string | undefined;
                val?: string | undefined;
            }[];
        };
        description: string;
        parsedDescription: any[];
        stats: {
            posts: number | null;
            followers: number | null;
            following: number | null;
        };
        calculated: {
            emojis: Map<string, string>;
        };
        relationship: {
            blocking: boolean | null;
            blockedBy: boolean | null;
            domainBlocking: boolean | null;
            followedBy: boolean | null;
            following: boolean | null;
            muting: boolean | null;
            mutingNotifications: boolean | null;
            note: string | null;
            requested: boolean | null;
            requestedBy: boolean | null;
            showingReblogs: boolean | null;
        };
    } | null;
    static parse<T>(input: T | T[], driver: string | KNOWN_SOFTWARE, server: string): T extends unknown[] ? UserObjectType[] : UserObjectType;
}
export { Parser as UserParser };
export type { UserObjectType };
//# sourceMappingURL=user.d.ts.map